/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.configgroup;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ConfigGroupResponse;
import id.onyx.obdp.server.controller.internal.ConfigurationResourceProvider;
import id.onyx.obdp.server.logging.LockFactory;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ConfigGroupConfigMappingDAO;
import id.onyx.obdp.server.orm.dao.ConfigGroupDAO;
import id.onyx.obdp.server.orm.dao.ConfigGroupHostMappingDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupConfigMappingEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupHostMappingEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupHostMappingEntityPK;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigGroupImpl
implements ConfigGroup {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigGroupImpl.class);
    private Cluster cluster;
    private ConcurrentMap<Long, Host> m_hosts;
    private ConcurrentMap<String, Config> m_configurations;
    private String configGroupName;
    private String serviceName;
    private long configGroupId;
    private final ReadWriteLock hostLock;
    private static final String hostLockLabel = "configurationGroupHostLock";
    private final ConfigGroupDAO configGroupDAO;
    private final ConfigGroupConfigMappingDAO configGroupConfigMappingDAO;
    private final ConfigGroupHostMappingDAO configGroupHostMappingDAO;
    private final HostDAO hostDAO;
    private final ClusterDAO clusterDAO;
    private final ConfigFactory configFactory;

    @AssistedInject
    public ConfigGroupImpl(@Assisted(value="cluster") Cluster cluster, @Assisted(value="serviceName") @Nullable String serviceName, @Assisted(value="name") String name, @Assisted(value="tag") String tag, @Assisted(value="description") String description, @Assisted(value="configs") Map<String, Config> configurations, @Assisted(value="hosts") Map<Long, Host> hosts, Clusters clusters, ConfigFactory configFactory, ClusterDAO clusterDAO, HostDAO hostDAO, ConfigGroupDAO configGroupDAO, ConfigGroupConfigMappingDAO configGroupConfigMappingDAO, ConfigGroupHostMappingDAO configGroupHostMappingDAO, LockFactory lockFactory) throws OBDPException {
        this.configFactory = configFactory;
        this.clusterDAO = clusterDAO;
        this.hostDAO = hostDAO;
        this.configGroupDAO = configGroupDAO;
        this.configGroupConfigMappingDAO = configGroupConfigMappingDAO;
        this.configGroupHostMappingDAO = configGroupHostMappingDAO;
        this.hostLock = lockFactory.newReadWriteLock(hostLockLabel);
        this.cluster = cluster;
        this.serviceName = serviceName;
        this.configGroupName = name;
        ConfigGroupEntity configGroupEntity = new ConfigGroupEntity();
        configGroupEntity.setClusterId(cluster.getClusterId());
        configGroupEntity.setGroupName(name);
        configGroupEntity.setTag(tag);
        configGroupEntity.setDescription(description);
        configGroupEntity.setServiceName(serviceName);
        this.m_hosts = hosts == null ? new ConcurrentHashMap<Long, Host>() : new ConcurrentHashMap<Long, Host>(hosts);
        this.m_configurations = configurations == null ? new ConcurrentHashMap<String, Config>() : new ConcurrentHashMap<String, Config>(configurations);
        this.persist(configGroupEntity);
        this.configGroupId = configGroupEntity.getGroupId();
    }

    @AssistedInject
    public ConfigGroupImpl(@Assisted Cluster cluster, @Assisted ConfigGroupEntity configGroupEntity, Clusters clusters, ConfigFactory configFactory, ClusterDAO clusterDAO, HostDAO hostDAO, ConfigGroupDAO configGroupDAO, ConfigGroupConfigMappingDAO configGroupConfigMappingDAO, ConfigGroupHostMappingDAO configGroupHostMappingDAO, LockFactory lockFactory) {
        this.configFactory = configFactory;
        this.clusterDAO = clusterDAO;
        this.hostDAO = hostDAO;
        this.configGroupDAO = configGroupDAO;
        this.configGroupConfigMappingDAO = configGroupConfigMappingDAO;
        this.configGroupHostMappingDAO = configGroupHostMappingDAO;
        this.hostLock = lockFactory.newReadWriteLock(hostLockLabel);
        this.cluster = cluster;
        this.configGroupId = configGroupEntity.getGroupId();
        this.configGroupName = configGroupEntity.getGroupName();
        this.serviceName = configGroupEntity.getServiceName();
        this.m_configurations = new ConcurrentHashMap<String, Config>();
        this.m_hosts = new ConcurrentHashMap<Long, Host>();
        for (ConfigGroupConfigMappingEntity configMappingEntity : configGroupEntity.getConfigGroupConfigMappingEntities()) {
            Config config = cluster.getConfig(configMappingEntity.getConfigType(), configMappingEntity.getVersionTag());
            if (config != null) {
                this.m_configurations.put(config.getType(), config);
                continue;
            }
            LOG.warn("Unable to find config mapping {}/{} for config group in cluster {}", new Object[]{configMappingEntity.getConfigType(), configMappingEntity.getVersionTag(), cluster.getClusterName()});
        }
        for (ConfigGroupHostMappingEntity hostMappingEntity : configGroupEntity.getConfigGroupHostMappingEntities()) {
            try {
                Host host = clusters.getHost(hostMappingEntity.getHostname());
                HostEntity hostEntity = hostMappingEntity.getHostEntity();
                if (host == null || hostEntity == null) continue;
                this.m_hosts.put(hostEntity.getHostId(), host);
            }
            catch (Exception e) {
                LOG.warn("Host {} seems to be deleted but Config group {} mapping still exists !", (Object)hostMappingEntity.getHostname(), (Object)this.configGroupName);
                LOG.debug("Host seems to be deleted but Config group mapping still exists !", (Throwable)e);
            }
        }
    }

    @Override
    public Long getId() {
        return this.configGroupId;
    }

    @Override
    public String getName() {
        return this.configGroupName;
    }

    @Override
    public void setName(String name) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        configGroupEntity.setGroupName(name);
        this.configGroupDAO.merge(configGroupEntity);
        this.configGroupName = name;
    }

    @Override
    public String getClusterName() {
        return this.cluster.getClusterName();
    }

    @Override
    public String getTag() {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        return configGroupEntity.getTag();
    }

    @Override
    public void setTag(String tag) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        configGroupEntity.setTag(tag);
        this.configGroupDAO.merge(configGroupEntity);
    }

    @Override
    public String getDescription() {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        return configGroupEntity.getDescription();
    }

    @Override
    public void setDescription(String description) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        configGroupEntity.setDescription(description);
        this.configGroupDAO.merge(configGroupEntity);
    }

    @Override
    public Map<Long, Host> getHosts() {
        return Collections.unmodifiableMap(this.m_hosts);
    }

    @Override
    public Map<String, Config> getConfigurations() {
        return Collections.unmodifiableMap(this.m_configurations);
    }

    @Override
    public void setHosts(Map<Long, Host> hosts) {
        this.hostLock.writeLock().lock();
        try {
            this.replaceHostMappings(hosts);
            this.m_hosts = new ConcurrentHashMap<Long, Host>(hosts);
        }
        finally {
            this.hostLock.writeLock().unlock();
        }
    }

    @Override
    public void setConfigurations(Map<String, Config> configurations) throws OBDPException {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        ClusterEntity clusterEntity = configGroupEntity.getClusterEntity();
        this.persistConfigMapping(clusterEntity, configGroupEntity, configurations);
        this.m_configurations = new ConcurrentHashMap<String, Config>(configurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHost(Long hostId) throws OBDPException {
        this.hostLock.writeLock().lock();
        try {
            Host host = (Host)this.m_hosts.get(hostId);
            if (null == host) {
                return;
            }
            String hostName = host.getHostName();
            LOG.info("Removing host (id={}, name={}) from config group", (Object)host.getHostId(), (Object)hostName);
            try {
                this.removeConfigGroupHostEntity(host);
                this.m_hosts.remove(hostId);
            }
            catch (Exception e) {
                LOG.error("Failed to delete config group host mapping for cluster {} and host {}", new Object[]{this.cluster.getClusterName(), hostName, e});
                throw new OBDPException(e.getMessage());
            }
        }
        finally {
            this.hostLock.writeLock().unlock();
        }
    }

    @Transactional
    void removeConfigGroupHostEntity(Host host) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        ConfigGroupHostMappingEntityPK hostMappingEntityPK = new ConfigGroupHostMappingEntityPK();
        hostMappingEntityPK.setHostId(host.getHostId());
        hostMappingEntityPK.setConfigGroupId(this.configGroupId);
        ConfigGroupHostMappingEntity configGroupHostMapping = this.configGroupHostMappingDAO.findByPK(hostMappingEntityPK);
        this.configGroupHostMappingDAO.remove(configGroupHostMapping);
        configGroupEntity.getConfigGroupHostMappingEntities().remove(configGroupHostMapping);
        configGroupEntity = this.configGroupDAO.merge(this.getConfigGroupEntity());
    }

    private void persist(ConfigGroupEntity configGroupEntity) throws OBDPException {
        this.persistEntities(configGroupEntity);
        this.cluster.refresh();
    }

    @Transactional
    void persistEntities(ConfigGroupEntity configGroupEntity) throws OBDPException {
        ClusterEntity clusterEntity = this.clusterDAO.findById(this.cluster.getClusterId());
        configGroupEntity.setClusterEntity(clusterEntity);
        configGroupEntity.setTimestamp(System.currentTimeMillis());
        this.configGroupDAO.create(configGroupEntity);
        this.configGroupId = configGroupEntity.getGroupId();
        this.persistConfigMapping(clusterEntity, configGroupEntity, this.m_configurations);
        this.replaceHostMappings(this.m_hosts);
    }

    @Transactional
    void replaceHostMappings(Map<Long, Host> hosts) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        this.configGroupHostMappingDAO.removeAllByGroup(configGroupEntity.getGroupId());
        configGroupEntity.setConfigGroupHostMappingEntities(new HashSet<ConfigGroupHostMappingEntity>());
        if (hosts != null && !hosts.isEmpty()) {
            configGroupEntity = this.persistHostMapping(hosts.values(), configGroupEntity);
        }
    }

    @Transactional
    ConfigGroupEntity persistHostMapping(Collection<Host> hosts, ConfigGroupEntity configGroupEntity) {
        for (Host host : hosts) {
            HostEntity hostEntity = this.hostDAO.findById(host.getHostId());
            if (hostEntity != null) {
                ConfigGroupHostMappingEntity hostMappingEntity = new ConfigGroupHostMappingEntity();
                hostMappingEntity.setHostId(hostEntity.getHostId());
                hostMappingEntity.setHostEntity(hostEntity);
                hostMappingEntity.setConfigGroupEntity(configGroupEntity);
                hostMappingEntity.setConfigGroupId(configGroupEntity.getGroupId());
                configGroupEntity.getConfigGroupHostMappingEntities().add(hostMappingEntity);
                this.configGroupHostMappingDAO.create(hostMappingEntity);
                continue;
            }
            LOG.warn("The host {} has been removed from the cluster and cannot be added to the configuration group {}", (Object)host.getHostName(), (Object)this.configGroupName);
        }
        return this.configGroupDAO.merge(configGroupEntity);
    }

    @Transactional
    void persistConfigMapping(ClusterEntity clusterEntity, ConfigGroupEntity configGroupEntity, Map<String, Config> configurations) throws OBDPException {
        this.configGroupConfigMappingDAO.removeAllByGroup(configGroupEntity.getGroupId());
        configGroupEntity.setConfigGroupConfigMappingEntities(new HashSet<ConfigGroupConfigMappingEntity>());
        if (configurations != null && !configurations.isEmpty()) {
            for (Map.Entry<String, Config> entry : configurations.entrySet()) {
                Config config = entry.getValue();
                ClusterConfigEntity clusterConfigEntity = this.clusterDAO.findConfig((Long)this.cluster.getClusterId(), config.getType(), config.getTag());
                if (clusterConfigEntity == null) {
                    String serviceName = this.getServiceName();
                    Service service = this.cluster.getService(serviceName);
                    config = this.configFactory.createNew(service.getDesiredStackId(), config.getType(), this.cluster, config.getTag(), config.getProperties(), config.getPropertiesAttributes(), true);
                    entry.setValue(config);
                    clusterConfigEntity = this.clusterDAO.findConfig((Long)this.cluster.getClusterId(), config.getType(), config.getTag());
                }
                ConfigGroupConfigMappingEntity configMappingEntity = new ConfigGroupConfigMappingEntity();
                configMappingEntity.setTimestamp(System.currentTimeMillis());
                configMappingEntity.setClusterId(clusterEntity.getClusterId());
                configMappingEntity.setClusterConfigEntity(clusterConfigEntity);
                configMappingEntity.setConfigGroupEntity(configGroupEntity);
                configMappingEntity.setConfigGroupId(configGroupEntity.getGroupId());
                configMappingEntity.setConfigType(clusterConfigEntity.getType());
                configMappingEntity.setVersionTag(clusterConfigEntity.getTag());
                this.configGroupConfigMappingDAO.create(configMappingEntity);
                configGroupEntity.getConfigGroupConfigMappingEntities().add(configMappingEntity);
                configGroupEntity = this.configGroupDAO.merge(configGroupEntity);
            }
        }
    }

    @Override
    @Transactional
    public void delete() {
        this.configGroupConfigMappingDAO.removeAllByGroup(this.configGroupId);
        this.configGroupHostMappingDAO.removeAllByGroup(this.configGroupId);
        this.configGroupDAO.removeByPK(this.configGroupId);
        this.cluster.refresh();
    }

    @Override
    public void addHost(Host host) throws OBDPException {
        this.hostLock.writeLock().lock();
        try {
            if (this.m_hosts.containsKey(host.getHostId())) {
                String message = String.format("Host %s is already associated with the configuration group %s", host.getHostName(), this.configGroupName);
                throw new DuplicateResourceException(message);
            }
            ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
            this.persistHostMapping(Collections.singletonList(host), configGroupEntity);
            this.m_hosts.putIfAbsent(host.getHostId(), host);
        }
        finally {
            this.hostLock.writeLock().unlock();
        }
    }

    @Override
    public ConfigGroupResponse convertToResponse() throws OBDPException {
        HashSet<Map<String, Object>> hostnames = new HashSet<Map<String, Object>>();
        for (Object host : this.m_hosts.values()) {
            HashMap<String, String> hostMap = new HashMap<String, String>();
            hostMap.put("host_name", host.getHostName());
            hostnames.add(hostMap);
        }
        HashSet<Map<String, Object>> configObjMap = new HashSet<Map<String, Object>>();
        for (Config config : this.m_configurations.values()) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put(ConfigurationResourceProvider.TYPE, config.getType());
            configMap.put(ConfigurationResourceProvider.TAG, config.getTag());
            configObjMap.add(configMap);
        }
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        ConfigGroupResponse configGroupResponse = new ConfigGroupResponse(configGroupEntity.getGroupId(), this.cluster.getClusterName(), configGroupEntity.getGroupName(), configGroupEntity.getTag(), configGroupEntity.getDescription(), hostnames, configObjMap);
        return configGroupResponse;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity();
        configGroupEntity.setServiceName(serviceName);
        this.configGroupDAO.merge(configGroupEntity);
        this.serviceName = serviceName;
    }

    private ConfigGroupEntity getConfigGroupEntity() {
        return this.configGroupDAO.findById(this.configGroupId);
    }
}

