/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.cluster;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.DiskInfo;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.MetadataHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.events.HostsAddedEvent;
import id.onyx.obdp.server.events.HostsRemovedEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.HostConfigMappingDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostStateDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.RequestOperationLevelDAO;
import id.onyx.obdp.server.orm.dao.ResourceTypeDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.dao.TopologyHostInfoDAO;
import id.onyx.obdp.server.orm.dao.TopologyLogicalTaskDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import id.onyx.obdp.server.security.SecurityHelper;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.state.AgentVersion;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.cluster.ClusterFactory;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.host.HostFactory;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.RetryHelper;
import jakarta.persistence.RollbackException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

@Singleton
public class ClustersImpl
implements Clusters {
    private static final Logger LOG = LoggerFactory.getLogger(ClustersImpl.class);
    private ConcurrentHashMap<String, Cluster> clustersByName = null;
    private ConcurrentHashMap<Long, Cluster> clustersById = null;
    private ConcurrentHashMap<String, Host> hostsByName = null;
    private ConcurrentHashMap<Long, Host> hostsById = null;
    private ConcurrentHashMap<String, Set<Cluster>> hostClustersMap = null;
    private ConcurrentHashMap<String, Set<Host>> clusterHostsMap1 = null;
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private HostVersionDAO hostVersionDAO;
    @Inject
    private HostStateDAO hostStateDAO;
    @Inject
    private ResourceTypeDAO resourceTypeDAO;
    @Inject
    private RequestOperationLevelDAO requestOperationLevelDAO;
    @Inject
    private HostConfigMappingDAO hostConfigMappingDAO;
    @Inject
    private ServiceConfigDAO serviceConfigDAO;
    @Inject
    private ClusterFactory clusterFactory;
    @Inject
    private HostFactory hostFactory;
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private TopologyLogicalTaskDAO topologyLogicalTaskDAO;
    @Inject
    private TopologyHostInfoDAO topologyHostInfoDAO;
    @Inject
    private TopologyManager topologyManager;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    private StackDAO stackDAO;
    @Inject
    private OBDPEventPublisher eventPublisher;
    @Inject
    private Provider<TopologyHolder> m_topologyHolder;
    @Inject
    private Provider<AgentConfigsHolder> m_agentConfigsHolder;
    @Inject
    private Provider<MetadataHolder> m_metadataHolder;
    @Inject
    private Provider<OBDPManagementControllerImpl> m_ambariManagementController;

    @Inject
    public ClustersImpl(ClusterDAO clusterDAO, ClusterFactory clusterFactory, HostDAO hostDAO, HostFactory hostFactory) {
        this.clusterDAO = clusterDAO;
        this.clusterFactory = clusterFactory;
        this.hostDAO = hostDAO;
        this.hostFactory = hostFactory;
    }

    private ConcurrentHashMap<String, Cluster> getClustersByName() {
        if (this.clustersByName == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.clustersByName;
    }

    private ConcurrentHashMap<Long, Cluster> getClustersById() {
        if (this.clustersById == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.clustersById;
    }

    private ConcurrentHashMap<String, Host> getHostsByName() {
        if (this.hostsByName == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.hostsByName;
    }

    private ConcurrentHashMap<Long, Host> getHostsById() {
        if (this.hostsById == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.hostsById;
    }

    private ConcurrentHashMap<String, Set<Cluster>> getHostClustersMap() {
        if (this.hostClustersMap == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.hostClustersMap;
    }

    private ConcurrentHashMap<String, Set<Host>> getClusterHostsMap() {
        if (this.clusterHostsMap1 == null) {
            this.safelyLoadClustersAndHosts();
        }
        return this.clusterHostsMap1;
    }

    private synchronized void safelyLoadClustersAndHosts() {
        if (this.clustersByName == null || this.clustersById == null || this.hostsByName == null || this.hostsById == null || this.hostClustersMap == null || this.clusterHostsMap1 == null) {
            this.loadClustersAndHosts();
        }
    }

    private void loadClustersAndHosts() {
        LOG.info("Initializing cluster and host data.");
        ConcurrentHashMap<String, Cluster> clustersByNameTemp = new ConcurrentHashMap<String, Cluster>();
        ConcurrentHashMap<Long, Cluster> clustersByIdTemp = new ConcurrentHashMap<Long, Cluster>();
        ConcurrentHashMap<String, Host> hostsByNameTemp = new ConcurrentHashMap<String, Host>();
        ConcurrentHashMap<Long, Host> hostsByIdTemp = new ConcurrentHashMap<Long, Host>();
        ConcurrentHashMap hostClustersMapTemp = new ConcurrentHashMap();
        ConcurrentHashMap clusterHostsMap1Temp = new ConcurrentHashMap();
        List<HostEntity> hostEntities = this.hostDAO.findAll();
        for (HostEntity hostEntity : hostEntities) {
            Host host = this.hostFactory.create(hostEntity);
            hostsByNameTemp.put(hostEntity.getHostName(), host);
            hostsByIdTemp.put(hostEntity.getHostId(), host);
        }
        this.hostsByName = hostsByNameTemp;
        this.hostsById = hostsByIdTemp;
        for (ClusterEntity clusterEntity : this.clusterDAO.findAll()) {
            Cluster currentCluster = this.clusterFactory.create(clusterEntity);
            clustersByNameTemp.put(clusterEntity.getClusterName(), currentCluster);
            clustersByIdTemp.put(currentCluster.getClusterId(), currentCluster);
            clusterHostsMap1Temp.put(currentCluster.getClusterName(), Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.clustersByName = clustersByNameTemp;
        this.clustersById = clustersByIdTemp;
        for (HostEntity hostEntity : hostEntities) {
            Set cSet = Collections.newSetFromMap(new ConcurrentHashMap());
            hostClustersMapTemp.put(hostEntity.getHostName(), cSet);
            Host host = this.getHostsByName().get(hostEntity.getHostName());
            for (ClusterEntity clusterEntity : hostEntity.getClusterEntities()) {
                ((Set)clusterHostsMap1Temp.get(clusterEntity.getClusterName())).add(host);
                cSet.add(this.clustersByName.get(clusterEntity.getClusterName()));
            }
        }
        this.hostClustersMap = hostClustersMapTemp;
        this.clusterHostsMap1 = clusterHostsMap1Temp;
        for (Long hostId : this.hostsById.keySet()) {
            try {
                ((AgentConfigsHolder)this.m_agentConfigsHolder.get()).initializeDataIfNeeded(hostId, true);
            }
            catch (OBDPRuntimeException e) {
                LOG.error("Agent configs initialization was failed", (Throwable)e);
            }
        }
    }

    @Override
    public void addCluster(String clusterName, StackId stackId) throws OBDPException {
        this.addCluster(clusterName, stackId, null);
    }

    @Override
    public void addCluster(String clusterName, StackId stackId, SecurityType securityType) throws OBDPException {
        Cluster cluster = null;
        if (this.getClustersByName().containsKey(clusterName)) {
            throw new DuplicateResourceException("Attempted to create a Cluster which already exists, clusterName=" + clusterName);
        }
        ResourceTypeEntity resourceTypeEntity = this.resourceTypeDAO.findById(ResourceType.CLUSTER.getId());
        if (resourceTypeEntity == null) {
            resourceTypeEntity = new ResourceTypeEntity();
            resourceTypeEntity.setId(ResourceType.CLUSTER.getId());
            resourceTypeEntity.setName(ResourceType.CLUSTER.name());
            resourceTypeEntity = this.resourceTypeDAO.merge(resourceTypeEntity);
        }
        ResourceEntity resourceEntity = new ResourceEntity();
        resourceEntity.setResourceType(resourceTypeEntity);
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        ClusterEntity clusterEntity = new ClusterEntity();
        clusterEntity.setClusterName(clusterName);
        clusterEntity.setDesiredStack(stackEntity);
        clusterEntity.setResource(resourceEntity);
        if (securityType != null) {
            clusterEntity.setSecurityType(securityType);
        }
        try {
            this.clusterDAO.create(clusterEntity);
        }
        catch (RollbackException e) {
            LOG.warn("Unable to create cluster " + clusterName, (Throwable)e);
            throw new OBDPException("Unable to create cluster " + clusterName, (Throwable)e);
        }
        cluster = this.clusterFactory.create(clusterEntity);
        this.getClustersByName().put(clusterName, cluster);
        this.getClustersById().put(cluster.getClusterId(), cluster);
        this.getClusterHostsMap().put(clusterName, Collections.newSetFromMap(new ConcurrentHashMap()));
        cluster.setCurrentStackVersion(stackId);
        TreeMap<String, TopologyCluster> addedClusters = new TreeMap<String, TopologyCluster>();
        TopologyCluster addedCluster = new TopologyCluster();
        addedClusters.put(Long.toString(cluster.getClusterId()), addedCluster);
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(addedClusters, UpdateEventType.UPDATE);
        ((TopologyHolder)this.m_topologyHolder.get()).updateData(topologyUpdateEvent);
        ((MetadataHolder)this.m_metadataHolder.get()).updateData(((OBDPManagementControllerImpl)this.m_ambariManagementController.get()).getClusterMetadata(cluster));
    }

    @Override
    public Cluster getCluster(String clusterName) throws OBDPException {
        Cluster cluster = null;
        if (clusterName != null) {
            cluster = this.getClustersByName().get(clusterName);
        }
        if (null == cluster) {
            throw new ClusterNotFoundException(clusterName);
        }
        RetryHelper.addAffectedCluster(cluster);
        return cluster;
    }

    @Override
    public Cluster getCluster(Long clusterId) throws OBDPException {
        Cluster cluster = null;
        if (clusterId != null) {
            cluster = this.getClustersById().get(clusterId);
        }
        if (null == cluster) {
            throw new ClusterNotFoundException(clusterId);
        }
        RetryHelper.addAffectedCluster(cluster);
        return cluster;
    }

    @Override
    public Cluster getClusterById(long id) throws OBDPException {
        ConcurrentHashMap<Long, Cluster> clustersById = this.getClustersById();
        Cluster cluster = clustersById.get(id);
        if (null == cluster) {
            throw new ClusterNotFoundException("clusterID=" + id);
        }
        return clustersById.get(id);
    }

    @Override
    public List<Host> getHosts() {
        return new ArrayList<Host>(this.getHostsByName().values());
    }

    @Override
    public Set<Cluster> getClustersForHost(String hostname) throws OBDPException {
        Set<Cluster> clusters = this.getHostClustersMap().get(hostname);
        if (clusters == null) {
            throw new HostNotFoundException(hostname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up clusters for hostname, hostname={}, mappedClusters={}", (Object)hostname, (Object)clusters.size());
        }
        return Collections.unmodifiableSet(clusters);
    }

    @Override
    public Host getHost(String hostname) throws OBDPException {
        Host host = this.getHostsByName().get(hostname);
        if (null == host) {
            throw new HostNotFoundException(hostname);
        }
        return host;
    }

    @Override
    public boolean hostExists(String hostname) {
        return this.getHostsByName().containsKey(hostname);
    }

    @Override
    public boolean isHostMappedToCluster(long clusterId, String hostName) {
        Set<Cluster> clusters = this.getHostClustersMap().get(hostName);
        for (Cluster cluster : clusters) {
            if (clusterId != cluster.getClusterId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Host getHostById(Long hostId) throws OBDPException {
        if (!this.getHostsById().containsKey(hostId)) {
            throw new HostNotFoundException("Host Id = " + hostId);
        }
        return this.getHostsById().get(hostId);
    }

    @Override
    public void updateHostMappings(Host host) {
        Long hostId = host.getHostId();
        if (null != hostId) {
            this.getHostsById().put(hostId, host);
            try {
                ((AgentConfigsHolder)this.m_agentConfigsHolder.get()).initializeDataIfNeeded(hostId, true);
            }
            catch (OBDPRuntimeException e) {
                LOG.error("Agent configs initialization was failed for host with id %s", (Object)hostId, (Object)e);
            }
        }
    }

    @Override
    public void addHost(String hostname) throws OBDPException {
        if (this.getHostsByName().containsKey(hostname)) {
            throw new OBDPException(MessageFormat.format("Duplicate entry for Host {0}", hostname));
        }
        HostEntity hostEntity = new HostEntity();
        hostEntity.setHostName(hostname);
        hostEntity.setClusterEntities(new ArrayList<ClusterEntity>());
        Host host = this.hostFactory.create(hostEntity);
        host.setAgentVersion(new AgentVersion(""));
        CopyOnWriteArrayList<DiskInfo> emptyDiskList = new CopyOnWriteArrayList<DiskInfo>();
        host.setDisksInfo(emptyDiskList);
        host.setHealthStatus(new HostHealthStatus(HostHealthStatus.HealthStatus.UNKNOWN, ""));
        host.setHostAttributes(new ConcurrentHashMap<String, String>());
        host.setState(HostState.INIT);
        this.getHostsByName().put(hostname, host);
        this.getHostsById().put(host.getHostId(), host);
        this.getHostClustersMap().put(hostname, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding a host to Clusters, hostname={}", (Object)hostname);
        }
    }

    @Override
    public void updateHostWithClusterAndAttributes(Map<String, Set<String>> hostClusters, Map<String, Map<String, String>> hostAttributes) throws OBDPException {
        if (null == hostClusters || hostClusters.isEmpty()) {
            return;
        }
        Map<String, Host> hostMap = this.getHostsMap(hostClusters.keySet());
        HashMap clusterHosts = new HashMap();
        for (Map.Entry<String, Set<String>> entry : hostClusters.entrySet()) {
            Set<String> hostClusterNames = entry.getValue();
            String hostname = entry.getKey();
            Host host = hostMap.get(hostname);
            Map<String, String> attributes = hostAttributes.get(hostname);
            if (attributes != null && !attributes.isEmpty()) {
                host.setHostAttributes(attributes);
            }
            for (String clusterName : hostClusterNames) {
                if (clusterName == null || clusterName.isEmpty()) continue;
                if (!clusterHosts.containsKey(clusterName)) {
                    clusterHosts.put(clusterName, new HashSet());
                }
                ((Set)clusterHosts.get(clusterName)).add(hostname);
            }
        }
        for (Map.Entry<String, Set<String>> entry : clusterHosts.entrySet()) {
            Set<String> clusterHostsNames = entry.getValue();
            String clusterName = entry.getKey();
            this.mapAndPublishHostsToCluster(clusterHostsNames, clusterName);
        }
    }

    private Map<String, Host> getHostsMap(Collection<String> hostSet) throws HostNotFoundException {
        HashMap<String, Host> hostMap = new HashMap<String, Host>();
        Host host = null;
        for (String hostName : hostSet) {
            if (null != hostName) {
                host = this.getHostsByName().get(hostName);
                if (host == null) {
                    throw new HostNotFoundException(hostName);
                }
            } else {
                throw new HostNotFoundException(hostName);
            }
            hostMap.put(hostName, host);
        }
        return hostMap;
    }

    @Override
    public void mapAndPublishHostsToCluster(Set<String> hostnames, String clusterName) throws OBDPException {
        for (String hostname : hostnames) {
            this.mapHostToCluster(hostname, clusterName);
        }
        this.publishAddingHostsToCluster(hostnames, clusterName);
        this.getCluster(clusterName).refresh();
    }

    private void publishAddingHostsToCluster(Set<String> hostnames, String clusterName) throws OBDPException {
        HostsAddedEvent event = new HostsAddedEvent(this.getCluster(clusterName).getClusterId(), hostnames);
        this.eventPublisher.publish(event);
    }

    @Override
    public void mapHostToCluster(String hostname, String clusterName) throws OBDPException {
        Host host = this.getHost(hostname);
        Cluster cluster = this.getCluster(clusterName);
        ConcurrentHashMap<String, Set<Cluster>> hostClustersMap = this.getHostClustersMap();
        for (Cluster c : hostClustersMap.get(hostname)) {
            if (!c.getClusterName().equals(clusterName)) continue;
            throw new DuplicateResourceException("Attempted to create a host which already exists: clusterName=" + clusterName + ", hostName=" + hostname);
        }
        long clusterId = cluster.getClusterId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping host {} to cluster {} (id={})", new Object[]{hostname, clusterName, clusterId});
        }
        this.mapHostClusterEntities(hostname, clusterId);
        hostClustersMap.get(hostname).add(cluster);
        this.getClusterHostsMap().get(clusterName).add(host);
    }

    @Transactional
    void mapHostClusterEntities(String hostName, Long clusterId) {
        HostEntity hostEntity = this.hostDAO.findByName(hostName);
        ClusterEntity clusterEntity = this.clusterDAO.findById(clusterId);
        hostEntity.getClusterEntities().add(clusterEntity);
        clusterEntity.getHostEntities().add(hostEntity);
        this.clusterDAO.merge(clusterEntity);
        this.hostDAO.merge(hostEntity);
    }

    @Override
    public Map<String, Cluster> getClusters() {
        return Collections.unmodifiableMap(this.getClustersByName());
    }

    @Override
    public void updateClusterName(String oldName, String newName) {
        ConcurrentHashMap<String, Cluster> clusters = this.getClustersByName();
        clusters.put(newName, clusters.remove(oldName));
        ConcurrentHashMap<String, Set<Host>> clusterHostsMap = this.getClusterHostsMap();
        clusterHostsMap.put(newName, clusterHostsMap.remove(oldName));
    }

    @Override
    public void debugDump(StringBuilder sb) {
        sb.append("Clusters=[ ");
        boolean first = true;
        for (Cluster c : this.getClustersByName().values()) {
            if (!first) {
                sb.append(" , ");
            }
            first = false;
            sb.append("\n  ");
            c.debugDump(sb);
            sb.append(" ");
        }
        sb.append(" ]");
    }

    @Override
    public Map<String, Host> getHostsForCluster(String clusterName) {
        HashMap<String, Host> hosts = new HashMap<String, Host>();
        for (Host h : this.getClusterHostsMap().get(clusterName)) {
            hosts.put(h.getHostName(), h);
        }
        return hosts;
    }

    @Override
    public Map<Long, Host> getHostIdsForCluster(String clusterName) throws OBDPException {
        HashMap<Long, Host> hosts = new HashMap<Long, Host>();
        for (Host h : this.getClusterHostsMap().get(clusterName)) {
            HostEntity hostEntity = this.hostDAO.findByName(h.getHostName());
            hosts.put(hostEntity.getHostId(), h);
        }
        return hosts;
    }

    @Override
    public void deleteCluster(String clusterName) throws OBDPException {
        Cluster cluster = this.getCluster(clusterName);
        if (!cluster.canBeRemoved()) {
            throw new OBDPException("Could not delete cluster, clusterName=" + clusterName);
        }
        LOG.info("Deleting cluster " + cluster.getClusterName());
        cluster.delete();
        for (Set<Cluster> clusterSet : this.getHostClustersMap().values()) {
            clusterSet.remove(cluster);
        }
        this.getClusterHostsMap().remove(cluster.getClusterName());
        this.getClustersByName().remove(clusterName);
    }

    @Override
    public void unmapHostFromCluster(String hostname, String clusterName) throws OBDPException {
        Cluster cluster = this.getCluster(clusterName);
        Host host = this.getHost(hostname);
        this.unmapHostFromClusters(host, Sets.newHashSet((Object[])new Cluster[]{cluster}));
        cluster.refresh();
    }

    @Transactional
    void unmapHostFromClusters(Host host, Set<Cluster> clusters) throws OBDPException {
        HostEntity hostEntity = null;
        if (clusters.isEmpty()) {
            return;
        }
        String hostname = host.getHostName();
        hostEntity = this.hostDAO.findByName(hostname);
        for (Cluster cluster : clusters) {
            long clusterId = cluster.getClusterId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unmapping host {} from cluster {} (id={})", new Object[]{hostname, cluster.getClusterName(), clusterId});
            }
            this.unmapHostClusterEntities(hostname, cluster.getClusterId());
            this.getHostClustersMap().get(hostname).remove(cluster);
            this.getClusterHostsMap().get(cluster.getClusterName()).remove(host);
        }
        this.deleteConfigGroupHostMapping(hostEntity.getHostId());
        this.kerberosKeytabPrincipalDAO.removeByHost(hostEntity.getHostId());
    }

    @Transactional
    void unmapHostClusterEntities(String hostName, long clusterId) {
        HostEntity hostEntity = this.hostDAO.findByName(hostName);
        ClusterEntity clusterEntity = this.clusterDAO.findById(clusterId);
        hostEntity.getClusterEntities().remove(clusterEntity);
        clusterEntity.getHostEntities().remove(hostEntity);
        this.hostDAO.merge(hostEntity);
        this.clusterDAO.merge(clusterEntity, true);
    }

    @Transactional
    void deleteConfigGroupHostMapping(Long hostId) throws OBDPException {
        for (Cluster cluster : this.getClustersByName().values()) {
            for (ConfigGroup configGroup : cluster.getConfigGroups().values()) {
                configGroup.removeHost(hostId);
            }
        }
    }

    @Override
    public void deleteHost(String hostname) throws OBDPException {
        Set<Cluster> clusters = this.getHostClustersMap().get(hostname);
        if (clusters == null) {
            throw new HostNotFoundException(hostname);
        }
        this.deleteHostEntityRelationships(hostname);
    }

    @Override
    public void publishHostsDeletion(Set<Long> hostIds, Set<String> hostNames) throws OBDPException {
        HostsRemovedEvent event = new HostsRemovedEvent(hostNames, hostIds);
        this.eventPublisher.publish(event);
    }

    @Transactional
    void deleteHostEntityRelationships(String hostname) throws OBDPException {
        if (!this.getHostsByName().containsKey(hostname)) {
            throw new HostNotFoundException("Could not find host " + hostname);
        }
        HostEntity entity = this.hostDAO.findByName(hostname);
        if (entity == null) {
            return;
        }
        Set<Cluster> clusters = this.getHostClustersMap().get(hostname);
        HashSet clusterIds = Sets.newHashSet();
        for (Cluster cluster : clusters) {
            clusterIds.add(cluster.getClusterId());
        }
        Host host = this.getHostsByName().get(hostname);
        this.unmapHostFromClusters(host, clusters);
        this.hostDAO.refresh(entity);
        this.hostVersionDAO.removeByHostName(hostname);
        if (entity.getHostRoleCommandEntities() != null) {
            for (HostRoleCommandEntity hrcEntity : entity.getHostRoleCommandEntities()) {
                TopologyLogicalTaskEntity topologyLogicalTaskEnity = hrcEntity.getTopologyLogicalTaskEntity();
                if (topologyLogicalTaskEnity == null) continue;
                this.topologyLogicalTaskDAO.remove(topologyLogicalTaskEnity);
                hrcEntity.setTopologyLogicalTaskEntity(null);
            }
        }
        this.topologyManager.removeHostRequests(hostname);
        entity.setHostStateEntity(null);
        this.hostStateDAO.removeByHostId(entity.getHostId());
        this.hostConfigMappingDAO.removeByHostId(entity.getHostId());
        this.serviceConfigDAO.removeHostFromServiceConfigs(entity.getHostId());
        this.requestOperationLevelDAO.removeByHostId(entity.getHostId());
        this.topologyHostInfoDAO.removeByHost(entity);
        this.getHostsByName().remove(hostname);
        this.getHostsById().remove(entity.getHostId());
        this.hostDAO.remove(entity);
    }

    @Override
    public boolean checkPermission(String clusterName, boolean readOnly) {
        Cluster cluster = this.findCluster(clusterName);
        return cluster == null && readOnly || this.checkPermission(cluster, readOnly);
    }

    @Override
    public void addSessionAttributes(String name, Map<String, Object> attributes) {
        Cluster cluster = this.findCluster(name);
        if (cluster != null) {
            cluster.addSessionAttributes(attributes);
        }
    }

    @Override
    public Map<String, Object> getSessionAttributes(String name) {
        Cluster cluster = this.findCluster(name);
        return cluster == null ? Collections.emptyMap() : cluster.getSessionAttributes();
    }

    @Override
    public int getClusterSize(String clusterName) {
        int hostCount = 0;
        ConcurrentHashMap<String, Set<Host>> clusterHostsMap = this.getClusterHostsMap();
        Set<Host> hosts = clusterHostsMap.get(clusterName);
        if (null != hosts) {
            hostCount = clusterHostsMap.get(clusterName).size();
        }
        return hostCount;
    }

    protected Cluster findCluster(String name) {
        Cluster cluster = null;
        try {
            cluster = name == null ? null : this.getCluster(name);
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        return cluster;
    }

    private boolean checkPermission(Cluster cluster, boolean readOnly) {
        for (GrantedAuthority grantedAuthority : this.securityHelper.getCurrentAuthorities()) {
            if (!(grantedAuthority instanceof OBDPGrantedAuthority)) continue;
            OBDPGrantedAuthority authority = (OBDPGrantedAuthority)grantedAuthority;
            PrivilegeEntity privilegeEntity = authority.getPrivilegeEntity();
            Integer permissionId = privilegeEntity.getPermission().getId();
            if (permissionId.equals(1)) {
                return true;
            }
            if (cluster == null || !cluster.checkPermission(privilegeEntity, readOnly)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidate(Cluster cluster) {
        ClusterEntity clusterEntity = this.clusterDAO.findById(cluster.getClusterId());
        Cluster currentCluster = this.clusterFactory.create(clusterEntity);
        this.getClustersByName().put(clusterEntity.getClusterName(), currentCluster);
        this.getClustersById().put(currentCluster.getClusterId(), currentCluster);
    }

    @Override
    public void invalidateAllClusters() {
        if (this.clustersByName != null) {
            Collection<Cluster> clusters = this.clustersByName.values();
            for (Cluster cluster : clusters) {
                this.invalidate(cluster);
            }
        }
    }
}

