/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.cluster;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ConfigGroupNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.ServiceComponentHostNotFoundException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.ClusterResponse;
import id.onyx.obdp.server.controller.ConfigurationResponse;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPSessionManager;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.controller.internal.BlueprintConfigurationProcessor;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.events.ClusterConfigChangedEvent;
import id.onyx.obdp.server.events.ClusterEvent;
import id.onyx.obdp.server.events.ClusterProvisionedEvent;
import id.onyx.obdp.server.events.ConfigsUpdateEvent;
import id.onyx.obdp.server.events.OBDPEvent;
import id.onyx.obdp.server.events.jpa.EntityManagerCacheInvalidationEvent;
import id.onyx.obdp.server.events.publishers.JPAEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.logging.LockFactory;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.cache.HostConfigMapping;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ClusterStateDAO;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.HostConfigMappingDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterStateEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.TopologyRequestEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContextFactory;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ClusterHealthReport;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.ServiceComponentHostEventType;
import id.onyx.obdp.server.state.ServiceFactory;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.configgroup.ConfigGroupFactory;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.scheduler.RequestExecutionFactory;
import id.onyx.obdp.server.topology.STOMPComponentsDeleteHandler;
import id.onyx.obdp.server.topology.TopologyRequest;
import id.onyx.obdp.spi.ClusterInformation;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.RepositoryVersion;
import jakarta.persistence.RollbackException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterImpl
implements Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterImpl.class);
    private static final Logger configChangeLog = LoggerFactory.getLogger((String)"configchange");
    private static final String CLUSTER_SESSION_ATTRIBUTES_PREFIX = "cluster_session_attributes:";
    @Inject
    private Clusters clusters;
    private StackId desiredStackVersion;
    private final ConcurrentSkipListMap<String, Service> services = new ConcurrentSkipListMap();
    private final ConcurrentMap<String, ConcurrentMap<String, Config>> allConfigs = new ConcurrentHashMap<String, ConcurrentMap<String, Config>>();
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ServiceComponentHost>>> serviceComponentHosts = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ServiceComponentHost>>>();
    private final ConcurrentMap<String, List<ServiceComponentHost>> serviceComponentHostsByHost = new ConcurrentHashMap<String, List<ServiceComponentHost>>();
    private final Map<Long, ConfigGroup> clusterConfigGroups = new ConcurrentHashMap<Long, ConfigGroup>();
    private final Map<Long, RequestExecution> requestExecutions = new ConcurrentHashMap<Long, RequestExecution>();
    private final ReadWriteLock clusterGlobalLock;
    private final long clusterId;
    private String clusterName;
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private ClusterStateDAO clusterStateDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private HostVersionDAO hostVersionDAO;
    @Inject
    private ServiceFactory serviceFactory;
    @Inject
    private ConfigFactory configFactory;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private HostConfigMappingDAO hostConfigMappingDAO;
    @Inject
    private ConfigGroupFactory configGroupFactory;
    @Inject
    private RequestExecutionFactory requestExecutionFactory;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private OBDPManagementController controller;
    @Inject
    private ServiceConfigDAO serviceConfigDAO;
    @Inject
    private AlertDefinitionDAO alertDefinitionDAO;
    @Inject
    private AlertDispatchDAO alertDispatchDAO;
    @Inject
    private UpgradeDAO upgradeDAO;
    @Inject
    private OBDPSessionManager sessionManager;
    @Inject
    private TopologyRequestDAO topologyRequestDAO;
    @Inject
    private STOMPComponentsDeleteHandler STOMPComponentsDeleteHandler;
    @Inject
    private HostLevelParamsHolder hostLevelParamsHolder;
    @Inject
    private StackDAO stackDAO;
    private volatile Multimap<String, String> serviceConfigTypes;
    private OBDPEventPublisher eventPublisher;
    @Inject
    private JPAEventPublisher jpaEventPublisher;
    @Inject
    private RoleCommandOrderProvider roleCommandOrderProvider;
    @Inject
    private UpgradeContextFactory upgradeContextFactory;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private HostComponentDesiredStateDAO hostComponentDesiredStateDAO;
    private Map<String, String> m_clusterPropertyCache = new ConcurrentHashMap<String, String>();

    @Inject
    public ClusterImpl(@Assisted ClusterEntity clusterEntity, Injector injector, OBDPEventPublisher eventPublisher) throws OBDPException {
        this.clusterId = clusterEntity.getClusterId();
        this.clusterName = clusterEntity.getClusterName();
        injector.injectMembers((Object)this);
        this.clusterGlobalLock = this.lockFactory.newReadWriteLock("clusterGlobalLock");
        this.loadStackVersion();
        this.loadServices();
        this.loadServiceHostComponents();
        this.cacheConfigurations();
        this.loadConfigGroups();
        this.loadRequestExecutions();
        if (this.desiredStackVersion != null && !StringUtils.isEmpty((String)this.desiredStackVersion.getStackName()) && !StringUtils.isEmpty((String)this.desiredStackVersion.getStackVersion())) {
            this.loadServiceConfigTypes();
        }
        eventPublisher.register(this);
        this.eventPublisher = eventPublisher;
    }

    private void loadServiceConfigTypes() throws OBDPException {
        try {
            this.serviceConfigTypes = this.collectServiceConfigTypesMapping();
        }
        catch (OBDPException e) {
            LOG.error("Cannot load stack info:", (Throwable)e);
            throw e;
        }
        LOG.info("Service config types loaded: {}", this.serviceConfigTypes);
    }

    private Multimap<String, String> collectServiceConfigTypesMapping() throws OBDPException {
        HashMultimap serviceConfigTypes = HashMultimap.create();
        Map<String, ServiceInfo> serviceInfoMap = null;
        try {
            serviceInfoMap = this.obdpMetaInfo.getServices(this.desiredStackVersion.getStackName(), this.desiredStackVersion.getStackVersion());
        }
        catch (ParentObjectNotFoundException e) {
            LOG.error("Service config versioning disabled due to exception: ", (Throwable)((Object)e));
            return serviceConfigTypes;
        }
        for (Map.Entry<String, ServiceInfo> entry : serviceInfoMap.entrySet()) {
            String serviceName = entry.getKey();
            ServiceInfo serviceInfo = entry.getValue();
            Set<String> configTypes = serviceInfo.getConfigTypeAttributes().keySet();
            for (String configType : configTypes) {
                serviceConfigTypes.put((Object)serviceName, (Object)configType);
            }
        }
        return serviceConfigTypes;
    }

    private void loadServiceHostComponents() {
        for (Map.Entry<String, Service> serviceKV : this.services.entrySet()) {
            Service service = serviceKV.getValue();
            if (!this.serviceComponentHosts.containsKey(service.getName())) {
                this.serviceComponentHosts.put(service.getName(), new ConcurrentHashMap());
            }
            for (Map.Entry<String, ServiceComponent> svcComponent : service.getServiceComponents().entrySet()) {
                ServiceComponent comp = svcComponent.getValue();
                String componentName = svcComponent.getKey();
                if (!((ConcurrentMap)this.serviceComponentHosts.get(service.getName())).containsKey(componentName)) {
                    ((ConcurrentMap)this.serviceComponentHosts.get(service.getName())).put(componentName, new ConcurrentHashMap());
                }
                for (Map.Entry<String, ServiceComponentHost> svchost : comp.getServiceComponentHosts().entrySet()) {
                    String hostname = svchost.getKey();
                    ServiceComponentHost svcHostComponent = svchost.getValue();
                    if (!this.serviceComponentHostsByHost.containsKey(hostname)) {
                        this.serviceComponentHostsByHost.put(hostname, new CopyOnWriteArrayList());
                    }
                    List compList = (List)this.serviceComponentHostsByHost.get(hostname);
                    compList.add(svcHostComponent);
                    if (((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(service.getName())).get(componentName)).containsKey(hostname)) continue;
                    ((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(service.getName())).get(componentName)).put(hostname, svcHostComponent);
                }
            }
        }
    }

    private void loadServices() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        if (CollectionUtils.isEmpty(clusterEntity.getClusterServiceEntities())) {
            return;
        }
        for (ClusterServiceEntity serviceEntity : clusterEntity.getClusterServiceEntities()) {
            StackId stackId = this.getCurrentStackVersion();
            try {
                if (this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceEntity.getServiceName()) == null) continue;
                this.services.put(serviceEntity.getServiceName(), this.serviceFactory.createExisting(this, serviceEntity));
            }
            catch (OBDPException e) {
                LOG.error(String.format("Can not get service info: stackName=%s, stackVersion=%s, serviceName=%s", stackId.getStackName(), stackId.getStackVersion(), serviceEntity.getServiceName()));
            }
        }
    }

    private void loadConfigGroups() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        if (!clusterEntity.getConfigGroupEntities().isEmpty()) {
            for (ConfigGroupEntity configGroupEntity : clusterEntity.getConfigGroupEntities()) {
                this.clusterConfigGroups.put(configGroupEntity.getGroupId(), this.configGroupFactory.createExisting(this, configGroupEntity));
            }
        }
    }

    private void loadRequestExecutions() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        if (!clusterEntity.getRequestScheduleEntities().isEmpty()) {
            for (RequestScheduleEntity scheduleEntity : clusterEntity.getRequestScheduleEntities()) {
                this.requestExecutions.put(scheduleEntity.getScheduleId(), this.requestExecutionFactory.createExisting(this, scheduleEntity));
            }
        }
    }

    @Override
    public void addConfigGroup(ConfigGroup configGroup) throws OBDPException {
        Object hostList = "";
        if (LOG.isDebugEnabled() && configGroup.getHosts() != null) {
            for (Host host : configGroup.getHosts().values()) {
                hostList = (String)hostList + host.getHostName() + ", ";
            }
        }
        LOG.debug("Adding a new Config group, clusterName = {}, groupName = {}, tag = {} with hosts {}", new Object[]{this.getClusterName(), configGroup.getName(), configGroup.getTag(), hostList});
        if (this.clusterConfigGroups.containsKey(configGroup.getId())) {
            LOG.debug("Config group already exists, clusterName = {}, groupName = {}, groupId = {}, tag = {}", new Object[]{this.getClusterName(), configGroup.getName(), configGroup.getId(), configGroup.getTag()});
        } else {
            this.clusterConfigGroups.put(configGroup.getId(), configGroup);
        }
    }

    @Override
    public Map<Long, ConfigGroup> getConfigGroups() {
        return Collections.unmodifiableMap(this.clusterConfigGroups);
    }

    @Override
    public Map<Long, ConfigGroup> getConfigGroupsByHostname(String hostname) throws OBDPException {
        HashMap<Long, ConfigGroup> configGroups = new HashMap<Long, ConfigGroup>();
        block0: for (Map.Entry<Long, ConfigGroup> groupEntry : this.clusterConfigGroups.entrySet()) {
            Long id = groupEntry.getKey();
            ConfigGroup group = groupEntry.getValue();
            for (Host host : group.getHosts().values()) {
                if (!StringUtils.equals((String)hostname, (String)host.getHostName())) continue;
                configGroups.put(id, group);
                continue block0;
            }
        }
        return configGroups;
    }

    @Override
    public ConfigGroup getConfigGroupsById(Long configId) {
        return this.clusterConfigGroups.get(configId);
    }

    @Override
    public Map<Long, ConfigGroup> getConfigGroupsByServiceName(String serviceName) {
        HashMap<Long, ConfigGroup> configGroups = new HashMap<Long, ConfigGroup>();
        for (Map.Entry<Long, ConfigGroup> groupEntry : this.clusterConfigGroups.entrySet()) {
            Long id = groupEntry.getKey();
            ConfigGroup group = groupEntry.getValue();
            if (!StringUtils.equals((String)serviceName, (String)group.getServiceName())) continue;
            configGroups.put(id, group);
        }
        return configGroups;
    }

    @Override
    public void addRequestExecution(RequestExecution requestExecution) throws OBDPException {
        LOG.info("Adding a new request schedule, clusterName = " + this.getClusterName() + ", id = " + requestExecution.getId() + ", description = " + requestExecution.getDescription());
        if (this.requestExecutions.containsKey(requestExecution.getId())) {
            LOG.debug("Request schedule already exists, clusterName = {}, id = {}, description = {}", new Object[]{this.getClusterName(), requestExecution.getId(), requestExecution.getDescription()});
        } else {
            this.requestExecutions.put(requestExecution.getId(), requestExecution);
        }
    }

    @Override
    public Map<Long, RequestExecution> getAllRequestExecutions() {
        return Collections.unmodifiableMap(this.requestExecutions);
    }

    @Override
    public void deleteRequestExecution(Long id) throws OBDPException {
        RequestExecution requestExecution = this.requestExecutions.get(id);
        if (requestExecution == null) {
            throw new OBDPException("Request schedule does not exists, id = " + id);
        }
        LOG.info("Deleting request schedule, clusterName = " + this.getClusterName() + ", id = " + requestExecution.getId() + ", description = " + requestExecution.getDescription());
        requestExecution.delete();
        this.requestExecutions.remove(id);
    }

    @Override
    public void deleteConfigGroup(Long id) throws OBDPException {
        ConfigGroup configGroup = this.clusterConfigGroups.get(id);
        if (configGroup == null) {
            throw new ConfigGroupNotFoundException(this.getClusterName(), id.toString());
        }
        LOG.debug("Deleting Config group, clusterName = {}, groupName = {}, groupId = {}, tag = {}", new Object[]{this.getClusterName(), configGroup.getName(), configGroup.getId(), configGroup.getTag()});
        configGroup.delete();
        this.clusterConfigGroups.remove(id);
        this.configHelper.updateAgentConfigs(Collections.singleton(configGroup.getClusterName()));
    }

    public ServiceComponentHost getServiceComponentHost(String serviceName, String serviceComponentName, String hostname) throws OBDPException {
        if (!(this.serviceComponentHosts.containsKey(serviceName) && ((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).containsKey(serviceComponentName) && ((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(serviceComponentName)).containsKey(hostname))) {
            throw new ServiceComponentHostNotFoundException(this.getClusterName(), serviceName, serviceComponentName, hostname);
        }
        return (ServiceComponentHost)((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(serviceComponentName)).get(hostname);
    }

    @Override
    public List<ServiceComponentHost> getServiceComponentHosts() {
        ArrayList serviceComponentHosts = new ArrayList();
        if (!this.serviceComponentHostsByHost.isEmpty()) {
            for (List schList : this.serviceComponentHostsByHost.values()) {
                serviceComponentHosts.addAll(schList);
            }
        }
        return Collections.unmodifiableList(serviceComponentHosts);
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void setClusterName(String clusterName) {
        String oldName = null;
        ClusterEntity clusterEntity = this.getClusterEntity();
        oldName = clusterEntity.getClusterName();
        clusterEntity.setClusterName(clusterName);
        clusterEntity = this.clusterDAO.merge(clusterEntity);
        this.clusters.updateClusterName(oldName, clusterName);
        this.clusterName = clusterName;
        if (!StringUtils.equals((String)oldName, (String)clusterName)) {
            ClusterEvent clusterNameChangedEvent = new ClusterEvent(OBDPEvent.OBDPEventType.CLUSTER_RENAME, this.clusterId);
            this.eventPublisher.publish(clusterNameChangedEvent);
        }
    }

    @Override
    public Long getResourceId() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        ResourceEntity resourceEntity = clusterEntity.getResource();
        if (resourceEntity == null) {
            LOG.warn("There is no resource associated with this cluster:\n\tCluster Name: {}\n\tCluster ID: {}", (Object)this.getClusterName(), (Object)this.getClusterId());
            return null;
        }
        return resourceEntity.getId();
    }

    @Override
    @Transactional
    public void addServiceComponentHosts(Collection<ServiceComponentHost> serviceComponentHosts) throws OBDPException {
        for (ServiceComponentHost serviceComponentHost : serviceComponentHosts) {
            Service service = this.getService(serviceComponentHost.getServiceName());
            ServiceComponent serviceComponent = service.getServiceComponent(serviceComponentHost.getServiceComponentName());
            serviceComponent.addServiceComponentHost(serviceComponentHost);
        }
    }

    public void addServiceComponentHost(ServiceComponentHost svcCompHost) throws OBDPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to add component {} of service {} on {} to the cache", new Object[]{svcCompHost.getServiceComponentName(), svcCompHost.getServiceName(), svcCompHost.getHostName()});
        }
        String hostname = svcCompHost.getHostName();
        String serviceName = svcCompHost.getServiceName();
        String componentName = svcCompHost.getServiceComponentName();
        Set<Cluster> cs = this.clusters.getClustersForHost(hostname);
        boolean clusterFound = false;
        for (Cluster c : cs) {
            if (c.getClusterId() != this.getClusterId()) continue;
            clusterFound = true;
            break;
        }
        if (!clusterFound) {
            throw new OBDPException("Host does not belong this cluster, hostname=" + hostname + ", clusterName=" + this.getClusterName() + ", clusterId=" + this.getClusterId());
        }
        if (!this.serviceComponentHosts.containsKey(serviceName)) {
            this.serviceComponentHosts.put(serviceName, new ConcurrentHashMap());
        }
        if (!((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).containsKey(componentName)) {
            ((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).put(componentName, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(componentName)).containsKey(hostname)) {
            throw new OBDPException("Duplicate entry for ServiceComponentHost, serviceName=" + serviceName + ", serviceComponentName" + componentName + ", hostname= " + hostname);
        }
        if (!this.serviceComponentHostsByHost.containsKey(hostname)) {
            this.serviceComponentHostsByHost.put(hostname, new CopyOnWriteArrayList());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding a new ServiceComponentHost, clusterName={}, clusterId={}, serviceName={}, serviceComponentName{}, hostname= {}", new Object[]{this.getClusterName(), this.getClusterId(), serviceName, componentName, hostname});
        }
        ((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(componentName)).put(hostname, svcCompHost);
        ((List)this.serviceComponentHostsByHost.get(hostname)).add(svcCompHost);
    }

    @Override
    public void removeServiceComponentHost(ServiceComponentHost svcCompHost) throws OBDPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to remove component {} of service {} on {} from the cache", new Object[]{svcCompHost.getServiceComponentName(), svcCompHost.getServiceName(), svcCompHost.getHostName()});
        }
        String hostname = svcCompHost.getHostName();
        String serviceName = svcCompHost.getServiceName();
        String componentName = svcCompHost.getServiceComponentName();
        Set<Cluster> cs = this.clusters.getClustersForHost(hostname);
        boolean clusterFound = false;
        for (Cluster c : cs) {
            if (c.getClusterId() != this.getClusterId()) continue;
            clusterFound = true;
            break;
        }
        if (!clusterFound) {
            throw new OBDPException("Host does not belong this cluster, hostname=" + hostname + ", clusterName=" + this.getClusterName() + ", clusterId=" + this.getClusterId());
        }
        if (!(this.serviceComponentHosts.containsKey(serviceName) && ((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).containsKey(componentName) && ((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(componentName)).containsKey(hostname))) {
            throw new OBDPException("Invalid entry for ServiceComponentHost, serviceName=" + serviceName + ", serviceComponentName" + componentName + ", hostname= " + hostname);
        }
        if (!this.serviceComponentHostsByHost.containsKey(hostname)) {
            throw new OBDPException("Invalid host entry for ServiceComponentHost, serviceName=" + serviceName + ", serviceComponentName" + componentName + ", hostname= " + hostname);
        }
        ServiceComponentHost schToRemove = null;
        for (ServiceComponentHost sch : (List)this.serviceComponentHostsByHost.get(hostname)) {
            if (!sch.getServiceName().equals(serviceName) || !sch.getServiceComponentName().equals(componentName) || !sch.getHostName().equals(hostname)) continue;
            schToRemove = sch;
            break;
        }
        if (schToRemove == null) {
            LOG.warn("Unavailable in per host cache. ServiceComponentHost, serviceName=" + serviceName + ", serviceComponentName" + componentName + ", hostname= " + hostname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing a ServiceComponentHost, clusterName={}, clusterId={}, serviceName={}, serviceComponentName{}, hostname= {}", new Object[]{this.getClusterName(), this.getClusterId(), serviceName, componentName, hostname});
        }
        ((ConcurrentMap)((ConcurrentMap)this.serviceComponentHosts.get(serviceName)).get(componentName)).remove(hostname);
        if (schToRemove != null) {
            ((List)this.serviceComponentHostsByHost.get(hostname)).remove(schToRemove);
        }
    }

    @Override
    public long getClusterId() {
        return this.clusterId;
    }

    @Override
    public List<ServiceComponentHost> getServiceComponentHosts(String hostname) {
        List serviceComponentHosts = (List)this.serviceComponentHostsByHost.get(hostname);
        if (null != serviceComponentHosts) {
            return new CopyOnWriteArrayList<ServiceComponentHost>(serviceComponentHosts);
        }
        return new ArrayList<ServiceComponentHost>();
    }

    @Override
    public Map<String, Set<String>> getServiceComponentHostMap(Set<String> hostNames, Set<String> serviceNames) {
        TreeMap<String, Set<String>> componentHostMap = new TreeMap<String, Set<String>>();
        Collection<Host> hosts = this.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                List<ServiceComponentHost> serviceComponentHosts;
                String hostname = host.getHostName();
                if (hostNames != null && !hostNames.contains(hostname) || (serviceComponentHosts = this.getServiceComponentHosts(hostname)) == null) continue;
                for (ServiceComponentHost sch : serviceComponentHosts) {
                    if (serviceNames != null && !serviceNames.contains(sch.getServiceName())) continue;
                    String component = sch.getServiceComponentName();
                    TreeSet<String> componentHosts = (TreeSet<String>)componentHostMap.get(component);
                    if (componentHosts == null) {
                        componentHosts = new TreeSet<String>();
                        componentHostMap.put(component, componentHosts);
                    }
                    componentHosts.add(hostname);
                }
            }
        }
        return componentHostMap;
    }

    @Override
    public List<ServiceComponentHost> getServiceComponentHosts(String serviceName, String componentName) {
        ArrayList<ServiceComponentHost> foundItems = new ArrayList<ServiceComponentHost>();
        ConcurrentMap foundByService = (ConcurrentMap)this.serviceComponentHosts.get(serviceName);
        if (foundByService != null) {
            if (componentName == null) {
                for (Map foundByComponent : foundByService.values()) {
                    foundItems.addAll(foundByComponent.values());
                }
            } else if (foundByService.containsKey(componentName)) {
                foundItems.addAll(((ConcurrentMap)foundByService.get(componentName)).values());
            }
        }
        return foundItems;
    }

    @Override
    public void addService(Service service) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding a new Service, clusterName={}, clusterId={}, serviceName={}", new Object[]{this.getClusterName(), this.getClusterId(), service.getName()});
        }
        this.services.put(service.getName(), service);
    }

    @Override
    public Service addService(String serviceName, RepositoryVersionEntity repositoryVersion) throws OBDPException {
        if (this.services.containsKey(serviceName)) {
            String message = MessageFormat.format("The {0} service already exists in {1}", serviceName, this.getClusterName());
            throw new OBDPException(message);
        }
        Service service = this.serviceFactory.createNew(this, serviceName, repositoryVersion);
        this.addService(service);
        return service;
    }

    @Override
    public Service getService(String serviceName) throws OBDPException {
        Service service = this.services.get(serviceName);
        if (null == service) {
            throw new ServiceNotFoundException(this.getClusterName(), serviceName);
        }
        return service;
    }

    @Override
    public Map<String, Service> getServices() {
        return new HashMap<String, Service>(this.services);
    }

    @Override
    public Service getServiceByComponentName(String componentName) throws OBDPException {
        for (Service service : this.services.values()) {
            for (ServiceComponent component : service.getServiceComponents().values()) {
                if (!component.getName().equals(componentName)) continue;
                return service;
            }
        }
        throw new ServiceNotFoundException(this.getClusterName(), "component: " + componentName);
    }

    @Override
    public StackId getDesiredStackVersion() {
        return this.desiredStackVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDesiredStackVersion(StackId stackId) throws OBDPException {
        this.clusterGlobalLock.writeLock().lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing DesiredStackVersion of Cluster, clusterName={}, clusterId={}, currentDesiredStackVersion={}, newDesiredStackVersion={}", new Object[]{this.getClusterName(), this.getClusterId(), this.desiredStackVersion, stackId});
            }
            this.desiredStackVersion = stackId;
            StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
            ClusterEntity clusterEntity = this.getClusterEntity();
            clusterEntity.setDesiredStack(stackEntity);
            this.clusterDAO.merge(clusterEntity);
            this.loadServiceConfigTypes();
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    @Override
    public StackId getCurrentStackVersion() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        ClusterStateEntity clusterStateEntity = clusterEntity.getClusterStateEntity();
        if (clusterStateEntity != null) {
            StackEntity currentStackEntity = clusterStateEntity.getCurrentStack();
            return new StackId(currentStackEntity);
        }
        return null;
    }

    @Override
    public State getProvisioningState() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        State provisioningState = clusterEntity.getProvisioningState();
        if (null == provisioningState) {
            provisioningState = State.INIT;
        }
        return provisioningState;
    }

    @Override
    public void setProvisioningState(State provisioningState) {
        ClusterEntity clusterEntity = this.getClusterEntity();
        clusterEntity.setProvisioningState(provisioningState);
        this.clusterDAO.merge(clusterEntity);
    }

    private boolean setBlueprintProvisioningState(BlueprintProvisioningState blueprintProvisioningState) {
        boolean updated = false;
        for (Service s : this.getServices().values()) {
            for (ServiceComponent sc : s.getServiceComponents().values()) {
                if (sc.isClientComponent()) continue;
                for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
                    HostComponentDesiredStateEntity desiredStateEntity = sch.getDesiredStateEntity();
                    if (desiredStateEntity.getBlueprintProvisioningState() == blueprintProvisioningState) continue;
                    desiredStateEntity.setBlueprintProvisioningState(blueprintProvisioningState);
                    this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
                    updated = true;
                }
            }
        }
        return updated;
    }

    @Override
    public SecurityType getSecurityType() {
        SecurityType securityType = null;
        ClusterEntity clusterEntity = this.getClusterEntity();
        securityType = clusterEntity.getSecurityType();
        if (null == securityType) {
            securityType = SecurityType.NONE;
        }
        return securityType;
    }

    @Override
    public void setSecurityType(SecurityType securityType) {
        ClusterEntity clusterEntity = this.getClusterEntity();
        clusterEntity.setSecurityType(securityType);
        this.clusterDAO.merge(clusterEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public List<Host> transitionHostsToInstalling(RepositoryVersionEntity repoVersionEntity, VersionDefinitionXml versionDefinitionXml, boolean forceInstalled) throws OBDPException {
        ArrayList<Host> hostsRequiringInstallation;
        this.clusterGlobalLock.writeLock().lock();
        try {
            Map<String, Host> hosts = this.clusters.getHostsForCluster(this.getClusterName());
            hostsRequiringInstallation = new ArrayList<Host>(hosts.size());
            Collection<HostEntity> hostEntities = this.getClusterEntity().getHostEntities();
            for (HostEntity hostEntity : hostEntities) {
                Host host;
                RepositoryVersionState state = RepositoryVersionState.INSTALLING;
                if (forceInstalled) {
                    state = RepositoryVersionState.INSTALLED;
                }
                if (!(host = hosts.get(hostEntity.getHostName())).hasComponentsAdvertisingVersions(this.desiredStackVersion)) {
                    state = RepositoryVersionState.NOT_REQUIRED;
                }
                if (state != RepositoryVersionState.NOT_REQUIRED && repoVersionEntity.getType() != RepositoryType.STANDARD) {
                    boolean hostRequiresRepository = false;
                    ClusterVersionSummary clusterSummary = versionDefinitionXml.getClusterSummary(this, this.obdpMetaInfo);
                    Set<String> servicesInUpgrade = clusterSummary.getAvailableServiceNames();
                    List<ServiceComponentHost> schs = this.getServiceComponentHosts(hostEntity.getHostName());
                    for (ServiceComponentHost serviceComponentHost : schs) {
                        String serviceName = serviceComponentHost.getServiceName();
                        if (!servicesInUpgrade.contains(serviceName)) continue;
                        hostRequiresRepository = true;
                        break;
                    }
                    if (!hostRequiresRepository) {
                        state = RepositoryVersionState.NOT_REQUIRED;
                    }
                }
                if (state != RepositoryVersionState.NOT_REQUIRED && host.getMaintenanceState(this.clusterId) != MaintenanceState.OFF) {
                    state = RepositoryVersionState.OUT_OF_SYNC;
                }
                HostVersionEntity hostVersionEntity = null;
                Collection<HostVersionEntity> hostVersions = hostEntity.getHostVersionEntities();
                for (HostVersionEntity existingHostVersion : hostVersions) {
                    if (!Objects.equals(existingHostVersion.getRepositoryVersion().getId(), repoVersionEntity.getId())) continue;
                    hostVersionEntity = existingHostVersion;
                    break;
                }
                if (null == hostVersionEntity) {
                    hostVersionEntity = new HostVersionEntity(hostEntity, repoVersionEntity, state);
                    this.hostVersionDAO.create(hostVersionEntity);
                    hostVersions.add(hostVersionEntity);
                    this.hostDAO.merge(hostEntity);
                } else {
                    hostVersionEntity.setState(state);
                    hostVersionEntity = this.hostVersionDAO.merge(hostVersionEntity);
                }
                LOG.info("Created host version for {}, state={}, repository version={} (repo_id={})", new Object[]{hostVersionEntity.getHostName(), hostVersionEntity.getState(), repoVersionEntity.getVersion(), repoVersionEntity.getId()});
                if (state != RepositoryVersionState.INSTALLING) continue;
                hostsRequiringInstallation.add(host);
            }
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
        return hostsRequiringInstallation;
    }

    @Override
    @Transactional
    public void setCurrentStackVersion(StackId stackId) throws OBDPException {
        this.clusterGlobalLock.writeLock().lock();
        try {
            StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
            ClusterEntity clusterEntity = this.getClusterEntity();
            ClusterStateEntity clusterStateEntity = this.clusterStateDAO.findByPK(clusterEntity.getClusterId());
            if (clusterStateEntity == null) {
                clusterStateEntity = new ClusterStateEntity();
                clusterStateEntity.setClusterId(clusterEntity.getClusterId());
                clusterStateEntity.setCurrentStack(stackEntity);
                clusterStateEntity.setClusterEntity(clusterEntity);
                this.clusterStateDAO.create(clusterStateEntity);
                clusterStateEntity = this.clusterStateDAO.merge(clusterStateEntity);
                clusterEntity.setClusterStateEntity(clusterStateEntity);
                this.clusterDAO.merge(clusterEntity);
            } else {
                clusterStateEntity.setCurrentStack(stackEntity);
                this.clusterStateDAO.merge(clusterStateEntity);
                this.clusterDAO.merge(clusterEntity);
            }
        }
        catch (RollbackException e) {
            LOG.warn("Unable to set version " + stackId + " for cluster " + this.getClusterName());
            throw new OBDPException("Unable to set version=" + stackId + " for cluster " + this.getClusterName(), (Throwable)e);
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, Config> getConfigsByType(String configType) {
        this.clusterGlobalLock.readLock().lock();
        try {
            if (!this.allConfigs.containsKey(configType)) {
                Map<String, Config> map = null;
                return map;
            }
            Map<String, Config> map = Collections.unmodifiableMap((Map)this.allConfigs.get(configType));
            return map;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfig(String configType, String versionTag) {
        this.clusterGlobalLock.readLock().lock();
        try {
            if (!this.allConfigs.containsKey(configType) || !((ConcurrentMap)this.allConfigs.get(configType)).containsKey(versionTag)) {
                Config config = null;
                return config;
            }
            Config config = (Config)((ConcurrentMap)this.allConfigs.get(configType)).get(versionTag);
            return config;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    @Override
    public Config getDesiredConfigByType(String configType, @Nullable Map<String, DesiredConfig> desiredConfigs) {
        DesiredConfig desiredConfig = desiredConfigs == null ? null : desiredConfigs.get(configType);
        return desiredConfig == null ? this.getDesiredConfigByType(configType) : this.getConfig(configType, desiredConfig.getTag());
    }

    @Override
    public List<Config> getLatestConfigsWithTypes(Collection<String> types) {
        return this.clusterDAO.getLatestConfigurationsWithTypes(this.clusterId, this.getDesiredStackVersion(), types).stream().map(clusterConfigEntity -> this.configFactory.createExisting(this, (ClusterConfigEntity)clusterConfigEntity)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfigByVersion(String configType, Long configVersion) {
        this.clusterGlobalLock.readLock().lock();
        try {
            if (!this.allConfigs.containsKey(configType)) {
                Config config = null;
                return config;
            }
            for (Map.Entry entry : ((ConcurrentMap)this.allConfigs.get(configType)).entrySet()) {
                if (!((Config)entry.getValue()).getVersion().equals(configVersion)) continue;
                Config config = (Config)entry.getValue();
                return config;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    @Override
    public void addConfig(Config config) {
        if (config.getType() == null || config.getType().isEmpty()) {
            throw new IllegalArgumentException("Config type cannot be empty");
        }
        this.clusterGlobalLock.writeLock().lock();
        try {
            if (!this.allConfigs.containsKey(config.getType())) {
                this.allConfigs.put(config.getType(), new ConcurrentHashMap());
            }
            ((ConcurrentMap)this.allConfigs.get(config.getType())).put(config.getTag(), config);
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Config> getAllConfigs() {
        this.clusterGlobalLock.readLock().lock();
        try {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : this.allConfigs.entrySet()) {
                list.addAll(((ConcurrentMap)entry.getValue()).values());
            }
            List list2 = Collections.unmodifiableList(list);
            return list2;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    @Override
    public ClusterResponse convertToResponse() throws OBDPException {
        String clusterName = this.getClusterName();
        Map<String, Host> hosts = this.clusters.getHostsForCluster(clusterName);
        return new ClusterResponse(this.getClusterId(), clusterName, this.getProvisioningState(), this.getSecurityType(), hosts.keySet(), hosts.size(), this.getDesiredStackVersion().getStackId(), this.getClusterHealthReport(hosts));
    }

    @Override
    public void debugDump(StringBuilder sb) {
        sb.append("Cluster={ clusterName=").append(this.getClusterName()).append(", clusterId=").append(this.getClusterId()).append(", desiredStackVersion=").append(this.desiredStackVersion.getStackId()).append(", services=[ ");
        boolean first = true;
        for (Service s : this.services.values()) {
            if (!first) {
                sb.append(" , ");
            }
            first = false;
            sb.append("\n    ");
            s.debugDump(sb);
            sb.append(' ');
        }
        sb.append(" ] }");
        this.lockFactory.debugDump(sb);
    }

    @Override
    @Transactional
    public void refresh() {
        this.clusterGlobalLock.writeLock().lock();
        try {
            ClusterEntity clusterEntity = this.getClusterEntity();
            this.clusterDAO.refresh(clusterEntity);
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void deleteAllServices() throws OBDPException {
        this.clusterGlobalLock.writeLock().lock();
        try {
            LOG.info("Deleting all services for cluster, clusterName=" + this.getClusterName());
            for (Service service : this.services.values()) {
                if (service.canBeRemoved()) continue;
                throw new OBDPException("Found non removable service when trying to all services from cluster, clusterName=" + this.getClusterName() + ", serviceName=" + service.getName());
            }
            DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
            for (Service service : this.services.values()) {
                this.deleteService(service, deleteMetaData);
                this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
            }
            this.STOMPComponentsDeleteHandler.processDeleteCluster(this.getClusterId());
            this.services.clear();
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void deleteAllClusterConfigs() {
        this.clusterGlobalLock.writeLock().lock();
        try {
            Collection<ClusterConfigEntity> clusterConfigs = this.getClusterEntity().getClusterConfigEntities();
            for (ClusterConfigEntity clusterConfigEntity : clusterConfigs) {
                this.clusterDAO.removeConfig(clusterConfigEntity);
            }
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteService(String serviceName, DeleteHostComponentStatusMetaData deleteMetaData) throws OBDPException {
        this.clusterGlobalLock.writeLock().lock();
        try {
            Service service = this.getService(serviceName);
            LOG.info("Deleting service for cluster, clusterName=" + this.getClusterName() + ", serviceName=" + service.getName());
            if (!service.canBeRemoved()) {
                deleteMetaData.setAmbariException(new OBDPException("Could not delete service from cluster, clusterName=" + this.getClusterName() + ", serviceName=" + service.getName()));
                return;
            }
            this.deleteService(service, deleteMetaData);
            this.services.remove(serviceName);
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    private void deleteService(Service service, DeleteHostComponentStatusMetaData deleteMetaData) {
        final String serviceName = service.getName();
        service.delete(deleteMetaData);
        if (deleteMetaData.getAmbariException() != null) {
            return;
        }
        this.serviceComponentHosts.remove(serviceName);
        for (List serviceComponents : this.serviceComponentHostsByHost.values()) {
            Iterables.removeIf((Iterable)serviceComponents, (Predicate)new Predicate<ServiceComponentHost>(){

                public boolean apply(ServiceComponentHost serviceComponentHost) {
                    return serviceComponentHost.getServiceName().equals(serviceName);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canBeRemoved() {
        this.clusterGlobalLock.readLock().lock();
        try {
            boolean safeToRemove = true;
            for (Service service : this.services.values()) {
                if (service.canBeRemoved()) continue;
                safeToRemove = false;
                LOG.warn("Found non removable service, clusterName=" + this.getClusterName() + ", serviceName=" + service.getName());
            }
            boolean bl = safeToRemove;
            return bl;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    @Override
    @Transactional
    public void delete() throws OBDPException {
        this.clusterGlobalLock.writeLock().lock();
        try {
            this.refresh();
            this.deleteAllServices();
            this.deleteAllClusterConfigs();
            this.resetHostVersions();
            this.refresh();
            this.removeEntities();
            this.allConfigs.clear();
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    @Transactional
    protected void removeEntities() throws OBDPException {
        long clusterId = this.getClusterId();
        this.alertDefinitionDAO.removeAll(clusterId);
        this.alertDispatchDAO.removeAllGroups(clusterId);
        this.upgradeDAO.removeAll(clusterId);
        this.topologyRequestDAO.removeAll(clusterId);
        this.clusterDAO.removeByPK(clusterId);
    }

    private void resetHostVersions() {
        for (HostVersionEntity hostVersionEntity : this.hostVersionDAO.findByCluster(this.getClusterName())) {
            if (hostVersionEntity.getState().equals((Object)RepositoryVersionState.NOT_REQUIRED)) continue;
            hostVersionEntity.setState(RepositoryVersionState.NOT_REQUIRED);
            this.hostVersionDAO.merge(hostVersionEntity);
        }
    }

    @Override
    public ServiceConfigVersionResponse addDesiredConfig(String user, Set<Config> configs) throws OBDPException {
        return this.addDesiredConfig(user, configs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceConfigVersionResponse addDesiredConfig(String user, Set<Config> configs, String serviceConfigVersionNote) throws OBDPException {
        if (null == user) {
            throw new NullPointerException("User must be specified.");
        }
        this.clusterGlobalLock.writeLock().lock();
        try {
            ServiceConfigVersionResponse serviceConfigVersionResponse;
            if (configs == null) {
                ServiceConfigVersionResponse serviceConfigVersionResponse2 = null;
                return serviceConfigVersionResponse2;
            }
            Iterator<Config> configIterator = configs.iterator();
            while (configIterator.hasNext()) {
                Config config = configIterator.next();
                if (config == null) {
                    configIterator.remove();
                    continue;
                }
                Config currentDesired = this.getDesiredConfigByType(config.getType());
                if (null == currentDesired || !currentDesired.getTag().equals(config.getTag())) continue;
                configIterator.remove();
            }
            ServiceConfigVersionResponse serviceConfigVersionResponse3 = serviceConfigVersionResponse = this.applyConfigs(configs, user, serviceConfigVersionNote);
            return serviceConfigVersionResponse3;
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, Set<DesiredConfig>> getAllDesiredConfigVersions() {
        return this.getDesiredConfigs(true, true);
    }

    @Override
    public Map<String, DesiredConfig> getDesiredConfigs() {
        return this.getDesiredConfigs(true);
    }

    @Override
    public Map<String, DesiredConfig> getDesiredConfigs(boolean cachedConfigEntities) {
        Map<String, Set<DesiredConfig>> activeConfigsByType = this.getDesiredConfigs(false, cachedConfigEntities);
        return Maps.transformEntries(activeConfigsByType, (key, value) -> (DesiredConfig)value.iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<DesiredConfig>> getDesiredConfigs(boolean allVersions, boolean cachedConfigEntities) {
        this.clusterGlobalLock.readLock().lock();
        try {
            HashMap<String, Set<DesiredConfig>> map = new HashMap<String, Set<DesiredConfig>>();
            HashSet<String> types = new HashSet<String>();
            Collection<ClusterConfigEntity> entities = cachedConfigEntities ? this.getClusterEntity().getClusterConfigEntities() : this.clusterDAO.getEnabledConfigs(this.clusterId);
            for (ClusterConfigEntity configEntity : entities) {
                if (!allVersions && !configEntity.isSelected()) continue;
                DesiredConfig desiredConfig = new DesiredConfig();
                desiredConfig.setServiceName(null);
                desiredConfig.setTag(configEntity.getTag());
                if (!this.allConfigs.containsKey(configEntity.getType())) {
                    LOG.error("An inconsistency exists for configuration {}", (Object)configEntity.getType());
                    continue;
                }
                Map configMap = (Map)this.allConfigs.get(configEntity.getType());
                if (!configMap.containsKey(configEntity.getTag())) {
                    LOG.error("An inconsistency exists for the configuration {} with tag {}", (Object)configEntity.getType(), (Object)configEntity.getTag());
                    continue;
                }
                Config config = (Config)configMap.get(configEntity.getTag());
                desiredConfig.setVersion(config.getVersion());
                HashSet<DesiredConfig> configs = (HashSet<DesiredConfig>)map.get(configEntity.getType());
                if (configs == null) {
                    configs = new HashSet<DesiredConfig>();
                }
                configs.add(desiredConfig);
                map.put(configEntity.getType(), configs);
                types.add(configEntity.getType());
            }
            HashMap<Long, String> hostIdToName = new HashMap<Long, String>();
            if (!map.isEmpty()) {
                Map<String, List<HostConfigMapping>> hostMappingsByType = this.hostConfigMappingDAO.findSelectedHostsByTypes(this.clusterId, types);
                for (Map.Entry entry : map.entrySet()) {
                    ArrayList<DesiredConfig.HostOverride> hostOverrides = new ArrayList<DesiredConfig.HostOverride>();
                    for (HostConfigMapping mappingEntity : hostMappingsByType.get(entry.getKey())) {
                        if (!hostIdToName.containsKey(mappingEntity.getHostId())) {
                            HostEntity hostEntity = this.hostDAO.findById(mappingEntity.getHostId());
                            hostIdToName.put(mappingEntity.getHostId(), hostEntity.getHostName());
                        }
                        hostOverrides.add(new DesiredConfig.HostOverride((String)hostIdToName.get(mappingEntity.getHostId()), mappingEntity.getVersion()));
                    }
                    for (DesiredConfig c : (Set)entry.getValue()) {
                        c.setHostOverrides(hostOverrides);
                    }
                }
            }
            HashMap<String, Set<DesiredConfig>> hashMap = map;
            return hashMap;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceConfigVersionResponse createServiceConfigVersion(String serviceName, String user, String note, ConfigGroup configGroup) throws OBDPException {
        ServiceConfigEntity serviceConfigEntity = new ServiceConfigEntity();
        this.clusterGlobalLock.writeLock().lock();
        try {
            ClusterEntity clusterEntity = this.getClusterEntity();
            if (configGroup != null) {
                serviceConfigEntity.setGroupId(configGroup.getId());
                Collection<Config> configs = configGroup.getConfigurations().values();
                ArrayList<ClusterConfigEntity> configEntities = new ArrayList<ClusterConfigEntity>(configs.size());
                for (Config config : configs) {
                    configEntities.add(this.clusterDAO.findConfig((Long)this.getClusterId(), config.getType(), config.getTag()));
                }
                serviceConfigEntity.setClusterConfigEntities(configEntities);
            } else {
                List<ClusterConfigEntity> configEntities = this.getClusterConfigEntitiesByService(serviceName);
                serviceConfigEntity.setClusterConfigEntities(configEntities);
            }
            Map<String, Collection<String>> changedConfigs = this.configHelper.getChangedConfigTypes(this, serviceConfigEntity, configGroup == null ? null : configGroup.getId(), this.clusterId, serviceName);
            long nextServiceConfigVersion = this.serviceConfigDAO.findNextServiceConfigVersion(this.clusterId, serviceName);
            StackEntity stackEntity = clusterEntity.getDesiredStack();
            Service service = this.services.get(serviceName);
            if (null != service) {
                StackId serviceStackId = service.getDesiredStackId();
                stackEntity = this.stackDAO.find(serviceStackId);
            }
            serviceConfigEntity.setServiceName(serviceName);
            serviceConfigEntity.setClusterEntity(clusterEntity);
            serviceConfigEntity.setVersion(nextServiceConfigVersion);
            serviceConfigEntity.setUser(user);
            serviceConfigEntity.setNote(note);
            serviceConfigEntity.setStack(stackEntity);
            this.serviceConfigDAO.create(serviceConfigEntity);
            List groupHostNames = null;
            if (configGroup != null) {
                if (MapUtils.isNotEmpty(configGroup.getHosts())) {
                    groupHostNames = configGroup.getHosts().entrySet().stream().map(h -> ((Host)h.getValue()).getHostName()).collect(Collectors.toList());
                }
                serviceConfigEntity.setHostIds(new ArrayList<Long>(configGroup.getHosts().keySet()));
                serviceConfigEntity = this.serviceConfigDAO.merge(serviceConfigEntity);
            }
            this.STOMPUpdatePublisher.publish(new ConfigsUpdateEvent(serviceConfigEntity, configGroup == null ? null : configGroup.getName(), groupHostNames, changedConfigs.keySet()));
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
        String configGroupName = configGroup == null ? "Default" : configGroup.getName();
        configChangeLog.info("(configchange) Creating config version. cluster: '{}', changed by: '{}', service_name: '{}', config_group: '{}', config_group_id: '{}', version: '{}', create_timestamp: '{}', note: '{}'", new Object[]{this.getClusterName(), user, serviceName, configGroupName, configGroup == null ? "null" : configGroup.getId(), serviceConfigEntity.getVersion(), serviceConfigEntity.getCreateTimestamp(), serviceConfigEntity.getNote()});
        ServiceConfigVersionResponse response = new ServiceConfigVersionResponse(serviceConfigEntity, configGroupName);
        return response;
    }

    @Override
    public String getServiceForConfigTypes(Collection<String> configTypes) {
        boolean allTheSame;
        List serviceNames = configTypes.stream().map(this::getServiceByConfigType).filter(Objects::nonNull).collect(Collectors.toList());
        boolean bl = allTheSame = new HashSet(serviceNames).size() <= 1;
        if (!allTheSame) {
            throw new IllegalArgumentException(String.format("Config types: %s should belong to a single installed service. But they belong to: %s", configTypes, serviceNames));
        }
        return serviceNames.isEmpty() ? null : (String)serviceNames.get(0);
    }

    public List<String> serviceNameByConfigType(String configType) {
        return this.serviceConfigTypes.entries().stream().filter(entry -> StringUtils.equals((String)((String)entry.getValue()), (String)configType)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    @Override
    public String getServiceByConfigType(String configType) {
        return this.serviceNameByConfigType(configType).stream().filter(this::isServiceInstalled).findFirst().orElse(null);
    }

    private boolean isServiceInstalled(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceConfigVersionResponse setServiceConfigVersion(String serviceName, Long version, String user, String note) throws OBDPException {
        if (null == user) {
            throw new NullPointerException("User must be specified.");
        }
        this.clusterGlobalLock.writeLock().lock();
        try {
            ServiceConfigVersionResponse serviceConfigVersionResponse;
            ServiceConfigVersionResponse serviceConfigVersionResponse2 = serviceConfigVersionResponse = this.applyServiceConfigVersion(serviceName, version, user, note);
            return serviceConfigVersionResponse2;
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<ServiceConfigVersionResponse>> getActiveServiceConfigVersions() {
        this.clusterGlobalLock.readLock().lock();
        try {
            HashMap map = new HashMap();
            Set<ServiceConfigVersionResponse> responses = this.getActiveServiceConfigVersionSet();
            for (ServiceConfigVersionResponse response : responses) {
                if (map.get(response.getServiceName()) == null) {
                    map.put(response.getServiceName(), new ArrayList());
                }
                ((Collection)map.get(response.getServiceName())).add(response);
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceConfigVersionResponse> getServiceConfigVersions() {
        this.clusterGlobalLock.readLock().lock();
        try {
            ArrayList<ServiceConfigVersionResponse> serviceConfigVersionResponses = new ArrayList<ServiceConfigVersionResponse>();
            List<ServiceConfigEntity> serviceConfigs = this.serviceConfigDAO.getServiceConfigs(this.getClusterId());
            HashMap activeServiceConfigResponses = new HashMap();
            for (ServiceConfigEntity serviceConfigEntity : serviceConfigs) {
                ServiceConfigVersionResponse activeServiceConfigResponse;
                ServiceConfigVersionResponse serviceConfigVersionResponse = this.convertToServiceConfigVersionResponse(serviceConfigEntity);
                HashMap<String, ServiceConfigVersionResponse> activeServiceConfigResponseGroups = (HashMap<String, ServiceConfigVersionResponse>)activeServiceConfigResponses.get(serviceConfigVersionResponse.getServiceName());
                if (activeServiceConfigResponseGroups == null) {
                    HashMap<String, ServiceConfigVersionResponse> serviceConfigGroups = new HashMap<String, ServiceConfigVersionResponse>();
                    activeServiceConfigResponses.put(serviceConfigVersionResponse.getServiceName(), serviceConfigGroups);
                    activeServiceConfigResponseGroups = serviceConfigGroups;
                }
                if ((activeServiceConfigResponse = (ServiceConfigVersionResponse)activeServiceConfigResponseGroups.get(serviceConfigVersionResponse.getGroupName())) == null && !"Deleted".equals(serviceConfigVersionResponse.getGroupName())) {
                    activeServiceConfigResponseGroups.put(serviceConfigVersionResponse.getGroupName(), serviceConfigVersionResponse);
                    activeServiceConfigResponse = serviceConfigVersionResponse;
                }
                if (serviceConfigEntity.getGroupId() == null) {
                    if (serviceConfigVersionResponse.getCreateTime() > activeServiceConfigResponse.getCreateTime()) {
                        activeServiceConfigResponseGroups.put(serviceConfigVersionResponse.getGroupName(), serviceConfigVersionResponse);
                    }
                } else if (this.clusterConfigGroups != null && this.clusterConfigGroups.containsKey(serviceConfigEntity.getGroupId()) && serviceConfigVersionResponse.getVersion() > activeServiceConfigResponse.getVersion()) {
                    activeServiceConfigResponseGroups.put(serviceConfigVersionResponse.getGroupName(), serviceConfigVersionResponse);
                }
                serviceConfigVersionResponse.setIsCurrent(false);
                serviceConfigVersionResponses.add(this.getServiceConfigVersionResponseWithConfig(serviceConfigVersionResponse, serviceConfigEntity));
            }
            for (Map serviceConfigVersionResponseGroup : activeServiceConfigResponses.values()) {
                for (ServiceConfigVersionResponse serviceConfigVersionResponse : serviceConfigVersionResponseGroup.values()) {
                    serviceConfigVersionResponse.setIsCurrent(true);
                }
            }
            ArrayList<ServiceConfigVersionResponse> arrayList = serviceConfigVersionResponses;
            return arrayList;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    private Set<ServiceConfigVersionResponse> getActiveServiceConfigVersionSet() {
        HashSet<ServiceConfigVersionResponse> responses = new HashSet<ServiceConfigVersionResponse>();
        List<ServiceConfigEntity> activeServiceConfigVersions = this.getActiveServiceConfigVersionEntities();
        for (ServiceConfigEntity lastServiceConfig : activeServiceConfigVersions) {
            ServiceConfigVersionResponse response = this.convertToServiceConfigVersionResponse(lastServiceConfig);
            response.setIsCurrent(true);
            responses.add(response);
        }
        return responses;
    }

    private List<ServiceConfigEntity> getActiveServiceConfigVersionEntities() {
        ArrayList<ServiceConfigEntity> activeServiceConfigVersions = new ArrayList<ServiceConfigEntity>();
        activeServiceConfigVersions.addAll(this.serviceConfigDAO.getLastServiceConfigs(this.getClusterId()));
        if (this.clusterConfigGroups != null) {
            activeServiceConfigVersions.addAll(this.serviceConfigDAO.getLastServiceConfigVersionsForGroups(this.clusterConfigGroups.keySet()));
        }
        return activeServiceConfigVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceConfigVersionResponse> getActiveServiceConfigVersionResponse(String serviceName) {
        this.clusterGlobalLock.readLock().lock();
        try {
            ArrayList<ServiceConfigEntity> activeServiceConfigVersionEntities = new ArrayList<ServiceConfigEntity>();
            ArrayList<ServiceConfigVersionResponse> activeServiceConfigVersionResponses = new ArrayList<ServiceConfigVersionResponse>();
            activeServiceConfigVersionEntities.addAll(this.serviceConfigDAO.getLastServiceConfigsForService(this.getClusterId(), serviceName));
            for (ServiceConfigEntity serviceConfigEntity : activeServiceConfigVersionEntities) {
                ServiceConfigVersionResponse serviceConfigVersionResponse = this.getServiceConfigVersionResponseWithConfig(this.convertToServiceConfigVersionResponse(serviceConfigEntity), serviceConfigEntity);
                serviceConfigVersionResponse.setIsCurrent(true);
                activeServiceConfigVersionResponses.add(serviceConfigVersionResponse);
            }
            ArrayList<ServiceConfigVersionResponse> arrayList = activeServiceConfigVersionResponses;
            return arrayList;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    private ServiceConfigVersionResponse getServiceConfigVersionResponseWithConfig(ServiceConfigVersionResponse serviceConfigVersionResponse, ServiceConfigEntity serviceConfigEntity) {
        serviceConfigVersionResponse.setConfigurations(new ArrayList<ConfigurationResponse>());
        List<ClusterConfigEntity> clusterConfigEntities = serviceConfigEntity.getClusterConfigEntities();
        for (ClusterConfigEntity clusterConfigEntity : clusterConfigEntities) {
            Config config = (Config)((ConcurrentMap)this.allConfigs.get(clusterConfigEntity.getType())).get(clusterConfigEntity.getTag());
            serviceConfigVersionResponse.getConfigurations().add(new ConfigurationResponse(this.getClusterName(), config));
        }
        return serviceConfigVersionResponse;
    }

    @RequiresSession
    ServiceConfigVersionResponse getActiveServiceConfigVersion(String serviceName) {
        ServiceConfigEntity lastServiceConfig = this.serviceConfigDAO.getLastServiceConfig(this.getClusterId(), serviceName);
        if (lastServiceConfig == null) {
            LOG.debug("No service config version found for service {}", (Object)serviceName);
            return null;
        }
        return this.convertToServiceConfigVersionResponse(lastServiceConfig);
    }

    @RequiresSession
    ServiceConfigVersionResponse convertToServiceConfigVersionResponse(ServiceConfigEntity serviceConfigEntity) {
        String groupName;
        Long groupId = serviceConfigEntity.getGroupId();
        if (groupId != null) {
            ConfigGroup configGroup = null;
            if (this.clusterConfigGroups != null) {
                configGroup = this.clusterConfigGroups.get(groupId);
            }
            groupName = configGroup != null ? configGroup.getName() : "Deleted";
        } else {
            groupName = "Default";
        }
        ServiceConfigVersionResponse serviceConfigVersionResponse = new ServiceConfigVersionResponse(serviceConfigEntity, groupName);
        return serviceConfigVersionResponse;
    }

    @Transactional
    ServiceConfigVersionResponse applyServiceConfigVersion(String serviceName, Long serviceConfigVersion, String user, String serviceConfigVersionNote) throws OBDPException {
        ServiceConfigEntity serviceConfigEntity = this.serviceConfigDAO.findByServiceAndVersion(serviceName, serviceConfigVersion);
        if (serviceConfigEntity == null) {
            throw new ObjectNotFoundException("Service config version with serviceName={} and version={} not found");
        }
        String configGroupName = null;
        if (serviceConfigEntity.getGroupId() == null) {
            Collection configTypes = this.serviceConfigTypes.get((Object)serviceName);
            List<ClusterConfigEntity> enabledConfigs = this.clusterDAO.getEnabledConfigsByTypes(this.clusterId, configTypes);
            List<ClusterConfigEntity> serviceConfigEntities = serviceConfigEntity.getClusterConfigEntities();
            ArrayList<ClusterConfigEntity> duplicatevalues = new ArrayList<ClusterConfigEntity>(serviceConfigEntities);
            duplicatevalues.retainAll(enabledConfigs);
            for (ClusterConfigEntity enabledConfig : enabledConfigs) {
                if (duplicatevalues.contains(enabledConfig)) continue;
                enabledConfig.setSelected(false);
                this.clusterDAO.merge(enabledConfig);
            }
            for (ClusterConfigEntity configEntity : serviceConfigEntities) {
                if (duplicatevalues.contains(configEntity)) continue;
                configEntity.setSelected(true);
                this.clusterDAO.merge(configEntity);
            }
        } else {
            Long configGroupId = serviceConfigEntity.getGroupId();
            ConfigGroup configGroup = this.clusterConfigGroups.get(configGroupId);
            if (configGroup != null) {
                configGroupName = configGroup.getName();
                HashMap<String, Config> groupDesiredConfigs = new HashMap<String, Config>();
                for (ClusterConfigEntity clusterConfigEntity : serviceConfigEntity.getClusterConfigEntities()) {
                    Config config = (Config)((ConcurrentMap)this.allConfigs.get(clusterConfigEntity.getType())).get(clusterConfigEntity.getTag());
                    groupDesiredConfigs.put(config.getType(), config);
                }
                configGroup.setConfigurations(groupDesiredConfigs);
                HashMap<Long, Host> groupDesiredHosts = new HashMap<Long, Host>();
                if (serviceConfigEntity.getHostIds() != null) {
                    for (Long hostId : serviceConfigEntity.getHostIds()) {
                        Host host = this.clusters.getHostById(hostId);
                        if (host != null) {
                            groupDesiredHosts.put(hostId, host);
                            continue;
                        }
                        LOG.warn("Host with id {} doesn't exist anymore, skipping", (Object)hostId);
                    }
                }
                configGroup.setHosts(groupDesiredHosts);
            } else {
                throw new IllegalArgumentException("Config group {} doesn't exist");
            }
        }
        Map<String, Collection<String>> changedConfigs = this.configHelper.getChangedConfigTypes(this, serviceConfigEntity, serviceConfigEntity.getGroupId(), this.clusterId, serviceName);
        ClusterEntity clusterEntity = this.getClusterEntity();
        long nextServiceConfigVersion = this.serviceConfigDAO.findNextServiceConfigVersion(clusterEntity.getClusterId(), serviceName);
        ServiceConfigEntity serviceConfigEntity2 = new ServiceConfigEntity();
        serviceConfigEntity2.setCreateTimestamp(System.currentTimeMillis());
        serviceConfigEntity2.setUser(user);
        serviceConfigEntity2.setServiceName(serviceName);
        serviceConfigEntity2.setClusterEntity(clusterEntity);
        serviceConfigEntity2.setStack(serviceConfigEntity.getStack());
        serviceConfigEntity2.setClusterConfigEntities(serviceConfigEntity.getClusterConfigEntities());
        serviceConfigEntity2.setClusterId(serviceConfigEntity.getClusterId());
        serviceConfigEntity2.setHostIds(serviceConfigEntity.getHostIds());
        serviceConfigEntity2.setGroupId(serviceConfigEntity.getGroupId());
        serviceConfigEntity2.setNote(serviceConfigVersionNote);
        serviceConfigEntity2.setVersion(nextServiceConfigVersion);
        List<String> groupHostNames = null;
        if (CollectionUtils.isNotEmpty(serviceConfigEntity.getHostIds())) {
            groupHostNames = this.getHosts().stream().filter(h -> serviceConfigEntity.getHostIds().contains(h.getHostId())).map(h -> h.getHostName()).collect(Collectors.toList());
        }
        this.serviceConfigDAO.create(serviceConfigEntity2);
        this.STOMPUpdatePublisher.publish(new ConfigsUpdateEvent(serviceConfigEntity2, configGroupName, groupHostNames, changedConfigs.keySet()));
        return this.convertToServiceConfigVersionResponse(serviceConfigEntity2);
    }

    @Transactional
    ServiceConfigVersionResponse applyConfigs(Set<Config> configs, String user, String serviceConfigVersionNote) throws OBDPException {
        ArrayList<ClusterConfigEntity> appliedConfigs = new ArrayList<ClusterConfigEntity>();
        String serviceName = this.getServiceForConfigTypes(configs.stream().map(Config::getType).collect(Collectors.toList()));
        ClusterEntity clusterEntity = this.getClusterEntity();
        Collection<ClusterConfigEntity> clusterConfigs = clusterEntity.getClusterConfigEntities();
        for (Config config : configs) {
            for (ClusterConfigEntity clusterConfigEntity : clusterConfigs) {
                if (!StringUtils.equals((String)clusterConfigEntity.getType(), (String)config.getType())) continue;
                clusterConfigEntity.setSelected(false);
                if (!StringUtils.equals((String)clusterConfigEntity.getTag(), (String)config.getTag())) continue;
                appliedConfigs.add(clusterConfigEntity);
                clusterConfigEntity.setSelected(true);
            }
        }
        this.clusterDAO.merge(clusterConfigs);
        if (serviceName == null) {
            ArrayList<String> configTypes = new ArrayList<String>();
            for (Config config : configs) {
                configTypes.add(config.getType());
            }
            this.STOMPUpdatePublisher.publish(new ConfigsUpdateEvent(this, appliedConfigs));
            LOG.error("No service found for config types '{}', service config version not created", configTypes);
            return null;
        }
        return this.createServiceConfigVersion(serviceName, user, serviceConfigVersionNote);
    }

    private ServiceConfigVersionResponse createServiceConfigVersion(String serviceName, String user, String serviceConfigVersionNote) throws OBDPException {
        return this.createServiceConfigVersion(serviceName, user, serviceConfigVersionNote, null);
    }

    private List<ClusterConfigEntity> getClusterConfigEntitiesByService(String serviceName) {
        Collection configTypes = this.serviceConfigTypes.get((Object)serviceName);
        return this.clusterDAO.getEnabledConfigsByTypes(this.getClusterId(), new ArrayList<String>(configTypes));
    }

    @Override
    public Config getDesiredConfigByType(String configType) {
        ClusterConfigEntity config = this.clusterDAO.findEnabledConfigByType(this.getClusterId(), configType);
        if (null == config) {
            return null;
        }
        return this.getConfig(configType, config.getTag());
    }

    @Override
    public boolean isConfigTypeExists(String configType) {
        ClusterConfigEntity config = this.clusterDAO.findEnabledConfigByType(this.getClusterId(), configType);
        return null != config;
    }

    @Override
    public Map<Long, Map<String, DesiredConfig>> getHostsDesiredConfigs(Collection<Long> hostIds) {
        if (hostIds == null || hostIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<HostConfigMapping> mappingEntities = this.hostConfigMappingDAO.findSelectedByHosts(hostIds);
        HashMap<Long, Map<String, DesiredConfig>> desiredConfigsByHost = new HashMap<Long, Map<String, DesiredConfig>>();
        for (Long hostId : hostIds) {
            desiredConfigsByHost.put(hostId, new HashMap());
        }
        for (HostConfigMapping mappingEntity : mappingEntities) {
            DesiredConfig desiredConfig = new DesiredConfig();
            desiredConfig.setTag(mappingEntity.getVersion());
            desiredConfig.setServiceName(mappingEntity.getServiceName());
            ((Map)desiredConfigsByHost.get(mappingEntity.getHostId())).put(mappingEntity.getType(), desiredConfig);
        }
        return desiredConfigsByHost;
    }

    @Override
    public Map<Long, Map<String, DesiredConfig>> getAllHostsDesiredConfigs() {
        Set<Long> hostIds;
        try {
            hostIds = this.clusters.getHostIdsForCluster(this.clusterName).keySet();
        }
        catch (OBDPException ignored) {
            return Collections.emptyMap();
        }
        return this.getHostsDesiredConfigs(hostIds);
    }

    @Override
    public Long getNextConfigVersion(String type) {
        return this.clusterDAO.findNextConfigVersion(this.clusterId, type);
    }

    @Override
    public Map<ServiceComponentHostEvent, String> processServiceComponentHostEvents(ListMultimap<String, ServiceComponentHostEvent> eventMap) {
        this.clusterGlobalLock.readLock().lock();
        try {
            Map<ServiceComponentHostEvent, String> map = this.processServiceComponentHostEventsInSingleTransaction(eventMap);
            return map;
        }
        finally {
            this.clusterGlobalLock.readLock().unlock();
        }
    }

    @Transactional
    protected Map<ServiceComponentHostEvent, String> processServiceComponentHostEventsInSingleTransaction(ListMultimap<String, ServiceComponentHostEvent> eventMap) {
        HashMap<ServiceComponentHostEvent, String> failedEvents = new HashMap<ServiceComponentHostEvent, String>();
        for (Map.Entry entry : eventMap.entries()) {
            String serviceName = (String)entry.getKey();
            ServiceComponentHostEvent event = (ServiceComponentHostEvent)entry.getValue();
            String serviceComponentName = event.getServiceComponentName();
            if (StringUtils.isBlank((String)serviceName) || RootService.OBDP.name().equals(serviceName) || StringUtils.isBlank((String)serviceComponentName)) continue;
            try {
                Service service = this.getService(serviceName);
                ServiceComponent serviceComponent = service.getServiceComponent(serviceComponentName);
                ServiceComponentHost serviceComponentHost = serviceComponent.getServiceComponentHost(event.getHostName());
                serviceComponentHost.handleEvent(event);
            }
            catch (ServiceNotFoundException e) {
                String message = String.format("ServiceComponentHost lookup exception. Service not found for Service: %s. Error: %s", serviceName, e.getMessage());
                LOG.error(message);
                failedEvents.put(event, message);
            }
            catch (ServiceComponentNotFoundException e) {
                String message = String.format("ServiceComponentHost lookup exception. Service Component not found for Service: %s, Component: %s. Error: %s", serviceName, serviceComponentName, e.getMessage());
                LOG.error(message);
                failedEvents.put(event, message);
            }
            catch (ServiceComponentHostNotFoundException e) {
                String message = String.format("ServiceComponentHost lookup exception. Service Component Host not found for Service: %s, Component: %s, Host: %s. Error: %s", serviceName, serviceComponentName, event.getHostName(), e.getMessage());
                LOG.error(message);
                failedEvents.put(event, message);
            }
            catch (OBDPException e) {
                String message = String.format("ServiceComponentHost lookup exception %s", e.getMessage());
                LOG.error(message);
                failedEvents.put(event, message);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Invalid transition ", (Throwable)e);
                boolean isFailure = true;
                Enum<?> currentState = e.getCurrentState();
                Enum<?> failedEvent = e.getEvent();
                if (currentState == State.STARTED && failedEvent == ServiceComponentHostEventType.HOST_SVCCOMP_START) {
                    isFailure = false;
                    LOG.warn("The start request for {} is invalid since the component is already started. Ignoring the request.", (Object)serviceComponentName);
                }
                if (currentState == State.UNKNOWN && failedEvent == ServiceComponentHostEventType.HOST_SVCCOMP_OP_IN_PROGRESS) {
                    isFailure = false;
                    LOG.warn("The host {} is in an unknown state; attempting to put {} back in progress.", (Object)event.getHostName(), (Object)serviceComponentName);
                }
                if (!isFailure) continue;
                failedEvents.put(event, String.format("Invalid transition. %s", e.getMessage()));
            }
        }
        return failedEvents;
    }

    @Override
    public Set<String> getHosts(String serviceName, String componentName) {
        Map<String, Service> clusterServices = this.getServices();
        if (!clusterServices.containsKey(serviceName)) {
            return Collections.emptySet();
        }
        Service service = clusterServices.get(serviceName);
        Map<String, ServiceComponent> components = service.getServiceComponents();
        if (!components.containsKey(componentName) || components.get(componentName).getServiceComponentHosts().size() == 0) {
            return Collections.emptySet();
        }
        return components.get(componentName).getServiceComponentHosts().keySet();
    }

    @Override
    public Host getHost(String hostName) {
        if (StringUtils.isEmpty((String)hostName)) {
            return null;
        }
        Collection<Host> hosts = this.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                String hostString = host.getHostName();
                if (!hostName.equalsIgnoreCase(hostString)) continue;
                return host;
            }
        }
        return null;
    }

    @Override
    public Host getHost(Long hostId) {
        if (hostId == null) {
            return null;
        }
        Collection<Host> hosts = this.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                if (!hostId.equals(host.getHostId())) continue;
                return host;
            }
        }
        return null;
    }

    @Override
    public Collection<Host> getHosts() {
        return this.clusters.getHostsForCluster(this.clusterName).values();
    }

    private ClusterHealthReport getClusterHealthReport(Map<String, Host> clusterHosts) throws OBDPException {
        int staleConfigsHosts = 0;
        int maintenanceStateHosts = 0;
        int healthyStateHosts = 0;
        int unhealthyStateHosts = 0;
        int initStateHosts = 0;
        int healthyStatusHosts = 0;
        int unhealthyStatusHosts = 0;
        int unknownStatusHosts = 0;
        int alertStatusHosts = 0;
        int heartbeatLostStateHosts = 0;
        Map<String, DesiredConfig> desiredConfigs = this.getDesiredConfigs();
        Collection<Host> hosts = clusterHosts.values();
        Iterator<Host> iterator = hosts.iterator();
        List<Long> hostIds = hosts.stream().map(Host::getHostId).collect(Collectors.toList());
        List<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities = hostIds.isEmpty() ? Collections.EMPTY_LIST : this.hostComponentDesiredStateDAO.findByHostsAndCluster(hostIds, this.clusterId);
        Map mappedHostIds = hostComponentDesiredStateEntities.stream().collect(Collectors.groupingBy(HostComponentDesiredStateEntity::getHostId, Collectors.toMap(HostComponentDesiredStateEntity::getComponentName, java.util.function.Function.identity())));
        while (iterator.hasNext()) {
            Host host = iterator.next();
            String hostName = host.getHostName();
            switch (host.getState()) {
                case HEALTHY: {
                    ++healthyStateHosts;
                    break;
                }
                case UNHEALTHY: {
                    ++unhealthyStateHosts;
                    break;
                }
                case INIT: {
                    ++initStateHosts;
                    break;
                }
                case HEARTBEAT_LOST: {
                    ++heartbeatLostStateHosts;
                }
            }
            switch (HostHealthStatus.HealthStatus.valueOf(host.getStatus())) {
                case HEALTHY: {
                    ++healthyStatusHosts;
                    break;
                }
                case UNHEALTHY: {
                    ++unhealthyStatusHosts;
                    break;
                }
                case UNKNOWN: {
                    ++unknownStatusHosts;
                    break;
                }
                case ALERT: {
                    ++alertStatusHosts;
                }
            }
            boolean staleConfig = false;
            boolean maintenanceState = false;
            if (this.serviceComponentHostsByHost.containsKey(hostName)) {
                Map componentsStates = mappedHostIds.get(host.getHostId());
                for (ServiceComponentHost sch : (List)this.serviceComponentHostsByHost.get(hostName)) {
                    HostComponentDesiredStateEntity componentState;
                    HostComponentDesiredStateEntity hostComponentDesiredStateEntity = componentState = componentsStates == null ? null : (HostComponentDesiredStateEntity)componentsStates.get(sch.getServiceComponentName());
                    staleConfig = componentState != null ? staleConfig || this.configHelper.isStaleConfigs(sch, desiredConfigs, componentState) : staleConfig || this.configHelper.isStaleConfigs(sch, desiredConfigs);
                    maintenanceState = maintenanceState || this.maintenanceStateHelper.getEffectiveState(sch) != MaintenanceState.OFF;
                }
            }
            if (staleConfig) {
                ++staleConfigsHosts;
            }
            if (!maintenanceState) continue;
            ++maintenanceStateHosts;
        }
        ClusterHealthReport chr = new ClusterHealthReport();
        chr.setAlertStatusHosts(alertStatusHosts);
        chr.setHealthyStateHosts(healthyStateHosts);
        chr.setUnknownStatusHosts(unknownStatusHosts);
        chr.setUnhealthyStatusHosts(unhealthyStatusHosts);
        chr.setUnhealthyStateHosts(unhealthyStateHosts);
        chr.setStaleConfigsHosts(staleConfigsHosts);
        chr.setMaintenanceStateHosts(maintenanceStateHosts);
        chr.setInitStateHosts(initStateHosts);
        chr.setHeartbeatLostStateHosts(heartbeatLostStateHosts);
        chr.setHealthyStatusHosts(healthyStatusHosts);
        return chr;
    }

    @Override
    public boolean checkPermission(PrivilegeEntity privilegeEntity, boolean readOnly) {
        ClusterEntity clusterEntity = this.getClusterEntity();
        ResourceEntity resourceEntity = clusterEntity.getResource();
        if (resourceEntity != null) {
            Integer permissionId = privilegeEntity.getPermission().getId();
            if (privilegeEntity.getResource().equals(resourceEntity) && (readOnly && permissionId.equals(2) || permissionId.equals(3))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addSessionAttributes(Map<String, Object> attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            HashMap<String, Object> sessionAttributes = new HashMap<String, Object>(this.getSessionAttributes());
            sessionAttributes.putAll(attributes);
            this.setSessionAttributes(attributes);
        }
    }

    @Override
    public void setSessionAttribute(String key, Object value) {
        if (key != null && !key.isEmpty()) {
            HashMap<String, Object> sessionAttributes = new HashMap<String, Object>(this.getSessionAttributes());
            sessionAttributes.put(key, value);
            this.setSessionAttributes(sessionAttributes);
        }
    }

    @Override
    public void removeSessionAttribute(String key) {
        if (key != null && !key.isEmpty()) {
            HashMap<String, Object> sessionAttributes = new HashMap<String, Object>(this.getSessionAttributes());
            sessionAttributes.remove(key);
            this.setSessionAttributes(sessionAttributes);
        }
    }

    @Override
    public Map<String, Object> getSessionAttributes() {
        Map attributes = (Map)this.getSessionManager().getAttribute(this.getClusterSessionAttributeName());
        return attributes == null ? Collections.emptyMap() : attributes;
    }

    protected OBDPSessionManager getSessionManager() {
        return this.sessionManager;
    }

    private void setSessionAttributes(Map<String, Object> sessionAttributes) {
        this.getSessionManager().setAttribute(this.getClusterSessionAttributeName(), sessionAttributes);
    }

    private String getClusterSessionAttributeName() {
        return CLUSTER_SESSION_ATTRIBUTES_PREFIX + this.getClusterName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void applyLatestConfigurations(StackId stackId, String serviceName) {
        this.clusterGlobalLock.writeLock().lock();
        try {
            ClusterEntity clusterEntity = this.getClusterEntity();
            Collection<ClusterConfigEntity> configEntities = clusterEntity.getClusterConfigEntities();
            ImmutableMap clusterConfigEntityMap = Maps.uniqueIndex(configEntities, (Function)Functions.identity());
            HashSet<String> configTypesForService = new HashSet<String>();
            List<ServiceConfigEntity> latestServiceConfigs = this.serviceConfigDAO.getLastServiceConfigsForService(this.getClusterId(), serviceName);
            for (ServiceConfigEntity serviceConfig : latestServiceConfigs) {
                List<ClusterConfigEntity> latestConfigs = serviceConfig.getClusterConfigEntities();
                for (ClusterConfigEntity latestConfig : latestConfigs) {
                    latestConfig = (ClusterConfigEntity)clusterConfigEntityMap.get((Object)latestConfig);
                    configTypesForService.add(latestConfig.getType());
                    LOG.debug("Disabling configuration {} with tag {}", (Object)latestConfig.getType(), (Object)latestConfig.getTag());
                    latestConfig.setSelected(false);
                }
            }
            List<ClusterConfigEntity> latestConfigsByStack = this.clusterDAO.getLatestConfigurations(this.clusterId, stackId);
            for (ClusterConfigEntity latestConfigByStack : latestConfigsByStack) {
                if (!configTypesForService.contains(latestConfigByStack.getType())) continue;
                ClusterConfigEntity entity = (ClusterConfigEntity)clusterConfigEntityMap.get((Object)latestConfigByStack);
                entity.setSelected(true);
                LOG.info("Setting {} with version tag {} created on {} to selected for stack {}", new Object[]{entity.getType(), entity.getTag(), new Date(entity.getTimestamp()), stackId});
            }
            this.clusterDAO.merge(configEntities, true);
            this.cacheConfigurations();
            LOG.info("Applied latest configurations for {} on stack {}. The the following types were modified: {}", new Object[]{serviceName, stackId, StringUtils.join(configTypesForService, (char)',')});
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
        EntityManagerCacheInvalidationEvent event = new EntityManagerCacheInvalidationEvent();
        this.jpaEventPublisher.publish(event);
    }

    @Override
    public Map<PropertyInfo.PropertyType, Set<String>> getConfigPropertiesTypes(String configType) {
        return this.getConfigPropertiesTypes(configType, this.getCurrentStackVersion());
    }

    @Override
    public Map<PropertyInfo.PropertyType, Set<String>> getConfigPropertiesTypes(String configType, StackId stackId) {
        try {
            StackInfo stackInfo = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            return stackInfo.getConfigPropertiesTypes(configType);
        }
        catch (OBDPException oBDPException) {
            return new HashMap<PropertyInfo.PropertyType, Set<String>>();
        }
    }

    @Transactional
    void removeAllConfigsForStack(StackId stackId, String serviceName) {
        ClusterEntity clusterEntity = this.getClusterEntity();
        this.clusterDAO.refresh(clusterEntity);
        long clusterId = clusterEntity.getClusterId();
        HashSet<String> removedConfigurationTypes = new HashSet<String>();
        ArrayList<ClusterConfigEntity> removedClusterConfigs = new ArrayList<ClusterConfigEntity>(50);
        Collection<ClusterConfigEntity> allClusterConfigEntities = clusterEntity.getClusterConfigEntities();
        Collection<ServiceConfigEntity> allServiceConfigEntities = clusterEntity.getServiceConfigEntities();
        List<ServiceConfigEntity> serviceConfigs = this.serviceConfigDAO.getServiceConfigsForServiceAndStack(clusterId, stackId, serviceName);
        for (ServiceConfigEntity serviceConfig : serviceConfigs) {
            for (ClusterConfigEntity configEntity : serviceConfig.getClusterConfigEntities()) {
                removedConfigurationTypes.add(configEntity.getType());
                allClusterConfigEntities.remove(configEntity);
                this.clusterDAO.removeConfig(configEntity);
                removedClusterConfigs.add(configEntity);
            }
            serviceConfig.getClusterConfigEntities().clear();
            this.serviceConfigDAO.remove(serviceConfig);
            allServiceConfigEntities.remove(serviceConfig);
        }
        clusterEntity.setClusterConfigEntities(allClusterConfigEntities);
        clusterEntity = this.clusterDAO.merge(clusterEntity);
        LOG.info("Removed the following configuration types for {} on stack {}: {}", new Object[]{serviceName, stackId, StringUtils.join(removedConfigurationTypes, (char)',')});
    }

    @Override
    public void removeConfigurations(StackId stackId, String serviceName) {
        this.clusterGlobalLock.writeLock().lock();
        try {
            this.removeAllConfigsForStack(stackId, serviceName);
            this.cacheConfigurations();
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheConfigurations() {
        this.clusterGlobalLock.writeLock().lock();
        try {
            ClusterEntity clusterEntity = this.getClusterEntity();
            this.allConfigs.clear();
            if (!clusterEntity.getClusterConfigEntities().isEmpty()) {
                for (ClusterConfigEntity entity : clusterEntity.getClusterConfigEntities()) {
                    if (!this.allConfigs.containsKey(entity.getType())) {
                        this.allConfigs.put(entity.getType(), new ConcurrentHashMap());
                    }
                    Config config = this.configFactory.createExisting(this, entity);
                    ((ConcurrentMap)this.allConfigs.get(entity.getType())).put(entity.getTag(), config);
                }
            }
        }
        finally {
            this.clusterGlobalLock.writeLock().unlock();
        }
    }

    private void loadStackVersion() {
        this.desiredStackVersion = new StackId(this.getClusterEntity().getDesiredStack());
        if (!StringUtils.isEmpty((String)this.desiredStackVersion.getStackName()) && !StringUtils.isEmpty((String)this.desiredStackVersion.getStackVersion())) {
            try {
                this.loadServiceConfigTypes();
            }
            catch (OBDPException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isBluePrintDeployed() {
        List<TopologyRequestEntity> topologyRequests = this.topologyRequestDAO.findByClusterId(this.getClusterId());
        for (TopologyRequestEntity topologyRequest : topologyRequests) {
            TopologyRequest.Type requestAction = TopologyRequest.Type.valueOf(topologyRequest.getAction());
            if (requestAction != TopologyRequest.Type.PROVISION) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClusterEntity getClusterEntity() {
        return this.clusterDAO.findById(this.clusterId);
    }

    @Override
    public int getClusterSize() {
        return this.clusters.getClusterSize(this.clusterName);
    }

    @Override
    public UpgradeEntity getUpgradeInProgress() {
        ClusterEntity clusterEntity = this.getClusterEntity();
        return clusterEntity.getUpgradeEntity();
    }

    @Override
    @Transactional
    public void setUpgradeEntity(UpgradeEntity upgradeEntity) throws OBDPException {
        try {
            ClusterEntity clusterEntity = this.getClusterEntity();
            clusterEntity.setUpgradeEntity(upgradeEntity);
            this.clusterDAO.merge(clusterEntity);
        }
        catch (RollbackException e) {
            throw new OBDPException("Unable to update the associated upgrade with the cluster", (Throwable)e);
        }
    }

    @Override
    public boolean isUpgradeSuspended() {
        UpgradeEntity upgrade = this.getUpgradeInProgress();
        if (null != upgrade) {
            return upgrade.isSuspended();
        }
        return false;
    }

    @Override
    public String getClusterProperty(String propertyName, String defaultValue) {
        String value;
        Map<String, String> clusterEnvProperties;
        String cachedValue = this.m_clusterPropertyCache.get(propertyName);
        if (null != cachedValue) {
            return cachedValue;
        }
        cachedValue = defaultValue;
        Config clusterEnv = this.getDesiredConfigByType("cluster-env");
        if (null != clusterEnv && (clusterEnvProperties = clusterEnv.getProperties()).containsKey(propertyName) && null != (value = clusterEnvProperties.get(propertyName))) {
            cachedValue = value;
        }
        this.m_clusterPropertyCache.put(propertyName, cachedValue);
        return cachedValue;
    }

    boolean isClusterPropertyCached(String propertyName) {
        return this.m_clusterPropertyCache.containsKey(propertyName);
    }

    @Subscribe
    public void handleClusterEnvConfigChangedEvent(ClusterConfigChangedEvent event) {
        if (!StringUtils.equals((String)event.getConfigType(), (String)"cluster-env")) {
            return;
        }
        this.m_clusterPropertyCache.clear();
    }

    @Subscribe
    public void onClusterProvisioned(ClusterProvisionedEvent event) {
        if (event.getClusterId() == this.getClusterId()) {
            LOG.info("Removing temporary configurations after successful deployment of cluster id={} name={}", (Object)this.getClusterId(), (Object)this.getClusterName());
            for (Map.Entry<String, Set<String>> e : BlueprintConfigurationProcessor.TEMPORARY_PROPERTIES_FOR_CLUSTER_DEPLOYMENT.entrySet()) {
                try {
                    this.configHelper.updateConfigType(this, this.getCurrentStackVersion(), this.controller, e.getKey(), Collections.emptyMap(), (Collection<String>)e.getValue(), "internal", "Removing temporary configurations after successful deployment");
                    LOG.info("Removed temporary configurations: {} / {}", (Object)e.getKey(), e.getValue());
                }
                catch (OBDPException ex) {
                    LOG.warn("Failed to remove temporary configurations: {} / {}", new Object[]{e.getKey(), e.getValue(), ex});
                }
            }
            this.changeBlueprintProvisioningState(BlueprintProvisioningState.FINISHED);
        }
    }

    private void changeBlueprintProvisioningState(BlueprintProvisioningState newState) {
        boolean updated = this.setBlueprintProvisioningState(newState);
        if (updated) {
            try {
                this.hostLevelParamsHolder.updateAllHosts();
            }
            catch (OBDPException e) {
                LOG.error("Topology update failed after setting blueprint provision state to {}", (Object)newState, (Object)e);
            }
        }
    }

    @Override
    public RoleCommandOrder getRoleCommandOrder() {
        return this.roleCommandOrderProvider.getRoleCommandOrder(this);
    }

    @Override
    public void addSuspendedUpgradeParameters(Map<String, String> commandParams, Map<String, String> roleParams) {
        UpgradeEntity suspendedUpgrade = this.getUpgradeInProgress();
        if (null == suspendedUpgrade) {
            LOG.warn("An upgrade is not currently suspended. The command and role parameters will not be modified.");
            return;
        }
        UpgradeContext upgradeContext = this.upgradeContextFactory.create((Cluster)this, suspendedUpgrade);
        commandParams.putAll(upgradeContext.getInitializedCommandParameters());
        roleParams.put("upgrade_suspended", Boolean.TRUE.toString().toLowerCase());
    }

    @Override
    public Map<String, Map<String, String>> getComponentVersionMap() {
        HashMap<String, Map<String, String>> componentVersionMap = new HashMap<String, Map<String, String>>();
        for (Service service : this.getServices().values()) {
            HashMap<String, String> componentMap = new HashMap<String, String>();
            for (ServiceComponent component : service.getServiceComponents().values()) {
                if (!component.isVersionAdvertised() || !component.getDesiredRepositoryVersion().isResolved()) continue;
                componentMap.put(component.getName(), component.getDesiredVersion());
            }
            if (componentMap.isEmpty()) continue;
            componentVersionMap.put(service.getName(), componentMap);
        }
        return componentVersionMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterImpl cluster = (ClusterImpl)o;
        return this.clusterId == cluster.clusterId;
    }

    public int hashCode() {
        return Objects.hash(this.clusterId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClusterInformation buildClusterInformation() {
        SecurityType securityType = this.getSecurityType();
        HashMap<Object, TreeSet> topology = new HashMap<Object, TreeSet>();
        List<ServiceComponentHost> serviceComponentHosts = this.getServiceComponentHosts();
        for (ServiceComponentHost serviceComponentHost : serviceComponentHosts) {
            void var7_7;
            String hash = serviceComponentHost.getServiceName() + "/" + serviceComponentHost.getServiceComponentName();
            Set set = (Set)topology.get(hash);
            if (null == set) {
                TreeSet treeSet = Sets.newTreeSet();
                topology.put(hash, treeSet);
            }
            var7_7.add(serviceComponentHost.getHostName());
        }
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        Map<String, DesiredConfig> desiredConfigs = this.getDesiredConfigs();
        for (Map.Entry entry : desiredConfigs.entrySet()) {
            String configType = (String)entry.getKey();
            DesiredConfig desiredConfig = (DesiredConfig)entry.getValue();
            Config clusterConfig = this.getConfig(configType, desiredConfig.getTag());
            configurations.put(configType, clusterConfig.getProperties());
        }
        Map<String, Service> clusterServices = this.getServices();
        HashMap<String, RepositoryVersion> hashMap = new HashMap<String, RepositoryVersion>();
        if (null != clusterServices) {
            for (Map.Entry<String, Service> serviceEntry : clusterServices.entrySet()) {
                Service service = serviceEntry.getValue();
                RepositoryVersionEntity desiredRepositoryEntity = service.getDesiredRepositoryVersion();
                RepositoryVersion desiredRepositoryVersion = desiredRepositoryEntity.getRepositoryVersion();
                hashMap.put(serviceEntry.getKey(), desiredRepositoryVersion);
            }
        }
        return new ClusterInformation(this.getClusterName(), securityType == SecurityType.KERBEROS, configurations, topology, hashMap);
    }
}

