/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.alerts.Threshold;
import id.onyx.obdp.server.state.AlertState;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Reporting {
    @SerializedName(value="ok")
    private ReportTemplate m_ok;
    @SerializedName(value="warning")
    private ReportTemplate m_warning;
    @SerializedName(value="critical")
    private ReportTemplate m_critical;
    @SerializedName(value="units")
    private String m_units;
    @SerializedName(value="type")
    private ReportingType m_type;

    @JsonProperty(value="warning")
    public ReportTemplate getWarning() {
        return this.m_warning;
    }

    public void setWarning(ReportTemplate warning) {
        this.m_warning = warning;
    }

    @JsonProperty(value="critical")
    public ReportTemplate getCritical() {
        return this.m_critical;
    }

    public void setCritical(ReportTemplate critical) {
        this.m_critical = critical;
    }

    @JsonProperty(value="ok")
    public ReportTemplate getOk() {
        return this.m_ok;
    }

    public void setOk(ReportTemplate ok) {
        this.m_ok = ok;
    }

    @JsonProperty(value="units")
    public String getUnits() {
        return this.m_units;
    }

    public void setUnits(String units) {
        this.m_units = units;
    }

    @JsonProperty(value="type")
    public ReportingType getType() {
        return this.m_type;
    }

    public void setType(ReportingType m_type) {
        this.m_type = m_type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_critical, this.m_ok, this.m_warning, this.m_type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Reporting other = (Reporting)obj;
        return Objects.equals(this.m_critical, other.m_critical) && Objects.equals(this.m_ok, other.m_ok) && Objects.equals(this.m_warning, other.m_warning) && Objects.equals((Object)this.m_type, (Object)other.m_type);
    }

    public AlertState state(double value) {
        return this.getThreshold().state(value);
    }

    private Threshold getThreshold() {
        return new Threshold(this.getOk().getValue(), this.getWarning().getValue(), this.getCritical().getValue());
    }

    public String formatMessage(double value, List<Object> args) {
        ArrayList<Object> copy = new ArrayList<Object>(args);
        copy.add(value);
        return MessageFormat.format(this.message(value), copy.toArray());
    }

    private String message(double value) {
        switch (this.state(value)) {
            case OK: {
                return this.getOk().getText();
            }
            case WARNING: {
                return this.getWarning().getText();
            }
            case CRITICAL: {
                return this.getCritical().getText();
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case SKIPPED: {
                return "Skipped";
            }
        }
        throw new IllegalStateException("Invalid alert state: " + this.state(value));
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static final class ReportTemplate {
        @SerializedName(value="text")
        private String m_text;
        @SerializedName(value="value")
        private Double m_value = null;

        @JsonProperty(value="text")
        public String getText() {
            return this.m_text;
        }

        public void setText(String text) {
            this.m_text = text;
        }

        @JsonProperty(value="value")
        public Double getValue() {
            return this.m_value;
        }

        public void setValue(Double value) {
            this.m_value = value;
        }

        public int hashCode() {
            return Objects.hash(this.m_text, this.m_value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ReportTemplate other = (ReportTemplate)obj;
            return Objects.equals(this.m_text, other.m_text) && Objects.equals(this.m_value, other.m_value);
        }
    }

    public static enum ReportingType {
        NUMERIC,
        PERCENT;

    }
}

