/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.alert.Source;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class ParameterizedSource
extends Source {
    @SerializedName(value="parameters")
    List<AlertParameter> m_parameters;

    @JsonProperty(value="parameters")
    public List<AlertParameter> getParameters() {
        if (null == this.m_parameters) {
            return Collections.emptyList();
        }
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedSource)) {
            return false;
        }
        ParameterizedSource that = (ParameterizedSource)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.m_parameters, that.m_parameters).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_parameters).toHashCode();
    }

    public static enum AlertParameterVisibility {
        VISIBLE,
        HIDDEN,
        READ_ONLY;

    }

    public static enum AlertParameterType {
        STRING,
        NUMERIC,
        PERCENT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class AlertParameter {
        @SerializedName(value="name")
        private String m_name;
        @SerializedName(value="display_name")
        private String m_displayName;
        @SerializedName(value="units")
        private String m_units;
        @SerializedName(value="value")
        private Object m_value;
        @SerializedName(value="description")
        private String m_description;
        @SerializedName(value="type")
        private AlertParameterType m_type;
        @SerializedName(value="visibility")
        private AlertParameterVisibility m_visibility;
        @SerializedName(value="threshold")
        private AlertState m_threshold;

        @JsonProperty(value="name")
        public String getName() {
            return this.m_name;
        }

        @JsonProperty(value="display_name")
        public String getDisplayName() {
            return this.m_displayName;
        }

        @JsonProperty(value="units")
        public String getUnits() {
            return this.m_units;
        }

        @JsonProperty(value="value")
        public Object getValue() {
            return this.m_value;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.m_description;
        }

        @JsonProperty(value="type")
        public AlertParameterType getType() {
            return this.m_type;
        }

        @JsonProperty(value="visibility")
        public AlertParameterVisibility getVisibility() {
            return this.m_visibility;
        }

        @JsonProperty(value="threshold")
        public AlertState getThreshold() {
            return this.m_threshold;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.m_description, this.m_displayName, this.m_name, this.m_threshold, this.m_type, this.m_units, this.m_value, this.m_visibility});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AlertParameter other = (AlertParameter)obj;
            return Objects.equals(this.m_description, other.m_description) && Objects.equals(this.m_displayName, other.m_displayName) && Objects.equals(this.m_name, other.m_name) && Objects.equals((Object)this.m_threshold, (Object)other.m_threshold) && Objects.equals((Object)this.m_type, (Object)other.m_type) && Objects.equals(this.m_units, other.m_units) && Objects.equals(this.m_value, other.m_value) && Objects.equals((Object)this.m_visibility, (Object)other.m_visibility);
        }
    }
}

