/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.controller.jmx.JMXMetricHolder;
import id.onyx.obdp.server.state.UriInfo;
import id.onyx.obdp.server.state.alert.Source;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MetricSource
extends Source {
    @SerializedName(value="uri")
    private UriInfo uri = null;
    @SerializedName(value="jmx")
    private JmxInfo jmxInfo = null;
    @SerializedName(value="ganglia")
    private String gangliaInfo = null;

    @JsonProperty(value="jmx")
    public JmxInfo getJmxInfo() {
        return this.jmxInfo;
    }

    @JsonProperty(value="ganglia")
    public String getGangliaInfo() {
        return this.gangliaInfo;
    }

    @JsonProperty(value="uri")
    public UriInfo getUri() {
        return this.uri;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gangliaInfo, this.uri, this.jmxInfo);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricSource other = (MetricSource)obj;
        return Objects.equals(this.gangliaInfo, other.gangliaInfo) && Objects.equals(this.uri, other.uri) && Objects.equals(this.jmxInfo, other.jmxInfo);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class JmxInfo {
        @JsonProperty(value="property_list")
        @SerializedName(value="property_list")
        private List<String> propertyList;
        @SerializedName(value="value")
        private String value = "{0}";
        @JsonProperty(value="url_suffix")
        @SerializedName(value="url_suffix")
        private String urlSuffix = "/jmx";

        public List<String> getPropertyList() {
            return this.propertyList;
        }

        public void setPropertyList(List<String> propertyList) {
            this.propertyList = propertyList;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Value getValue() {
            return new Value(this.value);
        }

        public boolean equals(Object object) {
            if (!JmxInfo.class.isInstance(object)) {
                return false;
            }
            JmxInfo other = (JmxInfo)object;
            ArrayList<String> list1 = new ArrayList<String>(this.propertyList);
            ArrayList<String> list2 = new ArrayList<String>(other.propertyList);
            return list1.equals(list2);
        }

        public int hashCode() {
            return Objects.hashCode(this.propertyList);
        }

        public String getUrlSuffix() {
            return this.urlSuffix;
        }

        public Optional<Number> eval(JMXMetricHolder jmxMetricHolder) {
            List<Object> metrics = jmxMetricHolder.findAll(this.propertyList);
            if (metrics.isEmpty()) {
                return Optional.empty();
            }
            Object value = this.getValue().eval(metrics);
            return value instanceof Number ? Optional.of((Number)value) : Optional.empty();
        }
    }

    public static class Value {
        private final String value;

        public Value(String value) {
            this.value = value;
        }

        public Object eval(List<Object> metrics) {
            SimpleEvaluationContext context = SimpleEvaluationContext.forReadWriteDataBinding().build();
            for (int i = 0; i < metrics.size(); ++i) {
                context.setVariable("var" + i, metrics.get(i));
            }
            return new SpelExpressionParser().parseExpression(this.value.replaceAll("(\\{(\\d+)\\})", "#var$2")).getValue((EvaluationContext)context);
        }

        public String toString() {
            return this.value;
        }
    }
}

