/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.google.inject.Singleton;
import id.onyx.obdp.server.agent.StaleAlert;
import id.onyx.obdp.server.alerts.StaleAlertRunnable;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.ParameterizedSource;
import id.onyx.obdp.server.state.alert.ServerSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AlertHelper.class);
    private static final int INTERVAL_WAIT_FACTOR_DEFAULT = 2;
    private static final String STALE_INTERVAL_MULTIPLIER_PARAM_KEY = "stale.interval.multiplier";
    private ConcurrentMap<Long, ConcurrentMap<Long, Long>> staleAlerts = new ConcurrentHashMap<Long, ConcurrentMap<Long, Long>>();

    public int getWaitFactorMultiplier(AlertDefinition definition) {
        int waitFactor = 2;
        try {
            ServerSource serverSource = (ServerSource)definition.getSource();
            List<ParameterizedSource.AlertParameter> parameters = serverSource.getParameters();
            for (ParameterizedSource.AlertParameter parameter : parameters) {
                Object value = parameter.getValue();
                if (!StringUtils.equals((String)parameter.getName(), (String)STALE_INTERVAL_MULTIPLIER_PARAM_KEY)) continue;
                waitFactor = this.getThresholdValue(value, 2);
            }
            if (waitFactor < 2 || waitFactor > 10) {
                LOG.warn("The interval multipler of {} is outside the valid range for {} and will be set to 2", (Object)waitFactor, (Object)definition.getLabel());
                waitFactor = 2;
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to read the {} parameter for {}", new Object[]{STALE_INTERVAL_MULTIPLIER_PARAM_KEY, StaleAlertRunnable.class.getSimpleName(), exception});
        }
        return waitFactor;
    }

    public int getThresholdValue(Object value, int defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (!(value instanceof String)) {
            value = value.toString();
        }
        if (!NumberUtils.isNumber((String)((String)value))) {
            return defaultValue;
        }
        Number number = NumberUtils.createNumber((String)((String)value));
        return number.intValue();
    }

    public void addStaleAlerts(Long hostId, List<StaleAlert> staleAlertsDefinitionId) {
        this.staleAlerts.put(hostId, new ConcurrentHashMap());
        ConcurrentMap hostStaleAlerts = (ConcurrentMap)this.staleAlerts.get(hostId);
        staleAlertsDefinitionId.forEach(s -> hostStaleAlerts.put(s.getId(), s.getTimestamp()));
    }

    public Map<Long, Long> getStaleAlerts(Long hostId) {
        return this.staleAlerts.containsKey(hostId) ? new HashMap((Map)this.staleAlerts.get(hostId)) : Collections.emptyMap();
    }

    public void clearStaleAlerts(Long hostId) {
        this.staleAlerts.remove(hostId);
    }

    public void clearStaleAlert(Long hostId, Long definitionId) {
        if (this.staleAlerts.containsKey(hostId)) {
            ((ConcurrentMap)this.staleAlerts.get(hostId)).remove(definitionId);
        }
    }

    public void clearStaleAlert(Long definitionId) {
        this.staleAlerts.forEach((k, v) -> v.remove(definitionId));
    }

    public List<Long> getHostIdsByDefinitionId(Long definitionId) {
        return this.staleAlerts.entrySet().stream().filter(e -> ((ConcurrentMap)e.getValue()).containsKey(definitionId)).map(e -> (Long)e.getKey()).collect(Collectors.toList());
    }
}

