/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AlertDefinitionCommand;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.SourceType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertDefinitionHash {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionHash.class);
    public static final String NULL_MD5_HASH = "37a6259cc0c1dae299a7866489dff0bd";
    @Inject
    private AlertDefinitionDAO m_definitionDao;
    @Inject
    private AlertDefinitionFactory m_factory;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private Provider<ConfigHelper> m_configHelper;
    private ReentrantLock m_actionQueueLock = new ReentrantLock();
    private ConcurrentMap<String, ConcurrentMap<String, String>> m_hashes = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();

    public String getHash(String clusterName, String hostName) {
        String hash;
        ConcurrentMap temp;
        ConcurrentMap<String, String> clusterMapping = (ConcurrentHashMap<String, String>)this.m_hashes.get(hostName);
        if (null == clusterMapping && (temp = (ConcurrentMap)this.m_hashes.putIfAbsent(hostName, clusterMapping = new ConcurrentHashMap<String, String>())) != null) {
            clusterMapping = temp;
        }
        if (null != (hash = (String)clusterMapping.get(hostName))) {
            return hash;
        }
        hash = this.hash(clusterName, hostName);
        clusterMapping.put(clusterName, hash);
        return hash;
    }

    public void invalidateAll() {
        this.m_hashes.clear();
    }

    public void invalidate(String hostName) {
        this.m_hashes.remove(hostName);
    }

    public void invalidate(String clusterName, String hostName) {
        Map clusterMapping = (Map)this.m_hashes.get(hostName);
        if (null != clusterMapping) {
            clusterMapping.remove(clusterName);
        }
    }

    public boolean isHashCached(String clusterName, String hostName) {
        if (null == clusterName || null == hostName) {
            return false;
        }
        Map clusterMapping = (Map)this.m_hashes.get(hostName);
        if (null == clusterMapping) {
            return false;
        }
        return clusterMapping.containsKey(clusterName);
    }

    public List<AlertDefinition> getAlertDefinitions(String clusterName, String hostName) {
        return this.coerce(this.getAlertDefinitionEntities(clusterName, hostName));
    }

    public Map<Long, Map<Long, AlertDefinition>> getAlertDefinitions(Long hostId) throws OBDPException {
        HashMap<Long, Map<Long, AlertDefinition>> result = new HashMap<Long, Map<Long, AlertDefinition>>();
        String hostName = ((Clusters)this.m_clusters.get()).getHostById(hostId).getHostName();
        for (Cluster cluster : ((Clusters)this.m_clusters.get()).getClustersForHost(hostName)) {
            List<AlertDefinition> alertDefinitions = this.getAlertDefinitions(cluster.getClusterName(), hostName);
            result.put(cluster.getClusterId(), AlertDefinitionHash.mapById(alertDefinitions));
        }
        return result;
    }

    public Map<Long, AlertDefinition> findByServiceComponent(long clusterId, String serviceName, String componentName) {
        return AlertDefinitionHash.mapById(this.coerce(this.m_definitionDao.findByServiceComponent(clusterId, serviceName, componentName)));
    }

    public Map<Long, AlertDefinition> findByServiceMaster(long clusterId, String ... serviceName) {
        return AlertDefinitionHash.mapById(this.coerce(this.m_definitionDao.findByServiceMaster(clusterId, Sets.newHashSet((Object[])serviceName))));
    }

    public Set<String> invalidateHosts(AlertDefinitionEntity definition) {
        return this.invalidateHosts(definition.getClusterId(), definition.getSourceType(), definition.getDefinitionName(), definition.getServiceName(), definition.getComponentName());
    }

    public Set<String> invalidateHosts(AlertDefinition definition) {
        return this.invalidateHosts(definition.getClusterId(), definition.getSource().getType(), definition.getName(), definition.getServiceName(), definition.getComponentName());
    }

    private Set<String> invalidateHosts(long clusterId, SourceType definitionSourceType, String definitionName, String definitionServiceName, String definitionComponentName) {
        Cluster cluster = null;
        String clusterName = null;
        try {
            cluster = ((Clusters)this.m_clusters.get()).getClusterById(clusterId);
            if (null != cluster) {
                clusterName = cluster.getClusterName();
            }
            if (null == cluster) {
                LOG.warn("Unable to lookup cluster with ID {}", (Object)clusterId);
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to lookup cluster with ID {}", (Object)clusterId, (Object)exception);
        }
        if (null == cluster) {
            return Collections.emptySet();
        }
        Set<String> affectedHosts = this.getAssociatedHosts(cluster, definitionSourceType, definitionName, definitionServiceName, definitionComponentName);
        for (String hostName : affectedHosts) {
            this.invalidate(clusterName, hostName);
        }
        return affectedHosts;
    }

    public Set<String> getAssociatedHosts(Cluster cluster, SourceType definitionSourceType, String definitionName, String definitionServiceName, String definitionComponentName) {
        if (definitionSourceType == SourceType.AGGREGATE) {
            return Collections.emptySet();
        }
        String clusterName = cluster.getClusterName();
        Map<String, Host> hosts = ((Clusters)this.m_clusters.get()).getHostsForCluster(clusterName);
        HashSet<String> affectedHosts = new HashSet<String>();
        String ambariServiceName = RootService.OBDP.name();
        String agentComponentName = RootComponent.AMBARI_AGENT.name();
        if (ambariServiceName.equals(definitionServiceName) && agentComponentName.equals(definitionComponentName)) {
            affectedHosts.addAll(hosts.keySet());
            return affectedHosts;
        }
        if (ambariServiceName.equalsIgnoreCase(definitionServiceName)) {
            return Collections.emptySet();
        }
        for (String hostName : hosts.keySet()) {
            List<ServiceComponentHost> hostComponents = cluster.getServiceComponentHosts(hostName);
            if (null == hostComponents || hostComponents.size() == 0) continue;
            for (ServiceComponentHost serviceComponentHost : hostComponents) {
                String serviceName = serviceComponentHost.getServiceName();
                String componentName = serviceComponentHost.getServiceComponentName();
                if (!serviceName.equals(definitionServiceName) || !componentName.equals(definitionComponentName)) continue;
                affectedHosts.add(hostName);
            }
        }
        Map<String, Service> services = cluster.getServices();
        Service service = services.get(definitionServiceName);
        if (null == service) {
            LOG.warn("The alert definition {} has an unknown service of {}", (Object)definitionName, (Object)definitionServiceName);
            return affectedHosts;
        }
        Map<String, ServiceComponent> components = service.getServiceComponents();
        if (null != components) {
            for (Map.Entry entry : components.entrySet()) {
                Map<String, ServiceComponentHost> componentHosts;
                if (!((ServiceComponent)entry.getValue()).isMasterComponent() || null == (componentHosts = ((ServiceComponent)entry.getValue()).getServiceComponentHosts())) continue;
                affectedHosts.addAll(componentHosts.keySet());
            }
        }
        return affectedHosts;
    }

    public void enqueueAgentCommands(long clusterId) {
        String clusterName = null;
        try {
            Cluster cluster = ((Clusters)this.m_clusters.get()).getClusterById(clusterId);
            clusterName = cluster.getClusterName();
            Collection<Host> hosts = cluster.getHosts();
            ArrayList<String> hostNames = new ArrayList<String>(hosts.size());
            for (Host host : hosts) {
                hostNames.add(host.getHostName());
            }
            this.enqueueAgentCommands(cluster, clusterName, hostNames);
        }
        catch (OBDPException ae) {
            LOG.error("Unable to lookup cluster for alert definition commands", (Throwable)ae);
        }
    }

    public void enqueueAgentCommands(long clusterId, Collection<String> hosts) {
        String clusterName = null;
        Cluster cluster = null;
        try {
            cluster = ((Clusters)this.m_clusters.get()).getClusterById(clusterId);
            clusterName = cluster.getClusterName();
        }
        catch (OBDPException ae) {
            LOG.error("Unable to lookup cluster for alert definition commands", (Throwable)ae);
        }
        this.enqueueAgentCommands(cluster, clusterName, hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAgentCommands(Cluster cluster, String clusterName, Collection<String> hosts) {
        if (null == clusterName) {
            LOG.warn("Unable to create alert definition agent commands because of a null cluster name");
            return;
        }
        if (null == hosts || hosts.size() == 0) {
            return;
        }
        try {
            this.m_actionQueueLock.lock();
            for (String hostName : hosts) {
                List<AlertDefinition> definitions = this.getAlertDefinitions(clusterName, hostName);
                String hash = this.getHash(clusterName, hostName);
                Host host = cluster.getHost(hostName);
                String publicHostName = host == null ? hostName : host.getPublicHostName();
                AlertDefinitionCommand command = new AlertDefinitionCommand(clusterName, hostName, publicHostName, hash, definitions);
                try {
                    command.addConfigs((ConfigHelper)this.m_configHelper.get(), cluster);
                }
                catch (OBDPException ae) {
                    LOG.warn("Unable to add configurations to alert definition command", (Throwable)ae);
                }
            }
        }
        finally {
            this.m_actionQueueLock.unlock();
        }
    }

    private String hash(String clusterName, String hostName) {
        Set<AlertDefinitionEntity> definitions = this.getAlertDefinitionEntities(clusterName, hostName);
        if (definitions.isEmpty()) {
            return NULL_MD5_HASH;
        }
        Iterator<AlertDefinitionEntity> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            if (!SourceType.AGGREGATE.equals((Object)iterator.next().getSourceType())) continue;
            iterator.remove();
        }
        ArrayList<String> uuids = new ArrayList<String>(definitions.size());
        for (AlertDefinitionEntity alertDefinitionEntity : definitions) {
            uuids.add(alertDefinitionEntity.getHash());
        }
        Collections.sort(uuids);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String uuid : uuids) {
                digest.update(uuid.getBytes());
            }
            byte[] byArray = digest.digest();
            return Hex.encodeHexString((byte[])byArray);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.warn("Unable to calculate MD5 alert definition hash", (Throwable)nsae);
            return NULL_MD5_HASH;
        }
    }

    private Set<AlertDefinitionEntity> getAlertDefinitionEntities(String clusterName, String hostName) {
        HashSet<AlertDefinitionEntity> definitions = new HashSet<AlertDefinitionEntity>();
        try {
            Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(clusterName);
            if (null == cluster) {
                return Collections.emptySet();
            }
            long clusterId = cluster.getClusterId();
            List<ServiceComponentHost> serviceComponents = cluster.getServiceComponentHosts(hostName);
            if (null == serviceComponents || !serviceComponents.isEmpty()) {
                if (serviceComponents != null) {
                    for (ServiceComponentHost serviceComponent : serviceComponents) {
                        String serviceName = serviceComponent.getServiceName();
                        String componentName = serviceComponent.getServiceComponentName();
                        definitions.addAll(this.m_definitionDao.findByServiceComponent(clusterId, serviceName, componentName));
                    }
                }
                HashSet<String> services = new HashSet<String>();
                for (Map.Entry<String, Service> entry : cluster.getServices().entrySet()) {
                    Service service = entry.getValue();
                    Map<String, ServiceComponent> components = service.getServiceComponents();
                    for (Map.Entry<String, ServiceComponent> component : components.entrySet()) {
                        Map<String, ServiceComponentHost> hosts;
                        if (!component.getValue().isMasterComponent() || !(hosts = component.getValue().getServiceComponentHosts()).containsKey(hostName)) continue;
                        services.add(service.getName());
                    }
                }
                if (services.size() > 0) {
                    definitions.addAll(this.m_definitionDao.findByServiceMaster(clusterId, services));
                }
            }
            definitions.addAll(this.m_definitionDao.findAgentScoped(clusterId));
        }
        catch (ClusterNotFoundException clusterNotFound) {
            LOG.warn("Unable to get alert definitions for the missing cluster {}", (Object)clusterName);
            return Collections.emptySet();
        }
        catch (OBDPException ambariException) {
            LOG.error("Unable to get alert definitions", (Throwable)ambariException);
            return Collections.emptySet();
        }
        return definitions;
    }

    private List<AlertDefinition> coerce(Collection<AlertDefinitionEntity> entities) {
        return entities.stream().map(this.m_factory::coerce).collect(Collectors.toList());
    }

    private static Map<Long, AlertDefinition> mapById(Collection<AlertDefinition> definitions) {
        return definitions.stream().collect(Collectors.toMap(AlertDefinition::getDefinitionId, Function.identity()));
    }
}

