/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.alert.AggregateSource;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AmsSource;
import id.onyx.obdp.server.state.alert.MetricSource;
import id.onyx.obdp.server.state.alert.PercentSource;
import id.onyx.obdp.server.state.alert.PortSource;
import id.onyx.obdp.server.state.alert.RecoverySource;
import id.onyx.obdp.server.state.alert.Scope;
import id.onyx.obdp.server.state.alert.ScriptSource;
import id.onyx.obdp.server.state.alert.ServerSource;
import id.onyx.obdp.server.state.alert.Source;
import id.onyx.obdp.server.state.alert.SourceType;
import id.onyx.obdp.server.state.alert.WebSource;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionFactory.class);
    private final GsonBuilder m_builder = new GsonBuilder();
    private final Gson m_gson;

    public AlertDefinitionFactory() {
        this.m_builder.registerTypeAdapter(Source.class, (Object)new AlertDefinitionSourceAdapter());
        this.m_gson = this.m_builder.create();
    }

    public Set<AlertDefinition> getAlertDefinitions(File alertDefinitionFile, String serviceName) throws OBDPException {
        try {
            FileReader fileReader = new FileReader(alertDefinitionFile);
            return this.getAlertDefinitions(fileReader, serviceName);
        }
        catch (IOException ioe) {
            String message = "Could not read the alert definition file";
            LOG.error(message, (Throwable)ioe);
            throw new OBDPException(message, (Throwable)ioe);
        }
    }

    public Set<AlertDefinition> getAlertDefinitions(Reader reader, String serviceName) throws OBDPException {
        Map serviceDefinitionMap = null;
        try {
            Type type = new TypeToken<Map<String, Map<String, List<AlertDefinition>>>>(){}.getType();
            serviceDefinitionMap = (Map)this.m_gson.fromJson(reader, type);
        }
        catch (Exception e) {
            LOG.error("Could not read the alert definitions", (Throwable)e);
            throw new OBDPException("Could not read alert definitions", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        HashSet<AlertDefinition> definitions = new HashSet<AlertDefinition>();
        Map definitionMap = (Map)serviceDefinitionMap.get(serviceName);
        if (null == definitionMap) {
            return definitions;
        }
        for (Map.Entry entry : definitionMap.entrySet()) {
            for (AlertDefinition ad : (List)entry.getValue()) {
                ad.setServiceName(serviceName);
                if (((String)entry.getKey()).equals("service")) continue;
                ad.setComponentName((String)entry.getKey());
            }
            definitions.addAll((Collection)entry.getValue());
        }
        return definitions;
    }

    public AlertDefinition coerce(AlertDefinitionEntity entity) {
        if (null == entity) {
            return null;
        }
        AlertDefinition definition = new AlertDefinition();
        definition.setClusterId(entity.getClusterId());
        definition.setDefinitionId(entity.getDefinitionId());
        definition.setComponentName(entity.getComponentName());
        definition.setEnabled(entity.getEnabled());
        definition.setHostIgnored(entity.isHostIgnored());
        definition.setInterval(entity.getScheduleInterval());
        definition.setName(entity.getDefinitionName());
        definition.setScope(entity.getScope());
        definition.setServiceName(entity.getServiceName());
        definition.setLabel(entity.getLabel());
        definition.setHelpURL(entity.getHelpURL());
        definition.setDescription(entity.getDescription());
        definition.setUuid(entity.getHash());
        definition.setRepeatTolerance(entity.getRepeatTolerance());
        definition.setRepeatToleranceEnabled(entity.isRepeatToleranceEnabled());
        try {
            String sourceJson = entity.getSource();
            Source source = (Source)this.m_gson.fromJson(sourceJson, Source.class);
            definition.setSource(source);
        }
        catch (Exception exception) {
            LOG.error("Alert defintion is invalid for  Id : " + entity.getDefinitionId() + " Name: " + entity.getDefinitionName());
            LOG.error("Unable to deserialize the alert definition source during coercion", (Throwable)exception);
            return null;
        }
        return definition;
    }

    public AlertDefinitionEntity coerce(long clusterId, AlertDefinition definition) {
        if (null == definition) {
            return null;
        }
        AlertDefinitionEntity entity = new AlertDefinitionEntity();
        entity.setClusterId(clusterId);
        return this.merge(definition, entity);
    }

    public AlertDefinitionEntity merge(AlertDefinition definition, AlertDefinitionEntity entity) {
        entity.setComponentName(definition.getComponentName());
        entity.setDefinitionName(definition.getName());
        entity.setEnabled(definition.isEnabled());
        entity.setHostIgnored(definition.isHostIgnored());
        entity.setLabel(definition.getLabel());
        entity.setDescription(definition.getDescription());
        entity.setScheduleInterval(definition.getInterval());
        entity.setHelpURL(definition.getHelpURL());
        entity.setServiceName(definition.getServiceName());
        Scope scope = definition.getScope();
        if (null == scope) {
            scope = Scope.ANY;
        }
        entity.setScope(scope);
        return this.mergeSource(definition.getSource(), entity);
    }

    public AlertDefinitionEntity mergeSource(Source source, AlertDefinitionEntity entity) {
        entity.setSourceType(source.getType());
        try {
            String sourceJson = this.m_gson.toJson((Object)source);
            entity.setSource(sourceJson);
        }
        catch (Exception e) {
            LOG.error("Unable to serialize the alert definition source during merge", (Throwable)e);
            return null;
        }
        AlertDefinitionFactory.assignNewUUID(entity);
        return entity;
    }

    private static void assignNewUUID(AlertDefinitionEntity entity) {
        if (entity != null) {
            entity.setHash(UUID.randomUUID().toString());
        }
    }

    public Gson getGson() {
        return this.m_gson;
    }

    private static final class AlertDefinitionSourceAdapter
    implements JsonDeserializer<Source> {
        private AlertDefinitionSourceAdapter() {
        }

        public Source deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = (JsonObject)json;
            SourceType type = SourceType.valueOf(jsonObj.get("type").getAsString());
            Class clazz = null;
            switch (type) {
                case METRIC: {
                    clazz = MetricSource.class;
                    break;
                }
                case AMS: {
                    clazz = AmsSource.class;
                    break;
                }
                case PORT: {
                    clazz = PortSource.class;
                    break;
                }
                case SCRIPT: {
                    clazz = ScriptSource.class;
                    break;
                }
                case AGGREGATE: {
                    clazz = AggregateSource.class;
                    break;
                }
                case PERCENT: {
                    clazz = PercentSource.class;
                    break;
                }
                case WEB: {
                    clazz = WebSource.class;
                    break;
                }
                case RECOVERY: {
                    clazz = RecoverySource.class;
                    break;
                }
                case SERVER: {
                    clazz = ServerSource.class;
                    break;
                }
            }
            if (null == clazz) {
                LOG.warn("Unable to deserialize an alert definition with source type {}", (Object)type);
                return null;
            }
            return (Source)context.deserialize(json, clazz);
        }
    }
}

