/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.alert.Reporting;
import id.onyx.obdp.server.state.alert.Scope;
import id.onyx.obdp.server.state.alert.Source;
import id.onyx.obdp.server.state.alert.SourceType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AlertDefinition {
    private long clusterId;
    private long definitionId;
    private String serviceName = null;
    private String componentName = null;
    private String name = null;
    private Scope scope = Scope.ANY;
    private int interval = 1;
    private boolean enabled = true;
    private Source source = null;
    private String label = null;
    private String description = null;
    private String uuid = null;
    @SerializedName(value="ignore_host")
    private boolean ignoreHost = false;
    @SerializedName(value="help_url")
    private String helpURL = null;
    @JsonProperty(value="repeat_tolerance")
    private int repeatTolerance;
    @JsonProperty(value="repeat_tolerance_enabled")
    private Boolean repeatToleranceEnabled;

    public long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public long getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(long definitionId) {
        this.definitionId = definitionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String name) {
        this.componentName = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String definitionName) {
        this.name = definitionName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope definitionScope) {
        if (null == definitionScope) {
            definitionScope = Scope.ANY;
        }
        this.scope = definitionScope;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int definitionInterval) {
        this.interval = definitionInterval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean definitionEnabled) {
        this.enabled = definitionEnabled;
    }

    @JsonProperty(value="ignore_host")
    public boolean isHostIgnored() {
        return this.ignoreHost;
    }

    public void setHostIgnored(boolean definitionHostIgnored) {
        this.ignoreHost = definitionHostIgnored;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source definitionSource) {
        this.source = definitionSource;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String definitionLabel) {
        this.label = definitionLabel;
    }

    @JsonProperty(value="help_url")
    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUuid(String definitionUuid) {
        this.uuid = definitionUuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getRepeatTolerance() {
        return this.repeatTolerance;
    }

    public void setRepeatTolerance(int repeatTolerance) {
        this.repeatTolerance = repeatTolerance;
    }

    public Boolean getRepeatToleranceEnabled() {
        return this.repeatToleranceEnabled;
    }

    public void setRepeatToleranceEnabled(Boolean repeatToleranceEnabled) {
        this.repeatToleranceEnabled = repeatToleranceEnabled;
    }

    public boolean deeplyEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlertDefinition other = (AlertDefinition)obj;
        if (this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.ignoreHost != other.ignoreHost) {
            return false;
        }
        if (this.interval != other.interval) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (!StringUtils.equals((String)this.helpURL, (String)other.helpURL)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (null == this.scope) {
            this.scope = Scope.ANY;
        }
        if (this.scope != other.scope) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public Alert buildAlert(double value, List<Object> args) {
        Reporting reporting = this.source.getReporting();
        Alert alert = new Alert(this.name, null, this.serviceName, this.componentName, null, reporting.state(value));
        alert.setText(reporting.formatMessage(value, args));
        return alert;
    }

    public boolean equals(Object obj) {
        if (null == obj || !obj.getClass().equals(AlertDefinition.class)) {
            return false;
        }
        return this.name.equals(((AlertDefinition)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public Set<String> matchingHosts(Clusters clusters) throws OBDPException {
        Cluster cluster = clusters.getCluster(this.clusterId);
        if (this.source.getType() == SourceType.AGGREGATE) {
            return Collections.emptySet();
        }
        if (RootService.OBDP.name().equals(this.serviceName)) {
            return RootComponent.AMBARI_AGENT.name().equals(this.componentName) ? cluster.getHostNames() : Collections.emptySet();
        }
        HashSet<String> matchingHosts = new HashSet<String>();
        for (String host : cluster.getHostNames()) {
            for (ServiceComponentHost component : cluster.getServiceComponentHosts(host)) {
                if (!this.belongsTo(component)) continue;
                matchingHosts.add(host);
            }
        }
        return matchingHosts;
    }

    private boolean belongsTo(ServiceComponentHost component) {
        return component.getServiceName().equals(this.serviceName) && component.getServiceComponentName().equals(this.componentName);
    }
}

