/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.alert;

import com.google.inject.Singleton;
import id.onyx.obdp.server.state.alert.AggregateSource;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class AggregateDefinitionMapping {
    private Map<Long, Map<String, AlertDefinition>> m_aggregateMap = new ConcurrentHashMap<Long, Map<String, AlertDefinition>>();

    public AlertDefinition getAggregateDefinition(long clusterId, String name) {
        Long id = clusterId;
        if (!this.m_aggregateMap.containsKey(id)) {
            return null;
        }
        if (!this.m_aggregateMap.get(id).containsKey(name)) {
            return null;
        }
        return this.m_aggregateMap.get(id).get(name);
    }

    public void registerAggregate(long clusterId, AlertDefinition definition) {
        Long id = clusterId;
        if (!this.m_aggregateMap.containsKey(id)) {
            this.m_aggregateMap.put(id, new HashMap());
        }
        Map<String, AlertDefinition> map = this.m_aggregateMap.get(id);
        AggregateSource as = (AggregateSource)definition.getSource();
        map.put(as.getAlertName(), definition);
    }

    public void removeAssociatedAggregate(long clusterId, String aggregatedDefinitonName) {
        Long id = clusterId;
        if (!this.m_aggregateMap.containsKey(id)) {
            return;
        }
        Map<String, AlertDefinition> map = this.m_aggregateMap.get(id);
        map.remove(aggregatedDefinitonName);
    }

    public List<AlertDefinition> getAggregateDefinitions(long clusterId) {
        if (!this.m_aggregateMap.containsKey(clusterId)) {
            return Collections.emptyList();
        }
        Map<String, AlertDefinition> map = this.m_aggregateMap.get(clusterId);
        return new ArrayList<AlertDefinition>(map.values());
    }

    public List<String> getAlertsWithAggregates(long clusterId) {
        if (!this.m_aggregateMap.containsKey(clusterId)) {
            return Collections.emptyList();
        }
        Map<String, AlertDefinition> map = this.m_aggregateMap.get(clusterId);
        return new ArrayList<String>(map.keySet());
    }
}

