/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state.action;

import id.onyx.obdp.server.state.action.Action;
import id.onyx.obdp.server.state.action.ActionCompletedEvent;
import id.onyx.obdp.server.state.action.ActionEvent;
import id.onyx.obdp.server.state.action.ActionEventType;
import id.onyx.obdp.server.state.action.ActionFailedEvent;
import id.onyx.obdp.server.state.action.ActionId;
import id.onyx.obdp.server.state.action.ActionInitEvent;
import id.onyx.obdp.server.state.action.ActionProgressUpdateEvent;
import id.onyx.obdp.server.state.action.ActionState;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.fsm.SingleArcTransition;
import id.onyx.obdp.server.state.fsm.StateMachine;
import id.onyx.obdp.server.state.fsm.StateMachineFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionImpl
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(ActionImpl.class);
    private final Lock readLock;
    private final Lock writeLock;
    private ActionId id;
    private long startTime;
    private long lastUpdateTime;
    private long completionTime;
    private static final StateMachineFactory<ActionImpl, ActionState, ActionEventType, ActionEvent> stateMachineFactory = new StateMachineFactory<ActionImpl, ActionState, ActionEventType, ActionEvent>(ActionState.INIT).addTransition(ActionState.INIT, ActionState.IN_PROGRESS, ActionEventType.ACTION_IN_PROGRESS, new ActionProgressUpdateTransition()).addTransition(ActionState.INIT, ActionState.COMPLETED, ActionEventType.ACTION_COMPLETED, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionCompletedTransition()).addTransition(ActionState.INIT, ActionState.FAILED, ActionEventType.ACTION_FAILED, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionFailedTransition()).addTransition(ActionState.INIT, ActionState.IN_PROGRESS, ActionEventType.ACTION_IN_PROGRESS, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionProgressUpdateTransition()).addTransition(ActionState.IN_PROGRESS, ActionState.IN_PROGRESS, ActionEventType.ACTION_IN_PROGRESS, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionProgressUpdateTransition()).addTransition(ActionState.IN_PROGRESS, ActionState.COMPLETED, ActionEventType.ACTION_COMPLETED, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionCompletedTransition()).addTransition(ActionState.IN_PROGRESS, ActionState.FAILED, ActionEventType.ACTION_FAILED, (SingleArcTransition<ActionImpl, ActionEvent>)new ActionFailedTransition()).addTransition(ActionState.COMPLETED, ActionState.INIT, ActionEventType.ACTION_INIT, (SingleArcTransition<ActionImpl, ActionEvent>)new NewActionTransition()).addTransition(ActionState.FAILED, ActionState.INIT, ActionEventType.ACTION_INIT, (SingleArcTransition<ActionImpl, ActionEvent>)new NewActionTransition()).installTopology();
    private final StateMachine<ActionState, ActionEventType, ActionEvent> stateMachine;

    public ActionImpl(ActionId id, long startTime) {
        this.id = id;
        this.stateMachine = stateMachineFactory.make(this);
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.startTime = startTime;
        this.lastUpdateTime = -1L;
        this.completionTime = -1L;
    }

    private void reset() {
        try {
            this.writeLock.lock();
            this.startTime = -1L;
            this.lastUpdateTime = -1L;
            this.completionTime = -1L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ActionState getState() {
        try {
            this.readLock.lock();
            ActionState actionState = this.stateMachine.getCurrentState();
            return actionState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setState(ActionState state) {
        try {
            this.writeLock.lock();
            this.stateMachine.setCurrentState(state);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(ActionEvent event) throws InvalidStateTransitionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling Action event, eventType={}, event={}", (Object)((ActionEventType)((Object)event.getType())).name(), (Object)event);
        }
        ActionState oldState = this.getState();
        try {
            this.writeLock.lock();
            try {
                this.stateMachine.doTransition((ActionEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Can't handle Action event at current state, actionId=" + this.getId() + ", currentState=" + oldState + ", eventType=" + event.getType() + ", event=" + event);
                throw e;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (oldState != this.getState() && LOG.isDebugEnabled()) {
            LOG.debug("Action transitioned to a new state, actionId={}, oldState={}, currentState={}, eventType={}, event={}", new Object[]{this.getId(), oldState, this.getState(), ((ActionEventType)((Object)event.getType())).name(), event});
        }
    }

    @Override
    public ActionId getId() {
        try {
            this.readLock.lock();
            ActionId actionId = this.id;
            return actionId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setId(ActionId id) {
        try {
            this.writeLock.lock();
            this.id = id;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getStartTime() {
        try {
            this.readLock.lock();
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setStartTime(long startTime) {
        try {
            this.writeLock.lock();
            this.startTime = startTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getLastUpdateTime() {
        try {
            this.readLock.lock();
            long l = this.lastUpdateTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        try {
            this.writeLock.lock();
            this.lastUpdateTime = lastUpdateTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getCompletionTime() {
        try {
            this.readLock.lock();
            long l = this.completionTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCompletionTime(long completionTime) {
        try {
            this.writeLock.lock();
            this.completionTime = completionTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static class ActionProgressUpdateTransition
    implements SingleArcTransition<ActionImpl, ActionEvent> {
        ActionProgressUpdateTransition() {
        }

        @Override
        public void transition(ActionImpl action, ActionEvent event) {
            ActionProgressUpdateEvent e = (ActionProgressUpdateEvent)event;
            action.setLastUpdateTime(e.getProgressUpdateTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Progress update for Action, actionId={}, startTime={}, lastUpdateTime={}", new Object[]{action.getId(), action.getStartTime(), action.getLastUpdateTime()});
            }
        }
    }

    static class ActionCompletedTransition
    implements SingleArcTransition<ActionImpl, ActionEvent> {
        ActionCompletedTransition() {
        }

        @Override
        public void transition(ActionImpl action, ActionEvent event) {
            ActionCompletedEvent e = (ActionCompletedEvent)event;
            action.setCompletionTime(e.getCompletionTime());
            action.setLastUpdateTime(e.getCompletionTime());
            LOG.info("Action completed successfully, actionId=" + action.getId() + ", startTime=" + action.getStartTime() + ", completionTime=" + action.getCompletionTime());
        }
    }

    static class ActionFailedTransition
    implements SingleArcTransition<ActionImpl, ActionEvent> {
        ActionFailedTransition() {
        }

        @Override
        public void transition(ActionImpl action, ActionEvent event) {
            ActionFailedEvent e = (ActionFailedEvent)event;
            action.setCompletionTime(e.getCompletionTime());
            action.setLastUpdateTime(e.getCompletionTime());
            LOG.info("Action failed to complete, actionId=" + action.getId() + ", startTime=" + action.getStartTime() + ", completionTime=" + action.getCompletionTime());
        }
    }

    static class NewActionTransition
    implements SingleArcTransition<ActionImpl, ActionEvent> {
        NewActionTransition() {
        }

        @Override
        public void transition(ActionImpl action, ActionEvent event) {
            ActionInitEvent e = (ActionInitEvent)event;
            action.reset();
            action.setId(e.getActionId());
            action.setStartTime(e.getStartTime());
            LOG.info("Launching a new Action, actionId=" + action.getId() + ", startTime=" + action.getStartTime());
        }
    }
}

