/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.kerberos.VariableReplacementHelper;
import java.net.URI;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UriInfo {
    @SerializedName(value="acceptable_codes")
    private Set<Integer> m_acceptableCodes;
    @SerializedName(value="http")
    private String m_httpUri;
    @SerializedName(value="https")
    private String m_httpsUri;
    @SerializedName(value="https_property")
    private String m_httpsProperty;
    @SerializedName(value="https_property_value")
    private String m_httpsPropertyValue;
    @SerializedName(value="kerberos_keytab")
    private String m_kerberosKeytab;
    @SerializedName(value="kerberos_principal")
    private String m_kerberosPrincipal;
    @SerializedName(value="default_port")
    private Number m_port = 0;
    @SerializedName(value="connection_timeout")
    @JsonProperty(value="connection_timeout")
    private float m_connectionTimeout = 5.0f;
    @SerializedName(value="read_timeout")
    private float readTimeout = 15.0f;
    @SerializedName(value="high_availability")
    private HighAvailability m_highAvailability;

    @JsonProperty(value="http")
    public String getHttpUri() {
        return this.m_httpUri;
    }

    public void setHttpUri(String httpUri) {
        this.m_httpUri = httpUri;
    }

    public void setHttpsUri(String httpsUri) {
        this.m_httpsUri = httpsUri;
    }

    public void setHttpsPropertyValue(String m_httpsPropertyValue) {
        this.m_httpsPropertyValue = m_httpsPropertyValue;
    }

    public void setHttpsProperty(String m_httpsProperty) {
        this.m_httpsProperty = m_httpsProperty;
    }

    @JsonProperty(value="default_port")
    public Number getDefaultPort() {
        return this.m_port;
    }

    @JsonProperty(value="https")
    public String getHttpsUri() {
        return this.m_httpsUri;
    }

    @JsonProperty(value="https_property")
    public String getHttpsProperty() {
        return this.m_httpsProperty;
    }

    @JsonProperty(value="https_property_value")
    public String getHttpsPropertyValue() {
        return this.m_httpsPropertyValue;
    }

    @JsonProperty(value="kerberos_keytab")
    public String getKerberosKeytab() {
        return this.m_kerberosKeytab;
    }

    @JsonProperty(value="kerberos_principal")
    public String getKerberosPrincipal() {
        return this.m_kerberosPrincipal;
    }

    @JsonProperty(value="high_availability")
    public HighAvailability getHighAvailability() {
        return this.m_highAvailability;
    }

    public Set<Integer> getAcceptableCodes() {
        return this.m_acceptableCodes;
    }

    public void setAcceptableCodes(Set<Integer> m_acceptableCodes) {
        this.m_acceptableCodes = m_acceptableCodes;
    }

    public URI resolve(Map<String, Map<String, String>> config) throws OBDPException {
        VariableReplacementHelper variableReplacer = new VariableReplacementHelper();
        String httpsProperty = variableReplacer.replaceVariables(this.m_httpsProperty, config);
        String httpsPropertyValue = variableReplacer.replaceVariables(this.m_httpsPropertyValue, config);
        return httpsProperty == null || !httpsProperty.equals(httpsPropertyValue) ? URI.create(String.format("http://%s", variableReplacer.replaceVariables(this.m_httpUri, config))) : URI.create(String.format("https://%s", variableReplacer.replaceVariables(this.m_httpsUri, config)));
    }

    public int getConnectionTimeoutMsec() {
        return (int)this.m_connectionTimeout * 1000;
    }

    public int getReadTimeoutMsec() {
        return (int)this.readTimeout * 1000;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_httpUri == null ? 0 : this.m_httpUri.hashCode());
        result = 31 * result + (this.m_httpsProperty == null ? 0 : this.m_httpsProperty.hashCode());
        result = 31 * result + (this.m_httpsPropertyValue == null ? 0 : this.m_httpsPropertyValue.hashCode());
        result = 31 * result + (this.m_httpsUri == null ? 0 : this.m_httpsUri.hashCode());
        result = 31 * result + this.m_port.intValue();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriInfo other = (UriInfo)obj;
        if (this.m_httpUri == null ? other.m_httpUri != null : !this.m_httpUri.equals(other.m_httpUri)) {
            return false;
        }
        if (this.m_httpsProperty == null ? other.m_httpsProperty != null : !this.m_httpsProperty.equals(other.m_httpsProperty)) {
            return false;
        }
        if (this.m_httpsPropertyValue == null ? other.m_httpsPropertyValue != null : !this.m_httpsPropertyValue.equals(other.m_httpsPropertyValue)) {
            return false;
        }
        if (this.m_httpsUri == null ? other.m_httpsUri != null : !this.m_httpsUri.equals(other.m_httpsUri)) {
            return false;
        }
        if (this.m_connectionTimeout != other.m_connectionTimeout) {
            return false;
        }
        return this.m_port.intValue() == other.m_port.intValue();
    }

    public class HighAvailability {
        @SerializedName(value="nameservice")
        private String m_nameservice;
        @SerializedName(value="alias_key")
        private String m_aliasKey;
        @SerializedName(value="http_pattern")
        private String m_httpPattern;
        @SerializedName(value="https_pattern")
        private String m_httpsPattern;

        @JsonProperty(value="nameservice")
        public String getNameservice() {
            return this.m_nameservice;
        }

        @JsonProperty(value="alias_key")
        public String getAliasKey() {
            return this.m_aliasKey;
        }

        @JsonProperty(value="http_pattern")
        public String getHttpPattern() {
            return this.m_httpPattern;
        }

        @JsonProperty(value="https_pattern")
        public String getHttpsPattern() {
            return this.m_httpsPattern;
        }
    }
}

