/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.state.ServiceComponentHost;

public enum State {
    INIT,
    INSTALLING,
    INSTALL_FAILED,
    INSTALLED,
    STARTING,
    STARTED,
    STOPPING,
    UNINSTALLING,
    UNINSTALLED,
    WIPING_OUT,
    UPGRADING,
    DISABLED,
    UNKNOWN;


    public boolean isValidDesiredState() {
        switch (this) {
            case INIT: 
            case INSTALLED: 
            case STARTED: 
            case UNINSTALLED: 
            case DISABLED: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidClientComponentState() {
        switch (this) {
            case STARTED: 
            case STARTING: 
            case STOPPING: {
                return false;
            }
        }
        return true;
    }

    public boolean isRemovableState() {
        switch (this) {
            case INIT: 
            case INSTALLED: 
            case UNINSTALLED: 
            case DISABLED: 
            case INSTALLING: 
            case INSTALL_FAILED: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidStateTransition(State startState, State desiredState) {
        switch (desiredState) {
            case INSTALLED: {
                if (startState != INIT && startState != UNINSTALLED && startState != INSTALLED && startState != INSTALLING && startState != STARTED && startState != INSTALL_FAILED && startState != UPGRADING && startState != STOPPING && startState != UNKNOWN && startState != DISABLED) break;
                return true;
            }
            case STARTED: {
                if (startState != INSTALLED && startState != STARTING && startState != STARTED) break;
                return true;
            }
            case UNINSTALLED: {
                if (startState != INSTALLED && startState != UNINSTALLED && startState != UNINSTALLING) break;
                return true;
            }
            case INIT: {
                if (startState != UNINSTALLED && startState != INIT && startState != WIPING_OUT) break;
                return true;
            }
            case DISABLED: {
                if (startState != INSTALLED && startState != INSTALL_FAILED && startState != UNKNOWN) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDesiredStateTransition(State startState, State desiredState) {
        switch (desiredState) {
            case INSTALLED: {
                if (startState != INIT && startState != UNINSTALLED && startState != INSTALLED && startState != STARTED && startState != STOPPING) break;
                return true;
            }
            case STARTED: {
                if (startState != INSTALLED && startState != STARTED) break;
                return true;
            }
        }
        return false;
    }

    public static void checkUpdateConfiguration(ServiceComponentHost serviceComponentHost, State currentState, State desiredState) throws OBDPException {
        if (desiredState != null && desiredState != INIT && desiredState != INSTALLED && desiredState != STARTED) {
            throw new OBDPException("Changing of configs not supported for this transition, clusterName=" + serviceComponentHost.getClusterName() + ", serviceName=" + serviceComponentHost.getServiceName() + ", componentName=" + serviceComponentHost.getServiceComponentName() + ", hostname=" + serviceComponentHost.getHostName() + ", currentState=" + currentState + ", newDesiredState=" + desiredState);
        }
    }
}

