/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import com.google.inject.Injector;
import id.onyx.obdp.server.controller.StackVersionResponse;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RefreshCommandConfiguration;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.repository.DefaultStackVersion;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.server.state.stack.StackRoleCommandOrder;
import id.onyx.obdp.server.utils.VersionUtils;
import id.onyx.obdp.spi.stack.StackReleaseVersion;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackInfo
implements Comparable<StackInfo>,
Validable {
    private static final Logger LOG = LoggerFactory.getLogger(StackInfo.class);
    private String minJdk;
    private String maxJdk;
    private String name;
    private String version;
    private String minUpgradeVersion;
    private boolean active;
    private String rcoFileLocation;
    private String kerberosDescriptorPreConfigurationFileLocation;
    private List<RepositoryInfo> repositories;
    private Collection<ServiceInfo> services;
    private Collection<ExtensionInfo> extensions;
    private String parentStackVersion;
    private List<PropertyInfo> properties;
    private Map<String, Map<String, Map<String, String>>> configTypes;
    private Map<String, UpgradePack> upgradePacks;
    private ConfigUpgradePack configUpgradePack;
    private StackRoleCommandOrder roleCommandOrder;
    private boolean valid = true;
    private Map<String, Map<PropertyInfo.PropertyType, Set<String>>> propertiesTypesCache = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Map<String, String>>> configPropertyAttributes = null;
    private String upgradesFolder = null;
    private volatile Map<String, PropertyInfo> requiredProperties;
    private Map<String, VersionDefinitionXml> versionDefinitions = new ConcurrentHashMap<String, VersionDefinitionXml>();
    private Set<String> errorSet = new HashSet<String>();
    private RepositoryXml repoXml = null;
    private VersionDefinitionXml latestVersion = null;
    private String releaseVersionClass = null;
    private URLClassLoader libraryClassLoader = null;
    private List<String> removedServices = new ArrayList<String>();
    private List<String> servicesWithNoConfigs = new ArrayList<String>();
    private RefreshCommandConfiguration refreshCommandConfiguration = new RefreshCommandConfiguration();

    public String getMinJdk() {
        return this.minJdk;
    }

    public void setMinJdk(String minJdk) {
        this.minJdk = minJdk;
    }

    public String getMaxJdk() {
        return this.maxJdk;
    }

    public void setMaxJdk(String maxJdk) {
        this.maxJdk = maxJdk;
    }

    public void setReleaseVersionClass(String className) {
        this.releaseVersionClass = className;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<RepositoryInfo> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<RepositoryInfo>();
        }
        return this.repositories;
    }

    public ListMultimap<String, RepositoryInfo> getRepositoriesByOs() {
        return Multimaps.index(this.getRepositories(), RepositoryInfo.GET_OSTYPE_FUNCTION);
    }

    public synchronized Collection<ServiceInfo> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<ServiceInfo>();
        }
        return this.services;
    }

    public ServiceInfo getService(String name) {
        Collection<ServiceInfo> services = this.getServices();
        for (ServiceInfo service : services) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public synchronized void setServices(Collection<ServiceInfo> services) {
        this.services = services;
    }

    public synchronized Collection<ExtensionInfo> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<ExtensionInfo>();
        }
        return this.extensions;
    }

    public ExtensionInfo getExtension(String name) {
        Collection<ExtensionInfo> extensions = this.getExtensions();
        for (ExtensionInfo extension : extensions) {
            if (!extension.getName().equals(name)) continue;
            return extension;
        }
        return null;
    }

    public ExtensionInfo getExtensionByService(String serviceName) {
        Collection<ExtensionInfo> extensions = this.getExtensions();
        for (ExtensionInfo extension : extensions) {
            Collection<ServiceInfo> services = extension.getServices();
            for (ServiceInfo service : services) {
                if (!service.getName().equals(serviceName)) continue;
                return extension;
            }
        }
        return null;
    }

    public void addExtension(ExtensionInfo extension) {
        Collection<ExtensionInfo> extensions = this.getExtensions();
        extensions.add(extension);
        Collection<ServiceInfo> services = this.getServices();
        services.addAll(extension.getServices());
    }

    public void removeExtension(ExtensionInfo extension) {
        Collection<ExtensionInfo> extensions = this.getExtensions();
        extensions.remove(extension);
        Collection<ServiceInfo> services = this.getServices();
        for (ServiceInfo service : extension.getServices()) {
            services.remove(service);
        }
    }

    public List<PropertyInfo> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyInfo>();
        }
        return this.properties;
    }

    public void setProperties(List<PropertyInfo> properties) {
        this.properties = properties;
    }

    public synchronized Map<String, Map<String, Map<String, String>>> getConfigTypeAttributes() {
        return this.configTypes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.configTypes);
    }

    public synchronized void setConfigTypeAttributes(String type, Map<String, Map<String, String>> typeAttributes) {
        if (this.configTypes == null) {
            this.configTypes = new HashMap<String, Map<String, Map<String, String>>>();
        }
        this.configTypes.put(type, typeAttributes);
    }

    public synchronized void setAllConfigAttributes(Map<String, Map<String, Map<String, String>>> types) {
        this.configTypes = new HashMap<String, Map<String, Map<String, String>>>();
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : types.entrySet()) {
            this.setConfigTypeAttributes(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Stack name:" + this.name + "\nversion:" + this.version + "\nactive:" + this.active + " \nvalid:" + this.isValid());
        if (this.services != null) {
            sb.append("\n\t\tService:");
            for (ServiceInfo service : this.services) {
                sb.append("\t\t");
                sb.append(service);
            }
        }
        if (this.repositories != null) {
            sb.append("\n\t\tRepositories:");
            for (RepositoryInfo repository : this.repositories) {
                sb.append("\t\t");
                sb.append(repository);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return 31 + this.name.hashCode() + this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StackInfo stackInfo = (StackInfo)obj;
        return this.getName().equals(stackInfo.getName()) && this.getVersion().equals(stackInfo.getVersion());
    }

    public StackVersionResponse convertToResponse() {
        Collection<ServiceInfo> serviceInfos = this.getServices();
        HashSet<File> serviceDescriptorFiles = new HashSet<File>();
        if (serviceInfos != null) {
            for (ServiceInfo serviceInfo : serviceInfos) {
                File file = serviceInfo.getKerberosDescriptorFile();
                if (file == null) continue;
                serviceDescriptorFiles.add(file);
            }
        }
        return new StackVersionResponse(this.getVersion(), this.isActive(), this.getParentStackVersion(), this.getConfigTypeAttributes(), serviceDescriptorFiles, null == this.upgradePacks ? Collections.emptySet() : this.upgradePacks.keySet(), this.isValid(), this.getErrors(), this.getMinJdk(), this.getMaxJdk());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getParentStackVersion() {
        return this.parentStackVersion;
    }

    public void setParentStackVersion(String parentStackVersion) {
        this.parentStackVersion = parentStackVersion;
    }

    public StackRoleCommandOrder getRoleCommandOrder() {
        return this.roleCommandOrder;
    }

    public void setRoleCommandOrder(StackRoleCommandOrder roleCommandOrder) {
        this.roleCommandOrder = roleCommandOrder;
    }

    public String getRcoFileLocation() {
        return this.rcoFileLocation;
    }

    public void setRcoFileLocation(String rcoFileLocation) {
        this.rcoFileLocation = rcoFileLocation;
    }

    public String getKerberosDescriptorPreConfigurationFileLocation() {
        return this.kerberosDescriptorPreConfigurationFileLocation;
    }

    public void setKerberosDescriptorPreConfigurationFileLocation(String kerberosDescriptorPreConfigurationFileLocation) {
        this.kerberosDescriptorPreConfigurationFileLocation = kerberosDescriptorPreConfigurationFileLocation;
    }

    public void setUpgradesFolder(String path) {
        this.upgradesFolder = path;
    }

    public String getUpgradesFolder() {
        return this.upgradesFolder;
    }

    public Map<String, UpgradePack> getUpgradePacks() {
        return this.upgradePacks;
    }

    public void setUpgradePacks(Map<String, UpgradePack> upgradePacks) {
        if (null != upgradePacks) {
            upgradePacks.values().forEach(pack -> pack.setOwnerStackId(new StackId(this)));
        }
        this.upgradePacks = upgradePacks;
    }

    public ConfigUpgradePack getConfigUpgradePack() {
        return this.configUpgradePack;
    }

    public void setConfigUpgradePack(ConfigUpgradePack configUpgradePack) {
        this.configUpgradePack = configUpgradePack;
    }

    @Override
    public int compareTo(StackInfo o) {
        if (this.name.equals(o.name)) {
            return VersionUtils.compareVersions((String)this.version, (String)o.version);
        }
        return this.name.compareTo(o.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyInfo> getRequiredProperties() {
        Map<String, PropertyInfo> result = this.requiredProperties;
        if (result == null) {
            StackInfo stackInfo = this;
            synchronized (stackInfo) {
                result = this.requiredProperties;
                if (result == null) {
                    this.requiredProperties = result = new HashMap<String, PropertyInfo>();
                    List<PropertyInfo> properties = this.getProperties();
                    for (PropertyInfo propertyInfo : properties) {
                        if (!propertyInfo.isRequireInput()) continue;
                        result.put(propertyInfo.getName(), propertyInfo);
                    }
                }
            }
        }
        return result;
    }

    public Map<PropertyInfo.PropertyType, Set<String>> getConfigPropertiesTypes(String configType) {
        if (!this.propertiesTypesCache.containsKey(configType)) {
            HashMap propertiesTypes = new HashMap();
            Collection<ServiceInfo> services = this.getServices();
            for (ServiceInfo serviceInfo : services) {
                for (PropertyInfo propertyInfo : serviceInfo.getProperties()) {
                    if (!propertyInfo.getFilename().contains(configType) || propertyInfo.getPropertyTypes().isEmpty()) continue;
                    Set<PropertyInfo.PropertyType> types = propertyInfo.getPropertyTypes();
                    for (PropertyInfo.PropertyType propertyType : types) {
                        if (!propertiesTypes.containsKey((Object)propertyType)) {
                            propertiesTypes.put(propertyType, new HashSet());
                        }
                        ((Set)propertiesTypes.get((Object)propertyType)).add(propertyInfo.getName());
                    }
                }
            }
            this.propertiesTypesCache.put(configType, propertiesTypes);
        }
        return this.propertiesTypesCache.get(configType);
    }

    public synchronized Map<String, Map<String, String>> getDefaultConfigAttributesForConfigType(String configType) {
        if (this.configPropertyAttributes == null) {
            this.configPropertyAttributes = this.getDefaultConfigAttributes();
        }
        if (this.configPropertyAttributes.containsKey(configType)) {
            return this.configPropertyAttributes.get(configType);
        }
        return null;
    }

    private Map<String, Map<String, Map<String, String>>> getDefaultConfigAttributes() {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>();
        for (ServiceInfo si : this.services) {
            for (PropertyInfo pi : si.getProperties()) {
                String propertyConfigType = Files.getNameWithoutExtension((String)pi.getFilename());
                String propertyName = pi.getName();
                String hidden = pi.getPropertyValueAttributes().getHidden();
                if (hidden == null) continue;
                if (!result.containsKey(propertyConfigType)) {
                    result.put(propertyConfigType, new HashMap());
                }
                if (!((Map)result.get(propertyConfigType)).containsKey("hidden")) {
                    ((Map)result.get(propertyConfigType)).put("hidden", new HashMap());
                }
                ((Map)((Map)result.get(propertyConfigType)).get("hidden")).put(propertyName, hidden);
            }
        }
        return result;
    }

    public void addVersionDefinition(String key, VersionDefinitionXml xml) {
        this.versionDefinitions.put(key, xml);
    }

    public Collection<VersionDefinitionXml> getVersionDefinitions() {
        return this.versionDefinitions.values();
    }

    public void setRepositoryXml(RepositoryXml rxml) {
        this.repoXml = rxml;
    }

    public RepositoryXml getRepositoryXml() {
        return this.repoXml;
    }

    public List<String> getRemovedServices() {
        return this.removedServices;
    }

    public void setRemovedServices(List<String> removedServices) {
        this.removedServices = removedServices;
    }

    public List<String> getServicesWithNoConfigs() {
        return this.servicesWithNoConfigs;
    }

    public void setServicesWithNoConfigs(List<String> servicesWithNoConfigs) {
        this.servicesWithNoConfigs = servicesWithNoConfigs;
    }

    public void setLatestVersionDefinition(VersionDefinitionXml xml) {
        this.latestVersion = xml;
    }

    public VersionDefinitionXml getLatestVersionDefinition() {
        return this.latestVersion;
    }

    public RefreshCommandConfiguration getRefreshCommandConfiguration() {
        return this.refreshCommandConfiguration;
    }

    public void setRefreshCommandConfiguration(RefreshCommandConfiguration refreshCommandConfiguration) {
        this.refreshCommandConfiguration = refreshCommandConfiguration;
    }

    public Set<String> getServiceNames() {
        return this.getServices().stream().map(ServiceInfo::getName).collect(Collectors.toSet());
    }

    public StackReleaseVersion getReleaseVersion() {
        if (StringUtils.isNotEmpty((CharSequence)this.releaseVersionClass)) {
            try {
                return (StackReleaseVersion)this.getLibraryInstance(this.releaseVersionClass);
            }
            catch (Exception e) {
                LOG.error("Could not create stack release instance.  Using default. {}", (Object)e.getMessage());
                return new DefaultStackVersion();
            }
        }
        return new DefaultStackVersion();
    }

    @Nullable
    public URLClassLoader getLibraryClassLoader() {
        return this.libraryClassLoader;
    }

    public void setLibraryClassLoader(URLClassLoader libraryClassLoader) {
        this.libraryClassLoader = libraryClassLoader;
    }

    public <T> T getLibraryInstance(String className) throws Exception {
        return this.getLibraryInstance(null, className);
    }

    public <T> T getLibraryInstance(Injector injector, String className) throws Exception {
        Class<?> clazz = null != this.libraryClassLoader ? this.libraryClassLoader.loadClass(className) : Class.forName(className);
        return (T)(null == injector ? clazz.newInstance() : injector.getInstance(clazz));
    }
}

