/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.utils.VersionUtils;

public class StackId
implements Comparable<StackId> {
    private static final String NAME_SEPARATOR = "-";
    private String stackName;
    private String stackVersion;

    public StackId() {
        this.stackName = "";
        this.stackVersion = "";
    }

    public StackId(String stackId) {
        this.parseStackIdHelper(this, stackId);
    }

    public StackId(StackInfo stackInfo) {
        this.stackName = stackInfo.getName();
        this.stackVersion = stackInfo.getVersion();
    }

    public StackId(String stackName, String stackVersion) {
        this(stackName + NAME_SEPARATOR + stackVersion);
    }

    public StackId(StackEntity stackEntity) {
        this(stackEntity.getStackName(), stackEntity.getStackVersion());
    }

    public String getStackName() {
        return this.stackName;
    }

    public String getStackVersion() {
        return this.stackVersion;
    }

    public String getStackId() {
        if (this.stackName.isEmpty() && this.stackVersion.isEmpty()) {
            return "";
        }
        return this.stackName + NAME_SEPARATOR + this.stackVersion;
    }

    public void setStackId(String stackId) {
        this.parseStackIdHelper(this, stackId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackId)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        StackId s = (StackId)object;
        return this.stackName.equals(s.stackName) && this.stackVersion.equals(s.stackVersion);
    }

    public int hashCode() {
        int result = this.stackName != null ? this.stackName.hashCode() : 0;
        result = 31 * result + (this.stackVersion != null ? this.stackVersion.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(StackId other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            throw new RuntimeException("Cannot compare with a null value.");
        }
        int returnValue = this.getStackName().compareTo(other.getStackName());
        if (returnValue != 0) {
            throw new RuntimeException("StackId with different names cannot be compared.");
        }
        returnValue = VersionUtils.compareVersions((String)this.getStackVersion(), (String)other.getStackVersion());
        return returnValue;
    }

    public String toString() {
        return this.getStackId();
    }

    private void parseStackIdHelper(StackId stackVersion, String stackId) {
        if (stackId == null || stackId.isEmpty()) {
            stackVersion.stackName = "";
            stackVersion.stackVersion = "";
            return;
        }
        int pos = stackId.indexOf(45);
        if (pos == -1 || stackId.length() <= pos + 1) {
            throw new RuntimeException("Could not parse invalid Stack Id, stackId=" + stackId);
        }
        stackVersion.stackName = stackId.substring(0, pos);
        stackVersion.stackVersion = stackId.substring(pos + 1);
    }
}

