/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.CredentialStoreInfo;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.LogDefinition;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.QuickLinksConfigurationInfo;
import id.onyx.obdp.server.state.ServiceLdapInfo;
import id.onyx.obdp.server.state.ServiceOsSpecific;
import id.onyx.obdp.server.state.ServicePropertyInfo;
import id.onyx.obdp.server.state.SingleSignOnInfo;
import id.onyx.obdp.server.state.ThemeInfo;
import id.onyx.obdp.server.state.stack.MetricDefinition;
import id.onyx.obdp.server.state.stack.StackRoleCommandOrder;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonFilter(value="propertiesfilter")
public class ServiceInfo
implements Validable {
    public static final AbstractMap.SimpleEntry<String, String> DEFAULT_SERVICE_INSTALLABLE_PROPERTY = new AbstractMap.SimpleEntry<String, String>("installable", "true");
    public static final AbstractMap.SimpleEntry<String, String> DEFAULT_SERVICE_MANAGED_PROPERTY = new AbstractMap.SimpleEntry<String, String>("managed", "true");
    public static final AbstractMap.SimpleEntry<String, String> DEFAULT_SERVICE_MONITORED_PROPERTY = new AbstractMap.SimpleEntry<String, String>("monitored", "true");
    public static final String HADOOP_COMPATIBLE_FS = "HCFS";
    @XmlTransient
    private String schemaVersion;
    private String name;
    private String displayName;
    private String version;
    private String comment;
    private String serviceType;
    private Selection selection;
    private String maintainer;
    @XmlElement(name="service_advisor_type")
    private ServiceAdvisorType serviceAdvisorType = ServiceAdvisorType.PYTHON;
    @XmlTransient
    private List<PropertyInfo> properties;
    @XmlElementWrapper(name="components")
    @XmlElements(value={@XmlElement(name="component")})
    private List<ComponentInfo> components;
    @XmlElement(name="deleted")
    private boolean isDeleted = false;
    @XmlElement(name="supportDeleteViaUI")
    private Boolean supportDeleteViaUIField;
    private boolean supportDeleteViaUIInternal = true;
    @JsonIgnore
    @XmlTransient
    private volatile Map<String, Set<String>> configLayout = null;
    @XmlElementWrapper(name="configuration-dependencies")
    @XmlElement(name="config-type")
    private List<String> configDependencies;
    @XmlElementWrapper(name="excluded-config-types")
    @XmlElement(name="config-type")
    private Set<String> excludedConfigTypes = new HashSet<String>();
    @XmlTransient
    private Map<String, Map<String, Map<String, String>>> configTypes;
    @JsonIgnore
    private Boolean monitoringService;
    @JsonIgnore
    @XmlElement(name="restartRequiredAfterChange")
    private Boolean restartRequiredAfterChange;
    @JsonIgnore
    @XmlElement(name="restartRequiredAfterRackChange")
    private Boolean restartRequiredAfterRackChange;
    @XmlElement(name="extends")
    private String parent;
    @XmlElement(name="widgetsFileName")
    private String widgetsFileName = "widgets.json";
    @XmlElement(name="metricsFileName")
    private String metricsFileName = "metrics.json";
    @XmlTransient
    private volatile Map<String, PropertyInfo> requiredProperties;
    @XmlElements(value={@XmlElement(name="credential-store")})
    private CredentialStoreInfo credentialStoreInfo;
    @XmlElement(name="kerberosEnabledTest")
    private String kerberosEnabledTest = null;
    @XmlElements(value={@XmlElement(name="sso")})
    private SingleSignOnInfo singleSignOnInfo;
    @XmlElements(value={@XmlElement(name="ldap")})
    private ServiceLdapInfo ldapInfo;
    @XmlTransient
    private File metricsFile = null;
    @XmlTransient
    private Map<String, Map<String, List<MetricDefinition>>> metrics = null;
    @XmlTransient
    private File advisorFile = null;
    @XmlTransient
    private String advisorName = null;
    @XmlTransient
    private File alertsFile = null;
    @XmlTransient
    private File kerberosDescriptorFile = null;
    @XmlTransient
    private File widgetsDescriptorFile = null;
    private StackRoleCommandOrder roleCommandOrder;
    @XmlTransient
    private boolean valid = true;
    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    private List<ServicePropertyInfo> servicePropertyList = Lists.newArrayList();
    @XmlTransient
    private Map<String, String> servicePropertyMap = ImmutableMap.copyOf(this.ensureMandatoryServiceProperties(Maps.newHashMap()));
    @XmlTransient
    private Set<String> errorSet = new HashSet<String>();
    @JsonIgnore
    @XmlElementWrapper(name="osSpecifics")
    @XmlElements(value={@XmlElement(name="osSpecific")})
    private List<ServiceOsSpecific> serviceOsSpecifics;
    @JsonIgnore
    @XmlElement(name="configuration-dir")
    private String configDir = "configuration";
    @JsonIgnore
    @XmlElement(name="themes-dir")
    private String themesDir = "themes";
    @JsonIgnore
    @XmlElementWrapper(name="themes")
    @XmlElements(value={@XmlElement(name="theme")})
    private List<ThemeInfo> themes;
    @XmlTransient
    private volatile Map<String, ThemeInfo> themesMap;
    @JsonIgnore
    @XmlElement(name="quickLinksConfigurations-dir")
    private String quickLinksConfigurationsDir = "quicklinks";
    @JsonIgnore
    @XmlElementWrapper(name="quickLinksConfigurations")
    @XmlElements(value={@XmlElement(name="quickLinksConfiguration")})
    private List<QuickLinksConfigurationInfo> quickLinksConfigurations;
    @XmlTransient
    private volatile Map<String, QuickLinksConfigurationInfo> quickLinksConfigurationsMap;
    private volatile Map<String, ServiceOsSpecific> serviceOsSpecificsMap;
    private CommandScriptDefinition commandScript;
    @XmlElementWrapper(name="customCommands")
    @XmlElements(value={@XmlElement(name="customCommand")})
    private List<CustomCommandDefinition> customCommands;
    @XmlElementWrapper(name="requiredServices")
    @XmlElement(name="service")
    private List<String> requiredServices = new ArrayList<String>();
    @XmlTransient
    private String servicePackageFolder;
    @XmlTransient
    private File serviceUpgradesFolder;
    @XmlTransient
    private File checksFolder;
    @XmlTransient
    private File serverActionsFolder;
    @XmlElement(name="rollingRestartSupported")
    private boolean rollingRestartSupported;

    public Boolean isRestartRequiredAfterChange() {
        return this.restartRequiredAfterChange;
    }

    public void setRestartRequiredAfterChange(Boolean restartRequiredAfterChange) {
        this.restartRequiredAfterChange = restartRequiredAfterChange;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public Boolean getSupportDeleteViaUIField() {
        return this.supportDeleteViaUIField;
    }

    public void setSupportDeleteViaUIField(Boolean supportDeleteViaUIField) {
        this.supportDeleteViaUIField = supportDeleteViaUIField;
    }

    public boolean isSupportDeleteViaUI() {
        if (null != this.supportDeleteViaUIField) {
            return this.supportDeleteViaUIField;
        }
        return this.supportDeleteViaUIInternal;
    }

    public void setSupportDeleteViaUI(boolean supportDeleteViaUI) {
        this.supportDeleteViaUIInternal = supportDeleteViaUI;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setServiceAdvisorType(ServiceAdvisorType type) {
        this.serviceAdvisorType = type;
    }

    public ServiceAdvisorType getServiceAdvisorType() {
        return this.serviceAdvisorType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Selection getSelection() {
        if (this.selection == null) {
            return Selection.DEFAULT;
        }
        return this.selection;
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
    }

    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public boolean isMaintainerEmpty() {
        return this.maintainer == null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getRequiredServices() {
        return this.requiredServices;
    }

    public String getWidgetsFileName() {
        return this.widgetsFileName;
    }

    public void setWidgetsFileName(String widgetsFileName) {
        this.widgetsFileName = widgetsFileName;
    }

    public String getMetricsFileName() {
        return this.metricsFileName;
    }

    public void setMetricsFileName(String metricsFileName) {
        this.metricsFileName = metricsFileName;
    }

    public void setRequiredServices(List<String> requiredServices) {
        this.requiredServices = requiredServices;
    }

    public List<PropertyInfo> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyInfo>();
        }
        return this.properties;
    }

    public void setProperties(List<PropertyInfo> properties) {
        this.properties = properties;
    }

    public List<ComponentInfo> getComponents() {
        if (this.components == null) {
            this.components = new ArrayList<ComponentInfo>();
        }
        return this.components;
    }

    public ComponentInfo getComponentByName(String componentName) {
        for (ComponentInfo componentInfo : this.getComponents()) {
            if (!componentInfo.getName().equals(componentName)) continue;
            return componentInfo;
        }
        return null;
    }

    public boolean isClientOnlyService() {
        if (this.components == null || this.components.isEmpty()) {
            return false;
        }
        for (ComponentInfo compInfo : this.components) {
            if (compInfo.isClient()) continue;
            return false;
        }
        return true;
    }

    public ComponentInfo getClientComponent() {
        ComponentInfo client = null;
        if (this.components != null) {
            for (ComponentInfo compInfo : this.components) {
                if (!compInfo.isClient()) continue;
                client = compInfo;
                break;
            }
        }
        return client;
    }

    public File getAdvisorFile() {
        return this.advisorFile;
    }

    public void setAdvisorFile(File advisorFile) {
        this.advisorFile = advisorFile;
    }

    public String getAdvisorName() {
        return this.advisorName;
    }

    public void setAdvisorName(String advisorName) {
        this.advisorName = advisorName;
    }

    public boolean isCredentialStoreSupported() {
        if (this.credentialStoreInfo != null && this.credentialStoreInfo.isSupported() != null) {
            return this.credentialStoreInfo.isSupported();
        }
        return false;
    }

    public void setCredentialStoreSupported(boolean credentialStoreSupported) {
        if (this.credentialStoreInfo == null) {
            this.credentialStoreInfo = new CredentialStoreInfo();
        }
        this.credentialStoreInfo.setSupported(credentialStoreSupported);
    }

    public boolean isCredentialStoreRequired() {
        if (this.credentialStoreInfo != null && this.credentialStoreInfo.isRequired() != null) {
            return this.credentialStoreInfo.isRequired();
        }
        return false;
    }

    public void setCredentialStoreRequired(boolean credentialStoreRequired) {
        if (this.credentialStoreInfo == null) {
            this.credentialStoreInfo = new CredentialStoreInfo();
        }
        this.credentialStoreInfo.setRequired(credentialStoreRequired);
    }

    public boolean isCredentialStoreEnabled() {
        if (this.credentialStoreInfo != null && this.credentialStoreInfo.isEnabled() != null) {
            return this.credentialStoreInfo.isEnabled();
        }
        return false;
    }

    public void setCredentialStoreEnabled(boolean credentialStoreEnabled) {
        if (this.credentialStoreInfo == null) {
            this.credentialStoreInfo = new CredentialStoreInfo();
        }
        this.credentialStoreInfo.setEnabled(credentialStoreEnabled);
    }

    public CredentialStoreInfo getCredentialStoreInfo() {
        return this.credentialStoreInfo;
    }

    public void setCredentialStoreInfo(CredentialStoreInfo credentialStoreInfo) {
        this.credentialStoreInfo = credentialStoreInfo;
    }

    public String getKerberosEnabledTest() {
        return this.kerberosEnabledTest;
    }

    public void setKerberosEnabledTest(String kerberosEnabledTest) {
        this.kerberosEnabledTest = kerberosEnabledTest;
    }

    public SingleSignOnInfo getSingleSignOnInfo() {
        return this.singleSignOnInfo;
    }

    public void setSingleSignOnInfo(SingleSignOnInfo singleSignOnInfo) {
        this.singleSignOnInfo = singleSignOnInfo;
    }

    public boolean isSingleSignOnSupported() {
        return this.singleSignOnInfo != null && this.singleSignOnInfo.isSupported();
    }

    @Deprecated
    public String getSingleSignOnEnabledConfiguration() {
        return this.singleSignOnInfo != null ? this.singleSignOnInfo.getEnabledConfiguration() : null;
    }

    public String getSingleSignOnEnabledTest() {
        return this.singleSignOnInfo != null ? this.singleSignOnInfo.getSsoEnabledTest() : null;
    }

    public boolean isKerberosRequiredForSingleSignOnIntegration() {
        return this.singleSignOnInfo != null && this.singleSignOnInfo.isKerberosRequired();
    }

    public ServiceLdapInfo getLdapInfo() {
        return this.ldapInfo;
    }

    public void setLdapInfo(ServiceLdapInfo ldapInfo) {
        this.ldapInfo = ldapInfo;
    }

    public boolean isLdapSupported() {
        return this.ldapInfo != null && this.ldapInfo.isSupported();
    }

    public String getLdapEnabledTest() {
        return this.ldapInfo != null ? this.ldapInfo.getLdapEnabledTest() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Service name:");
        sb.append(this.name);
        sb.append("\nService type:");
        sb.append(this.serviceType);
        sb.append("\nversion:");
        sb.append(this.version);
        sb.append("\nKerberos enabled test:");
        sb.append(this.kerberosEnabledTest);
        sb.append("\ncomment:");
        sb.append(this.comment);
        for (ComponentInfo component : this.getComponents()) {
            sb.append("\n\n\nComponent:\n");
            sb.append("name=");
            sb.append(component.getName());
            sb.append("\tcategory=");
            sb.append(component.getCategory());
        }
        return sb.toString();
    }

    public synchronized Map<String, Map<String, Map<String, String>>> getConfigTypeAttributes() {
        Map<Object, Object> tmpConfigTypes = this.configTypes == null ? new HashMap() : this.configTypes;
        for (String excludedtype : this.excludedConfigTypes) {
            tmpConfigTypes.remove(excludedtype);
        }
        return Collections.unmodifiableMap(tmpConfigTypes);
    }

    public synchronized void setTypeAttributes(String type, Map<String, Map<String, String>> typeAttributes) {
        if (this.configTypes == null) {
            this.configTypes = new HashMap<String, Map<String, Map<String, String>>>();
        }
        this.configTypes.put(type, typeAttributes);
    }

    public synchronized void setAllConfigAttributes(Map<String, Map<String, Map<String, String>>> types) {
        this.configTypes = new HashMap<String, Map<String, Map<String, String>>>();
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : types.entrySet()) {
            this.setTypeAttributes(entry.getKey(), entry.getValue());
        }
    }

    public boolean hasConfigDependency(String type) {
        return this.configDependencies != null && this.configDependencies.contains(type);
    }

    public boolean hasConfigType(String type) {
        return this.configTypes != null && this.configTypes.containsKey(type) && !this.excludedConfigTypes.contains(type);
    }

    public boolean hasDependencyAndPropertyFor(String type, Collection<String> keyNames) {
        if (!this.hasConfigDependency(type)) {
            return false;
        }
        this.buildConfigLayout();
        Set<String> keys = this.configLayout.get(type);
        for (String staleCheck : keyNames) {
            if (keys == null || !keys.contains(staleCheck)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildConfigLayout() {
        if (null == this.configLayout) {
            ServiceInfo serviceInfo = this;
            synchronized (serviceInfo) {
                if (null == this.configLayout) {
                    this.configLayout = new HashMap<String, Set<String>>();
                    for (PropertyInfo pi : this.getProperties()) {
                        String type = pi.getFilename();
                        int idx = type.indexOf(".xml");
                        if (!this.configLayout.containsKey(type = type.substring(0, idx))) {
                            this.configLayout.put(type, new HashSet());
                        }
                        this.configLayout.get(type).add(pi.getName());
                    }
                }
            }
        }
    }

    public List<String> getConfigDependencies() {
        return this.configDependencies;
    }

    public List<String> getConfigDependenciesWithComponents() {
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.configDependencies != null) {
            retVal.addAll(this.configDependencies);
        }
        if (this.components != null) {
            for (ComponentInfo c : this.components) {
                if (c.getConfigDependencies() == null) continue;
                retVal.addAll(c.getConfigDependencies());
            }
        }
        return retVal.size() == 0 ? (this.configDependencies == null ? null : this.configDependencies) : retVal;
    }

    public void setConfigDependencies(List<String> configDependencies) {
        this.configDependencies = configDependencies;
    }

    public String getSchemaVersion() {
        if (this.schemaVersion == null) {
            return "2.0";
        }
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getServicePackageFolder() {
        return this.servicePackageFolder;
    }

    public void setServicePackageFolder(String servicePackageFolder) {
        this.servicePackageFolder = servicePackageFolder;
    }

    public File getServiceUpgradesFolder() {
        return this.serviceUpgradesFolder;
    }

    public void setServiceUpgradesFolder(File serviceUpgradesFolder) {
        this.serviceUpgradesFolder = serviceUpgradesFolder;
    }

    public File getChecksFolder() {
        return this.checksFolder;
    }

    public void setChecksFolder(File checksFolder) {
        this.checksFolder = checksFolder;
    }

    public File getServerActionsFolder() {
        return this.serverActionsFolder;
    }

    public void setServerActionsFolder(File serverActionsFolder) {
        this.serverActionsFolder = serverActionsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ServiceOsSpecific> getOsSpecifics() {
        if (this.serviceOsSpecificsMap == null) {
            ServiceInfo serviceInfo = this;
            synchronized (serviceInfo) {
                if (this.serviceOsSpecificsMap == null) {
                    TreeMap<String, ServiceOsSpecific> tmpMap = new TreeMap<String, ServiceOsSpecific>();
                    if (this.serviceOsSpecifics != null) {
                        for (ServiceOsSpecific osSpecific : this.serviceOsSpecifics) {
                            tmpMap.put(osSpecific.getOsFamily(), osSpecific);
                        }
                    }
                    this.serviceOsSpecificsMap = tmpMap;
                }
            }
        }
        return this.serviceOsSpecificsMap;
    }

    public void setOsSpecifics(Map<String, ServiceOsSpecific> serviceOsSpecificsMap) {
        this.serviceOsSpecificsMap = serviceOsSpecificsMap;
    }

    public List<CustomCommandDefinition> getCustomCommands() {
        if (this.customCommands == null) {
            this.customCommands = new ArrayList<CustomCommandDefinition>();
        }
        return this.customCommands;
    }

    public void setCustomCommands(List<CustomCommandDefinition> customCommands) {
        this.customCommands = customCommands;
    }

    public CommandScriptDefinition getCommandScript() {
        return this.commandScript;
    }

    public void setCommandScript(CommandScriptDefinition commandScript) {
        this.commandScript = commandScript;
    }

    public void setMetricsFile(File file) {
        this.metricsFile = file;
    }

    public File getMetricsFile() {
        return this.metricsFile;
    }

    public Map<String, Map<String, List<MetricDefinition>>> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Map<String, List<MetricDefinition>>> map) {
        this.metrics = map;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public Boolean isMonitoringService() {
        return this.monitoringService;
    }

    public void setMonitoringService(Boolean monitoringService) {
        this.monitoringService = monitoringService;
    }

    public void setAlertsFile(File file) {
        this.alertsFile = file;
    }

    public File getAlertsFile() {
        return this.alertsFile;
    }

    public void setKerberosDescriptorFile(File file) {
        this.kerberosDescriptorFile = file;
    }

    public File getKerberosDescriptorFile() {
        return this.kerberosDescriptorFile;
    }

    public boolean isRollingRestartSupported() {
        return this.rollingRestartSupported;
    }

    public void setRollingRestartSupported(boolean rollingRestartSupported) {
        this.rollingRestartSupported = rollingRestartSupported;
    }

    public File getWidgetsDescriptorFile() {
        return this.widgetsDescriptorFile;
    }

    public void setWidgetsDescriptorFile(File widgetsDescriptorFile) {
        this.widgetsDescriptorFile = widgetsDescriptorFile;
    }

    public StackRoleCommandOrder getRoleCommandOrder() {
        return this.roleCommandOrder;
    }

    public void setRoleCommandOrder(StackRoleCommandOrder roleCommandOrder) {
        this.roleCommandOrder = roleCommandOrder;
    }

    public Set<String> getExcludedConfigTypes() {
        return this.excludedConfigTypes;
    }

    public void setExcludedConfigTypes(Set<String> excludedConfigTypes) {
        this.excludedConfigTypes = excludedConfigTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyInfo> getRequiredProperties() {
        Map<String, PropertyInfo> result = this.requiredProperties;
        if (result == null) {
            ServiceInfo serviceInfo = this;
            synchronized (serviceInfo) {
                result = this.requiredProperties;
                if (result == null) {
                    this.requiredProperties = result = new HashMap<String, PropertyInfo>();
                    List<PropertyInfo> properties = this.getProperties();
                    for (PropertyInfo propertyInfo : properties) {
                        if (!propertyInfo.isRequireInput()) continue;
                        result.put(propertyInfo.getName(), propertyInfo);
                    }
                }
            }
        }
        return result;
    }

    public Boolean isRestartRequiredAfterRackChange() {
        return this.restartRequiredAfterRackChange;
    }

    public void setRestartRequiredAfterRackChange(Boolean restartRequiredAfterRackChange) {
        this.restartRequiredAfterRackChange = restartRequiredAfterRackChange;
    }

    public String getThemesDir() {
        return this.themesDir;
    }

    public void setThemesDir(String themesDir) {
        this.themesDir = themesDir;
    }

    public List<ThemeInfo> getThemes() {
        return this.themes;
    }

    public void setThemes(List<ThemeInfo> themes) {
        this.themes = themes;
    }

    public Map<String, ThemeInfo> getThemesMap() {
        if (this.themesMap == null) {
            TreeMap<String, ThemeInfo> tmp = new TreeMap<String, ThemeInfo>();
            if (this.themes != null) {
                for (ThemeInfo theme : this.themes) {
                    tmp.put(theme.getFileName(), theme);
                }
            }
            this.themesMap = tmp;
        }
        return this.themesMap;
    }

    public void setThemesMap(Map<String, ThemeInfo> themesMap) {
        this.themesMap = themesMap;
    }

    public String getQuickLinksConfigurationsDir() {
        return this.quickLinksConfigurationsDir;
    }

    public void setQuickLinksConfigurationsDir(String quickLinksConfigurationsDir) {
        this.quickLinksConfigurationsDir = quickLinksConfigurationsDir;
    }

    public List<QuickLinksConfigurationInfo> getQuickLinksConfigurations() {
        return this.quickLinksConfigurations;
    }

    public void setQuickLinksConfigurations(List<QuickLinksConfigurationInfo> quickLinksConfigurations) {
        this.quickLinksConfigurations = quickLinksConfigurations;
    }

    public Map<String, QuickLinksConfigurationInfo> getQuickLinksConfigurationsMap() {
        if (this.quickLinksConfigurationsMap == null) {
            TreeMap<String, QuickLinksConfigurationInfo> tmp = new TreeMap<String, QuickLinksConfigurationInfo>();
            if (this.quickLinksConfigurations != null) {
                for (QuickLinksConfigurationInfo quickLinksConfiguration : this.quickLinksConfigurations) {
                    tmp.put(quickLinksConfiguration.getFileName(), quickLinksConfiguration);
                }
            }
            this.quickLinksConfigurationsMap = tmp;
        }
        return this.quickLinksConfigurationsMap;
    }

    public void setQuickLinksConfigurationsMap(Map<String, QuickLinksConfigurationInfo> quickLinksConfigurationsMap) {
        this.quickLinksConfigurationsMap = quickLinksConfigurationsMap;
    }

    public List<ServicePropertyInfo> getServicePropertyList() {
        return this.servicePropertyList;
    }

    public void setServicePropertyList(List<ServicePropertyInfo> servicePropertyList) {
        this.servicePropertyList = servicePropertyList;
        this.afterServicePropertyListSet();
    }

    private void afterServicePropertyListSet() {
        this.validateServiceProperties();
        this.buildServiceProperties();
    }

    public Map<String, String> getServiceProperties() {
        return this.servicePropertyMap;
    }

    private void buildServiceProperties() {
        if (this.isValid()) {
            HashMap properties = Maps.newHashMap();
            for (ServicePropertyInfo property : this.getServicePropertyList()) {
                properties.put(property.getName(), property.getValue());
            }
            this.servicePropertyMap = ImmutableMap.copyOf(this.ensureMandatoryServiceProperties(properties));
        } else {
            this.servicePropertyMap = ImmutableMap.of();
        }
    }

    private Map<String, String> ensureMandatoryServiceProperties(Map<String, String> properties) {
        return this.ensureVisibilityServiceProperties(properties);
    }

    private Map<String, String> ensureVisibilityServiceProperties(Map<String, String> properties) {
        if (!properties.containsKey(DEFAULT_SERVICE_INSTALLABLE_PROPERTY.getKey())) {
            properties.put(DEFAULT_SERVICE_INSTALLABLE_PROPERTY.getKey(), DEFAULT_SERVICE_INSTALLABLE_PROPERTY.getValue());
        }
        if (!properties.containsKey(DEFAULT_SERVICE_MANAGED_PROPERTY.getKey())) {
            properties.put(DEFAULT_SERVICE_MANAGED_PROPERTY.getKey(), DEFAULT_SERVICE_MANAGED_PROPERTY.getValue());
        }
        if (!properties.containsKey(DEFAULT_SERVICE_MONITORED_PROPERTY.getKey())) {
            properties.put(DEFAULT_SERVICE_MONITORED_PROPERTY.getKey(), DEFAULT_SERVICE_MONITORED_PROPERTY.getValue());
        }
        return properties;
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.afterServicePropertyListSet();
    }

    private void validateServiceProperties() {
        ImmutableListMultimap servicePropsByName = Multimaps.index(this.getServicePropertyList(), (Function)new Function<ServicePropertyInfo, String>(){

            public String apply(ServicePropertyInfo servicePropertyInfo) {
                return servicePropertyInfo.getName();
            }
        });
        for (String propertyName : servicePropsByName.keySet()) {
            if (servicePropsByName.get((Object)propertyName).size() <= 1) continue;
            this.setValid(false);
            this.addError("Duplicate service property with name '" + propertyName + "' found in " + this.getName() + ":" + this.getVersion() + " service definition !");
        }
        for (ComponentInfo component : this.getComponents()) {
            int primaryLogs = 0;
            for (LogDefinition log : component.getLogs()) {
                primaryLogs += log.isPrimary() ? 1 : 0;
            }
            if (primaryLogs <= true) continue;
            this.setValid(false);
            this.addError("More than one primary log exists for the component " + component.getName());
        }
        if (this.credentialStoreInfo != null) {
            if (this.credentialStoreInfo.isSupported() != null && this.credentialStoreInfo.isEnabled() != null && !this.credentialStoreInfo.isSupported().booleanValue() && this.credentialStoreInfo.isEnabled().booleanValue()) {
                this.setValid(false);
                this.addError("Credential store cannot be enabled for service " + this.getName() + " as it does not support it.");
            }
            if (this.credentialStoreInfo.isSupported() == null) {
                this.setValid(false);
                this.addError("Credential store supported is not specified for service " + this.getName());
            }
            if (this.credentialStoreInfo.isEnabled() == null) {
                this.setValid(false);
                this.addError("Credential store enabled is not specified for service " + this.getName());
            }
        }
        if (this.singleSignOnInfo != null && this.singleSignOnInfo.isSupported() && StringUtils.isEmpty((String)this.singleSignOnInfo.getSsoEnabledTest()) && StringUtils.isEmpty((String)this.singleSignOnInfo.getEnabledConfiguration())) {
            this.setValid(false);
            this.addError("Single Sign-on support is indicated for service " + this.getName() + " but no test configuration has been set (enabledConfiguration or ssoEnabledTest).");
        }
        if (this.ldapInfo != null && this.ldapInfo.isSupported() && StringUtils.isBlank((String)this.ldapInfo.getLdapEnabledTest())) {
            this.setValid(false);
            this.addError("LDAP support is indicated for service " + this.getName() + " but no test configuration has been set by ldapEnabledTest.");
        }
    }

    public boolean isVersionAdvertised() {
        if (null == this.components) {
            return false;
        }
        for (ComponentInfo componentInfo : this.components) {
            if (!componentInfo.isVersionAdvertised()) continue;
            return true;
        }
        return false;
    }

    @XmlEnum
    public static enum ServiceAdvisorType {
        PYTHON,
        JAVA;

    }

    public static enum Selection {
        DEFAULT,
        TECH_PREVIEW,
        MANDATORY,
        DEPRECATED;

    }
}

