/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.collections.Predicate;
import id.onyx.obdp.server.collections.PredicateUtils;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceResponse;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.controller.internal.OBDPServerLDAPConfigurationHandler;
import id.onyx.obdp.server.controller.internal.OBDPServerSSOConfigurationHandler;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.ServiceCredentialStoreUpdateEvent;
import id.onyx.obdp.server.events.ServiceInstalledEvent;
import id.onyx.obdp.server.events.ServiceRemovedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ClusterServiceDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.dao.ServiceDesiredStateDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntityPK;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntityPK;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentFactory;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
implements Service {
    private final Lock lock = new ReentrantLock();
    private ServiceDesiredStateEntityPK serviceDesiredStateEntityPK;
    private ClusterServiceEntityPK serviceEntityPK;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceImpl.class);
    private final Cluster cluster;
    private final ConcurrentMap<String, ServiceComponent> components = new ConcurrentHashMap<String, ServiceComponent>();
    private boolean isClientOnlyService;
    private boolean isCredentialStoreSupported;
    private boolean isCredentialStoreRequired;
    private final boolean ssoIntegrationSupported;
    private final Predicate ssoEnabledTest;
    private final boolean ldapIntegrationSupported;
    private final Predicate ldapEnabledTest;
    private final boolean ssoRequiresKerberos;
    private final Predicate kerberosEnabledTest;
    private OBDPMetaInfo obdpMetaInfo;
    private AtomicReference<MaintenanceState> maintenanceState = new AtomicReference();
    @Inject
    private ServiceConfigDAO serviceConfigDAO;
    @Inject
    private OBDPManagementController ambariManagementController;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private OBDPServerSSOConfigurationHandler ambariServerSSOConfigurationHandler;
    @Inject
    private OBDPServerLDAPConfigurationHandler ambariServerLDAPConfigurationHandler;
    private final ClusterServiceDAO clusterServiceDAO;
    private final ServiceDesiredStateDAO serviceDesiredStateDAO;
    private final ClusterDAO clusterDAO;
    private final ServiceComponentFactory serviceComponentFactory;
    private final OBDPEventPublisher eventPublisher;
    private final String serviceName;
    private final String displayName;

    @AssistedInject
    ServiceImpl(@Assisted Cluster cluster, @Assisted String serviceName, @Assisted RepositoryVersionEntity desiredRepositoryVersion, ClusterDAO clusterDAO, ClusterServiceDAO clusterServiceDAO, ServiceDesiredStateDAO serviceDesiredStateDAO, ServiceComponentFactory serviceComponentFactory, OBDPMetaInfo obdpMetaInfo, OBDPEventPublisher eventPublisher) throws OBDPException {
        this.cluster = cluster;
        this.clusterDAO = clusterDAO;
        this.clusterServiceDAO = clusterServiceDAO;
        this.serviceDesiredStateDAO = serviceDesiredStateDAO;
        this.serviceComponentFactory = serviceComponentFactory;
        this.eventPublisher = eventPublisher;
        this.serviceName = serviceName;
        this.obdpMetaInfo = obdpMetaInfo;
        ClusterServiceEntity serviceEntity = new ClusterServiceEntity();
        serviceEntity.setClusterId(cluster.getClusterId());
        serviceEntity.setServiceName(serviceName);
        ServiceDesiredStateEntity serviceDesiredStateEntity = new ServiceDesiredStateEntity();
        serviceDesiredStateEntity.setServiceName(serviceName);
        serviceDesiredStateEntity.setClusterId(cluster.getClusterId());
        serviceDesiredStateEntity.setDesiredRepositoryVersion(desiredRepositoryVersion);
        this.serviceDesiredStateEntityPK = this.getServiceDesiredStateEntityPK(serviceDesiredStateEntity);
        this.serviceEntityPK = this.getServiceEntityPK(serviceEntity);
        serviceDesiredStateEntity.setClusterServiceEntity(serviceEntity);
        serviceEntity.setServiceDesiredStateEntity(serviceDesiredStateEntity);
        StackId stackId = desiredRepositoryVersion.getStackId();
        ServiceInfo sInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        this.displayName = sInfo.getDisplayName();
        this.isClientOnlyService = sInfo.isClientOnlyService();
        this.isCredentialStoreSupported = sInfo.isCredentialStoreSupported();
        this.isCredentialStoreRequired = sInfo.isCredentialStoreRequired();
        this.ssoIntegrationSupported = sInfo.isSingleSignOnSupported();
        this.ssoEnabledTest = this.compileSsoEnabledPredicate(sInfo);
        this.ssoRequiresKerberos = sInfo.isKerberosRequiredForSingleSignOnIntegration();
        this.kerberosEnabledTest = this.compileKerberosEnabledPredicate(sInfo);
        if (this.ssoIntegrationSupported && this.ssoRequiresKerberos && this.kerberosEnabledTest == null) {
            LOG.warn("The service, {}, requires Kerberos to be enabled for SSO integration support; however, the kerberosEnabledTest specification has not been specified in the metainfo.xml file. Automated SSO integration will not be allowed for this service.", (Object)serviceName);
        }
        this.ldapIntegrationSupported = sInfo.isLdapSupported();
        this.ldapEnabledTest = StringUtils.isNotBlank((String)sInfo.getLdapEnabledTest()) ? PredicateUtils.fromJSON(sInfo.getLdapEnabledTest()) : null;
        this.persist(serviceEntity);
    }

    @AssistedInject
    ServiceImpl(@Assisted Cluster cluster, @Assisted ClusterServiceEntity serviceEntity, ClusterDAO clusterDAO, ClusterServiceDAO clusterServiceDAO, ServiceDesiredStateDAO serviceDesiredStateDAO, ServiceComponentFactory serviceComponentFactory, OBDPMetaInfo obdpMetaInfo, OBDPEventPublisher eventPublisher) throws OBDPException {
        this.cluster = cluster;
        this.clusterDAO = clusterDAO;
        this.clusterServiceDAO = clusterServiceDAO;
        this.serviceDesiredStateDAO = serviceDesiredStateDAO;
        this.serviceComponentFactory = serviceComponentFactory;
        this.eventPublisher = eventPublisher;
        this.serviceName = serviceEntity.getServiceName();
        this.obdpMetaInfo = obdpMetaInfo;
        ServiceDesiredStateEntity serviceDesiredStateEntity = serviceEntity.getServiceDesiredStateEntity();
        this.serviceDesiredStateEntityPK = this.getServiceDesiredStateEntityPK(serviceDesiredStateEntity);
        this.serviceEntityPK = this.getServiceEntityPK(serviceEntity);
        if (!serviceEntity.getServiceComponentDesiredStateEntities().isEmpty()) {
            for (ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity : serviceEntity.getServiceComponentDesiredStateEntities()) {
                try {
                    this.components.put(serviceComponentDesiredStateEntity.getComponentName(), serviceComponentFactory.createExisting(this, serviceComponentDesiredStateEntity));
                }
                catch (ProvisionException ex) {
                    StackId stackId = new StackId(serviceComponentDesiredStateEntity.getDesiredStack());
                    LOG.error(String.format("Can not get component info: stackName=%s, stackVersion=%s, serviceName=%s, componentName=%s", stackId.getStackName(), stackId.getStackVersion(), serviceEntity.getServiceName(), serviceComponentDesiredStateEntity.getComponentName()));
                    ex.printStackTrace();
                }
            }
        }
        StackId stackId = this.getDesiredStackId();
        ServiceInfo sInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), this.getName());
        this.isClientOnlyService = sInfo.isClientOnlyService();
        this.isCredentialStoreSupported = sInfo.isCredentialStoreSupported();
        this.isCredentialStoreRequired = sInfo.isCredentialStoreRequired();
        this.displayName = sInfo.getDisplayName();
        this.ssoIntegrationSupported = sInfo.isSingleSignOnSupported();
        this.ssoEnabledTest = this.compileSsoEnabledPredicate(sInfo);
        this.ssoRequiresKerberos = sInfo.isKerberosRequiredForSingleSignOnIntegration();
        this.kerberosEnabledTest = this.compileKerberosEnabledPredicate(sInfo);
        if (this.ssoIntegrationSupported && this.ssoRequiresKerberos && this.kerberosEnabledTest == null) {
            LOG.warn("The service, {}, requires Kerberos to be enabled for SSO integration support; however, the kerberosEnabledTest specification has not been specified in the metainfo.xml file. Automated SSO integration will not be allowed for this service.", (Object)this.serviceName);
        }
        this.ldapIntegrationSupported = sInfo.isLdapSupported();
        this.ldapEnabledTest = StringUtils.isNotBlank((String)sInfo.getLdapEnabledTest()) ? PredicateUtils.fromJSON(sInfo.getLdapEnabledTest()) : null;
    }

    @Override
    public void updateServiceInfo() throws OBDPException {
        try {
            ServiceInfo serviceInfo = this.obdpMetaInfo.getService(this);
            this.isClientOnlyService = serviceInfo.isClientOnlyService();
            this.isCredentialStoreSupported = serviceInfo.isCredentialStoreSupported();
            this.isCredentialStoreRequired = serviceInfo.isCredentialStoreRequired();
        }
        catch (ObjectNotFoundException e) {
            throw new RuntimeException("Trying to create a ServiceInfo not recognized in stack info, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName() + ", stackInfo=" + this.getDesiredStackId().getStackName());
        }
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.isBlank((String)this.displayName) ? this.serviceName : this.displayName;
    }

    @Override
    public long getClusterId() {
        return this.cluster.getClusterId();
    }

    @Override
    public Map<String, ServiceComponent> getServiceComponents() {
        return new HashMap<String, ServiceComponent>(this.components);
    }

    @Override
    public Set<String> getServiceHosts() {
        HashSet<String> hostNames = new HashSet<String>();
        for (ServiceComponent serviceComponent : this.getServiceComponents().values()) {
            hostNames.addAll(serviceComponent.getServiceComponentsHosts());
        }
        return hostNames;
    }

    @Override
    public void addServiceComponents(Map<String, ServiceComponent> components) throws OBDPException {
        for (ServiceComponent sc : components.values()) {
            this.addServiceComponent(sc);
        }
    }

    @Override
    public void addServiceComponent(ServiceComponent component) throws OBDPException {
        if (this.components.containsKey(component.getName())) {
            throw new OBDPException("Cannot add duplicate ServiceComponent, clusterName=" + this.cluster.getClusterName() + ", clusterId=" + this.cluster.getClusterId() + ", serviceName=" + this.getName() + ", serviceComponentName=" + component.getName());
        }
        this.components.put(component.getName(), component);
    }

    @Override
    public ServiceComponent addServiceComponent(String serviceComponentName) throws OBDPException {
        ServiceComponent component = this.serviceComponentFactory.createNew(this, serviceComponentName);
        this.addServiceComponent(component);
        return component;
    }

    @Override
    public ServiceComponent getServiceComponent(String componentName) throws OBDPException {
        ServiceComponent serviceComponent = (ServiceComponent)this.components.get(componentName);
        if (null == serviceComponent) {
            throw new ServiceComponentNotFoundException(this.cluster.getClusterName(), this.getName(), componentName);
        }
        return serviceComponent;
    }

    @Override
    public State getDesiredState() {
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        return serviceDesiredStateEntity.getDesiredState();
    }

    @Override
    public void setDesiredState(State state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting DesiredState of Service, clusterName={}, clusterId={}, serviceName={}, oldDesiredState={}, newDesiredState={}", new Object[]{this.cluster.getClusterName(), this.cluster.getClusterId(), this.getName(), this.getDesiredState(), state});
        }
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        serviceDesiredStateEntity.setDesiredState(state);
        this.serviceDesiredStateDAO.merge(serviceDesiredStateEntity);
    }

    @Override
    public StackId getDesiredStackId() {
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        if (null == serviceDesiredStateEntity) {
            return null;
        }
        StackEntity desiredStackEntity = serviceDesiredStateEntity.getDesiredStack();
        return new StackId(desiredStackEntity);
    }

    @Override
    public RepositoryVersionEntity getDesiredRepositoryVersion() {
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        return serviceDesiredStateEntity.getDesiredRepositoryVersion();
    }

    @Override
    @Transactional
    public void setDesiredRepositoryVersion(RepositoryVersionEntity repositoryVersionEntity) {
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        serviceDesiredStateEntity.setDesiredRepositoryVersion(repositoryVersionEntity);
        this.serviceDesiredStateDAO.merge(serviceDesiredStateEntity);
        Collection<ServiceComponent> components = this.getServiceComponents().values();
        for (ServiceComponent component : components) {
            component.setDesiredRepositoryVersion(repositoryVersionEntity);
        }
    }

    @Override
    public RepositoryVersionState getRepositoryState() {
        if (this.components.isEmpty()) {
            return RepositoryVersionState.NOT_REQUIRED;
        }
        ArrayList<RepositoryVersionState> states = new ArrayList<RepositoryVersionState>();
        for (ServiceComponent component : this.components.values()) {
            states.add(component.getRepositoryState());
        }
        return RepositoryVersionState.getAggregateState(states);
    }

    @Override
    public ServiceResponse convertToResponse() {
        Map<String, Map<String, String>> existingConfigurations;
        RepositoryVersionEntity desiredRespositoryVersion = this.getDesiredRepositoryVersion();
        StackId desiredStackId = desiredRespositoryVersion.getStackId();
        try {
            existingConfigurations = this.configHelper.calculateExistingConfigurations(this.ambariManagementController, this.cluster);
        }
        catch (OBDPException e) {
            LOG.warn("Failed to get the existing configurations for the cluster.  Predicate calculations may not be correct due to missing data.");
            existingConfigurations = Collections.emptyMap();
        }
        ServiceResponse r = new ServiceResponse(this.cluster.getClusterId(), this.cluster.getClusterName(), this.getName(), desiredStackId, desiredRespositoryVersion.getVersion(), this.getRepositoryState(), this.getDesiredState().toString(), this.isCredentialStoreSupported(), this.isCredentialStoreEnabled(), this.ssoIntegrationSupported, this.isSsoIntegrationDesired(), this.isSsoIntegrationEnabled(existingConfigurations), this.isKerberosRequiredForSsoIntegration(), this.isKerberosEnabled(existingConfigurations), this.ldapIntegrationSupported, this.isLdapIntegrationEnabeled(existingConfigurations), this.isLdapIntegrationDesired());
        r.setDesiredRepositoryVersionId(desiredRespositoryVersion.getId());
        r.setMaintenanceState(this.getMaintenanceState().name());
        return r;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isCredentialStoreSupported() {
        return this.isCredentialStoreSupported;
    }

    @Override
    public boolean isCredentialStoreRequired() {
        return this.isCredentialStoreRequired;
    }

    @Override
    public boolean isCredentialStoreEnabled() {
        ServiceDesiredStateEntity desiredStateEntity = this.getServiceDesiredStateEntity();
        if (desiredStateEntity != null) {
            return desiredStateEntity.isCredentialStoreEnabled();
        }
        LOG.warn("Trying to fetch a member from an entity object that may have been previously deleted, serviceName = " + this.getName());
        return false;
    }

    @Override
    public void setCredentialStoreEnabled(boolean credentialStoreEnabled) {
        ServiceDesiredStateEntity desiredStateEntity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting CredentialStoreEnabled of Service, clusterName={}, clusterId={}, serviceName={}, oldCredentialStoreEnabled={}, newCredentialStoreEnabled={}", new Object[]{this.cluster.getClusterName(), this.cluster.getClusterId(), this.getName(), this.isCredentialStoreEnabled(), credentialStoreEnabled});
        }
        if ((desiredStateEntity = this.getServiceDesiredStateEntity()) != null) {
            ServiceCredentialStoreUpdateEvent serviceCredentialStoreUpdateEvent = null;
            if (desiredStateEntity.isCredentialStoreEnabled() != credentialStoreEnabled) {
                StackId stackId = this.getDesiredStackId();
                serviceCredentialStoreUpdateEvent = new ServiceCredentialStoreUpdateEvent(this.getClusterId(), stackId.getStackName(), stackId.getStackVersion(), this.getName());
            }
            desiredStateEntity.setCredentialStoreEnabled(credentialStoreEnabled);
            desiredStateEntity = this.serviceDesiredStateDAO.merge(desiredStateEntity);
            if (serviceCredentialStoreUpdateEvent != null) {
                this.eventPublisher.publish(serviceCredentialStoreUpdateEvent);
            }
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.getName());
        }
    }

    @Override
    public void debugDump(StringBuilder sb) {
        sb.append("Service={ serviceName=").append(this.getName()).append(", clusterName=").append(this.cluster.getClusterName()).append(", clusterId=").append(this.cluster.getClusterId()).append(", desiredStackVersion=").append(this.getDesiredStackId()).append(", desiredState=").append((Object)this.getDesiredState()).append(", components=[ ");
        boolean first = true;
        for (ServiceComponent sc : this.components.values()) {
            if (!first) {
                sb.append(" , ");
            }
            first = false;
            sb.append("\n      ");
            sc.debugDump(sb);
            sb.append(" ");
        }
        sb.append(" ] }");
    }

    private void persist(ClusterServiceEntity serviceEntity) {
        this.persistEntities(serviceEntity);
        StackId stackId = this.getDesiredStackId();
        this.cluster.addService(this);
        ServiceInstalledEvent event = new ServiceInstalledEvent(this.getClusterId(), stackId.getStackName(), stackId.getStackVersion(), this.getName());
        this.eventPublisher.publish(event);
    }

    @Transactional
    void persistEntities(ClusterServiceEntity serviceEntity) {
        long clusterId = this.cluster.getClusterId();
        ClusterEntity clusterEntity = this.clusterDAO.findById(clusterId);
        serviceEntity.setClusterEntity(clusterEntity);
        this.clusterServiceDAO.create(serviceEntity);
        clusterEntity.getClusterServiceEntities().add(serviceEntity);
        this.clusterDAO.merge(clusterEntity);
        this.clusterServiceDAO.merge(serviceEntity);
    }

    @Override
    public boolean canBeRemoved() {
        for (ServiceComponent sc : this.components.values()) {
            if (sc.canBeRemoved()) continue;
            LOG.warn("Found non removable component when trying to delete service, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName() + ", componentName=" + sc.getName());
            return false;
        }
        return true;
    }

    @Transactional
    void deleteAllServiceConfigs() throws OBDPException {
        long clusterId = this.getClusterId();
        ServiceConfigEntity lastServiceConfigEntity = this.serviceConfigDAO.findMaxVersion(clusterId, this.getName());
        if (lastServiceConfigEntity != null) {
            for (ClusterConfigEntity serviceConfigEntity : lastServiceConfigEntity.getClusterConfigEntities()) {
                LOG.info("Disabling and unmapping configuration {}", (Object)serviceConfigEntity);
                serviceConfigEntity.setSelected(false);
                serviceConfigEntity.setUnmapped(true);
                this.clusterDAO.merge(serviceConfigEntity);
            }
        }
        LOG.info("Deleting all configuration associations for {} on cluster {}", (Object)this.getName(), (Object)this.cluster.getClusterName());
        List<ServiceConfigEntity> serviceConfigEntities = this.serviceConfigDAO.findByService(this.cluster.getClusterId(), this.getName());
        for (ServiceConfigEntity serviceConfigEntity : serviceConfigEntities) {
            for (ClusterConfigEntity clusterConfigEntity : serviceConfigEntity.getClusterConfigEntities()) {
                if (clusterConfigEntity.isUnmapped()) continue;
                LOG.info("Unmapping configuration {}", (Object)clusterConfigEntity);
                clusterConfigEntity.setUnmapped(true);
                this.clusterDAO.merge(clusterConfigEntity);
            }
            this.serviceConfigDAO.remove(serviceConfigEntity);
        }
    }

    void deleteAllServiceConfigGroups() throws OBDPException {
        for (Long configGroupId : this.cluster.getConfigGroupsByServiceName(this.serviceName).keySet()) {
            this.cluster.deleteConfigGroup(configGroupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void deleteAllComponents(DeleteHostComponentStatusMetaData deleteMetaData) {
        this.lock.lock();
        try {
            LOG.info("Deleting all components for service, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName());
            for (ServiceComponent component : this.components.values()) {
                if (component.canBeRemoved()) continue;
                deleteMetaData.setAmbariException(new OBDPException("Found non removable component when trying to delete all components from service, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName() + ", componentName=" + component.getName()));
                return;
            }
            for (ServiceComponent serviceComponent : this.components.values()) {
                serviceComponent.delete(deleteMetaData);
                if (deleteMetaData.getAmbariException() == null) continue;
                return;
            }
            this.components.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteServiceComponent(String componentName, DeleteHostComponentStatusMetaData deleteMetaData) throws OBDPException {
        this.lock.lock();
        try {
            ServiceComponent component = this.getServiceComponent(componentName);
            LOG.info("Deleting servicecomponent for cluster, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName() + ", componentName=" + componentName);
            if (!component.canBeRemoved()) {
                throw new OBDPException("Could not delete component from cluster, clusterName=" + this.cluster.getClusterName() + ", serviceName=" + this.getName() + ", componentName=" + componentName);
            }
            component.delete(deleteMetaData);
            this.components.remove(componentName);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isClientOnlyService() {
        return this.isClientOnlyService;
    }

    @Override
    @Transactional
    public void delete(DeleteHostComponentStatusMetaData deleteMetaData) {
        List<Component> components = this.getComponents();
        this.deleteAllComponents(deleteMetaData);
        if (deleteMetaData.getAmbariException() != null) {
            return;
        }
        StackId stackId = this.getDesiredStackId();
        try {
            this.deleteAllServiceConfigs();
            this.deleteAllServiceConfigGroups();
            this.removeEntities();
        }
        catch (OBDPException e) {
            deleteMetaData.setAmbariException(e);
            return;
        }
        if (null == stackId) {
            return;
        }
        ServiceRemovedEvent event = new ServiceRemovedEvent(this.getClusterId(), stackId.getStackName(), stackId.getStackVersion(), this.getName(), components);
        this.eventPublisher.publish(event);
    }

    private List<Component> getComponents() {
        ArrayList<Component> result = new ArrayList<Component>();
        for (ServiceComponent component : this.getServiceComponents().values()) {
            for (ServiceComponentHost host : component.getServiceComponentHosts().values()) {
                result.add(new Component(host.getHostName(), this.getName(), component.getName(), host.getHost().getHostId()));
            }
        }
        return result;
    }

    @Transactional
    protected void removeEntities() throws OBDPException {
        this.serviceDesiredStateDAO.removeByPK(this.serviceDesiredStateEntityPK);
        this.clusterServiceDAO.removeByPK(this.serviceEntityPK);
    }

    @Override
    public void setMaintenanceState(MaintenanceState state) {
        ServiceDesiredStateEntity serviceDesiredStateEntity = this.getServiceDesiredStateEntity();
        serviceDesiredStateEntity.setMaintenanceState(state);
        this.maintenanceState.set(this.serviceDesiredStateDAO.merge(serviceDesiredStateEntity).getMaintenanceState());
        MaintenanceModeEvent event = new MaintenanceModeEvent(state, this);
        this.eventPublisher.publish(event);
    }

    @Override
    public MaintenanceState getMaintenanceState() {
        if (this.maintenanceState.get() == null) {
            this.maintenanceState.set(this.getServiceDesiredStateEntity().getMaintenanceState());
        }
        return this.maintenanceState.get();
    }

    @Override
    public boolean isKerberosEnabled() {
        if (this.kerberosEnabledTest != null) {
            Map<String, Map<String, String>> existingConfigurations;
            try {
                existingConfigurations = this.configHelper.calculateExistingConfigurations(this.ambariManagementController, this.cluster);
            }
            catch (OBDPException e) {
                LOG.warn("Failed to get the existing configurations for the cluster.  Predicate calculations may not be correct due to missing data.");
                existingConfigurations = Collections.emptyMap();
            }
            return this.isKerberosEnabled(existingConfigurations);
        }
        return false;
    }

    @Override
    public boolean isKerberosEnabled(Map<String, Map<String, String>> configurations) {
        return this.kerberosEnabledTest != null && this.kerberosEnabledTest.evaluate(configurations);
    }

    private ClusterServiceEntityPK getServiceEntityPK(ClusterServiceEntity serviceEntity) {
        ClusterServiceEntityPK pk = new ClusterServiceEntityPK();
        pk.setClusterId(serviceEntity.getClusterId());
        pk.setServiceName(serviceEntity.getServiceName());
        return pk;
    }

    private ServiceDesiredStateEntityPK getServiceDesiredStateEntityPK(ServiceDesiredStateEntity serviceDesiredStateEntity) {
        ServiceDesiredStateEntityPK pk = new ServiceDesiredStateEntityPK();
        pk.setClusterId(serviceDesiredStateEntity.getClusterId());
        pk.setServiceName(serviceDesiredStateEntity.getServiceName());
        return pk;
    }

    private ServiceDesiredStateEntity getServiceDesiredStateEntity() {
        return this.serviceDesiredStateDAO.findByPK(this.serviceDesiredStateEntityPK);
    }

    private Predicate compileSsoEnabledPredicate(ServiceInfo sInfo) {
        if (StringUtils.isNotBlank((String)sInfo.getSingleSignOnEnabledTest())) {
            if (StringUtils.isNotBlank((String)sInfo.getSingleSignOnEnabledConfiguration())) {
                LOG.warn("Both <ssoEnabledTest> and <enabledConfiguration> have been declared within <sso> for {}; using <ssoEnabledTest>", (Object)this.serviceName);
            }
            return PredicateUtils.fromJSON(sInfo.getSingleSignOnEnabledTest());
        }
        if (StringUtils.isNotBlank((String)sInfo.getSingleSignOnEnabledConfiguration())) {
            LOG.warn("Only <enabledConfiguration> have been declared  within <sso> for {}; converting its value to an equals predicate", (Object)this.serviceName);
            String equalsPredicateJson = "{\"equals\": [\"" + sInfo.getSingleSignOnEnabledConfiguration() + "\", \"true\"]}";
            return PredicateUtils.fromJSON(equalsPredicateJson);
        }
        return null;
    }

    private Predicate compileKerberosEnabledPredicate(ServiceInfo sInfo) {
        if (StringUtils.isNotBlank((String)sInfo.getKerberosEnabledTest())) {
            return PredicateUtils.fromJSON(sInfo.getKerberosEnabledTest());
        }
        return null;
    }

    private boolean isSsoIntegrationDesired() {
        return this.ambariServerSSOConfigurationHandler.getSSOEnabledServices().contains(this.serviceName);
    }

    private boolean isSsoIntegrationEnabled(Map<String, Map<String, String>> existingConfigurations) {
        return this.ssoIntegrationSupported && this.ssoEnabledTest != null && this.ssoEnabledTest.evaluate(existingConfigurations);
    }

    private boolean isKerberosRequiredForSsoIntegration() {
        return this.ssoRequiresKerberos;
    }

    private boolean isLdapIntegrationEnabeled(Map<String, Map<String, String>> existingConfigurations) {
        return this.ldapIntegrationSupported && this.ldapEnabledTest != null && this.ldapEnabledTest.evaluate(existingConfigurations);
    }

    private boolean isLdapIntegrationDesired() {
        return this.ambariServerLDAPConfigurationHandler.getLDAPEnabledServices().contains(this.serviceName);
    }
}

