/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@Singleton
public class ServiceComponentSupport {
    private final Provider<OBDPMetaInfo> metaInfo;

    @Inject
    public ServiceComponentSupport(Provider<OBDPMetaInfo> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public Set<String> unsupportedServices(Cluster cluster, String stackName, String stackVersion) {
        return cluster.getServices().keySet().stream().filter(serviceName -> !this.isServiceSupported((String)serviceName, stackName, stackVersion)).collect(Collectors.toSet());
    }

    public boolean isServiceSupported(String serviceName, String stackName, String stackVersion) {
        try {
            ServiceInfo service = ((OBDPMetaInfo)this.metaInfo.get()).getServices(stackName, stackVersion).get(serviceName);
            return service != null && !service.isDeleted();
        }
        catch (OBDPException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<ServiceComponent> unsupportedComponents(Cluster cluster, String stackName, String stackVersion) throws OBDPException {
        HashSet<ServiceComponent> unsupportedComponents = new HashSet<ServiceComponent>();
        for (Service service : cluster.getServices().values()) {
            for (ServiceComponent component : service.getServiceComponents().values()) {
                if (!component.isVersionAdvertised() || this.isComponentSupported(service.getName(), component.getName(), stackName, stackVersion)) continue;
                unsupportedComponents.add(component);
            }
        }
        return unsupportedComponents;
    }

    private boolean isComponentSupported(String serviceName, String componentName, String stackName, String stackVersion) throws OBDPException {
        try {
            ComponentInfo component = ((OBDPMetaInfo)this.metaInfo.get()).getComponent(stackName, stackVersion, serviceName, componentName);
            return !component.isDeleted();
        }
        catch (StackAccessException e) {
            return false;
        }
    }

    public Collection<String> allUnsupported(Cluster cluster, String stackName, String stackVersion) throws OBDPException {
        return CollectionUtils.union(this.unsupportedServices(cluster, stackName, stackVersion), this.names(this.unsupportedComponents(cluster, stackName, stackVersion)));
    }

    private Set<String> names(Set<ServiceComponent> serviceComponents) {
        return serviceComponents.stream().map(each -> each.getName()).collect(Collectors.toSet());
    }
}

