/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ServiceComponentHostNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.ServiceComponentResponse;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.events.ServiceComponentRecoveryChangedEvent;
import id.onyx.obdp.server.events.listeners.upgrade.StackVersionListener;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.ClusterServiceDAO;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.HostComponentStateDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.ServiceComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntityPK;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostFactory;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.cluster.ClusterImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceComponentImpl
implements ServiceComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceComponentImpl.class);
    private final Service service;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String componentName;
    private String displayName;
    private boolean isClientComponent;
    private boolean isMasterComponent;
    private boolean isVersionAdvertised;
    private final ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO;
    private final ClusterServiceDAO clusterServiceDAO;
    private final ServiceComponentHostFactory serviceComponentHostFactory;
    private final OBDPEventPublisher eventPublisher;
    private OBDPMetaInfo obdpMetaInfo;
    private final ConcurrentMap<String, ServiceComponentHost> hostComponents = new ConcurrentHashMap<String, ServiceComponentHost>();
    private final long desiredStateEntityId;
    @Inject
    private RepositoryVersionDAO repoVersionDAO;
    @Inject
    private HostComponentStateDAO hostComponentDAO;
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;

    @AssistedInject
    public ServiceComponentImpl(@Assisted Service service, @Assisted String componentName, OBDPMetaInfo obdpMetaInfo, ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO, ClusterServiceDAO clusterServiceDAO, ServiceComponentHostFactory serviceComponentHostFactory, OBDPEventPublisher eventPublisher) throws OBDPException {
        this.obdpMetaInfo = obdpMetaInfo;
        this.service = service;
        this.componentName = componentName;
        this.serviceComponentDesiredStateDAO = serviceComponentDesiredStateDAO;
        this.clusterServiceDAO = clusterServiceDAO;
        this.serviceComponentHostFactory = serviceComponentHostFactory;
        this.eventPublisher = eventPublisher;
        ServiceComponentDesiredStateEntity desiredStateEntity = new ServiceComponentDesiredStateEntity();
        desiredStateEntity.setComponentName(componentName);
        desiredStateEntity.setDesiredState(State.INIT);
        desiredStateEntity.setServiceName(service.getName());
        desiredStateEntity.setClusterId(service.getClusterId());
        desiredStateEntity.setRecoveryEnabled(false);
        desiredStateEntity.setDesiredRepositoryVersion(service.getDesiredRepositoryVersion());
        this.updateComponentInfo();
        this.persistEntities(desiredStateEntity);
        this.desiredStateEntityId = desiredStateEntity.getId();
    }

    @Override
    public void updateComponentInfo() throws OBDPException {
        StackId stackId = this.service.getDesiredStackId();
        try {
            ComponentInfo compInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), this.service.getName(), this.componentName);
            this.isClientComponent = compInfo.isClient();
            this.isMasterComponent = compInfo.isMaster();
            this.isVersionAdvertised = compInfo.isVersionAdvertised();
            this.displayName = compInfo.getDisplayName();
        }
        catch (ObjectNotFoundException e) {
            throw new RuntimeException("Trying to create a ServiceComponent not recognized in stack info, clusterName=" + this.service.getCluster().getClusterName() + ", serviceName=" + this.service.getName() + ", componentName=" + this.componentName + ", stackInfo=" + stackId.getStackId());
        }
    }

    @AssistedInject
    public ServiceComponentImpl(@Assisted Service service, @Assisted ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity, OBDPMetaInfo obdpMetaInfo, ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO, ClusterServiceDAO clusterServiceDAO, HostComponentDesiredStateDAO hostComponentDesiredStateDAO, ServiceComponentHostFactory serviceComponentHostFactory, OBDPEventPublisher eventPublisher) throws OBDPException {
        this.service = service;
        this.serviceComponentDesiredStateDAO = serviceComponentDesiredStateDAO;
        this.clusterServiceDAO = clusterServiceDAO;
        this.serviceComponentHostFactory = serviceComponentHostFactory;
        this.eventPublisher = eventPublisher;
        this.obdpMetaInfo = obdpMetaInfo;
        this.desiredStateEntityId = serviceComponentDesiredStateEntity.getId();
        this.componentName = serviceComponentDesiredStateEntity.getComponentName();
        this.updateComponentInfo();
        List<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities = hostComponentDesiredStateDAO.findByIndex(service.getClusterId(), service.getName(), serviceComponentDesiredStateEntity.getComponentName());
        Map mappedHostComponentDesiredStateEntitites = hostComponentDesiredStateEntities.stream().collect(Collectors.toMap(h -> h.getHostEntity().getHostName(), java.util.function.Function.identity()));
        for (HostComponentStateEntity hostComponentStateEntity : serviceComponentDesiredStateEntity.getHostComponentStateEntities()) {
            try {
                this.hostComponents.put(hostComponentStateEntity.getHostName(), serviceComponentHostFactory.createExisting(this, hostComponentStateEntity, (HostComponentDesiredStateEntity)mappedHostComponentDesiredStateEntitites.get(hostComponentStateEntity.getHostName())));
            }
            catch (ProvisionException ex) {
                StackId currentStackId = this.getDesiredStackId();
                LOG.error(String.format("Can not get host component info: stackName=%s, stackVersion=%s, serviceName=%s, componentName=%s, hostname=%s", currentStackId.getStackName(), currentStackId.getStackVersion(), service.getName(), serviceComponentDesiredStateEntity.getComponentName(), hostComponentStateEntity.getHostName()));
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public boolean isRecoveryEnabled() {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        if (desiredStateEntity != null) {
            return desiredStateEntity.isRecoveryEnabled();
        }
        LOG.warn("Trying to fetch a member from an entity object that may have been previously deleted, serviceName = " + this.service.getName() + ", componentName = " + this.componentName);
        return false;
    }

    @Override
    public void setRecoveryEnabled(boolean recoveryEnabled) {
        ServiceComponentDesiredStateEntity desiredStateEntity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting RecoveryEnabled of Component, clusterName={}, clusterId={}, serviceName={}, componentName={}, oldRecoveryEnabled={}, newRecoveryEnabled={}", new Object[]{this.service.getCluster().getClusterName(), this.service.getCluster().getClusterId(), this.service.getName(), this.getName(), this.isRecoveryEnabled(), recoveryEnabled});
        }
        if ((desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId)) != null) {
            desiredStateEntity.setRecoveryEnabled(recoveryEnabled);
            desiredStateEntity = this.serviceComponentDesiredStateDAO.merge(desiredStateEntity);
            ServiceComponentRecoveryChangedEvent event = new ServiceComponentRecoveryChangedEvent(this.getClusterId(), this.getClusterName(), this.getServiceName(), this.getName(), this.isRecoveryEnabled());
            this.eventPublisher.publish(event);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + this.service.getName());
        }
    }

    @Override
    public String getServiceName() {
        return this.service.getName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public long getClusterId() {
        return this.service.getClusterId();
    }

    @Override
    public Map<String, ServiceComponentHost> getServiceComponentHosts() {
        return new HashMap<String, ServiceComponentHost>(this.hostComponents);
    }

    @Override
    public Set<String> getServiceComponentsHosts() {
        HashSet<String> serviceComponentsHosts = new HashSet<String>();
        for (ServiceComponentHost serviceComponentHost : this.getServiceComponentHosts().values()) {
            serviceComponentsHosts.add(serviceComponentHost.getHostName());
        }
        return serviceComponentsHosts;
    }

    @Override
    public void addServiceComponentHosts(Map<String, ServiceComponentHost> hostComponents) throws OBDPException {
        for (Map.Entry<String, ServiceComponentHost> entry : hostComponents.entrySet()) {
            if (entry.getKey().equals(entry.getValue().getHostName())) continue;
            throw new OBDPException("Invalid arguments in map, hostname does not match the key in map");
        }
        for (ServiceComponentHost sch : hostComponents.values()) {
            this.addServiceComponentHost(sch);
        }
    }

    @Override
    public void addServiceComponentHost(ServiceComponentHost hostComponent) throws OBDPException {
        this.readWriteLock.writeLock().lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding a ServiceComponentHost to ServiceComponent, clusterName={}, clusterId={}, serviceName={}, serviceComponentName={}, hostname={}, recoveryEnabled={}", new Object[]{this.service.getCluster().getClusterName(), this.service.getCluster().getClusterId(), this.service.getName(), this.getName(), hostComponent.getHostName(), this.isRecoveryEnabled()});
            }
            if (this.hostComponents.containsKey(hostComponent.getHostName())) {
                throw new OBDPException("Cannot add duplicate ServiceComponentHost, clusterName=" + this.service.getCluster().getClusterName() + ", clusterId=" + this.service.getCluster().getClusterId() + ", serviceName=" + this.service.getName() + ", serviceComponentName=" + this.getName() + ", hostname=" + hostComponent.getHostName() + ", recoveryEnabled=" + this.isRecoveryEnabled());
            }
            ClusterImpl clusterImpl = (ClusterImpl)this.service.getCluster();
            clusterImpl.addServiceComponentHost(hostComponent);
            this.hostComponents.put(hostComponent.getHostName(), hostComponent);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public ServiceComponentHost addServiceComponentHost(String hostName) throws OBDPException {
        ServiceComponentHost hostComponent = this.serviceComponentHostFactory.createNew(this, hostName);
        this.addServiceComponentHost(hostComponent);
        return hostComponent;
    }

    @Override
    public ServiceComponentHost getServiceComponentHost(String hostname) throws OBDPException {
        if (!this.hostComponents.containsKey(hostname)) {
            throw new ServiceComponentHostNotFoundException(this.getClusterName(), this.getServiceName(), this.getName(), hostname);
        }
        return (ServiceComponentHost)this.hostComponents.get(hostname);
    }

    @Override
    public State getDesiredState() {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        if (desiredStateEntity != null) {
            return desiredStateEntity.getDesiredState();
        }
        LOG.warn("Trying to fetch a member from an entity object that may have been previously deleted, serviceName = " + this.getServiceName() + ", componentName = " + this.componentName);
        return null;
    }

    @Override
    public void setDesiredState(State state) {
        ServiceComponentDesiredStateEntity desiredStateEntity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting DesiredState of Service, clusterName={}, clusterId={}, serviceName={}, serviceComponentName={}, oldDesiredState={}, newDesiredState={}", new Object[]{this.service.getCluster().getClusterName(), this.service.getCluster().getClusterId(), this.service.getName(), this.getName(), this.getDesiredState(), state});
        }
        if ((desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId)) != null) {
            desiredStateEntity.setDesiredState(state);
            desiredStateEntity = this.serviceComponentDesiredStateDAO.merge(desiredStateEntity);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + (this.service != null ? this.service.getName() : ""));
        }
    }

    @Override
    public StackId getDesiredStackId() {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        StackEntity stackEntity = desiredStateEntity.getDesiredStack();
        if (null != stackEntity) {
            return new StackId(stackEntity.getStackName(), stackEntity.getStackVersion());
        }
        return null;
    }

    @Override
    public void setDesiredRepositoryVersion(RepositoryVersionEntity repositoryVersionEntity) {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        if (desiredStateEntity != null) {
            desiredStateEntity.setDesiredRepositoryVersion(repositoryVersionEntity);
            desiredStateEntity = this.serviceComponentDesiredStateDAO.merge(desiredStateEntity);
        } else {
            LOG.warn("Setting a member on an entity object that may have been previously deleted, serviceName = " + (this.service != null ? this.service.getName() : ""));
        }
    }

    @Override
    public RepositoryVersionEntity getDesiredRepositoryVersion() {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        return desiredStateEntity.getDesiredRepositoryVersion();
    }

    @Override
    public String getDesiredVersion() {
        ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        return desiredStateEntity.getDesiredVersion();
    }

    @Override
    public ServiceComponentResponse convertToResponse() {
        Cluster cluster = this.service.getCluster();
        RepositoryVersionEntity repositoryVersionEntity = this.getDesiredRepositoryVersion();
        StackId desiredStackId = repositoryVersionEntity.getStackId();
        ServiceComponentResponse r = new ServiceComponentResponse(this.getClusterId(), cluster.getClusterName(), this.service.getName(), this.getName(), desiredStackId, this.getDesiredState().toString(), this.getServiceComponentStateCount(), this.isRecoveryEnabled(), this.displayName, repositoryVersionEntity.getVersion(), this.getRepositoryState());
        return r;
    }

    @Override
    public String getClusterName() {
        return this.service.getCluster().getClusterName();
    }

    @Override
    public void debugDump(StringBuilder sb) {
        sb.append("ServiceComponent={ serviceComponentName=").append(this.getName()).append(", recoveryEnabled=").append(this.isRecoveryEnabled()).append(", clusterName=").append(this.service.getCluster().getClusterName()).append(", clusterId=").append(this.service.getCluster().getClusterId()).append(", serviceName=").append(this.service.getName()).append(", desiredStackVersion=").append(this.getDesiredStackId()).append(", desiredState=").append((Object)this.getDesiredState()).append(", hostcomponents=[ ");
        boolean first = true;
        for (ServiceComponentHost sch : this.hostComponents.values()) {
            if (!first) {
                sb.append(" , ");
            }
            first = false;
            sb.append("\n        ");
            sch.debugDump(sb);
            sb.append(" ");
        }
        sb.append(" ] }");
    }

    @Transactional
    protected void persistEntities(ServiceComponentDesiredStateEntity desiredStateEntity) {
        ClusterServiceEntityPK pk = new ClusterServiceEntityPK();
        pk.setClusterId(this.service.getClusterId());
        pk.setServiceName(this.service.getName());
        ClusterServiceEntity serviceEntity = this.clusterServiceDAO.findByPK(pk);
        desiredStateEntity.setClusterServiceEntity(serviceEntity);
        this.serviceComponentDesiredStateDAO.create(desiredStateEntity);
        serviceEntity.getServiceComponentDesiredStateEntities().add(desiredStateEntity);
        serviceEntity = this.clusterServiceDAO.merge(serviceEntity);
    }

    @Override
    public boolean isClientComponent() {
        return this.isClientComponent;
    }

    @Override
    public boolean isMasterComponent() {
        return this.isMasterComponent;
    }

    @Override
    public boolean isVersionAdvertised() {
        return this.isVersionAdvertised;
    }

    @Override
    public boolean canBeRemoved() {
        for (ServiceComponentHost sch : this.hostComponents.values()) {
            if (sch.canBeRemoved()) continue;
            LOG.warn("Found non removable hostcomponent when trying to delete service component, clusterName=" + this.getClusterName() + ", serviceName=" + this.getServiceName() + ", componentName=" + this.getName() + ", state=" + sch.getState() + ", hostname=" + sch.getHostName());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void deleteAllServiceComponentHosts(DeleteHostComponentStatusMetaData deleteMetaData) {
        this.readWriteLock.writeLock().lock();
        try {
            LOG.info("Deleting all servicecomponenthosts for component, clusterName=" + this.getClusterName() + ", serviceName=" + this.getServiceName() + ", componentName=" + this.getName() + ", recoveryEnabled=" + this.isRecoveryEnabled());
            for (ServiceComponentHost sch : this.hostComponents.values()) {
                if (sch.canBeRemoved()) continue;
                deleteMetaData.setAmbariException(new OBDPException("Found non removable hostcomponent  when trying to delete all hostcomponents from servicecomponent, clusterName=" + this.getClusterName() + ", serviceName=" + this.getServiceName() + ", componentName=" + this.getName() + ", recoveryEnabled=" + this.isRecoveryEnabled() + ", hostname=" + sch.getHostName()));
                return;
            }
            for (ServiceComponentHost serviceComponentHost : this.hostComponents.values()) {
                serviceComponentHost.delete(deleteMetaData);
            }
            this.hostComponents.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteServiceComponentHosts(String hostname, DeleteHostComponentStatusMetaData deleteMetaData) throws OBDPException {
        this.readWriteLock.writeLock().lock();
        try {
            ServiceComponentHost sch = this.getServiceComponentHost(hostname);
            LOG.info("Deleting servicecomponenthost for cluster, clusterName=" + this.getClusterName() + ", serviceName=" + this.getServiceName() + ", componentName=" + this.getName() + ", recoveryEnabled=" + this.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", state=" + sch.getState());
            if (!sch.canBeRemoved()) {
                throw new OBDPException("Current host component state prohibiting component removal., clusterName=" + this.getClusterName() + ", serviceName=" + this.getServiceName() + ", componentName=" + this.getName() + ", recoveryEnabled=" + this.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", state=" + sch.getState());
            }
            sch.delete(deleteMetaData);
            this.hostComponents.remove(hostname);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    @Transactional
    public void delete(DeleteHostComponentStatusMetaData deleteMetaData) {
        this.readWriteLock.writeLock().lock();
        try {
            this.deleteAllServiceComponentHosts(deleteMetaData);
            if (deleteMetaData.getAmbariException() != null) {
                return;
            }
            ServiceComponentDesiredStateEntity desiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
            this.serviceComponentDesiredStateDAO.remove(desiredStateEntity);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    @Transactional
    public void updateRepositoryState(String reportedVersion) throws OBDPException {
        ServiceComponentVersionEntity componentVersion;
        ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        List<ServiceComponentVersionEntity> componentVersions = this.serviceComponentDesiredStateDAO.findVersions(this.getClusterId(), this.getServiceName(), this.getName());
        HashMap<String, ServiceComponentVersionEntity> map = new HashMap<String, ServiceComponentVersionEntity>((Map<String, ServiceComponentVersionEntity>)Maps.uniqueIndex(componentVersions, (Function)new Function<ServiceComponentVersionEntity, String>(){

            public String apply(ServiceComponentVersionEntity input) {
                return input.getRepositoryVersion().getVersion();
            }
        }));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Existing versions for {}/{}/{}: {}", new Object[]{this.getClusterName(), this.getServiceName(), this.getName(), map.keySet()});
        }
        if (null == (componentVersion = (ServiceComponentVersionEntity)map.get(reportedVersion))) {
            RepositoryVersionEntity repoVersion = this.repoVersionDAO.findByStackAndVersion(this.getDesiredStackId(), reportedVersion);
            if (null != repoVersion) {
                componentVersion = new ServiceComponentVersionEntity();
                componentVersion.setRepositoryVersion(repoVersion);
                componentVersion.setState(RepositoryVersionState.INSTALLED);
                componentVersion.setUserName("auto-reported");
                serviceComponentDesiredStateEntity.setRepositoryState(RepositoryVersionState.CURRENT);
                serviceComponentDesiredStateEntity.addVersion(componentVersion);
                serviceComponentDesiredStateEntity = this.serviceComponentDesiredStateDAO.merge(serviceComponentDesiredStateEntity);
                map.put(reportedVersion, componentVersion);
            } else {
                LOG.warn("There is no repository available for stack {}, version {}", (Object)this.getDesiredStackId(), (Object)reportedVersion);
            }
        }
        if (MapUtils.isNotEmpty(map)) {
            String desiredVersion = serviceComponentDesiredStateEntity.getDesiredVersion();
            RepositoryVersionEntity desiredRepositoryVersion = this.service.getDesiredRepositoryVersion();
            List<HostComponentStateEntity> hostComponents = this.hostComponentDAO.findByServiceAndComponentAndNotVersion(serviceComponentDesiredStateEntity.getServiceName(), serviceComponentDesiredStateEntity.getComponentName(), reportedVersion);
            LOG.debug("{}/{} reportedVersion={}, desiredVersion={}, non-matching desired count={}, repo_state={}", new Object[]{serviceComponentDesiredStateEntity.getServiceName(), serviceComponentDesiredStateEntity.getComponentName(), reportedVersion, desiredVersion, hostComponents.size(), serviceComponentDesiredStateEntity.getRepositoryState()});
            if (StackVersionListener.UNKNOWN_VERSION.equals(desiredVersion)) {
                if (CollectionUtils.isEmpty(hostComponents)) {
                    serviceComponentDesiredStateEntity.setDesiredRepositoryVersion(desiredRepositoryVersion);
                    serviceComponentDesiredStateEntity.setRepositoryState(RepositoryVersionState.CURRENT);
                } else {
                    serviceComponentDesiredStateEntity.setRepositoryState(RepositoryVersionState.OUT_OF_SYNC);
                }
            } else if (!reportedVersion.equals(desiredVersion)) {
                serviceComponentDesiredStateEntity.setRepositoryState(RepositoryVersionState.OUT_OF_SYNC);
            } else if (CollectionUtils.isEmpty(hostComponents)) {
                serviceComponentDesiredStateEntity.setRepositoryState(RepositoryVersionState.CURRENT);
            }
            serviceComponentDesiredStateEntity = this.serviceComponentDesiredStateDAO.merge(serviceComponentDesiredStateEntity);
        }
    }

    @Override
    public RepositoryVersionState getRepositoryState() {
        ServiceComponentDesiredStateEntity component = this.serviceComponentDesiredStateDAO.findById(this.desiredStateEntityId);
        if (null != component) {
            return component.getRepositoryState();
        }
        LOG.warn("Cannot retrieve repository state on component that may have been deleted: service {}, component {}", (Object)(this.service != null ? this.service.getName() : null), (Object)this.componentName);
        return null;
    }

    private int getSCHCountByState(State state) {
        int count = 0;
        for (ServiceComponentHost sch : this.hostComponents.values()) {
            if (sch.getState() != state) continue;
            ++count;
        }
        return count;
    }

    private int getMaintenanceOffSCHCountByState(State state) {
        int count = 0;
        for (ServiceComponentHost sch : this.hostComponents.values()) {
            try {
                MaintenanceState effectiveMaintenanceState = this.maintenanceStateHelper.getEffectiveState(sch, sch.getHost());
                if (sch.getState() != state || effectiveMaintenanceState != MaintenanceState.OFF) continue;
                ++count;
            }
            catch (OBDPException e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    private Map<String, Integer> getServiceComponentStateCount() {
        HashMap<String, Integer> serviceComponentStateCountMap = new HashMap<String, Integer>();
        serviceComponentStateCountMap.put("startedCount", this.getSCHCountByState(State.STARTED));
        serviceComponentStateCountMap.put("installedCount", this.getSCHCountByState(State.INSTALLED));
        serviceComponentStateCountMap.put("installedAndMaintenanceOffCount", this.getMaintenanceOffSCHCountByState(State.INSTALLED));
        serviceComponentStateCountMap.put("installFailedCount", this.getSCHCountByState(State.INSTALL_FAILED));
        serviceComponentStateCountMap.put("initCount", this.getSCHCountByState(State.INIT));
        serviceComponentStateCountMap.put("unknownCount", this.getSCHCountByState(State.UNKNOWN));
        serviceComponentStateCountMap.put("totalCount", this.hostComponents.size());
        return serviceComponentStateCountMap;
    }
}

