/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.ServiceComponentHostEventType;
import id.onyx.obdp.server.state.fsm.event.AbstractEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostDisableEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostInstallEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpFailedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpInProgressEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpRestartedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpSucceededEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostRestoreEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStartEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStartedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStopEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStoppedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostUninstallEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostUpgradeEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostWipeoutEvent;
import java.util.Map;

public abstract class ServiceComponentHostEvent
extends AbstractEvent<ServiceComponentHostEventType> {
    private final String serviceComponentName;
    private final String hostName;
    private final long opTimestamp;
    private final String stackId;

    public ServiceComponentHostEvent(ServiceComponentHostEventType type, String serviceComponentName, String hostName, long opTimestamp) {
        this(type, serviceComponentName, hostName, opTimestamp, "");
    }

    public ServiceComponentHostEvent(ServiceComponentHostEventType type, String serviceComponentName, String hostName, long opTimestamp, String stackId) {
        super(type);
        this.serviceComponentName = serviceComponentName;
        this.hostName = hostName;
        this.opTimestamp = opTimestamp;
        this.stackId = stackId;
    }

    public String getServiceComponentName() {
        return this.serviceComponentName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getOpTimestamp() {
        return this.opTimestamp;
    }

    @JsonCreator
    public static ServiceComponentHostEvent create(@JsonProperty(value="type") ServiceComponentHostEventType type, @JsonProperty(value="serviceComponentName") String serviceComponentName, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="opTimestamp") long opTimestamp, @JsonProperty(value="configs") Map<String, String> configs, @JsonProperty(value="stackId") String stackId) {
        switch (type) {
            case HOST_SVCCOMP_INSTALL: {
                return new ServiceComponentHostInstallEvent(serviceComponentName, hostName, opTimestamp, stackId);
            }
            case HOST_SVCCOMP_OP_FAILED: {
                return new ServiceComponentHostOpFailedEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_OP_IN_PROGRESS: {
                return new ServiceComponentHostOpInProgressEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_OP_RESTART: {
                return new ServiceComponentHostOpRestartedEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_OP_SUCCEEDED: {
                return new ServiceComponentHostOpSucceededEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_STOPPED: {
                return new ServiceComponentHostStoppedEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_STARTED: {
                return new ServiceComponentHostStartedEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_START: {
                return new ServiceComponentHostStartEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_STOP: {
                return new ServiceComponentHostStopEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_UNINSTALL: {
                return new ServiceComponentHostUninstallEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_WIPEOUT: {
                return new ServiceComponentHostWipeoutEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_UPGRADE: {
                return new ServiceComponentHostUpgradeEvent(serviceComponentName, hostName, opTimestamp, stackId);
            }
            case HOST_SVCCOMP_DISABLE: {
                return new ServiceComponentHostDisableEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_RESTORE: {
                return new ServiceComponentHostRestoreEvent(serviceComponentName, hostName, opTimestamp);
            }
            case HOST_SVCCOMP_SERVER_ACTION: {
                return new ServiceComponentHostServerActionEvent(serviceComponentName, hostName, opTimestamp);
            }
        }
        return null;
    }

    public String getStackId() {
        return this.stackId;
    }
}

