/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import java.util.List;

public enum RepositoryVersionState {
    NOT_REQUIRED(0),
    INSTALLING(3),
    INSTALLED(2),
    INSTALL_FAILED(5),
    OUT_OF_SYNC(4),
    CURRENT(1);

    private final int weight;

    private RepositoryVersionState(int weight) {
        this.weight = weight;
    }

    public static RepositoryVersionState getAggregateState(List<RepositoryVersionState> states) {
        if (null == states || states.isEmpty()) {
            return NOT_REQUIRED;
        }
        RepositoryVersionState heaviestState = states.get(0);
        for (RepositoryVersionState state : states) {
            if (state.weight <= heaviestState.weight) continue;
            heaviestState = state;
        }
        return heaviestState;
    }
}

