/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import id.onyx.obdp.server.controller.RepositoryResponse;
import id.onyx.obdp.server.state.stack.RepoTag;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class RepositoryInfo {
    private String baseUrl;
    private String osType;
    private String repoId;
    private String repoName;
    private String distribution;
    private String components;
    private String mirrorsList;
    private String defaultBaseUrl;
    private boolean repoSaved = false;
    private boolean unique = false;
    private boolean ambariManagedRepositories = true;
    private List<String> applicableServices = new LinkedList<String>();
    private Set<RepoTag> tags = new HashSet<RepoTag>();
    public static final Function<RepositoryInfo, String> GET_REPO_NAME_FUNCTION = new Function<RepositoryInfo, String>(){

        public String apply(RepositoryInfo input) {
            return input.repoName;
        }
    };
    public static final Function<RepositoryInfo, String> GET_REPO_ID_FUNCTION = new Function<RepositoryInfo, String>(){

        public String apply(RepositoryInfo input) {
            return input.repoId;
        }
    };
    public static final Function<RepositoryInfo, String> SAFE_GET_BASE_URL_FUNCTION = new Function<RepositoryInfo, String>(){

        public String apply(RepositoryInfo input) {
            return Strings.nullToEmpty((String)input.baseUrl);
        }
    };
    public static final Function<RepositoryInfo, String> GET_OSTYPE_FUNCTION = new Function<RepositoryInfo, String>(){

        public String apply(RepositoryInfo input) {
            return input.osType;
        }
    };

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public void setRepoId(String repoId) {
        this.repoId = repoId;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getComponents() {
        return this.components;
    }

    public void setComponents(String components) {
        this.components = components;
    }

    public String getMirrorsList() {
        return this.mirrorsList;
    }

    public void setMirrorsList(String mirrorsList) {
        this.mirrorsList = mirrorsList;
    }

    public String getDefaultBaseUrl() {
        return this.defaultBaseUrl;
    }

    public void setDefaultBaseUrl(String url) {
        this.defaultBaseUrl = url;
    }

    public boolean isRepoSaved() {
        return this.repoSaved;
    }

    public void setRepoSaved(boolean saved) {
        this.repoSaved = saved;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public List<String> getApplicableServices() {
        return this.applicableServices;
    }

    public void setApplicableServices(List<String> applicableServices) {
        this.applicableServices = applicableServices;
    }

    public String toString() {
        return "[ repoInfo: , osType=" + this.osType + ", repoId=" + this.repoId + ", baseUrl=" + URLCredentialsHider.hideCredentials(this.baseUrl) + ", repoName=" + this.repoName + ", distribution=" + this.distribution + ", components=" + this.components + ", mirrorsList=" + this.mirrorsList + ", unique=" + this.unique + ", ambariManagedRepositories=" + this.ambariManagedRepositories + ", applicableServices=" + StringUtils.join(this.applicableServices, (String)",") + " ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryInfo that = (RepositoryInfo)o;
        return this.repoSaved == that.repoSaved && this.unique == that.unique && Objects.equal((Object)this.baseUrl, (Object)that.baseUrl) && Objects.equal((Object)this.osType, (Object)that.osType) && Objects.equal((Object)this.repoId, (Object)that.repoId) && Objects.equal((Object)this.repoName, (Object)that.repoName) && Objects.equal((Object)this.distribution, (Object)that.distribution) && Objects.equal((Object)this.components, (Object)that.components) && Objects.equal((Object)this.mirrorsList, (Object)that.mirrorsList) && Objects.equal((Object)this.defaultBaseUrl, (Object)that.defaultBaseUrl) && Objects.equal((Object)this.ambariManagedRepositories, (Object)that.ambariManagedRepositories);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.baseUrl, this.osType, this.repoId, this.repoName, this.distribution, this.components, this.mirrorsList, this.defaultBaseUrl, this.ambariManagedRepositories});
    }

    public RepositoryResponse convertToResponse() {
        return new RepositoryResponse(this.getBaseUrl(), this.getOsType(), this.getRepoId(), this.getRepoName(), this.getDistribution(), this.getComponents(), this.getMirrorsList(), this.getDefaultBaseUrl(), this.getTags(), this.getApplicableServices());
    }

    public boolean isAmbariManagedRepositories() {
        return this.ambariManagedRepositories;
    }

    public void setAmbariManagedRepositories(boolean ambariManagedRepositories) {
        this.ambariManagedRepositories = ambariManagedRepositories;
    }

    public Set<RepoTag> getTags() {
        return this.tags;
    }

    public void setTags(Set<RepoTag> repoTags) {
        this.tags = repoTags;
    }
}

