/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.HashMap;
import java.util.Map;

public class RefreshCommandConfiguration {
    public static final String RELOAD_CONFIGS = "reload_configs";
    public static final String REFRESH_CONFIGS = "refresh_configs";
    private Map<String, Map<String, String>> propertyComponentCommandMap;

    private String findKey(String propertyName) {
        for (String keyName : this.propertyComponentCommandMap.keySet()) {
            if (!propertyName.startsWith(keyName)) continue;
            return keyName;
        }
        return null;
    }

    public String getRefreshCommandForComponent(ServiceComponentHost sch, String propertyName) {
        if (sch.isClientComponent()) {
            return REFRESH_CONFIGS;
        }
        String keyName = this.findKey(propertyName);
        Map<String, String> componentCommandMap = this.propertyComponentCommandMap.get(keyName);
        if (componentCommandMap != null) {
            String commandForComponent = componentCommandMap.get(sch.getServiceComponentName());
            if (commandForComponent != null) {
                return commandForComponent;
            }
            if (componentCommandMap.size() == 1) {
                return REFRESH_CONFIGS;
            }
        }
        return null;
    }

    public void addRefreshCommands(Map<String, Map<String, String>> refreshCommands) {
        if (this.propertyComponentCommandMap == null) {
            this.propertyComponentCommandMap = new HashMap<String, Map<String, String>>();
        }
        this.propertyComponentCommandMap.putAll(refreshCommands);
    }
}

