/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.controller.StackConfigurationResponse;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.PropertyStackUpgradeBehavior;
import id.onyx.obdp.server.state.PropertyUpgradeBehavior;
import id.onyx.obdp.server.state.RefreshCommand;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlList;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PropertyInfo {
    private String name;
    private String value;
    private String description;
    @XmlElement(name="display-name")
    private String displayName;
    private String filename;
    private boolean deleted;
    @XmlElement(name="on-ambari-upgrade", required=true)
    private PropertyUpgradeBehavior propertyAmbariUpgradeBehavior;
    @XmlElement(name="on-stack-upgrade")
    private PropertyStackUpgradeBehavior propertyStackUpgradeBehavior = new PropertyStackUpgradeBehavior();
    @XmlAttribute(name="require-input")
    private boolean requireInput;
    @XmlElement(name="property-type")
    @XmlList
    private Set<PropertyType> propertyTypes = new HashSet<PropertyType>();
    @XmlAnyElement
    private List<Element> propertyAttributes = new ArrayList<Element>();
    @XmlElement(name="value-attributes")
    private ValueAttributesInfo propertyValueAttributes = new ValueAttributesInfo();
    @XmlElementWrapper(name="depends-on")
    @XmlElement(name="property")
    private Set<PropertyDependencyInfo> dependsOnProperties = new HashSet<PropertyDependencyInfo>();
    @XmlElementWrapper(name="property_depended_by")
    private Set<PropertyDependencyInfo> dependedByProperties = new HashSet<PropertyDependencyInfo>();
    @XmlElementWrapper(name="used-by")
    @XmlElement(name="property")
    private Set<PropertyDependencyInfo> usedByProperties = new HashSet<PropertyDependencyInfo>();
    @XmlElementWrapper(name="supported-refresh-commands")
    @XmlElement(name="refresh-command")
    private Set<RefreshCommand> supportedRefreshCommands = new HashSet<RefreshCommand>();

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.propertyTypes.remove(null);
    }

    public PropertyInfo() {
        this.propertyAmbariUpgradeBehavior = new PropertyUpgradeBehavior();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<PropertyDependencyInfo> getUsedByProperties() {
        return this.usedByProperties;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Set<PropertyType> getPropertyTypes() {
        return this.propertyTypes;
    }

    public void setPropertyTypes(Set<PropertyType> propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    public PropertyUpgradeBehavior getPropertyAmbariUpgradeBehavior() {
        return this.propertyAmbariUpgradeBehavior;
    }

    public void setPropertyAmbariUpgradeBehavior(PropertyUpgradeBehavior propertyAmbariUpgradeBehavior) {
        this.propertyAmbariUpgradeBehavior = propertyAmbariUpgradeBehavior;
    }

    public StackConfigurationResponse convertToResponse() {
        return new StackConfigurationResponse(this.getName(), this.getValue(), this.getDescription(), this.getDisplayName(), this.getFilename(), this.isRequireInput(), this.getPropertyTypes(), this.getAttributesMap(), this.getPropertyValueAttributes(), this.getDependsOnProperties());
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Element propertyAttribute : this.propertyAttributes) {
            attributes.put(propertyAttribute.getTagName(), propertyAttribute.getFirstChild().getNodeValue());
        }
        String hidden = this.getPropertyValueAttributes().getHidden();
        if (hidden != null) {
            attributes.putIfAbsent("hidden", hidden);
        }
        return attributes;
    }

    public ValueAttributesInfo getPropertyValueAttributes() {
        return this.propertyValueAttributes;
    }

    public Set<PropertyDependencyInfo> getDependsOnProperties() {
        return this.dependsOnProperties;
    }

    public void setPropertyValueAttributes(ValueAttributesInfo propertyValueAttributes) {
        this.propertyValueAttributes = propertyValueAttributes;
    }

    public Set<PropertyDependencyInfo> getDependedByProperties() {
        return this.dependedByProperties;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public void setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
    }

    public List<Element> getPropertyAttributes() {
        return this.propertyAttributes;
    }

    public void setPropertyAttributes(List<Element> propertyAttributes) {
        this.propertyAttributes = propertyAttributes;
    }

    public Set<RefreshCommand> getSupportedRefreshCommands() {
        return this.supportedRefreshCommands;
    }

    public void setSupportedRefreshCommands(Set<RefreshCommand> supportedRefreshCommands) {
        this.supportedRefreshCommands = supportedRefreshCommands;
    }

    public boolean shouldBeConfigured() {
        return !this.getName().contains("*");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyInfo other = (PropertyInfo)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "PropertyInfo{name='" + this.name + "', value='" + this.value + "', description='" + this.description + "', filename='" + this.filename + "', deleted=" + this.deleted + ", requireInput=" + this.requireInput + ", propertyTypes=" + this.propertyTypes + ", propertyAttributes=" + this.propertyAttributes + ", propertyValueAttributes=" + this.propertyValueAttributes + ", dependsOnProperties=" + this.dependsOnProperties + ", dependedByProperties=" + this.dependedByProperties + "}";
    }

    public PropertyStackUpgradeBehavior getPropertyStackUpgradeBehavior() {
        return this.propertyStackUpgradeBehavior;
    }

    public void setPropertyStackUpgradeBehavior(PropertyStackUpgradeBehavior propertyStackUpgradeBehavior) {
        this.propertyStackUpgradeBehavior = propertyStackUpgradeBehavior;
    }

    public static enum PropertyType {
        PASSWORD,
        USER,
        UID,
        GROUP,
        GID,
        TEXT,
        ADDITIONAL_USER_PROPERTY,
        NOT_MANAGED_HDFS_PATH,
        VALUE_FROM_PROPERTY_FILE,
        KERBEROS_PRINCIPAL;

    }
}

