/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.state.Module;
import id.onyx.obdp.server.state.ModuleComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

public class Mpack {
    private Long resourceId;
    private Long registryId;
    @SerializedName(value="id")
    private String mpackId;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="prerequisites")
    private HashMap<String, String> prerequisites;
    @SerializedName(value="modules")
    private List<Module> modules;
    @SerializedName(value="definition")
    private String definition;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="displayName")
    private String displayName;
    private String mpackUri;

    public Long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(Long registryId) {
        this.registryId = registryId;
    }

    public String getMpackUri() {
        return this.mpackUri;
    }

    public void setMpackUri(String mpackUri) {
        this.mpackUri = mpackUri;
    }

    public String getMpackId() {
        return this.mpackId;
    }

    public void setMpackId(String mpackId) {
        this.mpackId = mpackId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HashMap<String, String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(HashMap<String, String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Module getModule(String moduleName) {
        for (Module module : this.modules) {
            if (!StringUtils.equals((String)moduleName, (String)module.getName())) continue;
            return module;
        }
        return null;
    }

    public ModuleComponent getModuleComponent(String moduleName, String moduleComponentName) {
        for (Module module : this.modules) {
            ModuleComponent moduleComponent = module.getModuleComponent(moduleComponentName);
            if (null == moduleComponent) continue;
            return moduleComponent;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mpack mpack = (Mpack)o;
        Mpack that = (Mpack)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.resourceId, (Object)that.resourceId);
        equalsBuilder.append((Object)this.registryId, (Object)that.registryId);
        equalsBuilder.append((Object)this.mpackId, (Object)that.mpackId);
        equalsBuilder.append((Object)this.name, (Object)that.name);
        equalsBuilder.append((Object)this.version, (Object)that.version);
        equalsBuilder.append(this.prerequisites, that.prerequisites);
        equalsBuilder.append(this.modules, that.modules);
        equalsBuilder.append((Object)this.definition, (Object)that.definition);
        equalsBuilder.append((Object)this.description, (Object)that.description);
        equalsBuilder.append((Object)this.mpackUri, (Object)that.mpackUri);
        equalsBuilder.append((Object)this.displayName, (Object)that.displayName);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.registryId, this.mpackId, this.name, this.version, this.prerequisites, this.modules, this.definition, this.description, this.mpackUri, this.displayName);
    }

    public String toString() {
        return "Mpack{id=" + this.resourceId + ", registryId=" + this.registryId + ", mpackId='" + this.mpackId + "', name='" + this.name + "', version='" + this.version + "', prerequisites=" + this.prerequisites + ", modules=" + this.modules + ", definition='" + this.definition + "', description='" + this.description + "', mpackUri='" + this.mpackUri + "', displayName='" + this.mpackUri + "'}";
    }

    public void copyFrom(Mpack mpack) {
        if (this.resourceId == null) {
            this.resourceId = mpack.getResourceId();
        }
        if (this.name == null) {
            this.name = mpack.getName();
            if (this.mpackId == null) {
                this.mpackId = mpack.getMpackId();
            }
            if (this.version == null) {
                this.version = mpack.getVersion();
            }
        }
        if (this.registryId == null) {
            this.registryId = mpack.getRegistryId();
            if (this.description == null) {
                this.description = mpack.getDescription();
            }
        }
        if (this.modules == null) {
            this.modules = mpack.getModules();
        }
        if (this.prerequisites == null) {
            this.prerequisites = mpack.getPrerequisites();
        }
        if (this.definition == null) {
            this.definition = mpack.getDefinition();
        }
        if (this.displayName == null) {
            this.displayName = mpack.getDisplayName();
        }
    }
}

