/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.state.ModuleComponent;
import id.onyx.obdp.server.state.ModuleDependency;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Module {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="displayName")
    private String displayName;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="category")
    private Category category;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="definition")
    private String definition;
    @SerializedName(value="dependencies")
    private List<ModuleDependency> dependencies;
    @SerializedName(value="components")
    private List<ModuleComponent> components;
    private HashMap<String, ModuleComponent> componentHashMap;

    public Category getCategory() {
        return this.category;
    }

    public void setType(Category category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ModuleDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<ModuleComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<ModuleComponent> components) {
        this.components = components;
    }

    public ModuleComponent getModuleComponent(String moduleComponentName) {
        return this.componentHashMap.get(moduleComponentName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return Objects.equals(this.id, module.id) && Objects.equals(this.displayName, module.displayName) && Objects.equals(this.description, module.description) && Objects.equals((Object)this.category, (Object)module.category) && Objects.equals(this.name, module.name) && Objects.equals(this.version, module.version) && Objects.equals(this.definition, module.definition) && Objects.equals(this.dependencies, module.dependencies) && Objects.equals(this.components, module.components);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.displayName, this.description, this.category, this.name, this.version, this.definition, this.dependencies, this.components});
    }

    public String toString() {
        return "Module{id='" + this.id + "', displayName='" + this.displayName + "', description='" + this.description + "', category=" + this.category + ", name='" + this.name + "', version='" + this.version + "', definition='" + this.definition + "', dependencies=" + this.dependencies + ", components=" + this.components + "}";
    }

    public void populateComponentMap() {
        this.componentHashMap = new HashMap();
        for (ModuleComponent moduleComponent : this.getComponents()) {
            moduleComponent.setModule(this);
            this.componentHashMap.put(moduleComponent.getName(), moduleComponent);
        }
    }

    public static enum Category {
        SERVER,
        CLIENT,
        LIBRARY;

    }
}

