/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.controller.ExtensionVersionResponse;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import id.onyx.obdp.server.utils.VersionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtensionInfo
implements Comparable<ExtensionInfo>,
Validable {
    private String name;
    private String version;
    private Collection<ServiceInfo> services;
    private String parentExtensionVersion;
    private List<ExtensionMetainfoXml.Stack> stacks;
    private List<ExtensionMetainfoXml.Extension> extensions;
    private boolean valid = true;
    private boolean autoLink = false;
    private boolean active = false;
    private Set<String> errorSet = new HashSet<String>();
    private String upgradesFolder = null;
    private volatile Map<String, PropertyInfo> requiredProperties;

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public synchronized Collection<ServiceInfo> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<ServiceInfo>();
        }
        return this.services;
    }

    public ServiceInfo getService(String name) {
        Collection<ServiceInfo> services = this.getServices();
        for (ServiceInfo service : services) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public synchronized void setServices(Collection<ServiceInfo> services) {
        this.services = services;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Extension name:" + this.name + "\nversion:" + this.version + " \nvalid:" + this.isValid());
        if (this.services != null) {
            sb.append("\n\t\tService:");
            for (ServiceInfo service : this.services) {
                sb.append("\t\t");
                sb.append(service);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return 31 + this.name.hashCode() + this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExtensionInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExtensionInfo extInfo = (ExtensionInfo)obj;
        return this.getName().equals(extInfo.getName()) && this.getVersion().equals(extInfo.getVersion());
    }

    public ExtensionVersionResponse convertToResponse() {
        Collection<ServiceInfo> serviceInfos = this.getServices();
        HashSet<File> serviceDescriptorFiles = new HashSet<File>();
        if (serviceInfos != null) {
            for (ServiceInfo serviceInfo : serviceInfos) {
                File file = serviceInfo.getKerberosDescriptorFile();
                if (file == null) continue;
                serviceDescriptorFiles.add(file);
            }
        }
        return new ExtensionVersionResponse(this.getVersion(), this.getParentExtensionVersion(), this.isValid(), this.getErrors());
    }

    public String getParentExtensionVersion() {
        return this.parentExtensionVersion;
    }

    public void setParentExtensionVersion(String parentExtensionVersion) {
        this.parentExtensionVersion = parentExtensionVersion;
    }

    @Override
    public int compareTo(ExtensionInfo o) {
        if (this.name.equals(o.name)) {
            return VersionUtils.compareVersions((String)this.version, (String)o.version);
        }
        return this.name.compareTo(o.name);
    }

    public List<ExtensionMetainfoXml.Stack> getStacks() {
        return this.stacks;
    }

    public void setStacks(List<ExtensionMetainfoXml.Stack> stacks) {
        this.stacks = stacks;
    }

    public List<ExtensionMetainfoXml.Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionMetainfoXml.Extension> extensions) {
        this.extensions = extensions;
    }

    public boolean isAutoLink() {
        return this.autoLink;
    }

    public void setAutoLink(boolean autoLink) {
        this.autoLink = autoLink;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

