/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.utils.VersionUtils;

public class ExtensionId
implements Comparable<ExtensionId> {
    private static final String NAME_SEPARATOR = "-";
    private String extensionName;
    private String extensionVersion;

    public ExtensionId() {
        this.extensionName = "";
        this.extensionVersion = "";
    }

    public ExtensionId(String extensionId) {
        this.parseExtensionIdHelper(this, extensionId);
    }

    public ExtensionId(ExtensionInfo extension) {
        this.extensionName = extension.getName();
        this.extensionVersion = extension.getVersion();
    }

    public ExtensionId(String extensionName, String extensionVersion) {
        this(extensionName + NAME_SEPARATOR + extensionVersion);
    }

    public ExtensionId(ExtensionEntity entity) {
        this(entity.getExtensionName(), entity.getExtensionVersion());
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getExtensionVersion() {
        return this.extensionVersion;
    }

    public String getExtensionId() {
        if (this.extensionName.isEmpty() && this.extensionVersion.isEmpty()) {
            return "";
        }
        return this.extensionName + NAME_SEPARATOR + this.extensionVersion;
    }

    public void setExtensionId(String extensionId) {
        this.parseExtensionIdHelper(this, extensionId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtensionId)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ExtensionId s = (ExtensionId)object;
        return this.extensionName.equals(s.extensionName) && this.extensionVersion.equals(s.extensionVersion);
    }

    public int hashCode() {
        int result = this.extensionName != null ? this.extensionName.hashCode() : 0;
        result = 31 * result + (this.extensionVersion != null ? this.extensionVersion.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ExtensionId other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            throw new RuntimeException("Cannot compare with a null value.");
        }
        int returnValue = this.getExtensionName().compareTo(other.getExtensionName());
        if (returnValue != 0) {
            throw new RuntimeException("ExtensionId with different names cannot be compared.");
        }
        returnValue = VersionUtils.compareVersions((String)this.getExtensionVersion(), (String)other.getExtensionVersion());
        return returnValue;
    }

    public String toString() {
        return this.getExtensionId();
    }

    private void parseExtensionIdHelper(ExtensionId extensionVersion, String extensionId) {
        if (extensionId == null || extensionId.isEmpty()) {
            extensionVersion.extensionName = "";
            extensionVersion.extensionVersion = "";
            return;
        }
        int pos = extensionId.indexOf(45);
        if (pos == -1 || extensionId.length() <= pos + 1) {
            throw new RuntimeException("Could not parse invalid Extension Id, extensionId=" + extensionId);
        }
        extensionVersion.extensionName = extensionId.substring(0, pos);
        extensionVersion.extensionVersion = extensionId.substring(pos + 1);
    }
}

