/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DesiredConfig {
    private String tag;
    private String serviceName;
    private Long version;
    private List<HostOverride> hostOverrides = new ArrayList<HostOverride>();

    public void setTag(String tag) {
        this.tag = tag;
    }

    @JsonProperty(value="tag")
    public String getTag() {
        return this.tag;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_name")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void setHostOverrides(List<HostOverride> overrides) {
        this.hostOverrides = overrides;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="host_overrides")
    public List<HostOverride> getHostOverrides() {
        return this.hostOverrides;
    }

    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("tag=").append(this.tag);
        if (null != this.serviceName) {
            sb.append(", service=").append(this.serviceName);
        }
        if (null != this.hostOverrides && this.hostOverrides.size() > 0) {
            sb.append(", hosts=[");
            int i = 0;
            for (HostOverride h : this.hostOverrides) {
                if (i++ != 0) {
                    sb.append(",");
                }
                sb.append(h.getName()).append(':').append(h.getVersionTag());
            }
            sb.append(']');
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesiredConfig that = (DesiredConfig)o;
        return new EqualsBuilder().append((Object)this.tag, (Object)that.tag).append((Object)this.serviceName, (Object)that.serviceName).append((Object)this.version, (Object)that.version).append(this.hostOverrides, that.hostOverrides).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.tag).append((Object)this.serviceName).append((Object)this.version).append(this.hostOverrides).toHashCode();
    }

    public static final class HostOverride {
        private final String hostName;
        private final String versionOverrideTag;

        public HostOverride(String name, String tag) {
            this.hostName = name;
            this.versionOverrideTag = tag;
        }

        @JsonProperty(value="host_name")
        public String getName() {
            return this.hostName;
        }

        @JsonProperty(value="tag")
        public String getVersionTag() {
            return this.versionOverrideTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostOverride that = (HostOverride)o;
            return new EqualsBuilder().append((Object)this.hostName, (Object)that.hostName).append((Object)this.versionOverrideTag, (Object)that.versionOverrideTag).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.hostName).append((Object)this.versionOverrideTag).toHashCode();
        }
    }
}

