/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.DependencyConditionInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import org.apache.commons.collections4.CollectionUtils;

public class DependencyInfo {
    private String name;
    private String scope;
    private String type = "inclusive";
    private String serviceName;
    private String componentName;
    @XmlElement(name="auto-deploy")
    private AutoDeployInfo m_autoDeploy;
    private List<DependencyConditionInfo> dependencyConditions = new ArrayList<DependencyConditionInfo>();

    public void setName(String name) {
        if (!name.contains("/")) {
            throw new IllegalArgumentException("Invalid dependency name specified in stack.  Expected form is: serviceName/componentName");
        }
        this.name = name;
        int idx = name.indexOf(47);
        this.serviceName = name.substring(0, idx);
        this.componentName = name.substring(idx + 1);
    }

    public String getName() {
        return this.name;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setAutoDeploy(AutoDeployInfo autoDeploy) {
        this.m_autoDeploy = autoDeploy;
    }

    public AutoDeployInfo getAutoDeploy() {
        return this.m_autoDeploy;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @XmlElementWrapper(name="conditions")
    @XmlElements(value={@XmlElement(name="condition")})
    public List<DependencyConditionInfo> getDependencyConditions() {
        return this.dependencyConditions;
    }

    public void setDependencyConditions(List<DependencyConditionInfo> dependencyConditions) {
        this.dependencyConditions = dependencyConditions;
    }

    public boolean hasDependencyConditions() {
        return !CollectionUtils.isEmpty(this.dependencyConditions);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        String autoDeployString = this.m_autoDeploy == null ? "false" : String.valueOf(this.m_autoDeploy.isEnabled());
        return "DependencyInfo[name=" + this.getName() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", auto-deploy=" + autoDeployString + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyInfo that = (DependencyInfo)o;
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.m_autoDeploy != null ? !this.m_autoDeploy.equals(that.m_autoDeploy) : that.m_autoDeploy != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.m_autoDeploy != null ? this.m_autoDeploy.hashCode() : 0);
        return result;
    }
}

