/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.StackId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigMergeHelper {
    private static final Pattern HEAP_PATTERN = Pattern.compile("(\\d+)([mgMG])");
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMergeHelper.class);
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private Provider<OBDPMetaInfo> m_ambariMetaInfo;

    public Map<String, Map<String, ThreeWayValue>> getConflicts(String clusterName, StackId targetStack) throws OBDPException {
        Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(clusterName);
        StackId oldStack = cluster.getCurrentStackVersion();
        HashMap<String, Map<String, String>> oldMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> newMap = new HashMap<String, Map<String, String>>();
        for (String serviceName : cluster.getServices().keySet()) {
            try {
                Set<PropertyInfo> newStackProperties = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getServiceProperties(targetStack.getStackName(), targetStack.getStackVersion(), serviceName);
                this.addToMap(newMap, newStackProperties);
            }
            catch (StackAccessException e) {
                LOG.info("Skipping service {} which is currently installed but does not exist in the target stack {}", (Object)serviceName, (Object)targetStack);
                continue;
            }
            Set<PropertyInfo> oldStackProperties = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getServiceProperties(oldStack.getStackName(), oldStack.getStackVersion(), serviceName);
            this.addToMap(oldMap, oldStackProperties);
        }
        Set<PropertyInfo> set = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getStackProperties(oldStack.getStackName(), oldStack.getStackVersion());
        this.addToMap(oldMap, set);
        set = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getStackProperties(targetStack.getStackName(), targetStack.getStackVersion());
        this.addToMap(newMap, set);
        HashMap<String, Map<String, ThreeWayValue>> result = new HashMap<String, Map<String, ThreeWayValue>>();
        for (Map.Entry entry : oldMap.entrySet()) {
            if (!newMap.containsKey(entry.getKey())) {
                LOG.info("Stack {} does not have an equivalent config type {} in {}", new Object[]{oldStack.getStackId(), entry.getKey(), targetStack.getStackId()});
                continue;
            }
            Map oldPairs = (Map)entry.getValue();
            Map newPairs = (Map)newMap.get(entry.getKey());
            Collection customValueKeys = null;
            Config config = cluster.getDesiredConfigByType((String)entry.getKey());
            if (null != config) {
                Set<String> valueKeys = config.getProperties().keySet();
                customValueKeys = CollectionUtils.subtract(valueKeys, oldPairs.keySet());
            }
            if (null != customValueKeys) {
                for (String prop : customValueKeys) {
                    String newVal = (String)newPairs.get(prop);
                    String savedVal = config.getProperties().get(prop);
                    if (null == newVal || null == savedVal || newVal.equals(savedVal)) continue;
                    ThreeWayValue twv = new ThreeWayValue();
                    twv.oldStackValue = null;
                    twv.newStackValue = ConfigMergeHelper.normalizeValue(savedVal, newVal.trim());
                    twv.savedValue = savedVal.trim();
                    if (!result.containsKey(entry.getKey())) {
                        result.put((String)entry.getKey(), new HashMap());
                    }
                    ((Map)result.get(entry.getKey())).put(prop, twv);
                }
            }
            Collection common = CollectionUtils.intersection(newPairs.keySet(), oldPairs.keySet());
            for (String prop : common) {
                String oldStackVal = (String)oldPairs.get(prop);
                String newStackVal = (String)newPairs.get(prop);
                String savedVal = "";
                if (null != config) {
                    savedVal = config.getProperties().get(prop);
                }
                if (newStackVal == null || oldStackVal == null || newStackVal.equals(savedVal) || oldStackVal.equals(newStackVal) && oldStackVal.equals(savedVal)) continue;
                ThreeWayValue twv = new ThreeWayValue();
                twv.oldStackValue = ConfigMergeHelper.normalizeValue(savedVal, oldStackVal.trim());
                twv.newStackValue = ConfigMergeHelper.normalizeValue(savedVal, newStackVal.trim());
                String string = twv.savedValue = null == savedVal ? null : savedVal.trim();
                if (!result.containsKey(entry.getKey())) {
                    result.put((String)entry.getKey(), new HashMap());
                }
                ((Map)result.get(entry.getKey())).put(prop, twv);
            }
        }
        return result;
    }

    private void addToMap(Map<String, Map<String, String>> map, Set<PropertyInfo> stackProperties) {
        for (PropertyInfo pi : stackProperties) {
            String type = ConfigHelper.fileNameToConfigType(pi.getFilename());
            if (!map.containsKey(type)) {
                map.put(type, new HashMap());
            }
            map.get(type).put(pi.getName(), pi.getValue());
        }
    }

    static String normalizeValue(String templateValue, String newRawValue) {
        if (null == templateValue) {
            return newRawValue;
        }
        Matcher m = HEAP_PATTERN.matcher(templateValue);
        if (m.matches()) {
            return newRawValue + m.group(2);
        }
        return newRawValue;
    }

    public static class ThreeWayValue {
        public String oldStackValue;
        public String newStackValue;
        public String savedValue;
    }
}

