/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.events.ClusterConfigChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.logging.LockFactory;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.StackId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImpl
implements Config {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigImpl.class);
    private static final String PROPERTY_LOCK_LABEL = "configurationPropertyLock";
    public static final String GENERATED_TAG_PREFIX = "generatedTag_";
    private final long configId;
    private final Cluster cluster;
    private final StackId stackId;
    private final String type;
    private final String tag;
    private final Long version;
    private Map<String, String> properties;
    private final ReadWriteLock propertyLock;
    private Map<String, Map<String, String>> propertiesAttributes;
    private Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes;
    private final ClusterDAO clusterDAO;
    private final Gson gson;
    @Inject
    private ServiceConfigDAO serviceConfigDAO;
    private final OBDPEventPublisher eventPublisher;

    @AssistedInject
    ConfigImpl(@Assisted Cluster cluster, @Assisted(value="type") String type, @Assisted(value="tag") @Nullable String tag, @Assisted Map<String, String> properties, @Assisted @Nullable Map<String, Map<String, String>> propertiesAttributes, ClusterDAO clusterDAO, StackDAO stackDAO, Gson gson, OBDPEventPublisher eventPublisher, LockFactory lockFactory, @Named(value="ConfigPropertiesEncryptor") Encryptor<Config> configPropertiesEncryptor) {
        this(cluster.getDesiredStackVersion(), type, cluster, tag, properties, propertiesAttributes, clusterDAO, stackDAO, gson, eventPublisher, lockFactory, true, configPropertiesEncryptor);
    }

    @AssistedInject
    ConfigImpl(@Assisted StackId stackId, @Assisted Cluster cluster, @Assisted(value="type") String type, @Assisted(value="tag") @Nullable String tag, @Assisted Map<String, String> properties, @Assisted @Nullable Map<String, Map<String, String>> propertiesAttributes, ClusterDAO clusterDAO, StackDAO stackDAO, Gson gson, OBDPEventPublisher eventPublisher, LockFactory lockFactory, @Named(value="ConfigPropertiesEncryptor") Encryptor<Config> configPropertiesEncryptor) {
        this(stackId, type, cluster, tag, properties, propertiesAttributes, clusterDAO, stackDAO, gson, eventPublisher, lockFactory, true, configPropertiesEncryptor);
    }

    @AssistedInject
    ConfigImpl(@Assisted @Nullable StackId stackId, @Assisted(value="type") String type, @Assisted Cluster cluster, @Assisted(value="tag") @Nullable String tag, @Assisted Map<String, String> properties, @Assisted @Nullable Map<String, Map<String, String>> propertiesAttributes, ClusterDAO clusterDAO, StackDAO stackDAO, Gson gson, OBDPEventPublisher eventPublisher, LockFactory lockFactory, @Assisted boolean refreshCluster, @Named(value="ConfigPropertiesEncryptor") Encryptor<Config> configPropertiesEncryptor) {
        this.propertyLock = lockFactory.newReadWriteLock(PROPERTY_LOCK_LABEL);
        this.cluster = cluster;
        this.type = type;
        this.properties = properties;
        configPropertiesEncryptor.encryptSensitiveData(this);
        this.propertiesAttributes = null == propertiesAttributes ? null : new HashMap<String, Map<String, String>>(propertiesAttributes);
        this.clusterDAO = clusterDAO;
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.eventPublisher = eventPublisher;
        this.version = cluster.getNextConfigVersion(type);
        this.tag = tag = StringUtils.isBlank((String)tag) ? UUID.randomUUID().toString() : tag;
        ClusterEntity clusterEntity = clusterDAO.findById(cluster.getClusterId());
        StackEntity stackEntity = stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        ClusterConfigEntity entity = new ClusterConfigEntity();
        entity.setClusterEntity(clusterEntity);
        entity.setClusterId(cluster.getClusterId());
        entity.setType(type);
        entity.setVersion(this.version);
        entity.setTag(this.tag);
        entity.setTimestamp(System.currentTimeMillis());
        entity.setStack(stackEntity);
        entity.setData(this.gson.toJson(this.properties));
        if (null != propertiesAttributes) {
            entity.setAttributes(this.gson.toJson(propertiesAttributes));
        }
        this.stackId = stackId;
        this.propertiesTypes = cluster.getConfigPropertiesTypes(type);
        this.persist(entity, refreshCluster);
        this.configId = entity.getConfigId();
        configPropertiesEncryptor.decryptSensitiveData(this);
    }

    @AssistedInject
    ConfigImpl(@Assisted Cluster cluster, @Assisted ClusterConfigEntity entity, ClusterDAO clusterDAO, Gson gson, OBDPEventPublisher eventPublisher, LockFactory lockFactory, @Named(value="ConfigPropertiesEncryptor") Encryptor<Config> configPropertiesEncryptor) {
        this.propertyLock = lockFactory.newReadWriteLock(PROPERTY_LOCK_LABEL);
        this.cluster = cluster;
        this.clusterDAO = clusterDAO;
        this.gson = gson;
        this.eventPublisher = eventPublisher;
        this.configId = entity.getConfigId();
        this.type = entity.getType();
        this.tag = entity.getTag();
        this.version = entity.getVersion();
        this.stackId = new StackId(entity.getStack());
        this.propertiesTypes = cluster.getConfigPropertiesTypes(this.type);
        try {
            HashMap deserializedProperties = (HashMap)gson.fromJson(entity.getData(), Map.class);
            if (null == deserializedProperties) {
                deserializedProperties = new HashMap();
            }
            this.properties = deserializedProperties;
            configPropertiesEncryptor.decryptSensitiveData(this);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Malformed configuration JSON stored in the database for {}/{}", (Object)entity.getType(), (Object)entity.getTag());
        }
        try {
            Map deserializedAttributes = (Map)gson.fromJson(entity.getAttributes(), Map.class);
            if (null != deserializedAttributes) {
                this.propertiesAttributes = new HashMap<String, Map<String, String>>(deserializedAttributes);
            }
        }
        catch (JsonSyntaxException e) {
            LOG.error("Malformed configuration attribute JSON stored in the database for {}/{}", (Object)entity.getType(), (Object)entity.getTag());
        }
    }

    @AssistedInject
    ConfigImpl(@Assisted(value="type") String type, @Assisted(value="tag") @Nullable String tag, @Assisted Map<String, String> properties, @Assisted @Nullable Map<String, Map<String, String>> propertiesAttributes, ClusterDAO clusterDAO, Gson gson, OBDPEventPublisher eventPublisher, LockFactory lockFactory) {
        this.propertyLock = lockFactory.newReadWriteLock(PROPERTY_LOCK_LABEL);
        this.tag = tag;
        this.type = type;
        this.properties = new HashMap<String, String>(properties);
        this.propertiesAttributes = null == propertiesAttributes ? null : new HashMap<String, Map<String, String>>(propertiesAttributes);
        this.clusterDAO = clusterDAO;
        this.gson = gson;
        this.eventPublisher = eventPublisher;
        this.cluster = null;
        this.configId = 0L;
        this.version = 0L;
        this.stackId = null;
    }

    @Override
    public StackId getStackId() {
        return this.stackId;
    }

    @Override
    public Map<PropertyInfo.PropertyType, Set<String>> getPropertiesTypes() {
        return this.propertiesTypes;
    }

    @Override
    public void setPropertiesTypes(Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes) {
        this.propertiesTypes = propertiesTypes;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public Map<String, String> getProperties() {
        this.propertyLock.readLock().lock();
        try {
            HashMap<String, String> hashMap = this.properties == null ? new HashMap<String, String>() : new HashMap<String, String>(this.properties);
            return hashMap;
        }
        finally {
            this.propertyLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, Map<String, String>> getPropertiesAttributes() {
        return null == this.propertiesAttributes ? null : new HashMap<String, Map<String, String>>(this.propertiesAttributes);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.propertyLock.writeLock().lock();
        try {
            this.properties = properties;
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    @Override
    public void setPropertiesAttributes(Map<String, Map<String, String>> propertiesAttributes) {
        this.propertiesAttributes = propertiesAttributes;
    }

    @Override
    public void updateProperties(Map<String, String> propertiesToUpdate) {
        this.propertyLock.writeLock().lock();
        try {
            this.properties.putAll(propertiesToUpdate);
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public List<Long> getServiceConfigVersions() {
        return this.serviceConfigDAO.getServiceConfigVersionsByConfig(this.cluster.getClusterId(), this.type, this.version);
    }

    @Override
    public void deleteProperties(List<String> propertyKeysToRemove) {
        this.propertyLock.writeLock().lock();
        try {
            Set<String> keySet = this.properties.keySet();
            keySet.removeAll(propertyKeysToRemove);
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    private void persist(ClusterConfigEntity entity, boolean refreshCluster) {
        this.persistEntitiesInTransaction(entity);
        this.cluster.addConfig(this);
        if (refreshCluster) {
            this.cluster.refresh();
        }
        ClusterConfigChangedEvent event = new ClusterConfigChangedEvent(this.cluster.getClusterName(), this.getType(), this.getTag(), this.getVersion());
        this.eventPublisher.publish(event);
    }

    @Transactional
    void persistEntitiesInTransaction(ClusterConfigEntity entity) {
        ClusterEntity clusterEntity = entity.getClusterEntity();
        this.clusterDAO.createConfig(entity);
        clusterEntity.getClusterConfigEntities().add(entity);
        clusterEntity = this.clusterDAO.merge(clusterEntity, true);
        LOG.info("Persisted config entity with id {} and cluster entity {}", (Object)entity.getConfigId(), (Object)clusterEntity.toString());
    }

    @Override
    @Transactional
    public void save() {
        ClusterConfigEntity entity = this.clusterDAO.findConfig(this.configId);
        if (null != entity) {
            ClusterEntity clusterEntity = this.clusterDAO.findById(entity.getClusterId());
            LOG.debug("Updating {} version {} with new configurations; a new version will not be created", (Object)this.getType(), (Object)this.getVersion());
            entity.setData(this.gson.toJson(this.getProperties()));
            this.clusterDAO.merge(clusterEntity, true);
            this.cluster.refresh();
            ClusterConfigChangedEvent event = new ClusterConfigChangedEvent(this.cluster.getClusterName(), this.getType(), this.getTag(), this.getVersion());
            this.eventPublisher.publish(event);
        }
    }
}

