/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.MetadataHolder;
import id.onyx.obdp.server.agent.stomp.dto.ClusterConfigs;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.HostComponentUpdate;
import id.onyx.obdp.server.events.HostComponentsUpdateEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostConfig;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RefreshCommandConfiguration;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.UserGroupInfo;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.utils.SecretReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigHelper {
    private Clusters clusters = null;
    private OBDPMetaInfo obdpMetaInfo = null;
    private ClusterDAO clusterDAO = null;
    private static final String DELETED = "DELETED_";
    public static final String CLUSTER_DEFAULT_TAG = "tag";
    private final boolean STALE_CONFIGS_CACHE_ENABLED;
    private final int STALE_CONFIGS_CACHE_EXPIRATION_TIME;
    private final Cache<Integer, Boolean> staleConfigsCache;
    private final Map<Long, Map<Long, Map<String, Map<String, Boolean>>>> stateCache = new HashMap<Long, Map<Long, Map<String, Map<String, Boolean>>>>();
    private final Cache<Integer, String> refreshConfigCommandCache;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHelper.class);
    public static final String HBASE_SITE = "hbase-site";
    public static final String HDFS_SITE = "hdfs-site";
    public static final String HIVE_SITE = "hive-site";
    public static final String YARN_SITE = "yarn-site";
    public static final String CLUSTER_ENV = "cluster-env";
    public static final String CLUSTER_ENV_ALERT_REPEAT_TOLERANCE = "alerts_repeat_tolerance";
    public static final String CLUSTER_ENV_RETRY_ENABLED = "command_retry_enabled";
    public static final String SERVICE_CHECK_TYPE = "service_check_type";
    public static final String CLUSTER_ENV_RETRY_COMMANDS = "commands_to_retry";
    public static final String CLUSTER_ENV_RETRY_MAX_TIME_IN_SEC = "command_retry_max_time_in_sec";
    public static final String COMMAND_RETRY_MAX_TIME_IN_SEC_DEFAULT = "600";
    public static final String CLUSTER_ENV_STACK_NAME_PROPERTY = "stack_name";
    public static final String CLUSTER_ENV_STACK_FEATURES_PROPERTY = "stack_features";
    public static final String CLUSTER_ENV_STACK_TOOLS_PROPERTY = "stack_tools";
    public static final String CLUSTER_ENV_STACK_ROOT_PROPERTY = "stack_root";
    public static final String CLUSTER_ENV_STACK_PACKAGES_PROPERTY = "stack_packages";
    public static final String HTTP_ONLY = "HTTP_ONLY";
    public static final String HTTPS_ONLY = "HTTPS_ONLY";
    public static final String SERVICE_CHECK_MINIMAL = "minimal";
    public static final String FIRST_VERSION_TAG = "version1";
    @Inject
    private Provider<MetadataHolder> m_metadataHolder;
    @Inject
    private Provider<AgentConfigsHolder> m_agentConfigsHolder;
    @Inject
    private Provider<OBDPManagementControllerImpl> m_ambariManagementController;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private ServiceConfigDAO serviceConfigDAO;

    @Inject
    public ConfigHelper(Clusters c, OBDPMetaInfo metaInfo, Configuration configuration, ClusterDAO clusterDAO) {
        this.clusters = c;
        this.obdpMetaInfo = metaInfo;
        this.clusterDAO = clusterDAO;
        this.STALE_CONFIGS_CACHE_ENABLED = configuration.isStaleConfigCacheEnabled();
        this.STALE_CONFIGS_CACHE_EXPIRATION_TIME = configuration.staleConfigCacheExpiration();
        this.staleConfigsCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.STALE_CONFIGS_CACHE_EXPIRATION_TIME, TimeUnit.SECONDS).build();
        this.refreshConfigCommandCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.STALE_CONFIGS_CACHE_EXPIRATION_TIME, TimeUnit.SECONDS).build();
    }

    public Map<String, Map<String, String>> getEffectiveDesiredTags(Cluster cluster, String hostName) throws OBDPException {
        return this.getEffectiveDesiredTags(cluster, hostName, null);
    }

    public Map<String, Map<String, String>> getEffectiveDesiredTags(Cluster cluster, String hostName, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        Host host = null;
        if (hostName != null) {
            try {
                host = this.clusters.getHost(hostName);
            }
            catch (HostNotFoundException e) {
                LOG.error("Cannot get desired config for unknown host {}", (Object)hostName, (Object)e);
            }
        }
        Map<String, HostConfig> desiredHostConfigs = host == null ? null : host.getDesiredHostConfigs(cluster, desiredConfigs);
        return this.getEffectiveDesiredTags(cluster, desiredConfigs, desiredHostConfigs);
    }

    private Map<String, Map<String, String>> getEffectiveDesiredTags(Cluster cluster, Map<String, DesiredConfig> clusterDesired, Map<String, HostConfig> hostConfigOverrides) {
        if (null == cluster) {
            clusterDesired = new HashMap<String, DesiredConfig>();
        }
        if (null == clusterDesired) {
            clusterDesired = cluster.getDesiredConfigs();
        }
        if (null == clusterDesired) {
            clusterDesired = new HashMap<String, DesiredConfig>();
        }
        TreeMap<String, Map<String, String>> resolved = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, DesiredConfig> clusterEntry : clusterDesired.entrySet()) {
            HostConfig hostConfig;
            Config config;
            String type = clusterEntry.getKey();
            String tag = clusterEntry.getValue().getTag();
            if (cluster == null || null == (config = cluster.getConfig(type, tag))) continue;
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put(CLUSTER_DEFAULT_TAG, config.getTag());
            if (hostConfigOverrides != null && (hostConfig = hostConfigOverrides.get(config.getType())) != null) {
                for (Map.Entry<Long, String> tagEntry : hostConfig.getConfigGroupOverrides().entrySet()) {
                    tags.put(tagEntry.getKey().toString(), tagEntry.getValue());
                }
            }
            resolved.put(type, tags);
        }
        return resolved;
    }

    public Set<String> filterInvalidPropertyValues(Map<PropertyInfo, String> properties, String filteredListName) {
        HashSet<String> resultSet = new HashSet<String>();
        Iterator<Map.Entry<PropertyInfo, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PropertyInfo, String> property = iterator.next();
            PropertyInfo propertyInfo = property.getKey();
            String propertyValue = property.getValue();
            if (propertyValue == null || propertyValue.toLowerCase().equals("null") || propertyValue.isEmpty()) {
                LOG.error(String.format("Excluding property %s from %s, because of invalid or empty value!", propertyInfo.getName(), filteredListName));
                iterator.remove();
                continue;
            }
            resultSet.add(propertyValue);
        }
        return resultSet;
    }

    public Map<String, Map<String, String>> getEffectiveConfigProperties(Cluster cluster, Map<String, Map<String, String>> desiredTags) {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        if (desiredTags != null) {
            for (Map.Entry<String, Map<String, String>> entry : desiredTags.entrySet()) {
                HashMap<String, String> tags;
                String clusterTag;
                String type = entry.getKey();
                Map<String, String> propertyMap = (HashMap<String, String>)properties.get(type);
                if (propertyMap == null) {
                    propertyMap = new HashMap<String, String>();
                }
                if ((clusterTag = (String)(tags = new HashMap<String, String>(entry.getValue())).get(CLUSTER_DEFAULT_TAG)) != null) {
                    Config config = cluster.getConfig(type, clusterTag);
                    if (config != null) {
                        propertyMap.putAll(config.getProperties());
                    }
                    tags.remove(CLUSTER_DEFAULT_TAG);
                    for (Map.Entry overrideEntry : tags.entrySet()) {
                        Config overrideConfig = cluster.getConfig(type, (String)overrideEntry.getValue());
                        if (overrideConfig == null) continue;
                        propertyMap = this.getMergedConfig(propertyMap, overrideConfig.getProperties());
                    }
                }
                properties.put(type, propertyMap);
            }
        }
        return properties;
    }

    public Map<String, Map<String, String>> getEffectiveConfigProperties(String clusterName, String hostName) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterName);
        return this.getEffectiveConfigProperties(cluster, this.getEffectiveDesiredTags(cluster, hostName));
    }

    public Map<String, Map<String, Map<String, String>>> getEffectiveConfigAttributes(Cluster cluster, Map<String, Map<String, String>> desiredTags) {
        HashMap<String, Map<String, Map<String, String>>> attributes = new HashMap<String, Map<String, Map<String, String>>>();
        if (desiredTags != null) {
            for (Map.Entry<String, Map<String, String>> entry : desiredTags.entrySet()) {
                String type = entry.getKey();
                TreeMap<String, Map<String, String>> attributesMap = null;
                HashMap<String, String> tags = new HashMap<String, String>(entry.getValue());
                String clusterTag = (String)tags.get(CLUSTER_DEFAULT_TAG);
                if (clusterTag != null) {
                    Config config = cluster.getConfig(type, clusterTag);
                    if (config != null) {
                        attributesMap = new TreeMap<String, Map<String, String>>();
                        this.cloneAttributesMap(config.getPropertiesAttributes(), attributesMap);
                    }
                    tags.remove(CLUSTER_DEFAULT_TAG);
                }
                for (Map.Entry overrideEntry : tags.entrySet()) {
                    Config overrideConfig = cluster.getConfig(type, (String)overrideEntry.getValue());
                    this.overrideAttributes(overrideConfig, attributesMap);
                }
                if (attributesMap == null) continue;
                attributes.put(type, attributesMap);
            }
        }
        return attributes;
    }

    public Map<String, String> getMergedConfig(Map<String, String> persistedClusterConfig, Map<String, String> override) {
        HashMap<String, String> finalConfig = new HashMap<String, String>(persistedClusterConfig);
        if (override != null && override.size() > 0) {
            for (Map.Entry<String, String> entry : override.entrySet()) {
                String nameToUse;
                Boolean deleted = 0 == entry.getKey().indexOf(DELETED);
                String string = nameToUse = deleted != false ? entry.getKey().substring(DELETED.length()) : entry.getKey();
                if (finalConfig.containsKey(nameToUse)) {
                    finalConfig.remove(nameToUse);
                }
                if (deleted.booleanValue()) continue;
                finalConfig.put(nameToUse, entry.getValue());
            }
        }
        return finalConfig;
    }

    public void getAndMergeHostConfigs(Map<String, Map<String, String>> configurations, Map<String, Map<String, String>> configurationTags, Cluster cluster) {
        if (null != configurationTags && !configurationTags.isEmpty()) {
            Map<String, Map<String, String>> configProperties = this.getEffectiveConfigProperties(cluster, configurationTags);
            for (Map.Entry<String, Map<String, String>> entry : configProperties.entrySet()) {
                String type = entry.getKey();
                Map<String, String> allLevelMergedConfig = entry.getValue();
                if (configurations.containsKey(type)) {
                    Map<String, String> mergedConfig = this.getMergedConfig(allLevelMergedConfig, configurations.get(type));
                    configurations.get(type).clear();
                    configurations.get(type).putAll(mergedConfig);
                    continue;
                }
                configurations.put(type, new HashMap());
                configurations.get(type).putAll(allLevelMergedConfig);
            }
        }
    }

    public void getAndMergeHostConfigAttributes(Map<String, Map<String, Map<String, String>>> configurationAttributes, Map<String, Map<String, String>> configurationTags, Cluster cluster) {
        if (null != configurationTags && !configurationTags.isEmpty()) {
            Map<String, Map<String, Map<String, String>>> configAttributes = this.getEffectiveConfigAttributes(cluster, configurationTags);
            for (Map.Entry<String, Map<String, Map<String, String>>> attributesOccurrence : configAttributes.entrySet()) {
                String type = attributesOccurrence.getKey();
                Map<String, Map<String, String>> attributes = attributesOccurrence.getValue();
                if (configurationAttributes == null) continue;
                if (!configurationAttributes.containsKey(type)) {
                    configurationAttributes.put(type, new TreeMap());
                }
                this.cloneAttributesMap(attributes, configurationAttributes.get(type));
            }
        }
    }

    public Map<String, Map<String, String>> overrideAttributes(Config overrideConfig, Map<String, Map<String, String>> persistedAttributes) {
        Map<String, Map<String, String>> overrideAttributes;
        if (overrideConfig != null && persistedAttributes != null && (overrideAttributes = overrideConfig.getPropertiesAttributes()) != null) {
            this.cloneAttributesMap(overrideAttributes, persistedAttributes);
            Map<String, String> overrideProperties = overrideConfig.getProperties();
            if (overrideProperties != null) {
                Set<String> overriddenProperties = overrideProperties.keySet();
                for (String overriddenProperty : overriddenProperties) {
                    for (Map.Entry<String, Map<String, String>> persistedAttribute : persistedAttributes.entrySet()) {
                        String attributeName = persistedAttribute.getKey();
                        Map<String, String> persistedAttributeValues = persistedAttribute.getValue();
                        Map<String, String> overrideAttributeValues = overrideAttributes.get(attributeName);
                        if (overrideAttributeValues != null && overrideAttributeValues.containsKey(overriddenProperty)) continue;
                        persistedAttributeValues.remove(overriddenProperty);
                    }
                }
            }
        }
        return persistedAttributes;
    }

    public void cloneAttributesMap(Map<String, Map<String, String>> sourceAttributesMap, Map<String, Map<String, String>> targetAttributesMap) {
        if (sourceAttributesMap != null && targetAttributesMap != null) {
            for (Map.Entry<String, Map<String, String>> attributesEntry : sourceAttributesMap.entrySet()) {
                String attributeName = attributesEntry.getKey();
                if (!targetAttributesMap.containsKey(attributeName)) {
                    targetAttributesMap.put(attributeName, new TreeMap());
                }
                for (Map.Entry<String, String> attributesValue : attributesEntry.getValue().entrySet()) {
                    targetAttributesMap.get(attributeName).put(attributesValue.getKey(), attributesValue.getValue());
                }
            }
        }
    }

    public void applyCustomConfig(Map<String, Map<String, String>> configurations, String type, String name, String value, Boolean deleted) {
        if (!configurations.containsKey(type)) {
            configurations.put(type, new HashMap());
        }
        Object nameToUse = deleted != false ? DELETED + name : name;
        Map<String, String> properties = configurations.get(type);
        if (properties.containsKey(nameToUse)) {
            properties.remove(nameToUse);
        }
        properties.put((String)nameToUse, value);
    }

    public boolean isStaleConfigs(ServiceComponentHost sch, Map<String, DesiredConfig> requestDesiredConfigs) throws OBDPException {
        HostComponentDesiredStateEntity hostComponentDesiredStateEntity = sch.getDesiredStateEntity();
        return this.isStaleConfigs(sch, requestDesiredConfigs, hostComponentDesiredStateEntity);
    }

    public boolean isStaleConfigs(ServiceComponentHost sch, Map<String, DesiredConfig> requestDesiredConfigs, HostComponentDesiredStateEntity hostComponentDesiredStateEntity) throws OBDPException {
        boolean stale = this.calculateIsStaleConfigs(sch, requestDesiredConfigs, hostComponentDesiredStateEntity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache configuration staleness for host {} and component {} as {}", new Object[]{sch.getHostName(), sch.getServiceComponentName(), stale});
        }
        return stale;
    }

    @Transactional
    public void removeConfigsByType(Cluster cluster, String type) {
        Set<String> globalVersions = cluster.getConfigsByType(type).keySet();
        for (String version : globalVersions) {
            ClusterConfigEntity clusterConfigEntity = this.clusterDAO.findConfig((Long)cluster.getClusterId(), type, version);
            this.clusterDAO.removeConfig(clusterConfigEntity);
        }
    }

    public Set<String> findConfigTypesByPropertyName(StackId stackId, String propertyName, String clusterName) throws OBDPException {
        StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        HashSet<String> result = new HashSet<String>();
        for (Service service : this.clusters.getCluster(clusterName).getServices().values()) {
            Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getServiceProperties(stack.getName(), stack.getVersion(), service.getName());
            Set<PropertyInfo> stackLevelProperties = this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion());
            stackProperties.addAll(stackLevelProperties);
            for (PropertyInfo stackProperty : stackProperties) {
                if (!stackProperty.getName().equals(propertyName)) continue;
                String configType = ConfigHelper.fileNameToConfigType(stackProperty.getFilename());
                result.add(configType);
            }
        }
        return result;
    }

    public Map<String, Map<String, String>> getCredentialStoreEnabledProperties(StackId stackId, Service service) throws OBDPException {
        PropertyInfo.PropertyType propertyType = PropertyInfo.PropertyType.PASSWORD;
        StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Set<PropertyInfo> serviceProperties = this.obdpMetaInfo.getServiceProperties(stack.getName(), stack.getVersion(), service.getName());
        for (PropertyInfo serviceProperty : serviceProperties) {
            if (!serviceProperty.getPropertyTypes().contains((Object)propertyType) || !serviceProperty.getPropertyValueAttributes().isKeyStore()) continue;
            String stackPropertyConfigType = ConfigHelper.fileNameToConfigType(serviceProperty.getFilename());
            HashMap<String, String> passwordProperties = (HashMap<String, String>)result.get(stackPropertyConfigType);
            if (passwordProperties == null) {
                passwordProperties = new HashMap<String, String>();
                result.put(stackPropertyConfigType, passwordProperties);
            }
            if (serviceProperty.getUsedByProperties().size() > 0) {
                for (PropertyDependencyInfo usedByProperty : serviceProperty.getUsedByProperties()) {
                    Object propertyName = usedByProperty.getName();
                    if (!StringUtils.isEmpty((String)usedByProperty.getType())) {
                        propertyName = (String)propertyName + ":" + usedByProperty.getType();
                    }
                    passwordProperties.put((String)propertyName, serviceProperty.getName());
                }
                continue;
            }
            passwordProperties.put(serviceProperty.getName(), serviceProperty.getName());
        }
        return result;
    }

    public Map<String, Set<String>> createUserGroupsMap(StackId stackId, Cluster cluster, Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        Map<String, ServiceInfo> servicesMap = this.obdpMetaInfo.getServices(stack.getName(), stack.getVersion());
        Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion());
        return this.createUserGroupsMap(cluster, desiredConfigs, servicesMap, stackProperties);
    }

    public Map<String, Set<String>> createUserGroupsMap(Cluster cluster, Map<String, DesiredConfig> desiredConfigs, Map<String, ServiceInfo> servicesMap, Set<PropertyInfo> stackProperties) throws OBDPException {
        HashMap<String, Set<String>> userGroupsMap = new HashMap<String, Set<String>>();
        Map<PropertyInfo, String> userProperties = this.getPropertiesWithPropertyType(PropertyInfo.PropertyType.USER, cluster, desiredConfigs, servicesMap, stackProperties);
        Map<PropertyInfo, String> groupProperties = this.getPropertiesWithPropertyType(PropertyInfo.PropertyType.GROUP, cluster, desiredConfigs, servicesMap, stackProperties);
        if (userProperties != null && groupProperties != null) {
            for (Map.Entry<PropertyInfo, String> userProperty : userProperties.entrySet()) {
                PropertyInfo userPropertyInfo = userProperty.getKey();
                String userPropertyValue = userProperty.getValue();
                if (userPropertyInfo.getPropertyValueAttributes() == null || userPropertyInfo.getPropertyValueAttributes().getUserGroupEntries() == null) continue;
                HashSet<String> groupPropertyValues = new HashSet<String>();
                Collection<UserGroupInfo> userGroupEntries = userPropertyInfo.getPropertyValueAttributes().getUserGroupEntries();
                for (UserGroupInfo userGroupInfo : userGroupEntries) {
                    boolean found = false;
                    for (Map.Entry<PropertyInfo, String> groupProperty : groupProperties.entrySet()) {
                        PropertyInfo groupPropertyInfo = groupProperty.getKey();
                        String groupPropertyValue = groupProperty.getValue();
                        if (!StringUtils.equals((String)userGroupInfo.getType(), (String)ConfigHelper.fileNameToConfigType(groupPropertyInfo.getFilename())) || !StringUtils.equals((String)userGroupInfo.getName(), (String)groupPropertyInfo.getName())) continue;
                        groupPropertyValues.add(groupPropertyValue);
                        found = true;
                    }
                    if (found) continue;
                    LOG.error("User group mapping property {" + userGroupInfo.getType() + "/" + userGroupInfo.getName() + "} is missing for user property {" + ConfigHelper.fileNameToConfigType(userPropertyInfo.getFilename()) + "/" + userPropertyInfo.getName() + "} (username = " + userPropertyInfo.getValue() + ")");
                }
                userGroupsMap.put(userPropertyValue, groupPropertyValues);
            }
        }
        return userGroupsMap;
    }

    public Map<PropertyInfo, String> getPropertiesWithPropertyType(StackId stackId, PropertyInfo.PropertyType propertyType, Cluster cluster, Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        Map<String, ServiceInfo> servicesMap = this.obdpMetaInfo.getServices(stack.getName(), stack.getVersion());
        Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion());
        return this.getPropertiesWithPropertyType(propertyType, cluster, desiredConfigs, servicesMap, stackProperties);
    }

    public Map<PropertyInfo, String> getPropertiesWithPropertyType(PropertyInfo.PropertyType propertyType, Cluster cluster, Map<String, DesiredConfig> desiredConfigs, Map<String, ServiceInfo> servicesMap, Set<PropertyInfo> stackProperties) throws OBDPException {
        HashMap<String, Config> actualConfigs = new HashMap<String, Config>();
        HashMap<PropertyInfo, String> result = new HashMap<PropertyInfo, String>();
        for (Map.Entry<String, DesiredConfig> desiredConfigEntry : desiredConfigs.entrySet()) {
            String configType = desiredConfigEntry.getKey();
            DesiredConfig desiredConfig = desiredConfigEntry.getValue();
            actualConfigs.put(configType, cluster.getConfig(configType, desiredConfig.getTag()));
        }
        for (Service service : cluster.getServices().values()) {
            ServiceInfo serviceInfo = servicesMap.get(service.getName());
            if (serviceInfo == null) continue;
            HashSet<PropertyInfo> serviceProperties = new HashSet<PropertyInfo>(serviceInfo.getProperties());
            for (PropertyInfo serviceProperty : serviceProperties) {
                if (!serviceProperty.getPropertyTypes().contains((Object)propertyType)) continue;
                String stackPropertyConfigType = ConfigHelper.fileNameToConfigType(serviceProperty.getFilename());
                try {
                    String property = ((Config)actualConfigs.get(stackPropertyConfigType)).getProperties().get(serviceProperty.getName());
                    if (null == property) {
                        LOG.error(String.format("Unable to obtain property values for %s with property attribute %s. The property does not exist in version %s of %s configuration.", new Object[]{serviceProperty.getName(), propertyType, desiredConfigs.get(stackPropertyConfigType), stackPropertyConfigType}));
                        continue;
                    }
                    result.put(serviceProperty, property);
                }
                catch (Exception exception) {}
            }
        }
        for (PropertyInfo stackProperty : stackProperties) {
            String stackPropertyConfigType;
            if (!stackProperty.getPropertyTypes().contains((Object)propertyType) || !actualConfigs.containsKey(stackPropertyConfigType = ConfigHelper.fileNameToConfigType(stackProperty.getFilename()))) continue;
            result.put(stackProperty, ((Config)actualConfigs.get(stackPropertyConfigType)).getProperties().get(stackProperty.getName()));
        }
        return result;
    }

    public Set<String> getPropertyValuesWithPropertyType(StackId stackId, PropertyInfo.PropertyType propertyType, Cluster cluster, Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        Map<String, ServiceInfo> servicesMap = this.obdpMetaInfo.getServices(stack.getName(), stack.getVersion());
        Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion());
        return this.getPropertyValuesWithPropertyType(propertyType, cluster, desiredConfigs, servicesMap, stackProperties);
    }

    public Set<String> getPropertyValuesWithPropertyType(PropertyInfo.PropertyType propertyType, Cluster cluster, Map<String, DesiredConfig> desiredConfigs, Map<String, ServiceInfo> servicesMap, Set<PropertyInfo> stackProperties) throws OBDPException {
        HashMap<String, Config> actualConfigs = new HashMap<String, Config>();
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, DesiredConfig> desiredConfigEntry : desiredConfigs.entrySet()) {
            String configType = desiredConfigEntry.getKey();
            DesiredConfig desiredConfig = desiredConfigEntry.getValue();
            actualConfigs.put(configType, cluster.getConfig(configType, desiredConfig.getTag()));
        }
        for (Service service : cluster.getServices().values()) {
            if (!servicesMap.containsKey(service.getName())) continue;
            HashSet<PropertyInfo> serviceProperties = new HashSet<PropertyInfo>(servicesMap.get(service.getName()).getProperties());
            for (PropertyInfo serviceProperty : serviceProperties) {
                if (!serviceProperty.getPropertyTypes().contains((Object)propertyType)) continue;
                String stackPropertyConfigType = ConfigHelper.fileNameToConfigType(serviceProperty.getFilename());
                try {
                    String property = ((Config)actualConfigs.get(stackPropertyConfigType)).getProperties().get(serviceProperty.getName());
                    if (null == property) {
                        LOG.error(String.format("Unable to obtain property values for %s with property attribute %s. The property does not exist in version %s of %s configuration.", new Object[]{serviceProperty.getName(), propertyType, desiredConfigs.get(stackPropertyConfigType), stackPropertyConfigType}));
                        continue;
                    }
                    result.add(property);
                }
                catch (Exception exception) {}
            }
        }
        for (PropertyInfo stackProperty : stackProperties) {
            String stackPropertyConfigType;
            if (!stackProperty.getPropertyTypes().contains((Object)propertyType) || !actualConfigs.containsKey(stackPropertyConfigType = ConfigHelper.fileNameToConfigType(stackProperty.getFilename()))) continue;
            result.add(((Config)actualConfigs.get(stackPropertyConfigType)).getProperties().get(stackProperty.getName()));
        }
        return result;
    }

    public void checkAllStageConfigsPresentInDesiredConfigs(Cluster cluster) throws OBDPException {
        StackId stackId = cluster.getDesiredStackVersion();
        Set<String> stackConfigTypes = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion()).getConfigTypeAttributes().keySet();
        HashMap<String, Config> actualConfigs = new HashMap<String, Config>();
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        for (Map.Entry<String, DesiredConfig> desiredConfigEntry : desiredConfigs.entrySet()) {
            String configType = desiredConfigEntry.getKey();
            DesiredConfig desiredConfig = desiredConfigEntry.getValue();
            actualConfigs.put(configType, cluster.getConfig(configType, desiredConfig.getTag()));
        }
        for (String stackConfigType : stackConfigTypes) {
            if (actualConfigs.containsKey(stackConfigType)) continue;
            LOG.error(String.format("Unable to find stack configuration %s in ambari configs!", stackConfigType));
        }
    }

    public String getPropertyValueFromStackDefinitions(Cluster cluster, String configType, String propertyName) throws OBDPException {
        HashSet<StackId> stackIds = new HashSet<StackId>();
        for (Service service : cluster.getServices().values()) {
            stackIds.add(service.getDesiredStackId());
        }
        for (StackId stackId : stackIds) {
            StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            for (ServiceInfo serviceInfo : stack.getServices()) {
                Set<PropertyInfo> serviceProperties = this.obdpMetaInfo.getServiceProperties(stack.getName(), stack.getVersion(), serviceInfo.getName());
                Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion());
                serviceProperties.addAll(stackProperties);
                for (PropertyInfo stackProperty : serviceProperties) {
                    String stackPropertyConfigType = ConfigHelper.fileNameToConfigType(stackProperty.getFilename());
                    if (!stackProperty.getName().equals(propertyName) || !stackPropertyConfigType.equals(configType)) continue;
                    return stackProperty.getValue();
                }
            }
        }
        return null;
    }

    public String getPlaceholderValueFromDesiredConfigurations(Cluster cluster, String placeholder) {
        String propertyName;
        int delimiterPosition;
        if (placeholder.startsWith("{{") && placeholder.endsWith("}}")) {
            placeholder = placeholder.substring(2, placeholder.length() - 2).trim();
        }
        if ((delimiterPosition = placeholder.indexOf("/")) < 0) {
            return placeholder;
        }
        String configType = placeholder.substring(0, delimiterPosition);
        String value = this.getValueFromDesiredConfigurations(cluster, configType, propertyName = placeholder.substring(delimiterPosition + 1, placeholder.length()));
        return value != null ? value : placeholder;
    }

    public String getValueFromDesiredConfigurations(Cluster cluster, String configType, String propertyName) {
        String value;
        Config config;
        Map<String, String> configurationProperties;
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (desiredConfig != null && null != (configurationProperties = (config = cluster.getConfig(configType, desiredConfig.getTag())).getProperties()) && null != (value = configurationProperties.get(propertyName))) {
            return value;
        }
        return null;
    }

    public ServiceInfo getPropertyOwnerService(Cluster cluster, String configType, String propertyName) throws OBDPException {
        for (Service service : cluster.getServices().values()) {
            StackId stackId = service.getDesiredStackId();
            StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            for (ServiceInfo serviceInfo : stack.getServices()) {
                Set<PropertyInfo> serviceProperties = this.obdpMetaInfo.getServiceProperties(stack.getName(), stack.getVersion(), serviceInfo.getName());
                for (PropertyInfo stackProperty : serviceProperties) {
                    String stackPropertyConfigType = ConfigHelper.fileNameToConfigType(stackProperty.getFilename());
                    if (!stackProperty.getName().equals(propertyName) || !stackPropertyConfigType.equals(configType)) continue;
                    return serviceInfo;
                }
            }
        }
        return null;
    }

    public Set<PropertyInfo> getServiceProperties(Cluster cluster, String serviceName) throws OBDPException {
        Service service = cluster.getService(serviceName);
        return this.getServiceProperties(service.getDesiredStackId(), serviceName, false);
    }

    public Set<PropertyInfo> getServiceProperties(StackId stackId, String serviceName, boolean removeExcluded) throws OBDPException {
        Set<String> excludedConfigTypes;
        ServiceInfo service = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        HashSet<PropertyInfo> properties = new HashSet<PropertyInfo>(service.getProperties());
        if (removeExcluded && (excludedConfigTypes = service.getExcludedConfigTypes()) != null && !excludedConfigTypes.isEmpty()) {
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                PropertyInfo propertyInfo = (PropertyInfo)iterator.next();
                if (!excludedConfigTypes.contains(ConfigHelper.fileNameToConfigType(propertyInfo.getFilename()))) continue;
                iterator.remove();
            }
        }
        return properties;
    }

    public Set<PropertyInfo> getStackProperties(Cluster cluster) throws OBDPException {
        HashSet<StackId> stackIds = new HashSet<StackId>();
        for (Service service : cluster.getServices().values()) {
            stackIds.add(service.getDesiredStackId());
        }
        HashSet<PropertyInfo> propertySets = new HashSet<PropertyInfo>();
        for (StackId stackId : stackIds) {
            StackInfo stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            propertySets.addAll(this.obdpMetaInfo.getStackProperties(stack.getName(), stack.getVersion()));
        }
        return propertySets;
    }

    public void updateConfigType(Cluster cluster, StackId stackId, OBDPManagementController controller, String configType, Map<String, String> updates, Collection<String> removals, String authenticatedUserName, String serviceVersionNote) throws OBDPException {
        this.updateConfigType(cluster, stackId, controller, configType, updates, removals, authenticatedUserName, serviceVersionNote, null, true);
    }

    public void updateBulkConfigType(Cluster cluster, StackId stackId, OBDPManagementController controller, Iterable<String> configTypes, Map<String, Map<String, String>> updates, Map<String, Collection<String>> removals, String authenticatedUserName, String serviceVersionNote) throws OBDPException, OBDPRuntimeException {
        Map<String, DesiredConfig> desiredConfig = cluster.getDesiredConfigs();
        Boolean[] doUpdateAgentConfigs = new Boolean[]{false};
        LOG.info("Bulk config update. Starting...");
        configTypes.forEach(configType -> {
            try {
                Boolean updated = this.updateConfigType(cluster, stackId, controller, (String)configType, (Map)updates.get(configType), (Collection)removals.get(configType), authenticatedUserName, serviceVersionNote, desiredConfig, false);
                LOG.info("Bulk config update. Working with {}...{}", configType, (Object)(updated != false ? "updated" : "not updated"));
                doUpdateAgentConfigs[0] = doUpdateAgentConfigs[0] != false || updated != false;
            }
            catch (OBDPException e) {
                throw new OBDPRuntimeException(e);
            }
        });
        LOG.info("Bulk config update, agent update is {} required", (Object)(doUpdateAgentConfigs[0] != false ? "" : "not"));
        if (doUpdateAgentConfigs[0].booleanValue()) {
            this.updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
        }
    }

    public Boolean updateConfigType(Cluster cluster, StackId stackId, OBDPManagementController controller, String configType, Map<String, String> updates, Collection<String> removals, String authenticatedUserName, String serviceVersionNote, @Nullable Map<String, DesiredConfig> desiredConfig, Boolean doUpdateAgentConfigs) throws OBDPException {
        Map<String, String> oldConfigProperties;
        if (configType == null || (updates == null || updates.isEmpty()) && (removals == null || removals.isEmpty())) {
            return false;
        }
        Config oldConfig = desiredConfig != null && desiredConfig.containsKey(configType) ? cluster.getConfig(configType, desiredConfig.get(configType).getTag()) : cluster.getDesiredConfigByType(configType);
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, Map<String, String>> propertiesAttributes = new HashMap<String, Map<String, String>>();
        if (oldConfig == null) {
            oldConfigProperties = null;
        } else {
            oldConfigProperties = oldConfig.getProperties();
            if (oldConfigProperties != null) {
                properties.putAll(oldConfigProperties);
            }
            if (oldConfig.getPropertiesAttributes() != null) {
                propertiesAttributes.putAll(oldConfig.getPropertiesAttributes());
            }
        }
        if (updates != null) {
            properties.putAll(updates);
        }
        if (removals != null) {
            for (String propertyName : removals) {
                properties.remove(propertyName);
                for (Map attributesMap : propertiesAttributes.values()) {
                    attributesMap.remove(propertyName);
                }
            }
        }
        if ((oldConfigProperties == null || !Maps.difference(oldConfigProperties, properties).areEqual()) && this.createConfigType(cluster, stackId, controller, configType, properties, propertiesAttributes, authenticatedUserName, serviceVersionNote)) {
            if (doUpdateAgentConfigs.booleanValue()) {
                this.updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
            }
            return true;
        }
        return false;
    }

    public void createConfigType(Cluster cluster, StackId stackId, OBDPManagementController controller, String configType, Map<String, String> properties, String authenticatedUserName, String serviceVersionNote) throws OBDPException {
        if (this.createConfigType(cluster, stackId, controller, configType, properties, new HashMap<String, Map<String, String>>(), authenticatedUserName, serviceVersionNote)) {
            this.updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
        }
    }

    public boolean createConfigType(Cluster cluster, StackId stackId, OBDPManagementController controller, String configType, Map<String, String> properties, Map<String, Map<String, String>> propertyAttributes, String authenticatedUserName, String serviceVersionNote) throws OBDPException {
        Config baseConfig = this.createConfig(cluster, stackId, controller, configType, FIRST_VERSION_TAG, properties, propertyAttributes);
        if (baseConfig != null) {
            cluster.addDesiredConfig(authenticatedUserName, Collections.singleton(baseConfig), serviceVersionNote);
            return true;
        }
        return false;
    }

    public boolean createConfigTypes(Cluster cluster, StackId stackId, OBDPManagementController controller, Map<String, Map<String, String>> batchProperties, String authenticatedUserName, String serviceVersionNote) throws OBDPException {
        HashMap serviceMapped = new HashMap();
        for (Map.Entry<String, Map<String, String>> entry : batchProperties.entrySet()) {
            Map<String, String> properties;
            String type = entry.getKey();
            Config baseConfig = this.createConfig(cluster, stackId, controller, type, FIRST_VERSION_TAG, properties = entry.getValue(), Collections.emptyMap());
            if (null == baseConfig) continue;
            try {
                String service = cluster.getServiceByConfigType(type);
                if (!serviceMapped.containsKey(service)) {
                    serviceMapped.put(service, new HashSet());
                }
                ((Set)serviceMapped.get(service)).add(baseConfig);
            }
            catch (Exception exception) {}
        }
        boolean added = false;
        for (Set configs : serviceMapped.values()) {
            if (configs.isEmpty()) continue;
            cluster.addDesiredConfig(authenticatedUserName, configs, serviceVersionNote);
            added = true;
        }
        return added;
    }

    Config createConfig(Cluster cluster, StackId stackId, OBDPManagementController controller, String type, String tag, Map<String, String> properties, Map<String, Map<String, String>> propertyAttributes) throws OBDPException {
        Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes;
        if (cluster.getConfigsByType(type) != null) {
            tag = "version" + System.currentTimeMillis();
        }
        if ((propertiesTypes = cluster.getConfigPropertiesTypes(type)).containsKey((Object)PropertyInfo.PropertyType.PASSWORD)) {
            for (String passwordProperty : propertiesTypes.get((Object)PropertyInfo.PropertyType.PASSWORD)) {
                String passwordPropertyValue;
                if (!properties.containsKey(passwordProperty) || !SecretReference.isSecret(passwordPropertyValue = properties.get(passwordProperty))) continue;
                SecretReference ref = new SecretReference(passwordPropertyValue, cluster);
                String refValue = ref.getValue();
                properties.put(passwordProperty, refValue);
            }
        }
        return controller.createConfig(cluster, stackId, type, properties, (String)tag, propertyAttributes);
    }

    public Map<String, Map<String, String>> getDefaultStackProperties(StackId stack) throws OBDPException {
        HashMap<String, Map<String, String>> defaultPropertiesByType = new HashMap<String, Map<String, String>>();
        Set<PropertyInfo> stackConfigurationProperties = this.obdpMetaInfo.getStackProperties(stack.getStackName(), stack.getStackVersion());
        for (PropertyInfo stackDefaultProperty : stackConfigurationProperties) {
            String type = ConfigHelper.fileNameToConfigType(stackDefaultProperty.getFilename());
            if (!defaultPropertiesByType.containsKey(type)) {
                defaultPropertiesByType.put(type, new HashMap());
            }
            ((Map)defaultPropertiesByType.get(type)).put(stackDefaultProperty.getName(), stackDefaultProperty.getValue());
        }
        return defaultPropertiesByType;
    }

    public Map<String, Map<String, String>> getDefaultProperties(StackId stack, String serviceName) throws OBDPException {
        HashMap<String, Map<String, String>> defaultPropertiesByType = new HashMap<String, Map<String, String>>();
        Set<PropertyInfo> stackConfigurationProperties = this.obdpMetaInfo.getStackProperties(stack.getStackName(), stack.getStackVersion());
        for (PropertyInfo stackDefaultProperty : stackConfigurationProperties) {
            String type = ConfigHelper.fileNameToConfigType(stackDefaultProperty.getFilename());
            if (!defaultPropertiesByType.containsKey(type)) {
                defaultPropertiesByType.put(type, new HashMap());
            }
            ((Map)defaultPropertiesByType.get(type)).put(stackDefaultProperty.getName(), stackDefaultProperty.getValue());
        }
        Set<PropertyInfo> serviceConfigurationProperties = this.obdpMetaInfo.getServiceProperties(stack.getStackName(), stack.getStackVersion(), serviceName);
        for (PropertyInfo serviceDefaultProperty : serviceConfigurationProperties) {
            String type = ConfigHelper.fileNameToConfigType(serviceDefaultProperty.getFilename());
            if (!defaultPropertiesByType.containsKey(type)) {
                defaultPropertiesByType.put(type, new HashMap());
            }
            ((Map)defaultPropertiesByType.get(type)).put(serviceDefaultProperty.getName(), serviceDefaultProperty.getValue());
        }
        return defaultPropertiesByType;
    }

    private boolean calculateIsStaleConfigs(ServiceComponentHost sch, Map<String, DesiredConfig> desiredConfigs, HostComponentDesiredStateEntity hostComponentDesiredStateEntity) throws OBDPException {
        if (sch.isRestartRequired(hostComponentDesiredStateEntity)) {
            return true;
        }
        Map<String, HostConfig> actual = sch.getActualConfigs();
        if (null == actual || actual.isEmpty()) {
            return false;
        }
        Cluster cluster = this.clusters.getClusterById(sch.getClusterId());
        Map<String, Map<String, String>> desired = this.getEffectiveDesiredTags(cluster, sch.getHostName(), desiredConfigs);
        Boolean stale = null;
        int staleHash = 0;
        if (this.STALE_CONFIGS_CACHE_ENABLED && (stale = (Boolean)this.staleConfigsCache.getIfPresent((Object)(staleHash = Objects.hashCode((Object[])new Object[]{actual.hashCode(), desired.hashCode(), sch.getHostName(), sch.getServiceComponentName(), sch.getServiceName()})))) != null) {
            return stale;
        }
        stale = false;
        StackId stackId = sch.getServiceComponent().getDesiredStackId();
        StackInfo stackInfo = this.obdpMetaInfo.getStack(stackId);
        ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), sch.getServiceName());
        ComponentInfo componentInfo = serviceInfo.getComponentByName(sch.getServiceComponentName());
        Iterator<Map.Entry<String, Map<String, String>>> it = desired.entrySet().iterator();
        LinkedList<String> changedProperties = new LinkedList<String>();
        while (it.hasNext()) {
            boolean staleEntry = false;
            Map.Entry<String, Map<String, String>> desiredEntry = it.next();
            String type = desiredEntry.getKey();
            Map<String, String> tags = desiredEntry.getValue();
            if (!actual.containsKey(type)) {
                staleEntry = serviceInfo.hasConfigDependency(type) || componentInfo.hasConfigType(type);
            } else {
                HostConfig hc = actual.get(type);
                Map<String, String> actualTags = this.buildTags(hc);
                if (!this.isTagChanged(tags, actualTags, this.hasGroupSpecificConfigsForType(cluster, sch.getHostName(), type))) {
                    staleEntry = false;
                } else {
                    boolean bl = staleEntry = serviceInfo.hasConfigDependency(type) || componentInfo.hasConfigType(type);
                    if (staleEntry) {
                        Collection<String> changedKeys = this.findChangedKeys(cluster, type, tags.values(), actualTags.values());
                        changedProperties.addAll(changedKeys);
                    }
                }
            }
            stale = stale | staleEntry;
        }
        String refreshCommand = this.calculateRefreshCommand(stackInfo.getRefreshCommandConfiguration(), sch, changedProperties);
        if (this.STALE_CONFIGS_CACHE_ENABLED) {
            this.staleConfigsCache.put((Object)staleHash, (Object)stale);
            if (refreshCommand != null) {
                this.refreshConfigCommandCache.put((Object)staleHash, (Object)refreshCommand);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changed properties {} ({}) {} :  COMMAND: {}", new Object[]{stale, sch.getServiceComponentName(), sch.getHostName(), refreshCommand});
            for (String p : changedProperties) {
                LOG.debug(p);
            }
        }
        return stale;
    }

    public void updateAgentConfigs(Set<String> updatedClusters) throws OBDPException {
        ArrayList<Cluster> clustersInUse = new ArrayList<Cluster>();
        for (String clusterName : updatedClusters) {
            Cluster cluster = this.clusters.getCluster(clusterName);
            clustersInUse.add(cluster);
        }
        HashMap<Long, AgentConfigsUpdateEvent> currentConfigEvents = new HashMap<Long, AgentConfigsUpdateEvent>();
        HashMap<Long, AgentConfigsUpdateEvent> previousConfigEvents = new HashMap<Long, AgentConfigsUpdateEvent>();
        for (Cluster cluster : clustersInUse) {
            for (Host host : cluster.getHosts()) {
                Long hostId = host.getHostId();
                if (!currentConfigEvents.containsKey(hostId)) {
                    currentConfigEvents.put(host.getHostId(), ((AgentConfigsHolder)this.m_agentConfigsHolder.get()).getCurrentData(hostId));
                }
                if (previousConfigEvents.containsKey(host.getHostId())) continue;
                previousConfigEvents.put(host.getHostId(), (AgentConfigsUpdateEvent)((AgentConfigsHolder)this.m_agentConfigsHolder.get()).initializeDataIfNeeded(hostId, true));
            }
        }
        for (Cluster cluster : clustersInUse) {
            HashMap<Long, Map<String, Collection<String>>> changedConfigs = new HashMap<Long, Map<String, Collection<String>>>();
            for (Host host : cluster.getHosts()) {
                AgentConfigsUpdateEvent currentConfigData = (AgentConfigsUpdateEvent)currentConfigEvents.get(host.getHostId());
                AgentConfigsUpdateEvent previousConfigsData = (AgentConfigsUpdateEvent)previousConfigEvents.get(host.getHostId());
                SortedMap<String, SortedMap<String, String>> currentConfigs = ((ClusterConfigs)currentConfigData.getClustersConfigs().get(Long.toString(cluster.getClusterId()))).getConfigurations();
                SortedMap<String, SortedMap<String, String>> previousConfigs = ((ClusterConfigs)previousConfigsData.getClustersConfigs().get(Long.toString(cluster.getClusterId()))).getConfigurations();
                HashMap<String, Set<Object>> changedConfigsHost = new HashMap<String, Set<Object>>();
                for (String currentConfigType : currentConfigs.keySet()) {
                    if (previousConfigs.containsKey(currentConfigType)) {
                        HashSet<String> changedKeys = new HashSet<String>();
                        Map currentTypedConfigs = (Map)currentConfigs.get(currentConfigType);
                        Map previousTypedConfigs = (Map)previousConfigs.get(currentConfigType);
                        for (String currentKey : currentTypedConfigs.keySet()) {
                            if (previousTypedConfigs.containsKey(currentKey) && ((String)currentTypedConfigs.get(currentKey)).equals(previousTypedConfigs.get(currentKey))) continue;
                            changedKeys.add(currentKey);
                        }
                        for (String previousKey : previousTypedConfigs.keySet()) {
                            if (currentTypedConfigs.containsKey(previousKey)) continue;
                            changedKeys.add(previousKey);
                        }
                        if (changedKeys.isEmpty()) continue;
                        changedConfigsHost.put(currentConfigType, changedKeys);
                        continue;
                    }
                    changedConfigsHost.put(currentConfigType, ((SortedMap)currentConfigs.get(currentConfigType)).keySet());
                }
                for (String previousConfigType : previousConfigs.keySet()) {
                    if (currentConfigs.containsKey(previousConfigType)) continue;
                    changedConfigsHost.put(previousConfigType, ((SortedMap)previousConfigs.get(previousConfigType)).keySet());
                }
                changedConfigs.put(host.getHostId(), changedConfigsHost);
            }
            for (String serviceName : cluster.getServices().keySet()) {
                this.checkStaleConfigsStatusOnConfigsUpdate(cluster.getClusterId(), serviceName, changedConfigs);
            }
            ((MetadataHolder)this.m_metadataHolder.get()).updateData(((OBDPManagementControllerImpl)this.m_ambariManagementController.get()).getClusterMetadataOnConfigsUpdate(cluster));
            ((AgentConfigsHolder)this.m_agentConfigsHolder.get()).updateData(cluster.getClusterId(), null);
        }
    }

    public void checkStaleConfigsStatusOnConfigsUpdate(Long clusterId, String serviceName, Map<Long, Map<String, Collection<String>>> changedConfigs) throws OBDPException {
        if (MapUtils.isEmpty(changedConfigs)) {
            return;
        }
        if (!this.clusters.getCluster(clusterId).getServices().keySet().contains(serviceName)) {
            return;
        }
        Service service = this.clusters.getCluster(clusterId).getService(serviceName);
        for (ServiceComponent serviceComponent : service.getServiceComponents().values()) {
            String serviceComponentHostName = serviceComponent.getName();
            for (ServiceComponentHost serviceComponentHost : serviceComponent.getServiceComponentHosts().values()) {
                if (!changedConfigs.keySet().contains(serviceComponentHost.getHost().getHostId())) continue;
                boolean staleConfigs = this.checkStaleConfigsStatusForHostComponent(serviceComponentHost, changedConfigs.get(serviceComponentHost.getHost().getHostId()));
                if (!this.wasStaleConfigsStatusUpdated(clusterId, serviceComponentHost.getHost().getHostId(), serviceName, serviceComponentHostName, staleConfigs)) continue;
                serviceComponentHost.setRestartRequiredWithoutEventPublishing(staleConfigs);
                this.STOMPUpdatePublisher.publish(new HostComponentsUpdateEvent(Collections.singletonList(HostComponentUpdate.createHostComponentStaleConfigsStatusUpdate(clusterId, serviceName, serviceComponentHost.getHostName(), serviceComponentHostName, staleConfigs))));
            }
        }
    }

    public boolean wasStaleConfigsStatusUpdated(Long clusterId, Long hostId, String serviceName, String hostComponentName, Boolean staleConfigs) {
        Map<String, Boolean> hostComponents;
        Map<String, Map<String, Boolean>> services;
        Map<Long, Map<String, Map<String, Boolean>>> hosts;
        if (!this.stateCache.containsKey(clusterId)) {
            this.stateCache.put(clusterId, new HashMap());
        }
        if (!(hosts = this.stateCache.get(clusterId)).containsKey(hostId)) {
            hosts.put(hostId, new HashMap());
        }
        if (!(services = hosts.get(hostId)).containsKey(serviceName)) {
            services.put(serviceName, new HashMap());
        }
        if (staleConfigs.equals((hostComponents = services.get(serviceName)).get(hostComponentName))) {
            return false;
        }
        hostComponents.put(hostComponentName, staleConfigs);
        return true;
    }

    public boolean checkStaleConfigsStatusForHostComponent(ServiceComponentHost sch, Map<String, Collection<String>> changedConfigs) throws OBDPException {
        HostComponentDesiredStateEntity hostComponentDesiredStateEntity = sch.getDesiredStateEntity();
        if (sch.isRestartRequired(hostComponentDesiredStateEntity)) {
            return true;
        }
        boolean stale = false;
        Cluster cluster = this.clusters.getClusterById(sch.getClusterId());
        StackId stackId = sch.getServiceComponent().getDesiredStackId();
        StackInfo stackInfo = this.obdpMetaInfo.getStack(stackId);
        ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), sch.getServiceName());
        ComponentInfo componentInfo = serviceInfo.getComponentByName(sch.getServiceComponentName());
        LinkedList<String> changedProperties = new LinkedList<String>();
        for (Map.Entry<String, Collection<String>> changedConfigType : changedConfigs.entrySet()) {
            String type = changedConfigType.getKey();
            if (!(stale |= serviceInfo.hasConfigDependency(type) || componentInfo.hasConfigType(type))) continue;
            for (String propertyName : changedConfigType.getValue()) {
                changedProperties.add(type + "/" + propertyName);
            }
        }
        String refreshCommand = this.calculateRefreshCommand(stackInfo.getRefreshCommandConfiguration(), sch, changedProperties);
        Map<String, HostConfig> actual = sch.getActualConfigs();
        Map<String, Map<String, String>> desired = this.getEffectiveDesiredTags(cluster, sch.getHostName(), cluster.getDesiredConfigs());
        if (this.STALE_CONFIGS_CACHE_ENABLED && refreshCommand != null) {
            int staleHash = Objects.hashCode((Object[])new Object[]{actual.hashCode(), desired.hashCode(), sch.getHostName(), sch.getServiceComponentName(), sch.getServiceName()});
            this.refreshConfigCommandCache.put((Object)staleHash, (Object)refreshCommand);
        }
        return stale;
    }

    public Map<String, Collection<String>> getChangedConfigTypes(Cluster cluster, ServiceConfigEntity currentServiceConfigEntity, Long configGroupId, Long clusterId, String serviceName) {
        ServiceConfigEntity previousServiceConfigEntity;
        ArrayList<ClusterConfigEntity> previousConfigEntities = new ArrayList<ClusterConfigEntity>();
        ArrayList<ClusterConfigEntity> currentConfigEntities = new ArrayList<ClusterConfigEntity>();
        currentConfigEntities.addAll(currentServiceConfigEntity.getClusterConfigEntities());
        if (configGroupId != null && (previousServiceConfigEntity = this.serviceConfigDAO.getLastServiceConfigVersionsForGroup(configGroupId)) != null) {
            previousConfigEntities.addAll(previousServiceConfigEntity.getClusterConfigEntities());
        }
        if ((previousServiceConfigEntity = this.serviceConfigDAO.getLastServiceConfigForServiceDefaultGroup(clusterId, serviceName)) != null) {
            for (ClusterConfigEntity clusterConfigEntity : previousServiceConfigEntity.getClusterConfigEntities()) {
                Object exist = previousConfigEntities.stream().filter(c -> c.getType().equals(clusterConfigEntity.getType())).findAny().orElse(null);
                if (exist == null) {
                    previousConfigEntities.add(clusterConfigEntity);
                }
                if (configGroupId == null || (exist = (ClusterConfigEntity)currentConfigEntities.stream().filter(c -> c.getType().equals(clusterConfigEntity.getType())).findAny().orElse(null)) != null) continue;
                currentConfigEntities.add(clusterConfigEntity);
            }
        }
        HashMap<String, String> previousConfigs = new HashMap<String, String>();
        HashMap<String, String> currentConfigs = new HashMap<String, String>();
        for (ClusterConfigEntity clusterConfigEntity : currentConfigEntities) {
            currentConfigs.put(clusterConfigEntity.getType(), clusterConfigEntity.getTag());
        }
        for (ClusterConfigEntity clusterConfigEntity : previousConfigEntities) {
            previousConfigs.put(clusterConfigEntity.getType(), clusterConfigEntity.getTag());
        }
        HashMap<String, Collection<String>> changedConfigs = new HashMap<String, Collection<String>>();
        for (Map.Entry currentConfig : currentConfigs.entrySet()) {
            String type = (String)currentConfig.getKey();
            String tag = (String)currentConfig.getValue();
            Collection<String> changedKeys = previousConfigs.containsKey(type) ? this.findChangedKeys(cluster, type, Collections.singletonList(tag), Collections.singletonList((String)previousConfigs.get(type))) : cluster.getConfig(type, tag).getProperties().keySet();
            if (!CollectionUtils.isNotEmpty(changedKeys)) continue;
            changedConfigs.put(type, changedKeys);
        }
        return changedConfigs;
    }

    public String getRefreshConfigsCommand(Cluster cluster, String hostName, String serviceName, String componentName) throws OBDPException {
        ServiceComponent serviceComponent = cluster.getService(serviceName).getServiceComponent(componentName);
        ServiceComponentHost sch = serviceComponent.getServiceComponentHost(hostName);
        return this.getRefreshConfigsCommand(cluster, sch);
    }

    public String getRefreshConfigsCommand(Cluster cluster, ServiceComponentHost sch) throws OBDPException {
        String refreshCommand = null;
        Map<String, HostConfig> actual = sch.getActualConfigs();
        if (this.STALE_CONFIGS_CACHE_ENABLED) {
            Map<String, Map<String, String>> desired = this.getEffectiveDesiredTags(cluster, sch.getHostName(), cluster.getDesiredConfigs());
            int staleHash = Objects.hashCode((Object[])new Object[]{actual.hashCode(), desired.hashCode(), sch.getHostName(), sch.getServiceComponentName(), sch.getServiceName()});
            refreshCommand = (String)this.refreshConfigCommandCache.getIfPresent((Object)staleHash);
        }
        return refreshCommand;
    }

    private String calculateRefreshCommand(RefreshCommandConfiguration refreshCommandConfiguration, ServiceComponentHost sch, List<String> changedProperties) {
        String finalRefreshCommand = null;
        for (String propertyName : changedProperties) {
            String refreshCommand = refreshCommandConfiguration.getRefreshCommandForComponent(sch, propertyName);
            if (refreshCommand == null) {
                return null;
            }
            if (finalRefreshCommand == null) {
                finalRefreshCommand = refreshCommand;
            }
            if (finalRefreshCommand.equals(refreshCommand)) continue;
            if (finalRefreshCommand.equals("refresh_configs")) {
                finalRefreshCommand = refreshCommand;
                continue;
            }
            if (refreshCommand.equals("refresh_configs")) continue;
            return null;
        }
        return finalRefreshCommand;
    }

    private boolean hasGroupSpecificConfigsForType(Cluster cluster, String hostname, String type) {
        try {
            Map<Long, ConfigGroup> configGroups = cluster.getConfigGroupsByHostname(hostname);
            if (configGroups != null && !configGroups.isEmpty()) {
                for (ConfigGroup configGroup : configGroups.values()) {
                    Config config = configGroup.getConfigurations().get(type);
                    if (config == null) continue;
                    return true;
                }
            }
        }
        catch (OBDPException ambariException) {
            LOG.warn("Could not determine group configuration for host. Details: " + ambariException.getMessage());
        }
        return false;
    }

    private Collection<String> findChangedKeys(Cluster cluster, String type, Collection<String> desiredTags, Collection<String> actualTags) {
        Config config;
        HashMap<String, String> desiredValues = new HashMap<String, String>();
        HashMap<String, String> actualValues = new HashMap<String, String>();
        for (String tag : desiredTags) {
            config = cluster.getConfig(type, tag);
            if (null == config) continue;
            desiredValues.putAll(config.getProperties());
        }
        for (String tag : actualTags) {
            config = cluster.getConfig(type, tag);
            if (null == config) continue;
            actualValues.putAll(config.getProperties());
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry entry : desiredValues.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (actualValues.containsKey(key) && ConfigHelper.valuesAreEqual((String)actualValues.get(key), value)) continue;
            keys.add(type + "/" + key);
        }
        for (String key : actualValues.keySet()) {
            if (desiredValues.containsKey(key)) continue;
            keys.add(type + "/" + key);
        }
        return keys;
    }

    static boolean valuesAreEqual(String value1, String value2) {
        if (NumberUtils.isNumber((String)value1) && NumberUtils.isNumber((String)value2)) {
            try {
                Number number1 = NumberUtils.createNumber((String)value1);
                Number number2 = NumberUtils.createNumber((String)value2);
                return Objects.equal((Object)number1, (Object)number2) || number1.doubleValue() == number2.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Objects.equal((Object)value1, (Object)value2);
    }

    private Map<String, String> buildTags(HostConfig hc) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(CLUSTER_DEFAULT_TAG, hc.getDefaultVersionTag());
        if (hc.getConfigGroupOverrides() != null) {
            for (Map.Entry<Long, String> entry : hc.getConfigGroupOverrides().entrySet()) {
                map.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return map;
    }

    private boolean isTagChanged(Map<String, String> desiredTags, Map<String, String> actualTags, boolean groupSpecificConfigs) {
        HashSet<String> actualSet;
        HashSet<String> desiredSet;
        if (!actualTags.get(CLUSTER_DEFAULT_TAG).equals(desiredTags.get(CLUSTER_DEFAULT_TAG))) {
            return true;
        }
        if (groupSpecificConfigs) {
            actualTags.remove(CLUSTER_DEFAULT_TAG);
            desiredTags.remove(CLUSTER_DEFAULT_TAG);
        }
        return !(desiredSet = new HashSet<String>(desiredTags.values())).equals(actualSet = new HashSet<String>(actualTags.values()));
    }

    public static String fileNameToConfigType(String filename) {
        int extIndex = filename.indexOf(".xml");
        return filename.substring(0, extIndex);
    }

    public static void processHiddenAttribute(Map<String, Map<String, String>> configurations, Map<String, Map<String, Map<String, String>>> attributes, String componentName, boolean configDownload) {
        if (configurations != null && attributes != null && componentName != null) {
            for (Map.Entry<String, Map<String, String>> confEntry : configurations.entrySet()) {
                Map<String, String> hiddenProperties;
                Map<String, Map<String, String>> configAttributes;
                String configTag = confEntry.getKey();
                Map<String, String> confProperties = confEntry.getValue();
                if (!attributes.containsKey(configTag) || !(configAttributes = attributes.get(configTag)).containsKey("hidden") || (hiddenProperties = configAttributes.get("hidden")) == null) continue;
                for (Map.Entry<String, String> hiddenEntry : hiddenProperties.entrySet()) {
                    String propertyName = hiddenEntry.getKey();
                    String components = hiddenEntry.getValue();
                    if (!(configDownload ? components.contains("CONFIG_DOWNLOAD") : components.contains(componentName)) || !confProperties.containsKey(propertyName)) continue;
                    confProperties.remove(propertyName);
                }
            }
        }
    }

    public static void mergeConfigAttributes(Map<String, Map<String, String>> attributes, Map<String, Map<String, String>> additionalAttributes) {
        for (Map.Entry<String, Map<String, String>> attrEntry : additionalAttributes.entrySet()) {
            String attributeName = attrEntry.getKey();
            Map<String, String> attributeProperties = attrEntry.getValue();
            if (!attributes.containsKey(attributeName)) {
                attributes.put(attributeName, attributeProperties);
                continue;
            }
            attributes.get(attributeName).putAll(attributeProperties);
        }
    }

    public AgentConfigsUpdateEvent getHostActualConfigs(Long hostId) throws OBDPException {
        return this.getHostActualConfigsExcludeCluster(hostId, null);
    }

    public AgentConfigsUpdateEvent getHostActualConfigsExcludeCluster(Long hostId, Long clusterId) throws OBDPException {
        TreeMap<String, ClusterConfigs> clustersConfigs = new TreeMap<String, ClusterConfigs>();
        Host host = this.clusters.getHostById(hostId);
        for (Cluster cl : this.clusters.getClusters().values()) {
            if (clusterId != null && cl.getClusterId() == clusterId.longValue()) continue;
            Map<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
            Map<String, Map<String, Map<String, String>>> configurationAttributes = new HashMap<String, Map<String, Map<String, String>>>();
            Map<String, DesiredConfig> clusterDesiredConfigs = cl.getDesiredConfigs(false);
            Map<String, Map<String, String>> configTags = this.getEffectiveDesiredTags(cl, host.getHostName(), clusterDesiredConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("For configs update on host {} will be used cluster entity {}", (Object)hostId, (Object)cl.getClusterEntity().toString());
                LOG.debug("For configs update on host {} will be used following cluster desired configs {}", (Object)hostId, (Object)clusterDesiredConfigs.toString());
                LOG.debug("For configs update on host {} will be used following effective desired tags {}", (Object)hostId, (Object)configTags.toString());
            }
            this.getAndMergeHostConfigs(configurations, configTags, cl);
            configurations = this.unescapeConfigNames(configurations);
            this.getAndMergeHostConfigAttributes(configurationAttributes, configTags, cl);
            configurationAttributes = this.unescapeConfigAttributeNames(configurationAttributes);
            SortedMap<String, SortedMap<String, String>> configurationsTreeMap = this.sortConfigutations(configurations);
            SortedMap<String, SortedMap<String, SortedMap<String, String>>> configurationAttributesTreeMap = this.sortConfigurationAttributes(configurationAttributes);
            clustersConfigs.put(Long.toString(cl.getClusterId()), new ClusterConfigs(configurationsTreeMap, configurationAttributesTreeMap));
        }
        return new AgentConfigsUpdateEvent(hostId, clustersConfigs);
    }

    private Map<String, Map<String, String>> unescapeConfigNames(Map<String, Map<String, String>> configurations) {
        HashMap<String, Map<String, String>> unescapedConfigs = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> configTypeEntry : configurations.entrySet()) {
            HashMap<String, String> unescapedTypeConfigs = new HashMap<String, String>();
            for (Map.Entry<String, String> config : configTypeEntry.getValue().entrySet()) {
                unescapedTypeConfigs.put(StringEscapeUtils.unescapeJava((String)config.getKey()), config.getValue());
            }
            unescapedConfigs.put(configTypeEntry.getKey(), unescapedTypeConfigs);
        }
        return unescapedConfigs;
    }

    private Map<String, Map<String, Map<String, String>>> unescapeConfigAttributeNames(Map<String, Map<String, Map<String, String>>> configurationAttributes) {
        HashMap<String, Map<String, Map<String, String>>> unescapedConfigAttributes = new HashMap<String, Map<String, Map<String, String>>>();
        configurationAttributes.forEach((key, value) -> unescapedConfigAttributes.put((String)key, this.unescapeConfigNames((Map<String, Map<String, String>>)value)));
        return unescapedConfigAttributes;
    }

    public SortedMap<String, SortedMap<String, String>> sortConfigutations(Map<String, Map<String, String>> configurations) {
        TreeMap<String, SortedMap<String, String>> configurationsTreeMap = new TreeMap<String, SortedMap<String, String>>();
        configurations.forEach((k, v) -> configurationsTreeMap.put((String)k, new TreeMap(v)));
        return configurationsTreeMap;
    }

    public SortedMap<String, SortedMap<String, SortedMap<String, String>>> sortConfigurationAttributes(Map<String, Map<String, Map<String, String>>> configurationAttributes) {
        TreeMap<String, SortedMap<String, SortedMap<String, String>>> configurationAttributesTreeMap = new TreeMap<String, SortedMap<String, SortedMap<String, String>>>();
        configurationAttributes.forEach((k, v) -> {
            TreeMap c = new TreeMap();
            v.forEach((k1, v1) -> c.put(k1, new TreeMap(v1)));
            configurationAttributesTreeMap.put((String)k, c);
        });
        return configurationAttributesTreeMap;
    }

    public Map<String, Map<String, String>> calculateExistingConfigurations(OBDPManagementController ambariManagementController, Cluster cluster) throws OBDPException {
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        for (Host host : cluster.getHosts()) {
            configurations.putAll(this.calculateExistingConfigurations(ambariManagementController, cluster, host.getHostName(), null));
        }
        return configurations;
    }

    public Map<String, Map<String, String>> calculateExistingConfigurations(OBDPManagementController ambariManagementController, Cluster cluster, String hostname, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> configurationTags = ambariManagementController.findConfigurationTagsWithOverrides(cluster, hostname, desiredConfigs);
        Map<String, Map<String, String>> configProperties = this.getEffectiveConfigProperties(cluster, configurationTags);
        for (Map.Entry<String, Map<String, String>> entry : configProperties.entrySet()) {
            String type = entry.getKey();
            Map<String, String> allLevelMergedConfig = entry.getValue();
            HashMap<String, String> configuration = (HashMap<String, String>)configurations.get(type);
            if (configuration == null) {
                configuration = new HashMap<String, String>(allLevelMergedConfig);
            } else {
                Map<String, String> mergedConfig = this.getMergedConfig(allLevelMergedConfig, (Map<String, String>)configuration);
                configuration.clear();
                configuration.putAll(mergedConfig);
            }
            configurations.put(type, configuration);
        }
        return configurations;
    }

    public Pair<Map<String, Map<String, String>>, Map<String, Map<String, Map<String, String>>>> calculateExistingConfigs(Cluster cluster) throws OBDPException {
        Map<String, Map<String, String>> desiredConfigTags = this.getEffectiveDesiredTags(cluster, null);
        return Pair.of(this.getEffectiveConfigProperties(cluster, desiredConfigTags), this.getEffectiveConfigAttributes(cluster, desiredConfigTags));
    }
}

