/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.BulkCommandDefinition;
import id.onyx.obdp.server.state.ClientConfigFileDefinition;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.state.LogDefinition;
import id.onyx.obdp.server.state.UnlimitedKeyJCERequirement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ComponentInfo {
    private String name;
    private String displayName;
    private String category;
    private boolean deleted;
    private String cardinality;
    @XmlElement(name="versionAdvertised")
    private Boolean versionAdvertisedField;
    private boolean versionAdvertisedInternal = false;
    @XmlElements(value={@XmlElement(name="decommissionAllowed")})
    private String decommissionAllowed;
    @XmlElement(name="unlimitedKeyJCERequired")
    private UnlimitedKeyJCERequirement unlimitedKeyJCERequired;
    @XmlElements(value={@XmlElement(name="rollingRestartSupported")})
    private boolean rollingRestartSupported;
    private CommandScriptDefinition commandScript;
    @XmlElementWrapper(name="logs")
    @XmlElements(value={@XmlElement(name="log")})
    private List<LogDefinition> logs;
    @XmlElementWrapper(name="clientsToUpdateConfigs")
    @XmlElements(value={@XmlElement(name="client")})
    private List<String> clientsToUpdateConfigs;
    @XmlElementWrapper(name="configFiles")
    @XmlElements(value={@XmlElement(name="configFile")})
    private List<ClientConfigFileDefinition> clientConfigFiles;
    @XmlElementWrapper(name="customCommands")
    @XmlElements(value={@XmlElement(name="customCommand")})
    private List<CustomCommandDefinition> customCommands;
    @XmlElement(name="bulkCommands")
    private BulkCommandDefinition bulkCommandDefinition;
    @XmlElementWrapper(name="dependencies")
    @XmlElements(value={@XmlElement(name="dependency")})
    private List<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
    @XmlElementWrapper(name="configuration-dependencies")
    @XmlElements(value={@XmlElement(name="config-type")})
    private List<String> configDependencies;
    @XmlElement(name="auto-deploy")
    private AutoDeployInfo autoDeploy;
    @XmlElements(value={@XmlElement(name="recovery_enabled")})
    private boolean recoveryEnabled = false;
    @XmlElements(value={@XmlElement(name="reassignAllowed")})
    private String reassignAllowed;
    private String timelineAppid;
    @XmlElement(name="customFolder")
    private String customFolder;
    private String componentType;

    public ComponentInfo() {
    }

    public ComponentInfo(ComponentInfo prototype) {
        this.name = prototype.name;
        this.category = prototype.category;
        this.deleted = prototype.deleted;
        this.cardinality = prototype.cardinality;
        this.versionAdvertisedField = prototype.versionAdvertisedField;
        this.versionAdvertisedInternal = prototype.versionAdvertisedInternal;
        this.decommissionAllowed = prototype.decommissionAllowed;
        this.unlimitedKeyJCERequired = prototype.unlimitedKeyJCERequired;
        this.clientsToUpdateConfigs = prototype.clientsToUpdateConfigs;
        this.commandScript = prototype.commandScript;
        this.logs = prototype.logs;
        this.customCommands = prototype.customCommands;
        this.bulkCommandDefinition = prototype.bulkCommandDefinition;
        this.dependencies = prototype.dependencies;
        this.autoDeploy = prototype.autoDeploy;
        this.configDependencies = prototype.configDependencies;
        this.clientConfigFiles = prototype.clientConfigFiles;
        this.timelineAppid = prototype.timelineAppid;
        this.reassignAllowed = prototype.reassignAllowed;
        this.customFolder = prototype.customFolder;
        this.rollingRestartSupported = prototype.rollingRestartSupported;
        this.componentType = prototype.componentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isClient() {
        return "CLIENT".equals(this.category);
    }

    public boolean isMaster() {
        return "MASTER".equals(this.category);
    }

    public boolean isSlave() {
        return "SLAVE".equals(this.category);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public CommandScriptDefinition getCommandScript() {
        return this.commandScript;
    }

    public void setCommandScript(CommandScriptDefinition commandScript) {
        this.commandScript = commandScript;
    }

    public List<LogDefinition> getLogs() {
        if (this.logs == null) {
            this.logs = new ArrayList<LogDefinition>();
        }
        return this.logs;
    }

    public LogDefinition getPrimaryLog() {
        for (LogDefinition log : this.getLogs()) {
            if (!log.isPrimary()) continue;
            return log;
        }
        return null;
    }

    public void setLogs(List<LogDefinition> logs) {
        this.logs = logs;
    }

    public List<ClientConfigFileDefinition> getClientConfigFiles() {
        return this.clientConfigFiles;
    }

    public void setClientConfigFiles(List<ClientConfigFileDefinition> clientConfigFiles) {
        this.clientConfigFiles = clientConfigFiles;
    }

    public List<CustomCommandDefinition> getCustomCommands() {
        if (this.customCommands == null) {
            this.customCommands = new ArrayList<CustomCommandDefinition>();
        }
        return this.customCommands;
    }

    public void setCustomCommands(List<CustomCommandDefinition> customCommands) {
        this.customCommands = customCommands;
    }

    public boolean isCustomCommand(String commandName) {
        if (this.customCommands != null && commandName != null) {
            for (CustomCommandDefinition cc : this.customCommands) {
                if (!commandName.equals(cc.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public CustomCommandDefinition getCustomCommandByName(String commandName) {
        for (CustomCommandDefinition ccd : this.getCustomCommands()) {
            if (!ccd.getName().equals(commandName)) continue;
            return ccd;
        }
        return null;
    }

    public BulkCommandDefinition getBulkCommandDefinition() {
        return this.bulkCommandDefinition;
    }

    public void setBulkCommands(BulkCommandDefinition bulkCommandDefinition) {
        this.bulkCommandDefinition = bulkCommandDefinition;
    }

    public List<DependencyInfo> getDependencies() {
        return this.dependencies;
    }

    public List<String> getConfigDependencies() {
        return this.configDependencies;
    }

    public void setConfigDependencies(List<String> configDependencies) {
        this.configDependencies = configDependencies;
    }

    public boolean hasConfigType(String type) {
        return this.configDependencies != null && this.configDependencies.contains(type);
    }

    public void setDependencies(List<DependencyInfo> dependencies) {
        this.dependencies = dependencies;
    }

    public void setAutoDeploy(AutoDeployInfo autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    public AutoDeployInfo getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setVersionAdvertisedField(Boolean versionAdvertisedField) {
        this.versionAdvertisedField = versionAdvertisedField;
    }

    public Boolean getVersionAdvertisedField() {
        return this.versionAdvertisedField;
    }

    public void setVersionAdvertised(boolean versionAdvertised) {
        this.versionAdvertisedInternal = versionAdvertised;
    }

    public boolean isVersionAdvertised() {
        if (null != this.versionAdvertisedField) {
            return this.versionAdvertisedField;
        }
        return this.versionAdvertisedInternal;
    }

    public String getDecommissionAllowed() {
        return this.decommissionAllowed;
    }

    public void setDecommissionAllowed(String decommissionAllowed) {
        this.decommissionAllowed = decommissionAllowed;
    }

    public boolean getRollingRestartSupported() {
        return this.rollingRestartSupported;
    }

    public void setRollingRestartSupported(boolean rollingRestartSupported) {
        this.rollingRestartSupported = rollingRestartSupported;
    }

    public UnlimitedKeyJCERequirement getUnlimitedKeyJCERequired() {
        return this.unlimitedKeyJCERequired;
    }

    public void setUnlimitedKeyJCERequired(UnlimitedKeyJCERequirement unlimitedKeyJCERequired) {
        this.unlimitedKeyJCERequired = unlimitedKeyJCERequired;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = recoveryEnabled;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public List<String> getClientsToUpdateConfigs() {
        return this.clientsToUpdateConfigs;
    }

    public void setClientsToUpdateConfigs(List<String> clientsToUpdateConfigs) {
        this.clientsToUpdateConfigs = clientsToUpdateConfigs;
    }

    public String getTimelineAppid() {
        return this.timelineAppid;
    }

    public void setTimelineAppid(String timelineAppid) {
        this.timelineAppid = timelineAppid;
    }

    public String getReassignAllowed() {
        return this.reassignAllowed;
    }

    public void setReassignAllowed(String reassignAllowed) {
        this.reassignAllowed = reassignAllowed;
    }

    public String getCustomFolder() {
        return this.customFolder;
    }

    public void setCustomFolder(String customFolder) {
        this.customFolder = customFolder;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInfo that = (ComponentInfo)o;
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) {
            return false;
        }
        if (this.cardinality != null ? !this.cardinality.equals(that.cardinality) : that.cardinality != null) {
            return false;
        }
        if (this.versionAdvertisedField != null ? !this.versionAdvertisedField.equals(that.versionAdvertisedField) : that.versionAdvertisedField != null) {
            return false;
        }
        if (this.versionAdvertisedInternal != that.versionAdvertisedInternal) {
            return false;
        }
        if (this.decommissionAllowed != null ? !this.decommissionAllowed.equals(that.decommissionAllowed) : that.decommissionAllowed != null) {
            return false;
        }
        if (this.unlimitedKeyJCERequired != null ? !this.unlimitedKeyJCERequired.equals((Object)that.unlimitedKeyJCERequired) : that.unlimitedKeyJCERequired != null) {
            return false;
        }
        if (this.reassignAllowed != null ? !this.reassignAllowed.equals(that.reassignAllowed) : that.reassignAllowed != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        if (this.clientConfigFiles != null ? !this.clientConfigFiles.equals(that.clientConfigFiles) : that.clientConfigFiles != null) {
            return false;
        }
        if (this.commandScript != null ? !this.commandScript.equals(that.commandScript) : that.commandScript != null) {
            return false;
        }
        if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) {
            return false;
        }
        if (this.configDependencies != null ? !this.configDependencies.equals(that.configDependencies) : that.configDependencies != null) {
            return false;
        }
        if (this.customCommands != null ? !this.customCommands.equals(that.customCommands) : that.customCommands != null) {
            return false;
        }
        if (this.bulkCommandDefinition != null ? !this.bulkCommandDefinition.equals(that.bulkCommandDefinition) : that.bulkCommandDefinition != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.clientConfigFiles != null ? !this.clientConfigFiles.equals(that.clientConfigFiles) : that.clientConfigFiles != null) {
            return false;
        }
        return !(this.customFolder != null ? !this.customFolder.equals(that.customFolder) : that.customFolder != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.cardinality != null ? this.cardinality.hashCode() : 0);
        result = 31 * result + (this.decommissionAllowed != null ? this.decommissionAllowed.hashCode() : 0);
        result = 31 * result + (this.unlimitedKeyJCERequired != null ? this.unlimitedKeyJCERequired.hashCode() : 0);
        result = 31 * result + (this.reassignAllowed != null ? this.reassignAllowed.hashCode() : 0);
        result = 31 * result + (this.commandScript != null ? this.commandScript.hashCode() : 0);
        result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
        result = 31 * result + (this.clientConfigFiles != null ? this.clientConfigFiles.hashCode() : 0);
        result = 31 * result + (this.customCommands != null ? this.customCommands.hashCode() : 0);
        result = 31 * result + (this.bulkCommandDefinition != null ? this.bulkCommandDefinition.hashCode() : 0);
        result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
        result = 31 * result + (this.autoDeploy != null ? this.autoDeploy.hashCode() : 0);
        result = 31 * result + (this.configDependencies != null ? this.configDependencies.hashCode() : 0);
        result = 31 * result + (this.clientConfigFiles != null ? this.clientConfigFiles.hashCode() : 0);
        result = 31 * result + (this.versionAdvertisedField != null ? (this.versionAdvertisedField.booleanValue() ? 2 : 1) : 0);
        result = 31 * result + (this.customFolder != null ? this.customFolder.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

