/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.collect.ListMultimap;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ClusterResponse;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.spi.ClusterInformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface Cluster {
    public long getClusterId();

    public String getClusterName();

    public void setClusterName(String var1);

    public Long getResourceId();

    public void addService(Service var1);

    public Service getService(String var1) throws OBDPException;

    public Service getServiceByComponentName(String var1) throws OBDPException;

    public Map<String, Service> getServices();

    public List<ServiceComponentHost> getServiceComponentHosts(String var1);

    public Map<String, Set<String>> getServiceComponentHostMap(Set<String> var1, Set<String> var2);

    public List<ServiceComponentHost> getServiceComponentHosts(String var1, String var2);

    public List<ServiceComponentHost> getServiceComponentHosts();

    public Collection<Host> getHosts();

    default public Set<String> getHostNames() {
        return this.getHosts().stream().map(Host::getHostName).collect(Collectors.toSet());
    }

    public Set<String> getHosts(String var1, String var2);

    public Host getHost(String var1);

    public Host getHost(Long var1);

    public void addServiceComponentHosts(Collection<ServiceComponentHost> var1) throws OBDPException;

    public void removeServiceComponentHost(ServiceComponentHost var1) throws OBDPException;

    public StackId getDesiredStackVersion();

    public void setDesiredStackVersion(StackId var1) throws OBDPException;

    public StackId getCurrentStackVersion();

    public void setCurrentStackVersion(StackId var1) throws OBDPException;

    public List<Host> transitionHostsToInstalling(RepositoryVersionEntity var1, VersionDefinitionXml var2, boolean var3) throws OBDPException;

    public State getProvisioningState();

    public void setProvisioningState(State var1);

    public SecurityType getSecurityType();

    public void setSecurityType(SecurityType var1);

    public Map<String, Config> getConfigsByType(String var1);

    public Map<PropertyInfo.PropertyType, Set<String>> getConfigPropertiesTypes(String var1);

    public Map<PropertyInfo.PropertyType, Set<String>> getConfigPropertiesTypes(String var1, StackId var2);

    public Config getConfig(String var1, String var2);

    public List<Config> getLatestConfigsWithTypes(Collection<String> var1);

    public Config getConfigByVersion(String var1, Long var2);

    public void addConfig(Config var1);

    public Collection<Config> getAllConfigs();

    public ServiceConfigVersionResponse addDesiredConfig(String var1, Set<Config> var2) throws OBDPException;

    public ServiceConfigVersionResponse addDesiredConfig(String var1, Set<Config> var2, String var3) throws OBDPException;

    public ServiceConfigVersionResponse createServiceConfigVersion(String var1, String var2, String var3, ConfigGroup var4) throws OBDPException;

    public String getServiceForConfigTypes(Collection<String> var1);

    public ServiceConfigVersionResponse setServiceConfigVersion(String var1, Long var2, String var3, String var4) throws OBDPException;

    public Map<String, Collection<ServiceConfigVersionResponse>> getActiveServiceConfigVersions();

    public List<ServiceConfigVersionResponse> getActiveServiceConfigVersionResponse(String var1);

    public List<ServiceConfigVersionResponse> getServiceConfigVersions();

    public Config getDesiredConfigByType(String var1);

    public Config getDesiredConfigByType(String var1, @Nullable Map<String, DesiredConfig> var2);

    public boolean isConfigTypeExists(String var1);

    public Map<String, DesiredConfig> getDesiredConfigs();

    public Map<String, DesiredConfig> getDesiredConfigs(boolean var1);

    public ClusterEntity getClusterEntity();

    public Map<String, Set<DesiredConfig>> getAllDesiredConfigVersions();

    public ClusterResponse convertToResponse() throws OBDPException;

    public void refresh();

    public void debugDump(StringBuilder var1);

    public void deleteAllServices() throws OBDPException;

    public void deleteAllClusterConfigs();

    public void deleteService(String var1, DeleteHostComponentStatusMetaData var2) throws OBDPException;

    public boolean canBeRemoved();

    public void delete() throws OBDPException;

    public Service addService(String var1, RepositoryVersionEntity var2) throws OBDPException;

    public Map<Long, Map<String, DesiredConfig>> getHostsDesiredConfigs(Collection<Long> var1);

    public Map<Long, Map<String, DesiredConfig>> getAllHostsDesiredConfigs();

    public void addConfigGroup(ConfigGroup var1) throws OBDPException;

    public Map<Long, ConfigGroup> getConfigGroups();

    public void deleteConfigGroup(Long var1) throws OBDPException;

    public Map<Long, ConfigGroup> getConfigGroupsByHostname(String var1) throws OBDPException;

    public ConfigGroup getConfigGroupsById(Long var1);

    public Map<Long, ConfigGroup> getConfigGroupsByServiceName(String var1);

    public void addRequestExecution(RequestExecution var1) throws OBDPException;

    public Map<Long, RequestExecution> getAllRequestExecutions();

    public void deleteRequestExecution(Long var1) throws OBDPException;

    public Long getNextConfigVersion(String var1);

    public Map<ServiceComponentHostEvent, String> processServiceComponentHostEvents(ListMultimap<String, ServiceComponentHostEvent> var1);

    public boolean checkPermission(PrivilegeEntity var1, boolean var2);

    public void addSessionAttributes(Map<String, Object> var1);

    public void setSessionAttribute(String var1, Object var2);

    public void removeSessionAttribute(String var1);

    public Map<String, Object> getSessionAttributes();

    public void applyLatestConfigurations(StackId var1, String var2);

    public void removeConfigurations(StackId var1, String var2);

    public boolean isBluePrintDeployed();

    public UpgradeEntity getUpgradeInProgress();

    public void setUpgradeEntity(UpgradeEntity var1) throws OBDPException;

    public boolean isUpgradeSuspended();

    public String getServiceByConfigType(String var1);

    public String getClusterProperty(String var1, String var2);

    public int getClusterSize();

    public RoleCommandOrder getRoleCommandOrder();

    public void addSuspendedUpgradeParameters(Map<String, String> var1, Map<String, String> var2);

    public Map<String, Map<String, String>> getComponentVersionMap();

    public ClusterInformation buildClusterInformation();
}

