/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.OrchestrationQualification;
import id.onyx.obdp.server.checks.UpgradeTypeQualification;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.CheckQualification;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CheckHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CheckHelper.class);
    @Inject
    protected Provider<RepositoryVersionDAO> repositoryVersionDaoProvider;
    @Inject
    protected Provider<Clusters> clustersProvider;
    @Inject
    protected Provider<OBDPMetaInfo> metaInfoProvider;

    public List<UpgradeCheck> getApplicableChecks(UpgradeCheckRequest request, List<UpgradeCheck> upgradeChecks) {
        LinkedList<UpgradeCheck> applicableChecks = new LinkedList<UpgradeCheck>();
        for (UpgradeCheck check : upgradeChecks) {
            ArrayList qualifications = Lists.newArrayList((Object[])new CheckQualification[]{new ServiceQualification(check), new OrchestrationQualification(check.getClass()), new UpgradeTypeQualification(check.getClass())});
            List checkQualifications = check.getQualifications();
            if (CollectionUtils.isNotEmpty((Collection)checkQualifications)) {
                qualifications.addAll(checkQualifications);
            }
            try {
                boolean checkIsApplicable = true;
                for (CheckQualification qualification : qualifications) {
                    if (qualification.isApplicable(request)) continue;
                    checkIsApplicable = false;
                    break;
                }
                if (!checkIsApplicable) continue;
                applicableChecks.add(check);
            }
            catch (Exception ex) {
                LOG.error("Unable to determine whether the pre-upgrade check {} is applicable to this upgrade", (Object)check.getCheckDescription().name(), (Object)ex);
            }
        }
        return applicableChecks;
    }

    public List<UpgradeCheckResult> performChecks(UpgradeCheckRequest request, List<UpgradeCheck> upgradeChecks, Configuration config) {
        String clusterName = request.getClusterName();
        ArrayList<UpgradeCheckResult> results = new ArrayList<UpgradeCheckResult>();
        boolean canBypassPreChecks = config.isUpgradePrecheckBypass();
        List<UpgradeCheck> applicablePreChecks = this.getApplicableChecks(request, upgradeChecks);
        for (UpgradeCheck check : applicablePreChecks) {
            UpgradeCheckResult result = new UpgradeCheckResult(check);
            try {
                result = check.perform(request);
            }
            catch (ClusterNotFoundException ex) {
                result.setFailReason("Cluster with name " + clusterName + " doesn't exists");
                result.setStatus(UpgradeCheckStatus.FAIL);
            }
            catch (Exception ex) {
                LOG.error("Check " + check.getCheckDescription().name() + " failed", (Throwable)ex);
                result.setFailReason("Unexpected server error happened");
                result.setStatus(UpgradeCheckStatus.FAIL);
            }
            if (result.getStatus() == UpgradeCheckStatus.FAIL && canBypassPreChecks) {
                LOG.error("Check {} failed but stack upgrade is allowed to bypass failures. Error to bypass: {}. Failed on: {}", new Object[]{check.getCheckDescription().name(), result.getFailReason(), StringUtils.join((Collection)result.getFailedOn(), (String)", ")});
                result.setStatus(UpgradeCheckStatus.BYPASS);
            }
            results.add(result);
            request.addResult(check.getCheckDescription(), result.getStatus());
        }
        return results;
    }

    public final VersionDefinitionXml getVersionDefinitionXml(UpgradeCheckRequest request) throws OBDPException {
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        RepositoryVersionEntity entity = (RepositoryVersionEntity)((RepositoryVersionDAO)this.repositoryVersionDaoProvider.get()).findByPK(repositoryVersion.getId());
        try {
            VersionDefinitionXml vdf = entity.getRepositoryXml();
            return vdf;
        }
        catch (Exception exception) {
            throw new OBDPException("Unable to run upgrade checks because of an invalid VDF", (Throwable)exception);
        }
    }

    public final Set<String> getServicesInUpgrade(UpgradeCheckRequest request) throws OBDPException {
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        try {
            VersionDefinitionXml vdf = this.getVersionDefinitionXml(request);
            ClusterVersionSummary clusterVersionSummary = vdf.getClusterSummary(cluster, (OBDPMetaInfo)this.metaInfoProvider.get());
            return clusterVersionSummary.getAvailableServiceNames();
        }
        catch (Exception exception) {
            throw new OBDPException("Unable to run upgrade checks because of an invalid VDF", (Throwable)exception);
        }
    }

    final class ServiceQualification
    implements CheckQualification {
        private final UpgradeCheck m_upgradeCheck;

        public ServiceQualification(UpgradeCheck upgradeCheck) {
            this.m_upgradeCheck = upgradeCheck;
        }

        public boolean isApplicable(UpgradeCheckRequest request) throws OBDPException {
            Set applicableServices = this.m_upgradeCheck.getApplicableServices();
            if (applicableServices.isEmpty()) {
                return true;
            }
            Set<String> servicesForUpgrade = CheckHelper.this.getServicesInUpgrade(request);
            for (String serviceInUpgrade : servicesForUpgrade) {
                if (!applicableServices.contains(serviceInUpgrade)) continue;
                return true;
            }
            return false;
        }
    }
}

