/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.state.AlertState;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class Alert {
    private String name;
    private String instance;
    private String service;
    private String component;
    private String hostName;
    private AlertState state = AlertState.UNKNOWN;
    private String label;
    private String text;
    private long timestamp;
    private Long clusterId;
    private String uuid;
    protected static final int MAX_ALERT_TEXT_SIZE = 32617;

    public Alert(String alertName, String alertInstance, String serviceName, String componentName, String hostName, AlertState alertState) {
        this.name = alertName;
        this.instance = alertInstance;
        this.service = serviceName;
        this.component = componentName;
        this.hostName = hostName;
        this.state = alertState;
        this.timestamp = System.currentTimeMillis();
    }

    public Alert() {
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="component")
    public String getComponent() {
        return this.component;
    }

    @JsonProperty(value="host")
    public String getHostName() {
        return this.hostName;
    }

    @JsonProperty(value="state")
    public AlertState getState() {
        return this.state;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    public void setLabel(String alertLabel) {
        this.label = alertLabel;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    public void setText(String alertText) {
        this.text = StringUtils.abbreviateMiddle((String)alertText, (String)"\u2026", (int)32617);
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    @JsonProperty(value="instance")
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    @JsonProperty(value="component")
    public void setComponent(String component) {
        this.component = component;
    }

    @JsonProperty(value="host")
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @JsonProperty(value="state")
    public void setState(AlertState state) {
        this.state = state;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(long ts) {
        this.timestamp = ts;
    }

    @JsonProperty(value="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="clusterId")
    public Long getClusterId() {
        return this.clusterId;
    }

    @JsonProperty(value="clusterId")
    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    @JsonProperty(value="uuid")
    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.name, this.service, this.component, this.hostName, this.instance, this.clusterId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Alert other = (Alert)obj;
        return Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.name, other.name) && Objects.equals(this.service, other.service) && Objects.equals(this.component, other.component) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.instance, other.instance) && Objects.equals(this.clusterId, other.clusterId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("clusterId=").append(this.clusterId).append(", ");
        sb.append("state=").append((Object)this.state).append(", ");
        sb.append("name=").append(this.name).append(", ");
        sb.append("service=").append(this.service).append(", ");
        sb.append("component=").append(this.component).append(", ");
        sb.append("host=").append(this.hostName).append(", ");
        sb.append("instance=").append(this.instance).append(", ");
        sb.append("text='").append(this.text).append("'");
        sb.append('}');
        return sb.toString();
    }
}

