/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stageplanner;

import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RoleGraphNode {
    private Role role;
    private RoleCommand command;
    private int inDegree = 0;
    private List<String> hosts = new ArrayList<String>();
    private Map<String, RoleGraphNode> edges = new TreeMap<String, RoleGraphNode>();

    public RoleGraphNode(Role role, RoleCommand command) {
        this.role = role;
        this.command = command;
    }

    public synchronized void addHost(String host) {
        this.hosts.add(host);
    }

    public synchronized void addEdge(RoleGraphNode rgn) {
        if (this.edges.containsKey(rgn.getRole().toString())) {
            return;
        }
        this.edges.put(rgn.getRole().toString(), rgn);
        rgn.incrementInDegree();
    }

    private synchronized void incrementInDegree() {
        ++this.inDegree;
    }

    public Role getRole() {
        return this.role;
    }

    public RoleCommand getCommand() {
        return this.command;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    Collection<RoleGraphNode> getEdges() {
        return this.edges.values();
    }

    public synchronized void decrementInDegree() {
        --this.inDegree;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(this.role).append(", ").append((Object)this.command).append(", ").append(this.inDegree).append(")");
        return builder.toString();
    }
}

