/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stageplanner;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.stageplanner.RoleGraphNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleGraph {
    private static final Logger LOG = LoggerFactory.getLogger(RoleGraph.class);
    Map<String, RoleGraphNode> graph = null;
    private RoleCommandOrder roleDependencies;
    private Stage initialStage = null;
    private boolean sameHostOptimization = true;
    private CommandExecutionType commandExecutionType = CommandExecutionType.STAGE;
    @Inject
    private StageFactory stageFactory;
    @Inject
    private HostRoleCommandFactory hrcFactory;

    @AssistedInject
    public RoleGraph() {
    }

    @AssistedInject
    public RoleGraph(@Assisted RoleCommandOrder rd) {
        this.roleDependencies = rd;
    }

    public CommandExecutionType getCommandExecutionType() {
        return this.commandExecutionType;
    }

    public void setCommandExecutionType(CommandExecutionType commandExecutionType) {
        this.commandExecutionType = commandExecutionType;
    }

    public void build(Stage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Null stage");
        }
        if (this.commandExecutionType == CommandExecutionType.DEPENDENCY_ORDERED) {
            LOG.info("Build stage with DEPENDENCY_ORDERED commandExecutionType: {} ", (Object)stage.getRequestContext());
        }
        this.initialStage = stage;
        Map<String, Map<String, HostRoleCommand>> hostRoleCommands = stage.getHostRoleCommands();
        this.build(hostRoleCommands);
    }

    private void build(Map<String, Map<String, HostRoleCommand>> hostRoleCommands) {
        this.graph = new TreeMap<String, RoleGraphNode>();
        for (String host : hostRoleCommands.keySet()) {
            for (String role : hostRoleCommands.get(host).keySet()) {
                RoleGraphNode rgn;
                HostRoleCommand hostRoleCommand = hostRoleCommands.get(host).get(role);
                if (this.graph.get(role) == null) {
                    rgn = new RoleGraphNode(hostRoleCommand.getRole(), this.getRoleCommand(hostRoleCommand));
                    this.graph.put(role, rgn);
                }
                rgn = this.graph.get(role);
                rgn.addHost(host);
            }
        }
        if (this.commandExecutionType == CommandExecutionType.STAGE && null != this.roleDependencies) {
            for (String roleI : this.graph.keySet()) {
                for (String roleJ : this.graph.keySet()) {
                    RoleGraphNode rgnJ;
                    if (roleI.equals(roleJ)) continue;
                    RoleGraphNode rgnI = this.graph.get(roleI);
                    int order = this.roleDependencies.order(rgnI, rgnJ = this.graph.get(roleJ));
                    if (order == -1) {
                        rgnI.addEdge(rgnJ);
                        continue;
                    }
                    if (order != 1) continue;
                    rgnJ.addEdge(rgnI);
                }
            }
        }
    }

    private RoleCommand getRoleCommand(HostRoleCommand hostRoleCommand) {
        if (hostRoleCommand.getRoleCommand().equals((Object)RoleCommand.CUSTOM_COMMAND)) {
            return hostRoleCommand.getCustomCommandName().equals("RESTART") ? RoleCommand.RESTART : RoleCommand.CUSTOM_COMMAND;
        }
        return hostRoleCommand.getRoleCommand();
    }

    public List<Stage> getStages() throws OBDPException {
        long initialStageId = this.initialStage.getStageId();
        ArrayList<Stage> stageList = new ArrayList<Stage>();
        ArrayList<RoleGraphNode> firstStageNodes = new ArrayList<RoleGraphNode>();
        if (!this.graph.isEmpty()) {
            LOG.info("Detecting cycle graphs");
            LOG.info(this.stringifyGraph());
            this.breakCycleGraph();
        }
        while (!this.graph.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.stringifyGraph());
            }
            for (String role : this.graph.keySet()) {
                RoleGraphNode rgn = this.graph.get(role);
                if (rgn.getInDegree() != 0) continue;
                firstStageNodes.add(rgn);
            }
            Stage aStage = this.getStageFromGraphNodes(this.initialStage, firstStageNodes);
            aStage.setStageId(++initialStageId);
            stageList.add(aStage);
            for (RoleGraphNode rgn : firstStageNodes) {
                if (this.sameHostOptimization) {
                    // empty if block
                }
                this.removeZeroInDegreeNode(rgn.getRole().toString());
            }
            firstStageNodes.clear();
        }
        return stageList;
    }

    public List<Map<String, List<HostRoleCommand>>> getOrderedHostRoleCommands(Map<String, Map<String, HostRoleCommand>> unorderedCommands) {
        this.build(unorderedCommands);
        ArrayList<Map<String, List<HostRoleCommand>>> orderedCommands = new ArrayList<Map<String, List<HostRoleCommand>>>();
        ArrayList<RoleGraphNode> firstStageNodes = new ArrayList<RoleGraphNode>();
        while (!this.graph.isEmpty()) {
            for (String role : this.graph.keySet()) {
                RoleGraphNode rgn = this.graph.get(role);
                if (rgn.getInDegree() != 0) continue;
                firstStageNodes.add(rgn);
            }
            HashMap commandsPerHost = new HashMap();
            for (RoleGraphNode rgn : firstStageNodes) {
                for (String host : rgn.getHosts()) {
                    ArrayList<HostRoleCommand> commands = (ArrayList<HostRoleCommand>)commandsPerHost.get(host);
                    if (null == commands) {
                        commands = new ArrayList<HostRoleCommand>();
                        commandsPerHost.put(host, commands);
                    }
                    HostRoleCommand hrc = this.hrcFactory.create(host, rgn.getRole(), null, rgn.getCommand());
                    commands.add(hrc);
                }
            }
            orderedCommands.add(commandsPerHost);
            for (RoleGraphNode rgn : firstStageNodes) {
                this.removeZeroInDegreeNode(rgn.getRole().toString());
            }
            firstStageNodes.clear();
        }
        return orderedCommands;
    }

    private synchronized void removeZeroInDegreeNode(String role) {
        RoleGraphNode nodeToRemove = this.graph.remove(role);
        for (RoleGraphNode edgeNode : nodeToRemove.getEdges()) {
            edgeNode.decrementInDegree();
        }
    }

    private Stage getStageFromGraphNodes(Stage origStage, List<RoleGraphNode> stageGraphNodes) {
        Stage newStage = this.stageFactory.createNew(origStage.getRequestId(), origStage.getLogDir(), origStage.getClusterName(), origStage.getClusterId(), origStage.getRequestContext(), origStage.getCommandParamsStage(), origStage.getHostParamsStage());
        newStage.setSuccessFactors(origStage.getSuccessFactors());
        newStage.setSkippable(origStage.isSkippable());
        newStage.setAutoSkipFailureSupported(origStage.isAutoSkipOnFailureSupported());
        if (this.commandExecutionType != null) {
            newStage.setCommandExecutionType(this.commandExecutionType);
        }
        for (RoleGraphNode rgn : stageGraphNodes) {
            for (String host : rgn.getHosts()) {
                newStage.addExecutionCommandWrapper(origStage, host, rgn.getRole());
            }
        }
        return newStage;
    }

    public String stringifyGraph() {
        StringBuilder builder = new StringBuilder();
        builder.append("Graph:\n");
        for (String role : this.graph.keySet()) {
            builder.append(this.graph.get(role));
            for (RoleGraphNode rgn : this.graph.get(role).getEdges()) {
                builder.append(" --> ");
                builder.append(rgn);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public void breakCycleGraph() throws OBDPException {
        ArrayList<String> edges = new ArrayList<String>();
        for (String role : this.graph.keySet()) {
            RoleGraphNode fromNode = this.graph.get(role);
            String fnRole = fromNode.getRole().name();
            String fnCommand = fromNode.getCommand().name();
            for (RoleGraphNode toNode : fromNode.getEdges()) {
                String tnRole = toNode.getRole().name();
                String tnCommand = toNode.getCommand().name();
                String format = "%s:%s --> %s:%s";
                String edge = String.format(format, fnRole, fnCommand, tnRole, tnCommand);
                String reversedEdge = String.format(format, tnRole, tnCommand, fnRole, fnCommand);
                if (edges.contains(reversedEdge)) {
                    String msg = String.format("Circular dependencies detected between %s and %s for %s. %s already exists in the role command order.", fnRole, tnRole, edge, reversedEdge);
                    LOG.error(msg);
                    throw new OBDPException(msg);
                }
                edges.add(edge);
            }
        }
    }
}

