/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.controller.internal.TaskResourceProvider;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.events.ClusterComponentsRepoChangedEvent;
import id.onyx.obdp.server.events.listeners.upgrade.StackVersionListener;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.MasterHostResolver;
import id.onyx.obdp.server.stack.upgrade.AddComponentTask;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ManualTask;
import id.onyx.obdp.server.stack.upgrade.RestartTask;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckGrouping;
import id.onyx.obdp.server.stack.upgrade.StartTask;
import id.onyx.obdp.server.stack.upgrade.StopTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradeFunction;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.Placeholder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeGroupHolder;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UpgradeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeHelper.class);
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("(\\{\\{.*?\\}\\})");
    @Inject
    Provider<ConfigHelper> m_configHelperProvider;
    @Inject
    private Provider<OBDPMetaInfo> m_ambariMetaInfoProvider;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private Provider<OBDPManagementControllerImpl> m_controllerProvider;
    @Inject
    ServiceConfigDAO m_serviceConfigDAO;
    @Inject
    private OBDPEventPublisher ambariEventPublisher;

    public UpgradePack suggestUpgradePack(String clusterName, StackId sourceStackId, StackId targetStackId, Direction direction, UpgradeType upgradeType, String preferredUpgradePackName) throws OBDPException {
        Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(clusterName);
        StackId currentStack = cluster.getCurrentStackVersion();
        UpgradePack pack = this.findPreferred(preferredUpgradePackName, currentStack, targetStackId);
        if (null != pack) {
            return pack;
        }
        pack = this.findUpgradePack(targetStackId, currentStack, upgradeType, true);
        if (null != pack) {
            return pack;
        }
        pack = this.findUpgradePack(currentStack, targetStackId, upgradeType, false);
        if (null == pack) {
            throw new OBDPException(String.format("Unable to perform %s. Could not locate %s upgrade pack for stack %s", direction.getText(false), upgradeType.toString(), targetStackId));
        }
        return pack;
    }

    private UpgradePack findPreferred(String preferred, StackId ... stackIds) {
        if (StringUtils.isEmpty((String)preferred)) {
            return null;
        }
        for (StackId stackId : stackIds) {
            Map<String, UpgradePack> packs = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getUpgradePacks(stackId.getStackName(), stackId.getStackVersion());
            if (packs.containsKey(preferred)) {
                return packs.get(preferred);
            }
            LOG.warn("Upgrade pack '{}' not found for stack {}", (Object)preferred, (Object)stackId);
        }
        return null;
    }

    private UpgradePack findUpgradePack(StackId sourceStack, StackId stackToFind, UpgradeType upgradeType, boolean compareToSource) throws OBDPException {
        Map<String, UpgradePack> packs = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getUpgradePacks(sourceStack.getStackName(), sourceStack.getStackVersion());
        UpgradePack result = null;
        for (UpgradePack upgradePack : packs.values()) {
            StackId upgradeStack = compareToSource ? new StackId(upgradePack.getSourceStack()) : new StackId(upgradePack.getTargetStack());
            if (!upgradeStack.equals(stackToFind) || upgradePack.getType() != upgradeType) continue;
            if (null == result) {
                result = upgradePack;
                continue;
            }
            throw new OBDPException(String.format("Unable to resolve upgrade pack. Found multiple upgrade packs for type %s and stack %s", upgradeType.toString(), stackToFind));
        }
        return result;
    }

    public List<UpgradeGroupHolder> createSequence(UpgradePack upgradePack, UpgradeContext context) throws OBDPException {
        Cluster cluster = context.getCluster();
        MasterHostResolver mhr = context.getResolver();
        Map<String, AddComponentTask> addedComponentsDuringUpgrade = upgradePack.getAddComponentTasks();
        Map<String, Map<String, UpgradePack.ProcessingComponent>> allTasks = upgradePack.getTasks();
        ArrayList<UpgradeGroupHolder> groups = new ArrayList<UpgradeGroupHolder>();
        UpgradeGroupHolder previousGroupHolder = null;
        for (Grouping grouping : upgradePack.getGroups(context.getDirection())) {
            Object reverse;
            if (!context.isScoped(grouping.scope)) continue;
            if (null != grouping.condition && !grouping.condition.isSatisfied(context)) {
                LOG.info("Skipping {} while building upgrade orchestration due to {}", (Object)grouping, (Object)grouping.condition);
                continue;
            }
            UpgradeGroupHolder groupHolder = new UpgradeGroupHolder();
            groupHolder.name = grouping.name;
            groupHolder.title = grouping.title;
            groupHolder.groupClass = grouping.getClass();
            groupHolder.skippable = grouping.skippable;
            groupHolder.supportsAutoSkipOnFailure = grouping.supportsAutoSkipOnFailure;
            groupHolder.allowRetry = grouping.allowRetry;
            groupHolder.processingGroup = grouping.isProcessingGroup();
            if (context.getDirection().isDowngrade()) {
                groupHolder.skippable = true;
            }
            Task.Type functionName = null;
            if (grouping instanceof UpgradeFunction) {
                functionName = ((UpgradeFunction)((Object)grouping)).getFunction();
            }
            if (upgradePack.getType() == UpgradeType.NON_ROLLING) {
                grouping.performServiceCheck = false;
            }
            StageWrapperBuilder builder = grouping.getBuilder();
            Object services = grouping.services;
            if (upgradePack.getType() == UpgradeType.ROLLING && context.getDirection().isDowngrade() && !services.isEmpty()) {
                reverse = new ArrayList<UpgradePack.OrderService>((Collection<UpgradePack.OrderService>)services);
                Collections.reverse(reverse);
                services = reverse;
            }
            reverse = services.iterator();
            while (reverse.hasNext()) {
                UpgradePack.OrderService service = reverse.next();
                if (!context.isServiceSupported(service.serviceName) || upgradePack.getType() == UpgradeType.ROLLING && !allTasks.containsKey(service.serviceName)) continue;
                for (String component : service.components) {
                    if (upgradePack.getType() == UpgradeType.ROLLING && !allTasks.get(service.serviceName).containsKey(component)) continue;
                    UpgradePack.ProcessingComponent pc = null;
                    if (null == functionName) {
                        pc = allTasks.get(service.serviceName).get(component);
                    } else if (functionName == Task.Type.STOP) {
                        pc = new UpgradePack.ProcessingComponent();
                        pc.name = component;
                        pc.tasks = new ArrayList<Task>();
                        pc.tasks.add(new StopTask());
                    } else if (allTasks.containsKey(service.serviceName) && allTasks.get(service.serviceName).containsKey(component)) {
                        pc = allTasks.get(service.serviceName).get(component);
                    } else {
                        pc = new UpgradePack.ProcessingComponent();
                        pc.name = component;
                        pc.tasks = new ArrayList<Task>();
                        if (functionName == Task.Type.START) {
                            pc.tasks.add(new StartTask());
                        }
                        if (functionName == Task.Type.RESTART) {
                            pc.tasks.add(new RestartTask());
                        }
                    }
                    if (pc == null) {
                        LOG.error(MessageFormat.format("Couldn't create a processing component for service {0} and component {1}.", service.serviceName, component));
                        continue;
                    }
                    HostsType hostsType = mhr.getMasterAndHosts(service.serviceName, component);
                    boolean taskIsRestartOrStart = functionName == null || functionName == Task.Type.START || functionName == Task.Type.RESTART;
                    String serviceAndComponentHash = service.serviceName + "/" + component;
                    if (taskIsRestartOrStart && addedComponentsDuringUpgrade.containsKey(serviceAndComponentHash)) {
                        AddComponentTask task = addedComponentsDuringUpgrade.get(serviceAndComponentHash);
                        Collection<Host> candidateHosts = MasterHostResolver.getCandidateHosts(cluster, task.hosts, task.hostService, task.hostComponent);
                        if (!candidateHosts.isEmpty()) {
                            if (null == hostsType) {
                                hostsType = HostsType.normal(candidateHosts.stream().map(host -> host.getHostName()).collect(Collectors.toCollection(LinkedHashSet::new)));
                            } else {
                                Set<String> hostsForTask = hostsType.getHosts();
                                for (Host host2 : candidateHosts) {
                                    hostsForTask.add(host2.getHostName());
                                }
                            }
                        }
                    }
                    if (null == hostsType) continue;
                    if (!hostsType.unhealthy.isEmpty()) {
                        context.addUnhealthy(hostsType.unhealthy);
                    }
                    Service svc = cluster.getService(service.serviceName);
                    this.setDisplayNames(context, service.serviceName, component);
                    if (service.serviceName.equalsIgnoreCase("HDFS") && component.equalsIgnoreCase("NAMENODE")) {
                        switch (upgradePack.getType()) {
                            case ROLLING: {
                                if (!hostsType.getHosts().isEmpty() && hostsType.hasMastersAndSecondaries()) {
                                    hostsType.arrangeHostSecondariesFirst();
                                    builder.add(context, hostsType, service.serviceName, svc.isClientOnlyService(), pc, null);
                                    break;
                                }
                                LOG.warn("Could not orchestrate NameNode.  Hosts could not be resolved: hosts={}, active={}, standby={}", new Object[]{StringUtils.join(hostsType.getHosts(), (char)','), hostsType.getMasters(), hostsType.getSecondaries()});
                                break;
                            }
                            case NON_ROLLING: {
                                boolean isNameNodeHA = mhr.isNameNodeHA();
                                if (isNameNodeHA && hostsType.hasMastersAndSecondaries()) {
                                    builder.add(context, HostsType.normal(hostsType.getMasters()), service.serviceName, svc.isClientOnlyService(), pc, UpgradeHelper.nameNodeRole("active"));
                                    builder.add(context, HostsType.normal(hostsType.getSecondaries()), service.serviceName, svc.isClientOnlyService(), pc, UpgradeHelper.nameNodeRole("standby"));
                                    break;
                                }
                                builder.add(context, hostsType, service.serviceName, svc.isClientOnlyService(), pc, null);
                            }
                        }
                        continue;
                    }
                    builder.add(context, hostsType, service.serviceName, svc.isClientOnlyService(), pc, null);
                }
            }
            List<StageWrapper> proxies = builder.build(context);
            if (!CollectionUtils.isNotEmpty(proxies)) continue;
            groupHolder.items = proxies;
            this.postProcess(context, groupHolder);
            if (ServiceCheckGrouping.class.isInstance(grouping)) {
                if (null != previousGroupHolder && ServiceCheckGrouping.class.equals(previousGroupHolder.groupClass)) {
                    this.mergeServiceChecks(groupHolder, previousGroupHolder);
                } else {
                    groups.add(groupHolder);
                }
            } else {
                groups.add(groupHolder);
            }
            previousGroupHolder = groupHolder;
        }
        if (LOG.isDebugEnabled()) {
            for (UpgradeGroupHolder upgradeGroupHolder : groups) {
                LOG.debug(upgradeGroupHolder.name);
                int i = 0;
                for (StageWrapper proxy : upgradeGroupHolder.items) {
                    LOG.debug("  Stage {}", (Object)i++);
                    int j = 0;
                    for (TaskWrapper task : proxy.getTasks()) {
                        LOG.debug("    Task {} {}", (Object)j++, (Object)task);
                    }
                }
            }
        }
        Iterator iterator = groups.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            int n;
            UpgradeGroupHolder holder = (UpgradeGroupHolder)iterator.next();
            if (ServiceCheckGrouping.class.equals(holder.groupClass) && n == 0) {
                iterator.remove();
            }
            n |= holder.processingGroup;
        }
        return groups;
    }

    private static Map<String, String> nameNodeRole(String value) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("desired_namenode_role", value);
        return params;
    }

    private void mergeServiceChecks(UpgradeGroupHolder newHolder, UpgradeGroupHolder oldHolder) {
        LinkedHashSet<StageWrapper> priority = new LinkedHashSet<StageWrapper>();
        LinkedHashSet<StageWrapper> others = new LinkedHashSet<StageWrapper>();
        HashSet<String> extraKeys = new HashSet<String>();
        LinkedHashSet<StageWrapper> extras = new LinkedHashSet<StageWrapper>();
        for (List holderItems : new List[]{oldHolder.items, newHolder.items}) {
            for (StageWrapper stageWrapper : holderItems) {
                if (stageWrapper instanceof ServiceCheckGrouping.ServiceCheckStageWrapper) {
                    ServiceCheckGrouping.ServiceCheckStageWrapper wrapper = (ServiceCheckGrouping.ServiceCheckStageWrapper)stageWrapper;
                    if (wrapper.priority) {
                        priority.add(stageWrapper);
                        continue;
                    }
                    others.add(stageWrapper);
                    continue;
                }
                String key = stageWrapper.toString();
                if (extraKeys.contains(key)) continue;
                extras.add(stageWrapper);
                extraKeys.add(key);
            }
        }
        others = new LinkedHashSet(CollectionUtils.subtract(others, priority));
        oldHolder.items = Lists.newLinkedList(priority);
        oldHolder.items.addAll(others);
        oldHolder.items.addAll(extras);
    }

    private void postProcess(UpgradeContext ctx, UpgradeGroupHolder holder) {
        holder.title = this.tokenReplace(ctx, holder.title, null, null);
        for (StageWrapper stageWrapper : holder.items) {
            if (null != stageWrapper.getText()) {
                stageWrapper.setText(this.tokenReplace(ctx, stageWrapper.getText(), null, null));
            }
            for (TaskWrapper taskWrapper : stageWrapper.getTasks()) {
                for (Task task : taskWrapper.getTasks()) {
                    if (null != task.summary) {
                        task.summary = this.tokenReplace(ctx, task.summary, null, null);
                    }
                    if (task.getType() != Task.Type.MANUAL) continue;
                    ManualTask mt = (ManualTask)task;
                    if (null == mt.messages || mt.messages.isEmpty()) continue;
                    for (int i = 0; i < mt.messages.size(); ++i) {
                        String message = (String)mt.messages.get(i);
                        message = this.tokenReplace(ctx, message, taskWrapper.getService(), taskWrapper.getComponent());
                        mt.messages.set(i, message);
                    }
                }
            }
        }
    }

    private String tokenReplace(UpgradeContext ctx, String source, String service, String component) {
        Cluster cluster = ctx.getCluster();
        MasterHostResolver mhr = ctx.getResolver();
        String result = source;
        ArrayList<String> tokens = new ArrayList<String>(5);
        Matcher matcher = PLACEHOLDER_REGEX.matcher(source);
        while (matcher.find()) {
            tokens.add(matcher.group(1));
        }
        for (String token : tokens) {
            String value = null;
            Placeholder p = Placeholder.find(token);
            switch (p) {
                case HOST_ALL: {
                    HostsType hostsType;
                    if (null == service || null == component || null == (hostsType = mhr.getMasterAndHosts(service, component))) break;
                    value = StringUtils.join(hostsType.getHosts(), (String)", ");
                    break;
                }
                case HOST_MASTER: {
                    HostsType hostsType;
                    if (null == service || null == component || null == (hostsType = mhr.getMasterAndHosts(service, component))) break;
                    value = StringUtils.join(hostsType.getMasters(), (String)", ");
                    break;
                }
                case VERSION: {
                    value = ctx.getRepositoryVersion().getVersion();
                    break;
                }
                case DIRECTION_VERB: 
                case DIRECTION_VERB_PROPER: {
                    value = ctx.getDirection().getVerb(p == Placeholder.DIRECTION_VERB_PROPER);
                    break;
                }
                case DIRECTION_PAST: 
                case DIRECTION_PAST_PROPER: {
                    value = ctx.getDirection().getPast(p == Placeholder.DIRECTION_PAST_PROPER);
                    break;
                }
                case DIRECTION_PLURAL: 
                case DIRECTION_PLURAL_PROPER: {
                    value = ctx.getDirection().getPlural(p == Placeholder.DIRECTION_PLURAL_PROPER);
                    break;
                }
                case DIRECTION_TEXT: 
                case DIRECTION_TEXT_PROPER: {
                    value = ctx.getDirection().getText(p == Placeholder.DIRECTION_TEXT_PROPER);
                    break;
                }
                default: {
                    value = ((ConfigHelper)this.m_configHelperProvider.get()).getPlaceholderValueFromDesiredConfigurations(cluster, token);
                }
            }
            if (null == value) continue;
            result = result.replace(token, value);
        }
        return result;
    }

    public Resource getTaskResource(String clusterName, Long requestId, Long stageId, Long taskId) throws UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException, SystemException {
        ClusterController clusterController = ClusterControllerHelper.getClusterController();
        Request request = PropertyHelper.getReadRequest(new String[0]);
        Predicate p1 = new PredicateBuilder().property(TaskResourceProvider.TASK_CLUSTER_NAME_PROPERTY_ID).equals(clusterName).toPredicate();
        Predicate p2 = new PredicateBuilder().property(TaskResourceProvider.TASK_REQUEST_ID_PROPERTY_ID).equals(requestId.toString()).toPredicate();
        Predicate p3 = new PredicateBuilder().property(TaskResourceProvider.TASK_STAGE_ID_PROPERTY_ID).equals(stageId.toString()).toPredicate();
        Predicate p4 = new PredicateBuilder().property(TaskResourceProvider.TASK_ID_PROPERTY_ID).equals(taskId.toString()).toPredicate();
        QueryResponse response = clusterController.getResources(Resource.Type.Task, request, new AndPredicate(p1, p2, p3, p4));
        Set<Resource> task = response.getResources();
        return task.size() == 1 ? task.iterator().next() : null;
    }

    private void setDisplayNames(UpgradeContext context, String service, String component) {
        StackId currentStackId = context.getCluster().getCurrentStackVersion();
        StackId stackId = context.getRepositoryVersion().getStackId();
        try {
            ServiceInfo serviceInfo = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getService(stackId.getStackName(), stackId.getStackVersion(), service);
            if (null == serviceInfo) {
                serviceInfo = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getService(currentStackId.getStackName(), currentStackId.getStackVersion(), service);
            }
            if (null == serviceInfo) {
                LOG.debug("Unable to lookup service display name information for {}", (Object)service);
                return;
            }
            context.setServiceDisplay(service, serviceInfo.getDisplayName());
            ComponentInfo compInfo = serviceInfo.getComponentByName(component);
            if (null == compInfo) {
                LOG.debug("Unable to lookup component display name information for {}", (Object)component);
                return;
            }
            context.setComponentDisplay(service, component, compInfo.getDisplayName());
        }
        catch (OBDPException e) {
            LOG.debug("Could not get service detail", (Throwable)e);
        }
    }

    @Transactional
    public void updateDesiredRepositoriesAndConfigs(UpgradeContext upgradeContext) throws OBDPException {
        this.setDesiredRepositories(upgradeContext);
        this.processConfigurationsIfRequired(upgradeContext);
    }

    public void publishDesiredRepositoriesUpdates(UpgradeContext upgradeContext) throws OBDPException {
        Cluster cluster = upgradeContext.getCluster();
        this.ambariEventPublisher.publish(new ClusterComponentsRepoChangedEvent(cluster.getClusterId()));
    }

    private void setDesiredRepositories(UpgradeContext upgradeContext) throws OBDPException {
        Cluster cluster = upgradeContext.getCluster();
        Set<String> services = upgradeContext.getSupportedServices();
        for (String serviceName : services) {
            Service service = cluster.getService(serviceName);
            RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
            StackId targetStack = targetRepositoryVersion.getStackId();
            service.setDesiredRepositoryVersion(targetRepositoryVersion);
            Collection<ServiceComponent> components = service.getServiceComponents().values();
            for (ServiceComponent serviceComponent : components) {
                boolean versionAdvertised = false;
                try {
                    ComponentInfo ci = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getComponent(targetStack.getStackName(), targetStack.getStackVersion(), serviceComponent.getServiceName(), serviceComponent.getName());
                    versionAdvertised = ci.isVersionAdvertised();
                }
                catch (OBDPException e) {
                    LOG.warn("Component {}/{} doesn't exist for stack {}.  Setting version to {}", new Object[]{serviceComponent.getServiceName(), serviceComponent.getName(), targetStack, StackVersionListener.UNKNOWN_VERSION});
                }
                UpgradeState upgradeStateToSet = UpgradeState.IN_PROGRESS;
                if (!versionAdvertised) {
                    upgradeStateToSet = UpgradeState.NONE;
                }
                for (ServiceComponentHost serviceComponentHost : serviceComponent.getServiceComponentHosts().values()) {
                    if (serviceComponentHost.getUpgradeState() != upgradeStateToSet) {
                        serviceComponentHost.setUpgradeState(upgradeStateToSet);
                    }
                    if (versionAdvertised || StringUtils.equals((String)StackVersionListener.UNKNOWN_VERSION, (String)serviceComponentHost.getVersion())) continue;
                    serviceComponentHost.setVersion(StackVersionListener.UNKNOWN_VERSION);
                }
                serviceComponent.setDesiredRepositoryVersion(targetRepositoryVersion);
            }
        }
    }

    private void processConfigurationsIfRequired(UpgradeContext upgradeContext) throws OBDPException {
        OBDPManagementController controller = (OBDPManagementController)this.m_controllerProvider.get();
        Cluster cluster = upgradeContext.getCluster();
        Direction direction = upgradeContext.getDirection();
        String userName = controller.getAuthName();
        Set<String> servicesInUpgrade = upgradeContext.getSupportedServices();
        HashSet<String> clusterConfigTypes = new HashSet<String>();
        HashSet<String> processedClusterConfigTypes = new HashSet<String>();
        boolean configsChanged = false;
        for (String serviceName : servicesInUpgrade) {
            StackId targetStackId;
            RepositoryVersionEntity sourceRepositoryVersion = upgradeContext.getSourceRepositoryVersion(serviceName);
            RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
            StackId sourceStackId = sourceRepositoryVersion.getStackId();
            if (sourceStackId.equals(targetStackId = targetRepositoryVersion.getStackId())) {
                RepositoryVersionEntity associatedRepositoryVersion = upgradeContext.getRepositoryVersion();
                LOG.info("The {} {} {} will not change stack configurations for {} since the source and target are both {}", new Object[]{direction.getText(false), direction.getPreposition(), associatedRepositoryVersion.getVersion(), serviceName, targetStackId});
                continue;
            }
            ConfigHelper configHelper = (ConfigHelper)this.m_configHelperProvider.get();
            if (direction == Direction.DOWNGRADE) {
                cluster.applyLatestConfigurations(targetStackId, serviceName);
                configsChanged = true;
                continue;
            }
            Map<String, Set<String>> readOnlyProperties = this.getReadOnlyProperties(sourceStackId, serviceName);
            Map<String, Map<String, String>> oldServiceDefaultConfigsByType = configHelper.getDefaultProperties(sourceStackId, serviceName);
            Map<String, Map<String, String>> newServiceDefaultConfigsByType = configHelper.getDefaultProperties(targetStackId, serviceName);
            if (null == oldServiceDefaultConfigsByType || null == newServiceDefaultConfigsByType) continue;
            HashSet<String> foundConfigTypes = new HashSet<String>();
            ArrayList<Config> existingServiceConfigs = new ArrayList<Config>();
            List<ServiceConfigEntity> latestServiceConfigs = this.m_serviceConfigDAO.getLastServiceConfigsForService(cluster.getClusterId(), serviceName);
            for (ServiceConfigEntity serviceConfigEntity : latestServiceConfigs) {
                List<ClusterConfigEntity> existingConfigurations = serviceConfigEntity.getClusterConfigEntities();
                for (ClusterConfigEntity currentServiceConfig : existingConfigurations) {
                    String configurationType = currentServiceConfig.getType();
                    Config currentClusterConfigForService = cluster.getDesiredConfigByType(configurationType);
                    if (currentClusterConfigForService == null) {
                        throw new OBDPException(String.format("configuration type %s did not have a selected version", configurationType));
                    }
                    existingServiceConfigs.add(currentClusterConfigForService);
                    foundConfigTypes.add(configurationType);
                }
            }
            HashSet missingConfigTypes = new HashSet(CollectionUtils.subtract(oldServiceDefaultConfigsByType.keySet(), foundConfigTypes));
            for (String missingConfigType : missingConfigTypes) {
                Config config = cluster.getDesiredConfigByType(missingConfigType);
                if (null == config) continue;
                existingServiceConfigs.add(config);
                clusterConfigTypes.add(missingConfigType);
            }
            for (Config existingServiceConfig : existingServiceConfigs) {
                String configurationType = existingServiceConfig.getType();
                Map<String, String> oldServiceDefaultConfigs = oldServiceDefaultConfigsByType.get(configurationType);
                if (null == oldServiceDefaultConfigs) {
                    oldServiceDefaultConfigs = Collections.emptyMap();
                }
                Map<String, String> existingConfigurations = existingServiceConfig.getProperties();
                Map<String, String> newDefaultConfigurations = newServiceDefaultConfigsByType.get(configurationType);
                if (null == newDefaultConfigurations) {
                    newServiceDefaultConfigsByType.put(configurationType, existingConfigurations);
                    continue;
                }
                Iterator<Map.Entry<String, String>> iter = newDefaultConfigurations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    if (entry.getValue() != null) continue;
                    iter.remove();
                }
                for (Map.Entry<String, String> existingConfigurationEntry : existingConfigurations.entrySet()) {
                    String existingConfigurationKey = existingConfigurationEntry.getKey();
                    String existingConfigurationValue = existingConfigurationEntry.getValue();
                    if (newDefaultConfigurations.containsKey(existingConfigurationKey)) {
                        String newDefaultConfigurationValue = newDefaultConfigurations.get(existingConfigurationKey);
                        if (StringUtils.equals((String)existingConfigurationValue, (String)newDefaultConfigurationValue)) continue;
                        String oldDefaultValue = oldServiceDefaultConfigs.get(existingConfigurationKey);
                        Set<String> readOnlyPropertiesForType = readOnlyProperties.get(configurationType);
                        boolean readOnly = null != readOnlyPropertiesForType && readOnlyPropertiesForType.contains(existingConfigurationKey);
                        if (readOnly || StringUtils.equals((String)existingConfigurationValue, (String)oldDefaultValue)) continue;
                        newDefaultConfigurations.put(existingConfigurationKey, existingConfigurationValue);
                        continue;
                    }
                    newDefaultConfigurations.put(existingConfigurationKey, existingConfigurationValue);
                }
                Iterator<Map.Entry<String, String>> newDefaultConfigurationsIterator = newDefaultConfigurations.entrySet().iterator();
                while (newDefaultConfigurationsIterator.hasNext()) {
                    Map.Entry<String, String> newConfigurationEntry = newDefaultConfigurationsIterator.next();
                    String newConfigurationPropertyName = newConfigurationEntry.getKey();
                    if (!oldServiceDefaultConfigs.containsKey(newConfigurationPropertyName) || existingConfigurations.containsKey(newConfigurationPropertyName)) continue;
                    LOG.info("The property {}/{} exists in both {} and {} but is not part of the current set of configurations and will therefore not be included in the configuration merge", new Object[]{configurationType, newConfigurationPropertyName, sourceStackId, targetStackId});
                    newDefaultConfigurationsIterator.remove();
                }
            }
            for (String clusterConfigType : clusterConfigTypes) {
                if (processedClusterConfigTypes.contains(clusterConfigType)) {
                    newServiceDefaultConfigsByType.remove(clusterConfigType);
                    continue;
                }
                processedClusterConfigTypes.add(clusterConfigType);
            }
            Set<String> set = newServiceDefaultConfigsByType.keySet();
            LOG.warn("The upgrade will create the following configurations for stack {}: {}", (Object)targetStackId, (Object)StringUtils.join(set, (char)','));
            String serviceVersionNote = String.format("%s %s %s", direction.getText(true), direction.getPreposition(), upgradeContext.getRepositoryVersion().getVersion());
            configHelper.createConfigTypes(cluster, targetStackId, controller, newServiceDefaultConfigsByType, userName, serviceVersionNote);
            configsChanged = true;
        }
        if (configsChanged) {
            ((ConfigHelper)this.m_configHelperProvider.get()).updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
        }
    }

    private Map<String, Set<String>> getReadOnlyProperties(StackId stackId, String serviceName) throws OBDPException {
        HashMap<String, Set<String>> readOnlyProperties = new HashMap<String, Set<String>>();
        HashSet<PropertyInfo> properties = new HashSet<PropertyInfo>();
        Set<PropertyInfo> stackProperties = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getStackProperties(stackId.getStackName(), stackId.getStackVersion());
        Set<PropertyInfo> serviceProperties = ((OBDPMetaInfo)this.m_ambariMetaInfoProvider.get()).getServiceProperties(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        if (CollectionUtils.isNotEmpty(stackProperties)) {
            properties.addAll(stackProperties);
        }
        if (CollectionUtils.isNotEmpty(serviceProperties)) {
            properties.addAll(serviceProperties);
        }
        for (PropertyInfo property : properties) {
            ValueAttributesInfo valueAttributes = property.getPropertyValueAttributes();
            if (null == valueAttributes || valueAttributes.getReadOnly() != Boolean.TRUE) continue;
            String type = ConfigHelper.fileNameToConfigType(property.getFilename());
            HashSet<String> readOnlyPropertiesForType = (HashSet<String>)readOnlyProperties.get(type);
            if (null == readOnlyPropertiesForType) {
                readOnlyPropertiesForType = new HashSet<String>();
                readOnlyProperties.put(type, readOnlyPropertiesForType);
            }
            readOnlyPropertiesForType.add(property.getName());
        }
        return readOnlyProperties;
    }
}

