/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.KerberosDetails;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.PreUpgradeCheckResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeHistoryEntity;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.stack.MasterHostResolver;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.HostOrderGrouping;
import id.onyx.obdp.server.stack.upgrade.HostOrderItem;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradeScope;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeServiceSummary;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeSummary;
import id.onyx.obdp.server.stageplanner.RoleGraphFactory;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.OrchestrationOptions;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeInformation;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeContext {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeContext.class);
    public static final String COMMAND_PARAM_CLUSTER_NAME = "clusterName";
    public static final String COMMAND_PARAM_DIRECTION = "upgrade_direction";
    public static final String COMMAND_PARAM_UPGRADE_PACK = "upgrade_pack";
    public static final String COMMAND_PARAM_REQUEST_ID = "request_id";
    public static final String COMMAND_PARAM_UPGRADE_TYPE = "upgrade_type";
    public static final String COMMAND_PARAM_TASKS = "tasks";
    public static final String COMMAND_PARAM_STRUCT_OUT = "structured_out";
    private final Cluster m_cluster;
    private final Direction m_direction;
    private final UpgradeType m_type;
    private final UpgradePack m_upgradePack;
    private final RepositoryVersionEntity m_repositoryVersion;
    private final MasterHostResolver m_resolver;
    private final List<ServiceComponentHost> m_unhealthy = new ArrayList<ServiceComponentHost>();
    private final Map<String, String> m_serviceNames = new HashMap<String, String>();
    private final Map<String, String> m_componentNames = new HashMap<String, String>();
    private boolean m_autoSkipComponentFailures = false;
    private boolean m_autoSkipServiceCheckFailures = false;
    private boolean m_autoSkipManualVerification = false;
    private final Set<String> m_services = new HashSet<String>();
    private final Map<String, RepositoryVersionEntity> m_targetRepositoryMap = new HashMap<String, RepositoryVersionEntity>();
    private final Map<String, RepositoryVersionEntity> m_sourceRepositoryMap = new HashMap<String, RepositoryVersionEntity>();
    @Inject
    private HostRoleCommandFactory m_hrcFactory;
    @Inject
    private RoleGraphFactory m_roleGraphFactory;
    @Inject
    private Gson m_gson;
    @Inject
    private OBDPMetaInfo m_metaInfo;
    @Inject
    private UpgradeHelper m_upgradeHelper;
    @Inject
    private RepositoryVersionDAO m_repoVersionDAO;
    @Inject
    private UpgradeDAO m_upgradeDAO;
    @Inject
    private KerberosHelper m_kerberosHelper;
    private final boolean m_isRevert;
    private long m_revertUpgradeId;
    private RepositoryType m_orchestration = RepositoryType.STANDARD;
    @Inject
    private Configuration configuration;
    private OrchestrationOptions m_orchestrationOptions;

    private UpgradeType calculateUpgradeType(Map<String, Object> upgradeRequestMap, UpgradeEntity upgradeEntity) throws OBDPException {
        UpgradeType upgradeType = UpgradeType.ROLLING;
        String upgradeTypeProperty = (String)upgradeRequestMap.get("Upgrade/upgrade_type");
        boolean upgradeTypePassed = StringUtils.isNotBlank((String)upgradeTypeProperty);
        if (upgradeTypePassed) {
            try {
                upgradeType = UpgradeType.valueOf((String)upgradeRequestMap.get("Upgrade/upgrade_type").toString());
            }
            catch (Exception e) {
                throw new OBDPException(String.format("Property %s has an incorrect value of %s.", "Upgrade/upgrade_type", upgradeTypeProperty));
            }
        } else if (upgradeEntity != null) {
            upgradeType = upgradeEntity.getUpgradeType();
        }
        return upgradeType;
    }

    @AssistedInject
    public UpgradeContext(@Assisted Cluster cluster, @Assisted Map<String, Object> upgradeRequestMap, Gson gson, UpgradeHelper upgradeHelper, UpgradeDAO upgradeDAO, RepositoryVersionDAO repoVersionDAO, ConfigHelper configHelper, OBDPMetaInfo metaInfo) throws OBDPException {
        this.m_gson = gson;
        this.m_upgradeHelper = upgradeHelper;
        this.m_upgradeDAO = upgradeDAO;
        this.m_repoVersionDAO = repoVersionDAO;
        this.m_cluster = cluster;
        this.m_isRevert = upgradeRequestMap.containsKey("Upgrade/revert_upgrade_id");
        this.m_metaInfo = metaInfo;
        if (this.m_isRevert) {
            this.m_revertUpgradeId = Long.parseLong(upgradeRequestMap.get("Upgrade/revert_upgrade_id").toString());
            UpgradeEntity revertUpgrade = this.m_upgradeDAO.findUpgrade(this.m_revertUpgradeId);
            UpgradeEntity revertableUpgrade = this.m_upgradeDAO.findRevertable(cluster.getClusterId());
            if (null == revertUpgrade) {
                throw new OBDPException(String.format("Could not find Upgrade with id %s to revert.", this.m_revertUpgradeId));
            }
            if (null == revertableUpgrade) {
                throw new OBDPException(String.format("There are no upgrades for cluster %s which are marked as revertable", cluster.getClusterName()));
            }
            if (!revertUpgrade.getOrchestration().isRevertable()) {
                throw new OBDPException(String.format("The %s repository type is not revertable", revertUpgrade.getOrchestration()));
            }
            if (revertUpgrade.getDirection() != Direction.UPGRADE) {
                throw new OBDPException("Only successfully completed upgrades can be reverted. Downgrades cannot be reverted.");
            }
            if (!revertableUpgrade.getId().equals(revertUpgrade.getId())) {
                throw new OBDPException(String.format("The only upgrade which is currently allowed to be reverted for cluster %s is upgrade ID %s which was an upgrade to %s", cluster.getClusterName(), revertableUpgrade.getId(), revertableUpgrade.getRepositoryVersion().getVersion()));
            }
            this.m_type = this.calculateUpgradeType(upgradeRequestMap, revertUpgrade);
            Map<String, Service> clusterServices = cluster.getServices();
            for (UpgradeHistoryEntity history : revertUpgrade.getHistory()) {
                String serviceName = history.getServiceName();
                String componentName = history.getComponentName();
                if (!clusterServices.containsKey(serviceName)) {
                    LOG.warn("{}/{} will not be reverted since it is no longer installed in the cluster", (Object)serviceName, (Object)componentName);
                    continue;
                }
                this.m_services.add(serviceName);
                this.m_sourceRepositoryMap.put(serviceName, history.getTargetRepositoryVersion());
                this.m_targetRepositoryMap.put(serviceName, history.getFromReposistoryVersion());
            }
            this.m_repositoryVersion = revertUpgrade.getRepositoryVersion();
            upgradeRequestMap.put("Upgrade/repository_version_id", this.m_repositoryVersion.getId().toString());
            upgradeRequestMap.put("Upgrade/pack", revertUpgrade.getUpgradePackage());
            this.m_direction = Direction.DOWNGRADE;
            this.m_orchestration = revertUpgrade.getOrchestration();
            this.m_upgradePack = this.getUpgradePack(revertUpgrade);
            this.m_orchestrationOptions = this.getOrchestrationOptions(metaInfo, this.m_upgradePack);
        } else {
            String directionProperty = (String)upgradeRequestMap.get("Upgrade/direction");
            if (StringUtils.isEmpty((String)directionProperty)) {
                throw new OBDPException(String.format("%s is required", "Upgrade/direction"));
            }
            this.m_direction = Direction.valueOf(directionProperty);
            switch (this.m_direction) {
                case UPGRADE: {
                    String repositoryVersionId = (String)upgradeRequestMap.get("Upgrade/repository_version_id");
                    if (null == repositoryVersionId) {
                        throw new OBDPException(String.format("The property %s is required when the upgrade direction is %s", new Object[]{"Upgrade/repository_version_id", this.m_direction}));
                    }
                    this.m_type = this.calculateUpgradeType(upgradeRequestMap, null);
                    this.m_repositoryVersion = (RepositoryVersionEntity)this.m_repoVersionDAO.findByPK(Long.valueOf(repositoryVersionId));
                    this.m_orchestration = this.m_repositoryVersion.getType();
                    Set<String> serviceNames = this.getServicesForUpgrade(cluster, this.m_repositoryVersion);
                    this.m_services.addAll((Collection<String>)serviceNames);
                    String preferredUpgradePackName = (String)upgradeRequestMap.get("Upgrade/pack");
                    RepositoryVersionEntity upgradeFromRepositoryVersion = cluster.getService((String)serviceNames.iterator().next()).getDesiredRepositoryVersion();
                    this.m_upgradePack = this.m_upgradeHelper.suggestUpgradePack(this.m_cluster.getClusterName(), upgradeFromRepositoryVersion.getStackId(), this.m_repositoryVersion.getStackId(), this.m_direction, this.m_type, preferredUpgradePackName);
                    this.m_orchestrationOptions = this.getOrchestrationOptions(metaInfo, this.m_upgradePack);
                    break;
                }
                case DOWNGRADE: {
                    UpgradeEntity upgrade = this.m_upgradeDAO.findLastUpgradeForCluster(cluster.getClusterId(), Direction.UPGRADE);
                    this.m_repositoryVersion = upgrade.getRepositoryVersion();
                    this.m_orchestration = upgrade.getOrchestration();
                    this.m_type = this.calculateUpgradeType(upgradeRequestMap, upgrade);
                    for (UpgradeHistoryEntity history : upgrade.getHistory()) {
                        this.m_services.add(history.getServiceName());
                        this.m_sourceRepositoryMap.put(history.getServiceName(), this.m_repositoryVersion);
                        this.m_targetRepositoryMap.put(history.getServiceName(), history.getFromReposistoryVersion());
                    }
                    this.m_upgradePack = this.getUpgradePack(upgrade);
                    this.m_orchestrationOptions = this.getOrchestrationOptions(metaInfo, this.m_upgradePack);
                    break;
                }
                default: {
                    throw new OBDPException(String.format("%s is not a valid upgrade direction.", new Object[]{this.m_direction}));
                }
            }
        }
        UpgradeRequestValidator upgradeRequestValidator = this.buildValidator(this.m_type);
        upgradeRequestValidator.validate(cluster, this.m_direction, this.m_type, this.m_upgradePack, upgradeRequestMap);
        boolean skipComponentFailures = this.m_upgradePack.isComponentFailureAutoSkipped();
        boolean skipServiceCheckFailures = this.m_upgradePack.isServiceCheckFailureAutoSkipped();
        if (upgradeRequestMap.containsKey("Upgrade/skip_failures")) {
            skipComponentFailures = Boolean.parseBoolean((String)upgradeRequestMap.get("Upgrade/skip_failures"));
        }
        if (upgradeRequestMap.containsKey("Upgrade/skip_service_check_failures")) {
            skipServiceCheckFailures = Boolean.parseBoolean((String)upgradeRequestMap.get("Upgrade/skip_service_check_failures"));
        }
        boolean skipManualVerification = false;
        if (upgradeRequestMap.containsKey("Upgrade/skip_manual_verification")) {
            skipManualVerification = Boolean.parseBoolean((String)upgradeRequestMap.get("Upgrade/skip_manual_verification"));
        }
        this.m_autoSkipComponentFailures = skipComponentFailures;
        this.m_autoSkipServiceCheckFailures = skipServiceCheckFailures;
        this.m_autoSkipManualVerification = skipManualVerification;
        this.m_resolver = new MasterHostResolver(this.m_cluster, configHelper, this);
    }

    @AssistedInject
    public UpgradeContext(@Assisted Cluster cluster, @Assisted UpgradeEntity upgradeEntity, OBDPMetaInfo obdpMetaInfo, ConfigHelper configHelper) {
        this.m_metaInfo = obdpMetaInfo;
        this.m_cluster = cluster;
        this.m_type = upgradeEntity.getUpgradeType();
        this.m_direction = upgradeEntity.getDirection();
        this.m_repositoryVersion = upgradeEntity.getRepositoryVersion();
        this.m_autoSkipComponentFailures = upgradeEntity.isComponentFailureAutoSkipped();
        this.m_autoSkipServiceCheckFailures = upgradeEntity.isServiceCheckFailureAutoSkipped();
        StackId stackId = null;
        List<UpgradeHistoryEntity> allHistory = upgradeEntity.getHistory();
        for (UpgradeHistoryEntity history : allHistory) {
            String serviceName = history.getServiceName();
            RepositoryVersionEntity sourceRepositoryVersion = history.getFromReposistoryVersion();
            RepositoryVersionEntity targetRepositoryVersion = history.getTargetRepositoryVersion();
            this.m_sourceRepositoryMap.put(serviceName, sourceRepositoryVersion);
            this.m_targetRepositoryMap.put(serviceName, targetRepositoryVersion);
            this.m_services.add(serviceName);
            if (null != stackId) continue;
            stackId = sourceRepositoryVersion.getStackId();
        }
        this.m_upgradePack = this.getUpgradePack(upgradeEntity);
        this.m_resolver = new MasterHostResolver(this.m_cluster, configHelper, this);
        this.m_orchestration = upgradeEntity.getOrchestration();
        this.m_isRevert = upgradeEntity.getOrchestration().isRevertable() && upgradeEntity.getDirection() == Direction.DOWNGRADE;
        this.m_orchestrationOptions = this.getOrchestrationOptions(obdpMetaInfo, this.m_upgradePack);
    }

    public StackId getStackIdFromVersions(Map<String, RepositoryVersionEntity> version) {
        return version.values().iterator().next().getStackId();
    }

    public UpgradePack getUpgradePack() {
        return this.m_upgradePack;
    }

    public Cluster getCluster() {
        return this.m_cluster;
    }

    public Map<String, RepositoryVersionEntity> getSourceVersions() {
        return new HashMap<String, RepositoryVersionEntity>(this.m_sourceRepositoryMap);
    }

    public RepositoryVersionEntity getSourceRepositoryVersion(String serviceName) {
        return this.m_sourceRepositoryMap.get(serviceName);
    }

    public String getSourceVersion(String serviceName) {
        RepositoryVersionEntity serviceSourceVersion = this.m_sourceRepositoryMap.get(serviceName);
        return serviceSourceVersion.getVersion();
    }

    public Map<String, RepositoryVersionEntity> getTargetVersions() {
        return new HashMap<String, RepositoryVersionEntity>(this.m_targetRepositoryMap);
    }

    public RepositoryVersionEntity getTargetRepositoryVersion(String serviceName) {
        return this.m_targetRepositoryMap.get(serviceName);
    }

    public String getTargetVersion(String serviceName) {
        RepositoryVersionEntity serviceTargetVersion = this.m_targetRepositoryMap.get(serviceName);
        return serviceTargetVersion.getVersion();
    }

    public Direction getDirection() {
        return this.m_direction;
    }

    public UpgradeType getType() {
        return this.m_type;
    }

    public MasterHostResolver getResolver() {
        return this.m_resolver;
    }

    public OBDPMetaInfo getAmbariMetaInfo() {
        return this.m_metaInfo;
    }

    public void addUnhealthy(List<ServiceComponentHost> unhealthy) {
        this.m_unhealthy.addAll(unhealthy);
    }

    public RepositoryVersionEntity getRepositoryVersion() {
        return this.m_repositoryVersion;
    }

    public String getServiceDisplay(String service) {
        if (this.m_serviceNames.containsKey(service)) {
            return this.m_serviceNames.get(service);
        }
        return service;
    }

    public String getComponentDisplay(String service, String component) {
        String key = service + ":" + component;
        if (this.m_componentNames.containsKey(key)) {
            return this.m_componentNames.get(key);
        }
        return component;
    }

    public void setServiceDisplay(String service, String displayName) {
        this.m_serviceNames.put(service, displayName == null ? service : displayName);
    }

    public void setComponentDisplay(String service, String component, String displayName) {
        String key = service + ":" + component;
        this.m_componentNames.put(key, displayName);
    }

    public boolean isComponentFailureAutoSkipped() {
        return this.m_autoSkipComponentFailures;
    }

    public boolean isServiceCheckFailureAutoSkipped() {
        return this.m_autoSkipServiceCheckFailures;
    }

    public boolean isManualVerificationAutoSkipped() {
        return this.m_autoSkipManualVerification;
    }

    public Set<String> getSupportedServices() {
        return Collections.unmodifiableSet(this.m_services);
    }

    public boolean isServiceSupported(String serviceName) {
        return this.m_services.contains(serviceName);
    }

    public boolean isScoped(UpgradeScope scope) {
        if (scope == UpgradeScope.ANY) {
            return true;
        }
        switch (this.m_orchestration) {
            case PATCH: 
            case SERVICE: 
            case MAINT: {
                return scope == UpgradeScope.PARTIAL;
            }
            case STANDARD: {
                return scope == UpgradeScope.COMPLETE;
            }
        }
        return false;
    }

    public RoleGraphFactory getRoleGraphFactory() {
        return this.m_roleGraphFactory;
    }

    public HostRoleCommandFactory getHostRoleCommandFactory() {
        return this.m_hrcFactory;
    }

    public RepositoryType getOrchestrationType() {
        return this.m_orchestration;
    }

    public Map<String, String> getInitializedCommandParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Direction direction = this.getDirection();
        parameters.put(COMMAND_PARAM_CLUSTER_NAME, this.m_cluster.getClusterName());
        parameters.put(COMMAND_PARAM_DIRECTION, direction.name().toLowerCase());
        if (null != this.getType()) {
            JsonElement json = this.m_gson.toJsonTree((Object)this.getType());
            parameters.put(COMMAND_PARAM_UPGRADE_TYPE, json.getAsString());
        }
        return parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("direction", (Object)this.m_direction).add("type", (Object)this.m_type).add("target", (Object)this.m_repositoryVersion).toString();
    }

    public boolean isDowngradeAllowed() {
        if (this.m_direction == Direction.DOWNGRADE) {
            return false;
        }
        return this.m_upgradePack.isDowngradeAllowed();
    }

    public boolean isPatchRevert() {
        return this.m_isRevert;
    }

    public long getPatchRevertUpgradeId() {
        return this.m_revertUpgradeId;
    }

    public int getDefaultMaxDegreeOfParallelism() {
        return this.configuration.getDefaultMaxParallelismForUpgrades();
    }

    public UpgradeSummary getUpgradeSummary() {
        UpgradeSummary summary = new UpgradeSummary();
        summary.direction = this.m_direction;
        summary.type = this.m_type;
        summary.orchestration = this.m_orchestration;
        summary.isRevert = this.m_isRevert;
        summary.isDowngradeAllowed = this.isDowngradeAllowed();
        summary.associatedRepositoryId = this.m_repositoryVersion.getId();
        summary.associatedStackId = this.m_repositoryVersion.getStackId().getStackId();
        summary.associatedVersion = this.m_repositoryVersion.getVersion();
        summary.isSwitchBits = this.m_isRevert || this.m_orchestration.isRevertable();
        summary.services = new HashMap<String, UpgradeServiceSummary>();
        for (String serviceName : this.m_services) {
            RepositoryVersionEntity sourceRepositoryVersion = this.m_sourceRepositoryMap.get(serviceName);
            RepositoryVersionEntity targetRepositoryVersion = this.m_targetRepositoryMap.get(serviceName);
            if (null == sourceRepositoryVersion || null == targetRepositoryVersion) {
                LOG.warn("Unable to get the source/target repositories for {} for the upgrade summary", (Object)serviceName);
                continue;
            }
            UpgradeServiceSummary serviceSummary = new UpgradeServiceSummary();
            serviceSummary.sourceRepositoryId = sourceRepositoryVersion.getId();
            serviceSummary.sourceStackId = sourceRepositoryVersion.getStackId().getStackId();
            serviceSummary.sourceVersion = sourceRepositoryVersion.getVersion();
            serviceSummary.targetRepositoryId = targetRepositoryVersion.getId();
            serviceSummary.targetStackId = targetRepositoryVersion.getStackId().getStackId();
            serviceSummary.targetVersion = targetRepositoryVersion.getVersion();
            summary.services.put(serviceName, serviceSummary);
        }
        return summary;
    }

    public StackId getTargetStack() {
        RepositoryVersionEntity repo = this.m_targetRepositoryMap.values().iterator().next();
        return repo.getStackId();
    }

    public StackId getSourceStack() {
        RepositoryVersionEntity repo = this.m_sourceRepositoryMap.values().iterator().next();
        return repo.getStackId();
    }

    public KerberosDetails getKerberosDetails() throws KerberosInvalidConfigurationException, OBDPException {
        return this.m_kerberosHelper.getKerberosDetails(this.m_cluster, null);
    }

    public OrchestrationOptions getOrchestrationOptions() {
        return this.m_orchestrationOptions;
    }

    private Set<String> getServicesForUpgrade(Cluster cluster, RepositoryVersionEntity repositoryVersion) throws OBDPException {
        Set<String> servicesForUpgrade;
        if (repositoryVersion.getType() == RepositoryType.STANDARD) {
            servicesForUpgrade = cluster.getServices().keySet();
        } else {
            try {
                VersionDefinitionXml vdf = repositoryVersion.getRepositoryXml();
                ClusterVersionSummary clusterVersionSummary = vdf.getClusterSummary(cluster, this.m_metaInfo);
                servicesForUpgrade = clusterVersionSummary.getAvailableServiceNames();
                if (servicesForUpgrade.isEmpty()) {
                    String message = String.format("When using a VDF of type %s, the available services must be defined in the VDF", repositoryVersion.getType());
                    throw new OBDPException(message);
                }
            }
            catch (Exception e) {
                String msg = String.format("Could not parse version definition for %s.  Upgrade will not proceed.", repositoryVersion.getVersion());
                throw new OBDPException(msg);
            }
        }
        Iterator<String> iterator = servicesForUpgrade.iterator();
        while (iterator.hasNext()) {
            String serviceName = null;
            try {
                serviceName = iterator.next();
                Service service = cluster.getService(serviceName);
                this.m_sourceRepositoryMap.put(serviceName, service.getDesiredRepositoryVersion());
                this.m_targetRepositoryMap.put(serviceName, repositoryVersion);
            }
            catch (ServiceNotFoundException e) {
                iterator.remove();
                LOG.warn("Skipping orchestration for service {}, as it was defined to upgrade, but is not installed in cluster {}", (Object)serviceName, (Object)cluster.getClusterName());
            }
        }
        return servicesForUpgrade;
    }

    private UpgradeRequestValidator buildValidator(UpgradeType upgradeType) {
        BasicUpgradePropertiesValidator validator = new BasicUpgradePropertiesValidator();
        PreReqCheckValidator preReqValidator = new PreReqCheckValidator();
        validator.setNextValidator(preReqValidator);
        preReqValidator.setNextValidator(switch (upgradeType) {
            case UpgradeType.HOST_ORDERED -> new HostOrderedUpgradeValidator();
            default -> null;
        });
        return validator;
    }

    private UpgradePack getUpgradePack(UpgradeEntity upgrade) {
        StackId stackId = upgrade.getUpgradePackStackId();
        Map<String, UpgradePack> packs = this.m_metaInfo.getUpgradePacks(stackId.getStackName(), stackId.getStackVersion());
        return packs.get(upgrade.getUpgradePackage());
    }

    public UpgradeInformation buildUpgradeInformation() {
        RepositoryVersionEntity targetRepositoryVersionEntity = this.m_repositoryVersion;
        Map<String, Service> clusterServices = this.m_cluster.getServices();
        HashMap<String, RepositoryVersion> clusterServiceVersions = new HashMap<String, RepositoryVersion>();
        if (null != clusterServices) {
            for (Map.Entry<String, Service> serviceEntry : clusterServices.entrySet()) {
                Service service2 = serviceEntry.getValue();
                RepositoryVersionEntity desiredRepositoryEntity = service2.getDesiredRepositoryVersion();
                RepositoryVersion desiredRepositoryVersion = desiredRepositoryEntity.getRepositoryVersion();
                clusterServiceVersions.put(serviceEntry.getKey(), desiredRepositoryVersion);
            }
        }
        Map<String, RepositoryVersionEntity> sourceVersionEntites = this.getSourceVersions();
        Map<String, RepositoryVersionEntity> targetVersionEntites = this.getTargetVersions();
        HashMap sourceVersions = new HashMap();
        HashMap targetVersions = new HashMap();
        sourceVersionEntites.forEach((service, repositoryVersion) -> sourceVersions.put(service, repositoryVersion.getRepositoryVersion()));
        targetVersionEntites.forEach((service, repositoryVersion) -> targetVersions.put(service, repositoryVersion.getRepositoryVersion()));
        UpgradeInformation upgradeInformation = new UpgradeInformation(this.getDirection().isUpgrade(), this.getType(), targetRepositoryVersionEntity.getRepositoryVersion(), sourceVersions, targetVersions);
        return upgradeInformation;
    }

    private OrchestrationOptions getOrchestrationOptions(OBDPMetaInfo metaInfo, UpgradePack pack) {
        if (null == pack) {
            return null;
        }
        String className = pack.getOrchestrationOptions();
        if (null == className) {
            return null;
        }
        StackId stackId = pack.getOwnerStackId();
        try {
            StackInfo stack = metaInfo.getStack(stackId);
            return (OrchestrationOptions)stack.getLibraryInstance(className);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not load orchestration options for stack {}: {}", stackId, e.getMessage()));
            return null;
        }
    }

    private abstract class UpgradeRequestValidator {
        UpgradeRequestValidator m_nextValidator;

        private UpgradeRequestValidator() {
        }

        void setNextValidator(UpgradeRequestValidator nextValidator) {
            this.m_nextValidator = nextValidator;
        }

        final void validate(Cluster cluster, Direction direction, UpgradeType type, UpgradePack upgradePack, Map<String, Object> requestMap) throws OBDPException {
            this.check(cluster, direction, type, upgradePack, requestMap);
            if (null != this.m_nextValidator) {
                this.m_nextValidator.validate(cluster, direction, type, upgradePack, requestMap);
            }
        }

        abstract void check(Cluster var1, Direction var2, UpgradeType var3, UpgradePack var4, Map<String, Object> var5) throws OBDPException;
    }

    private final class BasicUpgradePropertiesValidator
    extends UpgradeRequestValidator {
        private BasicUpgradePropertiesValidator() {
        }

        @Override
        public void check(Cluster cluster, Direction direction, UpgradeType type, UpgradePack upgradePack, Map<String, Object> requestMap) throws OBDPException {
            String repositoryVersionId;
            if (direction == Direction.UPGRADE && StringUtils.isBlank((String)(repositoryVersionId = (String)requestMap.get("Upgrade/repository_version_id")))) {
                throw new OBDPException(String.format("%s is required for upgrades", "Upgrade/repository_version_id"));
            }
        }
    }

    private final class PreReqCheckValidator
    extends UpgradeRequestValidator {
        private PreReqCheckValidator() {
        }

        @Override
        void check(Cluster cluster, Direction direction, UpgradeType type, UpgradePack upgradePack, Map<String, Object> requestMap) throws OBDPException {
            Set<Resource> preUpgradeCheckResources;
            String repositoryVersionId = (String)requestMap.get("Upgrade/repository_version_id");
            boolean skipPrereqChecks = Boolean.parseBoolean((String)requestMap.get("Upgrade/skip_prerequisite_checks"));
            boolean failOnCheckWarnings = Boolean.parseBoolean((String)requestMap.get("Upgrade/fail_on_check_warnings"));
            String preferredUpgradePack = requestMap.containsKey("Upgrade/pack") ? (String)requestMap.get("Upgrade/pack") : null;
            UpgradeEntity existingUpgrade = cluster.getUpgradeInProgress();
            if (null != existingUpgrade) {
                throw new OBDPException(String.format("Unable to perform %s as another %s (request ID %s) is in progress.", direction.getText(false), existingUpgrade.getDirection().getText(false), existingUpgrade.getRequestId()));
            }
            if (direction.isDowngrade() || skipPrereqChecks) {
                return;
            }
            PreUpgradeCheckResourceProvider provider = (PreUpgradeCheckResourceProvider)AbstractControllerResourceProvider.getResourceProvider(Resource.Type.PreUpgradeCheck);
            Predicate preUpgradeCheckPredicate = new PredicateBuilder().property(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID).equals(cluster.getClusterName()).and().property(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID).equals(repositoryVersionId).and().property(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_FOR_REVERT_PROPERTY_ID).equals(Boolean.valueOf(UpgradeContext.this.m_isRevert)).and().property(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID).equals(type).and().property(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_UPGRADE_PACK_PROPERTY_ID).equals(preferredUpgradePack).toPredicate();
            Request preUpgradeCheckRequest = PropertyHelper.getReadRequest(new String[0]);
            try {
                preUpgradeCheckResources = provider.getResources(preUpgradeCheckRequest, preUpgradeCheckPredicate);
            }
            catch (NoSuchParentResourceException | NoSuchResourceException | SystemException | UnsupportedPropertyException e) {
                throw new OBDPException(String.format("Unable to perform %s. Prerequisite checks could not be run", direction.getText(false)), (Throwable)e);
            }
            LinkedList<Resource> failedResources = new LinkedList<Resource>();
            if (preUpgradeCheckResources != null) {
                for (Resource res : preUpgradeCheckResources) {
                    UpgradeCheckStatus prereqCheckStatus = (UpgradeCheckStatus)res.getPropertyValue(PreUpgradeCheckResourceProvider.UPGRADE_CHECK_STATUS_PROPERTY_ID);
                    if (prereqCheckStatus != UpgradeCheckStatus.FAIL && (!failOnCheckWarnings || prereqCheckStatus != UpgradeCheckStatus.WARNING)) continue;
                    failedResources.add(res);
                }
            }
            if (!failedResources.isEmpty()) {
                throw new OBDPException(String.format("Unable to perform %s. Prerequisite checks failed %s", direction.getText(false), UpgradeContext.this.m_gson.toJson(failedResources)));
            }
        }
    }

    private final class HostOrderedUpgradeValidator
    extends UpgradeRequestValidator {
        private HostOrderedUpgradeValidator() {
        }

        @Override
        void check(Cluster cluster, Direction direction, UpgradeType type, UpgradePack upgradePack, Map<String, Object> requestMap) throws OBDPException {
            String skipFailuresRequestProperty = (String)requestMap.get("Upgrade/skip_failures");
            if (Boolean.parseBoolean(skipFailuresRequestProperty)) {
                throw new OBDPException(String.format("The %s property is not valid when creating a %s upgrade.", "Upgrade/skip_failures", UpgradeType.HOST_ORDERED));
            }
            String skipManualVerification = (String)requestMap.get("Upgrade/skip_manual_verification");
            if (Boolean.parseBoolean(skipManualVerification)) {
                throw new OBDPException(String.format("The %s property is not valid when creating a %s upgrade.", "Upgrade/skip_manual_verification", UpgradeType.HOST_ORDERED));
            }
            if (!requestMap.containsKey("Upgrade/host_order")) {
                throw new OBDPException(String.format("The %s property is required when creating a %s upgrade.", "Upgrade/host_order", UpgradeType.HOST_ORDERED));
            }
            List<HostOrderItem> hostOrderItems = this.extractHostOrderItemsFromRequest(requestMap);
            ArrayList<String> hostsFromRequest = new ArrayList<String>(hostOrderItems.size());
            for (HostOrderItem hostOrderItem : hostOrderItems) {
                if (hostOrderItem.getType() != HostOrderItem.HostOrderActionType.HOST_UPGRADE) continue;
                hostsFromRequest.addAll(hostOrderItem.getActionItems());
            }
            Collection<Host> hosts = cluster.getHosts();
            HashSet<String> clusterHostNames = new HashSet<String>(hosts.size());
            for (Host host : hosts) {
                clusterHostNames.add(host.getHostName());
            }
            Collection disjunction = CollectionUtils.disjunction(hostsFromRequest, clusterHostNames);
            if (CollectionUtils.isNotEmpty((Collection)disjunction)) {
                throw new OBDPException(String.format("The supplied list of hosts must match the cluster hosts in an upgrade of type %s. The following hosts are either missing or invalid: %s", UpgradeType.HOST_ORDERED, StringUtils.join((Collection)disjunction, (String)", ")));
            }
            HostOrderGrouping hostOrderGrouping = null;
            List<Grouping> groupings = upgradePack.getGroups(direction);
            for (Grouping grouping : groupings) {
                if (!(grouping instanceof HostOrderGrouping)) continue;
                hostOrderGrouping = (HostOrderGrouping)grouping;
                hostOrderGrouping.setHostOrderItems(hostOrderItems);
            }
        }

        private List<HostOrderItem> extractHostOrderItemsFromRequest(Map<String, Object> requestMap) throws OBDPException {
            Set hostsOrder = (Set)requestMap.get("Upgrade/host_order");
            if (CollectionUtils.isEmpty((Collection)hostsOrder)) {
                throw new OBDPException(String.format("The %s property must be specified when using a %s upgrade type.", "Upgrade/host_order", UpgradeType.HOST_ORDERED));
            }
            ArrayList<HostOrderItem> hostOrderItems = new ArrayList<HostOrderItem>();
            for (Map grouping : hostsOrder) {
                List hosts = (List)grouping.get("hosts");
                List serviceChecks = (List)grouping.get("service_checks");
                if (CollectionUtils.isEmpty((Collection)hosts) && CollectionUtils.isEmpty((Collection)serviceChecks)) {
                    throw new OBDPException(String.format("The %s property must contain at least one object with either a %s or %s key", "Upgrade/host_order", "hosts", "service_checks"));
                }
                if (CollectionUtils.isNotEmpty((Collection)hosts)) {
                    hostOrderItems.add(new HostOrderItem(HostOrderItem.HostOrderActionType.HOST_UPGRADE, hosts));
                }
                if (!CollectionUtils.isNotEmpty((Collection)serviceChecks)) continue;
                hostOrderItems.add(new HostOrderItem(HostOrderItem.HostOrderActionType.SERVICE_CHECK, serviceChecks));
            }
            return hostOrderItems;
        }
    }
}

