/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.ExecuteHostType;
import id.onyx.obdp.server.stack.upgrade.ExecuteTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.utils.StageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskWrapperBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TaskWrapperBuilder.class);

    public static List<TaskWrapper> getTaskList(String service, String component, HostsType hostsType, List<Task> tasks, Map<String, String> params) {
        String ambariServerHostname = StageUtils.getHostName();
        ArrayList<TaskWrapper> collection = new ArrayList<TaskWrapper>();
        for (Task t : tasks) {
            if (t.getType().isServerAction() && CollectionUtils.isNotEmpty(hostsType.getHosts())) {
                collection.add(new TaskWrapper(service, component, Collections.singleton(ambariServerHostname), params, t));
                continue;
            }
            if (t.getType().equals((Object)Task.Type.EXECUTE)) {
                ExecuteTask et = (ExecuteTask)t;
                if (et.hosts == ExecuteHostType.MASTER) {
                    if (hostsType.hasMasters()) {
                        collection.add(new TaskWrapper(service, component, hostsType.getMasters(), params, t));
                        continue;
                    }
                    LOG.error(MessageFormat.format("Found an Execute task for {0} and {1} meant to run on a master but could not find any masters to run on. Skipping this task.", service, component));
                    continue;
                }
                if (et.hosts == ExecuteHostType.ANY) {
                    if (!hostsType.getHosts().isEmpty()) {
                        collection.add(new TaskWrapper(service, component, Collections.singleton(hostsType.getHosts().iterator().next()), params, t));
                        continue;
                    }
                    LOG.error(MessageFormat.format("Found an Execute task for {0} and {1} meant to run on any host but could not find host to run on. Skipping this task.", service, component));
                    continue;
                }
                if (et.hosts == ExecuteHostType.FIRST) {
                    if (!hostsType.getHosts().isEmpty()) {
                        ArrayList<String> sortedHosts = new ArrayList<String>(hostsType.getHosts());
                        Collections.sort(sortedHosts, String.CASE_INSENSITIVE_ORDER);
                        collection.add(new TaskWrapper(service, component, Collections.singleton((String)sortedHosts.get(0)), params, t));
                        continue;
                    }
                    LOG.error(MessageFormat.format("Found an Execute task for {0} and {1} meant to run on the first host sorted alphabetically but could not find host to run on. Skipping this task.", service, component));
                    continue;
                }
            }
            collection.add(new TaskWrapper(service, component, hostsType.getHosts(), params, t));
        }
        return collection;
    }

    public static Set<String> getEffectiveHosts(List<TaskWrapper> tasks) {
        HashSet<String> effectiveHosts = new HashSet<String>();
        for (TaskWrapper t : tasks) {
            effectiveHosts.addAll(t.getHosts());
        }
        return effectiveHosts;
    }
}

