/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.stack.upgrade.Task;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TaskWrapper {
    private String service;
    private String component;
    private Set<String> hosts;
    private Map<String, String> params;
    private List<Task> tasks;
    private Set<String> timeoutKeys = new HashSet<String>();

    public TaskWrapper(String s, String c, Set<String> hosts, Task task) {
        this(s, c, hosts, null, task);
    }

    public TaskWrapper(String s, String c, Set<String> hosts, Map<String, String> params, Task ... tasks) {
        this(s, c, hosts, params, Arrays.asList(tasks));
    }

    public TaskWrapper(String s, String c, Set<String> hosts, Map<String, String> params, List<Task> tasks) {
        this.service = s;
        this.component = c;
        this.hosts = hosts;
        this.params = params == null ? new HashMap() : params;
        this.tasks = tasks;
        for (Task task : tasks) {
            if (!StringUtils.isNotBlank((String)task.timeoutConfig)) continue;
            this.timeoutKeys.add(task.timeoutConfig);
        }
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).add("component", (Object)this.component).add("tasks", this.tasks).add("hosts", this.hosts).omitNullValues().toString();
    }

    public String getService() {
        return this.service;
    }

    public String getComponent() {
        return this.component;
    }

    public boolean isAnyTaskSequential() {
        for (Task t : this.getTasks()) {
            if (!t.isSequential) continue;
            return true;
        }
        return false;
    }

    public Set<String> getTimeoutKeys() {
        return this.timeoutKeys;
    }
}

