/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import id.onyx.obdp.server.serveraction.upgrades.AutoSkipFailedSummaryAction;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ServerActionTask;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckGrouping;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class StageWrapperBuilder {
    private static final String AUTO_SKIPPED_TASK_SUMMARY = "Pauses the upgrade if there were failed steps that were automatically skipped.";
    private static final String AUTO_SKIPPED_MESSAGE = "There are failures that were automatically skipped.  Review the failures before continuing.";
    protected final Grouping m_grouping;

    protected StageWrapperBuilder(Grouping grouping) {
        this.m_grouping = grouping;
    }

    public abstract void add(UpgradeContext var1, HostsType var2, String var3, boolean var4, UpgradePack.ProcessingComponent var5, Map<String, String> var6);

    public final List<StageWrapper> build(UpgradeContext upgradeContext) {
        List<StageWrapper> stageWrappers = this.beforeBuild(upgradeContext);
        stageWrappers = this.build(upgradeContext, stageWrappers);
        stageWrappers = this.afterBuild(upgradeContext, stageWrappers);
        return stageWrappers;
    }

    protected List<StageWrapper> beforeBuild(UpgradeContext upgradeContext) {
        ArrayList<StageWrapper> stageWrappers = new ArrayList<StageWrapper>(100);
        return stageWrappers;
    }

    public abstract List<StageWrapper> build(UpgradeContext var1, List<StageWrapper> var2);

    protected List<StageWrapper> afterBuild(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
        if (CollectionUtils.isEmpty(stageWrappers)) {
            return stageWrappers;
        }
        boolean autoSkipFailures = this.m_grouping instanceof ServiceCheckGrouping ? upgradeContext.isServiceCheckFailureAutoSkipped() : upgradeContext.isComponentFailureAutoSkipped();
        if (this.m_grouping.supportsAutoSkipOnFailure && this.m_grouping.skippable && autoSkipFailures) {
            ServerActionTask skippedFailedCheck = new ServerActionTask();
            skippedFailedCheck.implClass = AutoSkipFailedSummaryAction.class.getName();
            skippedFailedCheck.summary = AUTO_SKIPPED_TASK_SUMMARY;
            skippedFailedCheck.messages.add(AUTO_SKIPPED_MESSAGE);
            TaskWrapper skippedFailedTaskWrapper = new TaskWrapper(null, null, Collections.emptySet(), skippedFailedCheck);
            StageWrapper skippedFailedStageWrapper = new StageWrapper(StageWrapper.Type.SERVER_SIDE_ACTION, "Verifying Skipped Failures", skippedFailedTaskWrapper);
            stageWrappers.add(skippedFailedStageWrapper);
        }
        return stageWrappers;
    }

    protected String getStageText(String prefix, String component, Set<String> hosts, int batchNum, int totalBatches) {
        String stageText = this.getStageText(prefix, component, hosts);
        String batchText = 1 == totalBatches ? "" : String.format(" (Batch %s of %s)", batchNum, totalBatches);
        return stageText + batchText;
    }

    protected String getStageText(String prefix, String component, Set<String> hosts) {
        return String.format("%s %s on %s%s", prefix, component, 1 == hosts.size() ? hosts.iterator().next() : Integer.valueOf(hosts.size()), 1 == hosts.size() ? "" : " hosts");
    }

    protected List<Task> resolveTasks(UpgradeContext context, boolean preTasks, UpgradePack.ProcessingComponent pc) {
        List<Task> interim;
        if (null == pc) {
            return Collections.emptyList();
        }
        boolean forUpgrade = context.getDirection().isUpgrade();
        if (forUpgrade) {
            interim = preTasks ? pc.preTasks : pc.postTasks;
        } else {
            List<Task> list = interim = preTasks ? pc.preDowngradeTasks : pc.postDowngradeTasks;
        }
        if (CollectionUtils.isEmpty(interim)) {
            return Collections.emptyList();
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Task t : interim) {
            boolean taskPassesScoping = context.isScoped(t.scope);
            boolean taskPassesCondition = true;
            if (null != t.condition && !t.condition.isSatisfied(context)) {
                taskPassesCondition = false;
            }
            if (!taskPassesScoping || !taskPassesCondition) continue;
            tasks.add(t);
        }
        return tasks;
    }

    protected Task resolveTask(UpgradeContext context, UpgradePack.ProcessingComponent pc) {
        if (null != pc.tasks && 1 == pc.tasks.size() && context.isScoped(pc.tasks.get((int)0).scope)) {
            return pc.tasks.get(0);
        }
        return null;
    }

    protected int getParallelHostCount(UpgradeContext ctx, int defaultValue) {
        if (this.m_grouping.parallelScheduler != null) {
            int taskParallelism = this.m_grouping.parallelScheduler.maxDegreeOfParallelism;
            String maxDegreeFromClusterEnv = ctx.getResolver().getValueFromDesiredConfigurations("cluster-env", "max_degree_parallelism");
            if (StringUtils.isNotEmpty((String)maxDegreeFromClusterEnv) && StringUtils.isNumeric((String)maxDegreeFromClusterEnv)) {
                taskParallelism = Integer.parseInt(maxDegreeFromClusterEnv);
            }
            if (taskParallelism == Integer.MAX_VALUE) {
                taskParallelism = ctx.getDefaultMaxDegreeOfParallelism();
            }
            return taskParallelism;
        }
        return defaultValue;
    }
}

