/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(StageWrapper.class);
    private static Gson gson = new Gson();
    private String text;
    private Type type;
    private Map<String, String> params;
    private List<TaskWrapper> tasks;

    public StageWrapper(Type type, String text, TaskWrapper ... tasks) {
        this(type, text, null, Arrays.asList(tasks));
    }

    public StageWrapper(Type type, String text, Map<String, String> params, TaskWrapper ... tasks) {
        this(type, text, params, Arrays.asList(tasks));
    }

    public StageWrapper(Type type, String text, Map<String, String> params, List<TaskWrapper> tasks) {
        this.type = type;
        this.text = text;
        this.params = params == null ? Collections.emptyMap() : params;
        this.tasks = tasks;
    }

    public String getHostsJson() {
        return gson.toJson(this.getHosts());
    }

    public String getTasksJson() {
        ArrayList<Task> realTasks = new ArrayList<Task>();
        for (TaskWrapper tw : this.tasks) {
            realTasks.addAll(tw.getTasks());
        }
        return gson.toJson(realTasks);
    }

    public Set<String> getHosts() {
        HashSet<String> hosts = new HashSet<String>();
        for (TaskWrapper tw : this.tasks) {
            hosts.addAll(tw.getHosts());
        }
        return hosts;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public List<TaskWrapper> getTasks() {
        return this.tasks;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("text", (Object)this.text).omitNullValues().toString();
    }

    public Integer getMaxTimeout(Configuration configuration) {
        HashSet<String> timeoutKeys = new HashSet<String>();
        for (TaskWrapper wrapper : this.tasks) {
            timeoutKeys.addAll(wrapper.getTimeoutKeys());
        }
        Integer defaultTimeout = Integer.valueOf(configuration.getDefaultAgentTaskTimeout(false));
        if (CollectionUtils.isEmpty(timeoutKeys)) {
            return defaultTimeout;
        }
        Integer timeout = null;
        for (String key : timeoutKeys) {
            String configValue = configuration.getProperty(key);
            if (StringUtils.isNotBlank((String)configValue)) {
                try {
                    Integer configTimeout = Integer.valueOf(configValue);
                    if (null != timeout && configTimeout <= timeout) continue;
                    timeout = configTimeout;
                }
                catch (Exception e) {
                    LOG.warn("Could not parse {}/{} to a timeout value", (Object)key, (Object)configValue);
                }
                continue;
            }
            LOG.warn("Configuration {} not found to compute timeout", (Object)key);
        }
        return null == timeout ? defaultTimeout : timeout;
    }

    public static enum Type {
        SERVER_SIDE_ACTION,
        RESTART,
        UPGRADE_TASKS,
        SERVICE_CHECK,
        STOP,
        START,
        CONFIGURE,
        REGENERATE_KEYTABS;

    }
}

