/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade.orchestrate;

import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.ExecuteHostType;
import id.onyx.obdp.server.stack.upgrade.ExecuteTask;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckGrouping;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class ParallelClientGroupingBuilder
extends StageWrapperBuilder {
    private Map<String, HostHolder> serviceToHostMap = new HashMap<String, HostHolder>();

    public ParallelClientGroupingBuilder(Grouping grouping) {
        super(grouping);
    }

    @Override
    public void add(UpgradeContext upgradeContext, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
        if (null == hostsType || CollectionUtils.isEmpty(hostsType.getHosts())) {
            return;
        }
        Task task = this.resolveTask(upgradeContext, pc);
        if (null == task) {
            return;
        }
        Iterator<String> hostIterator = hostsType.getHosts().iterator();
        HostHolder holder = new HostHolder();
        holder.m_firstHost = hostIterator.next();
        while (hostIterator.hasNext()) {
            holder.m_remainingHosts.add(hostIterator.next());
        }
        holder.m_component = pc.name;
        holder.m_tasks = Collections.singletonList(task);
        holder.m_preTasks = this.resolveTasks(upgradeContext, true, pc);
        holder.m_postTasks = this.resolveTasks(upgradeContext, false, pc);
        this.serviceToHostMap.put(service, holder);
    }

    @Override
    public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
        if (0 == this.serviceToHostMap.size()) {
            return stageWrappers;
        }
        ArrayList starterUpgrades = new ArrayList();
        ArrayList finisherUpgrades = new ArrayList();
        this.serviceToHostMap.forEach((service, holder) -> {
            starterUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_preTasks, true, "Preparing"));
            starterUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_tasks, true, "Upgrading"));
            starterUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_postTasks, true, "Completing"));
            ServiceCheckGrouping.ServiceCheckStageWrapper serviceCheck = new ServiceCheckGrouping.ServiceCheckStageWrapper((String)service, upgradeContext.getServiceDisplay((String)service), false, holder.m_firstHost);
            starterUpgrades.add(serviceCheck);
            finisherUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_preTasks, false, "Prepare Remaining"));
            finisherUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_tasks, false, "Upgrade Remaining"));
            finisherUpgrades.addAll(this.buildStageWrappers(upgradeContext, (String)service, (HostHolder)holder, holder.m_postTasks, false, "Complete Remaining"));
        });
        ArrayList<StageWrapper> results = new ArrayList<StageWrapper>(stageWrappers);
        results.addAll(starterUpgrades);
        results.addAll(finisherUpgrades);
        return results;
    }

    private List<StageWrapper> buildStageWrappers(UpgradeContext upgradeContext, String service, HostHolder holder, List<Task> tasks, boolean firstHost, String prefix) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Collections.emptyList();
        }
        Set<String> hosts = firstHost ? Collections.singleton(holder.m_firstHost) : holder.m_remainingHosts;
        String component = holder.m_component;
        String componentDisplay = upgradeContext.getComponentDisplay(service, component);
        String text = this.getStageText(prefix, componentDisplay, hosts);
        List<TaskWrapper> wrappers = this.buildTaskWrappers(service, component, tasks, hosts, firstHost);
        ArrayList<StageWrapper> results = new ArrayList<StageWrapper>();
        wrappers.forEach(task -> {
            StageWrapper.Type type = task.getTasks().get(0).getStageWrapperType();
            StageWrapper stage = new StageWrapper(type, text, new HashMap<String, String>(), Collections.singletonList(task));
            results.add(stage);
        });
        return results;
    }

    private List<TaskWrapper> buildTaskWrappers(String service, String component, List<Task> tasks, Set<String> hosts, boolean firstHost) {
        ArrayList<TaskWrapper> results = new ArrayList<TaskWrapper>();
        tasks.forEach(task -> {
            if (task.getType().isServerAction()) {
                if (firstHost) {
                    String ambariServerHostname = StageUtils.getHostName();
                    results.add(new TaskWrapper(service, component, Collections.singleton(ambariServerHostname), (Task)task));
                }
                return;
            }
            if (!firstHost && task.getType() == Task.Type.EXECUTE) {
                ExecuteTask et = (ExecuteTask)task;
                if (et.hosts != ExecuteHostType.ALL) {
                    return;
                }
            }
            results.add(new TaskWrapper(service, component, hosts, (Task)task));
        });
        return results;
    }

    private static class HostHolder {
        private String m_component;
        private String m_firstHost;
        private Set<String> m_remainingHosts = new HashSet<String>();
        private List<Task> m_tasks;
        private List<Task> m_preTasks;
        private List<Task> m_postTasks;

        private HostHolder() {
        }
    }
}

