/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import id.onyx.obdp.server.stack.upgrade.AddComponentTask;
import id.onyx.obdp.server.stack.upgrade.ClusterGrouping;
import id.onyx.obdp.server.stack.upgrade.ConfigureTask;
import id.onyx.obdp.server.stack.upgrade.CreateAndConfigureTask;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.ExecuteStage;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckGrouping;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="upgrade")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UpgradePack {
    private static final String ALL_VERSIONS = "*";
    private static final Logger LOG = LoggerFactory.getLogger(UpgradePack.class);
    private String name;
    @XmlElement(name="source")
    private String source;
    @XmlElement(name="source-stack")
    private String sourceStack;
    @XmlElement(name="target")
    private String target;
    @XmlElement(name="target-stack")
    private String targetStack;
    @XmlElementWrapper(name="order")
    @XmlElement(name="group")
    private List<Grouping> groups = new ArrayList<Grouping>();
    @XmlElement(name="prerequisite-checks")
    private PrerequisiteChecks prerequisiteChecks;
    @XmlElement(name="orchestration-options-class")
    private String orchestrationOptionsClass;
    @XmlElementWrapper(name="processing")
    @XmlElement(name="service")
    private List<ProcessingService> processing;
    @XmlElement(name="skip-failures")
    private boolean skipFailures = false;
    @XmlElement(name="downgrade-allowed", required=false, defaultValue="true")
    private boolean downgradeAllowed = true;
    @XmlElement(name="skip-service-check-failures")
    private boolean skipServiceCheckFailures = false;
    @XmlTransient
    private Map<String, Map<String, ProcessingComponent>> m_process = null;
    @XmlTransient
    private final Map<String, AddComponentTask> m_addComponentTasks = new LinkedHashMap<String, AddComponentTask>();
    @XmlTransient
    private boolean m_resolvedGroups = false;
    @XmlElement(name="type", defaultValue="rolling")
    private UpgradeType type;
    @XmlElementWrapper(name="upgrade-path")
    @XmlElement(name="intermediate-stack")
    private List<IntermediateStack> intermediateStacks;
    @XmlTransient
    private StackId ownerStackId;

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.sourceStack, this.target, this.targetStack, this.ownerStackId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UpgradePack)) {
            return false;
        }
        UpgradePack that = (UpgradePack)object;
        return new EqualsBuilder().append((Object)this.type, (Object)that.type).append((Object)this.source, (Object)that.source).append((Object)this.sourceStack, (Object)that.sourceStack).append((Object)this.target, (Object)that.targetStack).append((Object)this.ownerStackId, (Object)that.ownerStackId).isEquals();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceStack() {
        return this.sourceStack;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetStack() {
        return this.targetStack;
    }

    public UpgradeType getType() {
        return this.type;
    }

    public List<String> getPrerequisiteChecks() {
        if (this.prerequisiteChecks == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.prerequisiteChecks.checks);
    }

    public PrerequisiteCheckConfig getPrerequisiteCheckConfig() {
        if (this.prerequisiteChecks == null) {
            return new PrerequisiteCheckConfig();
        }
        return this.prerequisiteChecks.configuration;
    }

    public void mergePrerequisiteChecks(UpgradePack pack) {
        PrerequisiteChecks newPrereqChecks = pack.prerequisiteChecks;
        if (this.prerequisiteChecks == null) {
            this.prerequisiteChecks = newPrereqChecks;
            return;
        }
        if (newPrereqChecks == null) {
            return;
        }
        if (this.prerequisiteChecks.checks == null) {
            this.prerequisiteChecks.checks = new ArrayList<String>();
        }
        if (newPrereqChecks.checks != null) {
            this.prerequisiteChecks.checks.addAll(newPrereqChecks.checks);
        }
        if (newPrereqChecks.configuration == null) {
            return;
        }
        if (this.prerequisiteChecks.configuration == null) {
            this.prerequisiteChecks.configuration = newPrereqChecks.configuration;
            return;
        }
        if (this.prerequisiteChecks.configuration.globalProperties == null) {
            this.prerequisiteChecks.configuration.globalProperties = new ArrayList<PrerequisiteProperty>();
        }
        if (this.prerequisiteChecks.configuration.prerequisiteCheckProperties == null) {
            this.prerequisiteChecks.configuration.prerequisiteCheckProperties = new ArrayList<PrerequisiteCheckProperties>();
        }
        if (newPrereqChecks.configuration.globalProperties != null) {
            this.prerequisiteChecks.configuration.globalProperties.addAll(newPrereqChecks.configuration.globalProperties);
        }
        if (newPrereqChecks.configuration.prerequisiteCheckProperties != null) {
            this.prerequisiteChecks.configuration.prerequisiteCheckProperties.addAll(newPrereqChecks.configuration.prerequisiteCheckProperties);
        }
    }

    public void mergeProcessing(UpgradePack pack) {
        List<ProcessingService> list = pack.processing;
        if (list == null) {
            return;
        }
        if (this.processing == null) {
            this.processing = list;
            return;
        }
        this.processing.addAll(list);
        this.initializeProcessingComponentMappings();
    }

    public List<IntermediateStack> getIntermediateStacks() {
        return this.intermediateStacks;
    }

    public boolean isComponentFailureAutoSkipped() {
        return this.skipFailures;
    }

    public boolean isServiceCheckFailureAutoSkipped() {
        return this.skipServiceCheckFailures;
    }

    public List<Grouping> getAllGroups() {
        return this.groups;
    }

    public List<Grouping> getGroups(Direction direction) {
        List<Grouping> list;
        if (direction.isUpgrade()) {
            list = this.groups;
        } else {
            switch (this.type) {
                case NON_ROLLING: {
                    list = this.getDowngradeGroupsForNonrolling();
                    break;
                }
                default: {
                    list = this.getDowngradeGroupsForRolling();
                }
            }
        }
        ArrayList<Grouping> checked = new ArrayList<Grouping>();
        for (Grouping group : list) {
            if (null != group.intendedDirection && direction != group.intendedDirection) continue;
            checked.add(group);
        }
        return checked;
    }

    public boolean isDowngradeAllowed() {
        return this.downgradeAllowed;
    }

    public boolean canBeApplied(String targetVersion) {
        String regexPattern = this.getTarget().replaceAll("\\.", "\\\\.");
        regexPattern = regexPattern.replaceAll("\\\\\\.\\*", "(\\\\\\.\\\\d+)?");
        regexPattern = regexPattern.concat("(-\\d+)?");
        return Pattern.matches(regexPattern, targetVersion);
    }

    private List<Grouping> getDowngradeGroupsForRolling() {
        ArrayList<Grouping> reverse = new ArrayList<Grouping>();
        if (this.groups.size() == 1) {
            return this.groups;
        }
        int idx = 0;
        int iter = 0;
        Iterator<Grouping> it = this.groups.iterator();
        while (it.hasNext()) {
            Grouping g = it.next();
            if (ClusterGrouping.class.isInstance(g)) {
                reverse.add(g);
                ++idx;
            } else if (iter + 1 < this.groups.size()) {
                Grouping peek = this.groups.get(iter + 1);
                if (ServiceCheckGrouping.class.isInstance(peek)) {
                    reverse.add(idx, it.next());
                    reverse.add(idx, g);
                    ++iter;
                } else {
                    reverse.add(idx, g);
                }
            }
            ++iter;
        }
        return reverse;
    }

    private List<Grouping> getDowngradeGroupsForNonrolling() {
        return new ArrayList<Grouping>(this.groups);
    }

    public Map<String, Map<String, ProcessingComponent>> getTasks() {
        return this.m_process;
    }

    public Map<String, AddComponentTask> getAddComponentTasks() {
        return this.m_addComponentTasks;
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.initializeProcessingComponentMappings();
        this.initializeAddComponentTasks();
    }

    private void initializeProcessingComponentMappings() {
        this.m_process = new LinkedHashMap<String, Map<String, ProcessingComponent>>();
        if (CollectionUtils.isEmpty(this.processing)) {
            return;
        }
        for (ProcessingService svc : this.processing) {
            Map<String, ProcessingComponent> componentMap = this.m_process.get(svc.name);
            if (null == componentMap) {
                componentMap = new LinkedHashMap<String, ProcessingComponent>();
                this.m_process.put(svc.name, componentMap);
            }
            for (ProcessingComponent pc : svc.components) {
                if (pc != null) {
                    componentMap.put(pc.name, pc);
                    continue;
                }
                LOG.warn("ProcessingService {} has null amongst it's values (total {} components)", (Object)svc.name, (Object)svc.components.size());
            }
        }
    }

    private void initializeAddComponentTasks() {
        for (Grouping group : this.groups) {
            if (!ClusterGrouping.class.isInstance(group)) continue;
            List<ExecuteStage> executeStages = ((ClusterGrouping)group).executionStages;
            for (ExecuteStage executeStage : executeStages) {
                Task task = executeStage.task;
                if (task.getType() != Task.Type.ADD_COMPONENT) continue;
                AddComponentTask addComponentTask = (AddComponentTask)task;
                this.m_addComponentTasks.put(addComponentTask.getServiceAndComponentAsString(), addComponentTask);
            }
        }
    }

    public boolean isAllTarget() {
        return ALL_VERSIONS.equals(this.target) && ALL_VERSIONS.equals(this.targetStack);
    }

    public boolean anyGroupTaskMatch(Predicate<Task> taskPredicate) {
        return this.getAllGroups().stream().filter(ClusterGrouping.class::isInstance).flatMap(group -> ((ClusterGrouping)group).executionStages.stream()).map(executeStage -> executeStage.task).anyMatch(taskPredicate);
    }

    public void setOwnerStackId(StackId stackId) {
        this.ownerStackId = null == this.ownerStackId ? stackId : this.ownerStackId;
    }

    public StackId getOwnerStackId() {
        return this.ownerStackId;
    }

    public String getOrchestrationOptions() {
        return this.orchestrationOptionsClass;
    }

    public static class PrerequisiteChecks {
        @XmlElement(name="check", type=String.class)
        public List<String> checks = new ArrayList<String>();
        @XmlElement(name="configuration")
        public PrerequisiteCheckConfig configuration;
    }

    public static class PrerequisiteCheckConfig {
        @XmlElement(name="property")
        public List<PrerequisiteProperty> globalProperties;
        @XmlElement(name="check-properties")
        public List<PrerequisiteCheckProperties> prerequisiteCheckProperties;

        public Map<String, String> getGlobalProperties() {
            if (this.globalProperties == null) {
                return null;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (PrerequisiteProperty property : this.globalProperties) {
                result.put(property.name, property.value);
            }
            return result;
        }

        public Map<String, String> getAllProperties() {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (null != this.globalProperties) {
                for (PrerequisiteProperty property : this.globalProperties) {
                    properties.put(property.name, property.value);
                }
            }
            if (null != this.prerequisiteCheckProperties) {
                for (PrerequisiteCheckProperties checkProperties : this.prerequisiteCheckProperties) {
                    properties.putAll(checkProperties.getProperties());
                }
            }
            return properties;
        }

        public Map<String, String> getCheckProperties(String checkName) {
            if (this.prerequisiteCheckProperties == null) {
                return null;
            }
            for (PrerequisiteCheckProperties checkProperties : this.prerequisiteCheckProperties) {
                if (!checkProperties.name.equalsIgnoreCase(checkName)) continue;
                return checkProperties.getProperties();
            }
            return null;
        }
    }

    public static class ProcessingService {
        @XmlAttribute
        public String name;
        @XmlElement(name="component")
        public List<ProcessingComponent> components;
    }

    public static class ProcessingComponent {
        @XmlAttribute
        public String name;
        @XmlElementWrapper(name="pre-upgrade")
        @XmlElement(name="task")
        public List<Task> preTasks;
        @XmlElement(name="pre-downgrade")
        private DowngradeTasks preDowngradeXml;
        @XmlTransient
        public List<Task> preDowngradeTasks;
        @XmlElementWrapper(name="upgrade")
        @XmlElement(name="task")
        public List<Task> tasks;
        @XmlElementWrapper(name="post-upgrade")
        @XmlElement(name="task")
        public List<Task> postTasks;
        @XmlElement(name="post-downgrade")
        private DowngradeTasks postDowngradeXml;
        @XmlTransient
        public List<Task> postDowngradeTasks;

        void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
            if (null != this.preDowngradeXml) {
                List<Task> list = this.preDowngradeTasks = this.preDowngradeXml.copyUpgrade ? this.preTasks : this.preDowngradeXml.tasks;
            }
            if (null != this.postDowngradeXml) {
                this.postDowngradeTasks = this.postDowngradeXml.copyUpgrade ? this.postTasks : this.postDowngradeXml.tasks;
            }
            ProcessingService service = (ProcessingService)parent;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing component {}/{} preUpgrade={} postUpgrade={} preDowngrade={} postDowngrade={}", new Object[]{this.preTasks, this.preDowngradeTasks, this.postTasks, this.postDowngradeTasks});
            }
            if (null != this.preTasks && null == this.preDowngradeTasks) {
                String error = String.format("Upgrade pack must contain pre-downgrade elements if pre-upgrade exists for processing component %s/%s", service.name, this.name);
                throw new RuntimeException(error);
            }
            if (null != this.postTasks && null == this.postDowngradeTasks) {
                String error = String.format("Upgrade pack must contain post-downgrade elements if post-upgrade exists for processing component %s/%s", service.name, this.name);
                throw new RuntimeException(error);
            }
            this.initializeTasks(service.name, this.preTasks);
            this.initializeTasks(service.name, this.postTasks);
            this.initializeTasks(service.name, this.tasks);
            this.initializeTasks(service.name, this.preDowngradeTasks);
            this.initializeTasks(service.name, this.postDowngradeTasks);
        }

        private void initializeTasks(String service, List<Task> tasks) {
            if (CollectionUtils.isEmpty(tasks)) {
                return;
            }
            for (Task task : tasks) {
                if (Task.Type.CONFIGURE == task.getType()) {
                    ((ConfigureTask)task).associatedService = service;
                    continue;
                }
                if (Task.Type.CREATE_AND_CONFIGURE != task.getType()) continue;
                ((CreateAndConfigureTask)task).associatedService = service;
            }
        }
    }

    private static class DowngradeTasks {
        @XmlAttribute(name="copy-upgrade")
        private boolean copyUpgrade = false;
        @XmlElement(name="task")
        private List<Task> tasks = new ArrayList<Task>();

        private DowngradeTasks() {
        }
    }

    public static class PrerequisiteProperty {
        @XmlAttribute
        public String name;
        @XmlValue
        public String value;
    }

    public static class PrerequisiteCheckProperties {
        @XmlAttribute
        public String name;
        @XmlElement(name="property")
        public List<PrerequisiteProperty> properties;

        public Map<String, String> getProperties() {
            if (this.properties == null) {
                return null;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (PrerequisiteProperty property : this.properties) {
                result.put(property.name, property.value);
            }
            return result;
        }
    }

    public static class IntermediateStack {
        @XmlAttribute
        public String version;
    }

    public static class OrderService {
        @XmlAttribute(name="name")
        public String serviceName;
        @XmlElement(name="component")
        public List<String> components;
    }
}

