/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import id.onyx.obdp.server.stack.upgrade.AddComponentTask;
import id.onyx.obdp.server.stack.upgrade.Condition;
import id.onyx.obdp.server.stack.upgrade.ConfigureFunction;
import id.onyx.obdp.server.stack.upgrade.ConfigureTask;
import id.onyx.obdp.server.stack.upgrade.CreateAndConfigureTask;
import id.onyx.obdp.server.stack.upgrade.ExecuteTask;
import id.onyx.obdp.server.stack.upgrade.ManualTask;
import id.onyx.obdp.server.stack.upgrade.RegenerateKeytabsTask;
import id.onyx.obdp.server.stack.upgrade.RestartTask;
import id.onyx.obdp.server.stack.upgrade.ServerActionTask;
import id.onyx.obdp.server.stack.upgrade.StartTask;
import id.onyx.obdp.server.stack.upgrade.StopTask;
import id.onyx.obdp.server.stack.upgrade.UpgradeScope;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import java.util.EnumSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso(value={ExecuteTask.class, CreateAndConfigureTask.class, ConfigureTask.class, ManualTask.class, RestartTask.class, StartTask.class, StopTask.class, ServerActionTask.class, ConfigureFunction.class, AddComponentTask.class, RegenerateKeytabsTask.class})
public abstract class Task {
    protected static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    @XmlElement(name="summary")
    public String summary;
    @Expose
    @XmlAttribute(name="sequential")
    public boolean isSequential = false;
    @Expose
    @XmlAttribute(name="timeout-config")
    public String timeoutConfig = null;
    @XmlElement(name="condition")
    public Condition condition;
    @Expose
    @XmlElement(name="scope")
    public UpgradeScope scope = UpgradeScope.ANY;

    public abstract Type getType();

    public abstract StageWrapper.Type getStageWrapperType();

    public abstract String getActionVerb();

    public String toString() {
        return this.getType().toString();
    }

    public String getSummary() {
        return this.summary;
    }

    public static enum Type {
        EXECUTE,
        CONFIGURE,
        CREATE_AND_CONFIGURE,
        CONFIGURE_FUNCTION,
        MANUAL,
        RESTART,
        START,
        STOP,
        SERVICE_CHECK,
        SERVER_ACTION,
        ADD_COMPONENT,
        REGENERATE_KEYTABS;

        public static final EnumSet<Type> SERVER_ACTIONS;
        public static final EnumSet<Type> COMMANDS;

        public boolean isServerAction() {
            return SERVER_ACTIONS.contains((Object)this);
        }

        public boolean isCommand() {
            return COMMANDS.contains((Object)this);
        }

        static {
            SERVER_ACTIONS = EnumSet.of(MANUAL, CONFIGURE, SERVER_ACTION, ADD_COMPONENT);
            COMMANDS = EnumSet.of(RESTART, new Type[]{START, CONFIGURE_FUNCTION, STOP, SERVICE_CHECK, REGENERATE_KEYTABS});
        }
    }
}

