/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckTask;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="service-check")
public class ServiceCheckGrouping
extends Grouping {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCheckGrouping.class);
    @XmlElementWrapper(name="priority")
    @XmlElement(name="service")
    private Set<String> priorityServices = new LinkedHashSet<String>();
    @XmlElementWrapper(name="exclude")
    @XmlElement(name="service")
    private Set<String> excludeServices = new HashSet<String>();

    @Override
    protected boolean serviceCheckAfterProcessing() {
        return false;
    }

    @Override
    public ServiceCheckBuilder getBuilder() {
        return new ServiceCheckBuilder(this);
    }

    public Set<String> getPriorities() {
        return this.priorityServices;
    }

    public Set<String> getExcluded() {
        return this.excludeServices;
    }

    @Override
    public void merge(Iterator<Grouping> iterator) throws OBDPException {
        ArrayList<String> priorities = new ArrayList<String>();
        priorities.addAll(this.getPriorities());
        HashMap<String, Set<String>> skippedPriorities = new HashMap<String, Set<String>>();
        while (iterator.hasNext()) {
            Grouping next = iterator.next();
            if (!(next instanceof ServiceCheckGrouping)) {
                throw new OBDPException("Invalid group type " + next.getClass().getSimpleName() + " expected service check group");
            }
            ServiceCheckGrouping checkGroup = (ServiceCheckGrouping)next;
            this.getExcluded().addAll(checkGroup.getExcluded());
            boolean added = this.addPriorities(priorities, checkGroup.getPriorities(), checkGroup.addAfterGroupEntry);
            if (added) {
                this.addSkippedPriorities(priorities, skippedPriorities, checkGroup.getPriorities());
                continue;
            }
            if (skippedPriorities.containsKey(checkGroup.addAfterGroupEntry)) {
                Set tmp = (Set)skippedPriorities.get(checkGroup.addAfterGroupEntry);
                tmp.addAll(checkGroup.getPriorities());
                continue;
            }
            skippedPriorities.put(checkGroup.addAfterGroupEntry, checkGroup.getPriorities());
        }
        this.getPriorities().clear();
        this.getPriorities().addAll(priorities);
    }

    private boolean addPriorities(List<String> priorities, Set<String> childPriorities, String after) {
        if (after == null) {
            priorities.addAll(childPriorities);
            return true;
        }
        for (int index = priorities.size() - 1; index >= 0; --index) {
            String priority = priorities.get(index);
            if (!after.equals(priority)) continue;
            priorities.addAll(index + 1, childPriorities);
            return true;
        }
        return false;
    }

    private void addSkippedPriorities(List<String> priorities, Map<String, Set<String>> skippedPriorites, Set<String> prioritiesJustAdded) {
        for (String priority : prioritiesJustAdded) {
            if (!skippedPriorites.containsKey(priority)) continue;
            Set<String> prioritiesToAdd = skippedPriorites.remove(priority);
            this.addPriorities(priorities, prioritiesToAdd, priority);
            this.addSkippedPriorities(priorities, skippedPriorites, prioritiesToAdd);
        }
    }

    public class ServiceCheckBuilder
    extends StageWrapperBuilder {
        private Cluster m_cluster;
        private OBDPMetaInfo m_metaInfo;

        protected ServiceCheckBuilder(Grouping grouping) {
            super(grouping);
        }

        @Override
        public void add(UpgradeContext ctx, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
        }

        @Override
        public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
            ServiceCheckStageWrapper wrapper;
            this.m_cluster = upgradeContext.getCluster();
            this.m_metaInfo = upgradeContext.getAmbariMetaInfo();
            ArrayList<StageWrapper> result = new ArrayList<StageWrapper>(stageWrappers);
            if (upgradeContext.getDirection().isDowngrade()) {
                return result;
            }
            Map<String, Service> serviceMap = this.m_cluster.getServices();
            LinkedHashSet<String> clusterServices = new LinkedHashSet<String>(serviceMap.keySet());
            for (String service : ServiceCheckGrouping.this.priorityServices) {
                if (!this.checkServiceValidity(upgradeContext, service, serviceMap)) continue;
                wrapper = new ServiceCheckStageWrapper(service, upgradeContext.getServiceDisplay(service), true);
                result.add(wrapper);
                clusterServices.remove(service);
            }
            if (upgradeContext.getType() == UpgradeType.ROLLING) {
                for (String service : clusterServices) {
                    if (ServiceCheckGrouping.this.excludeServices.contains(service) || !this.checkServiceValidity(upgradeContext, service, serviceMap)) continue;
                    wrapper = new ServiceCheckStageWrapper(service, upgradeContext.getServiceDisplay(service), false);
                    result.add(wrapper);
                }
            }
            return result;
        }

        private boolean checkServiceValidity(UpgradeContext ctx, String service, Map<String, Service> clusterServices) {
            Service svc;
            if (clusterServices.containsKey(service) && null != (svc = clusterServices.get(service))) {
                StackId stackId = svc.getDesiredStackId();
                try {
                    ServiceInfo si = this.m_metaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), service);
                    CommandScriptDefinition script = si.getCommandScript();
                    if (null != script && null != script.getScript() && !script.getScript().isEmpty()) {
                        ctx.setServiceDisplay(service, si.getDisplayName());
                        return true;
                    }
                }
                catch (OBDPException e) {
                    LOG.error("Could not determine if service " + service + " can run a service check. Exception: " + e.getMessage());
                }
            }
            return false;
        }
    }

    public static class ServiceCheckStageWrapper
    extends StageWrapper {
        public String service;
        public boolean priority;

        ServiceCheckStageWrapper(String service, String serviceDisplay, boolean priority) {
            this(service, serviceDisplay, priority, null);
        }

        public ServiceCheckStageWrapper(String service, String serviceDisplay, boolean priority, String host) {
            super(StageWrapper.Type.SERVICE_CHECK, String.format("Service Check %s", serviceDisplay), new TaskWrapper(service, "", null == host ? Collections.emptySet() : Collections.singleton(host), new ServiceCheckTask()));
            this.service = service;
            this.priority = priority;
        }

        public int hashCode() {
            return this.service.hashCode();
        }

        public boolean equals(Object other) {
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return ((ServiceCheckStageWrapper)other).service.equals(this.service);
        }
    }
}

